#ifdef  __STRICT_ANSI__
#define __SA
#undef __STRICT_ANSI__
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <io.h>

#ifdef __SA
#undef __SA
#define __STRICT_ANSI__
#endif

/*
 Borland Turbo C Compiler 2.01 [DOS16]
  TCC -w -g1 -O -Z gratools.c

  GNU C Compiler 3.2 [Win32]
  GCC -Wall -pedantic -Werror -Os -s -o gratools gratools.c
*/

/* required types, DOS16 / Win32 compatible */
typedef   signed char   int8_t;
typedef unsigned char  uint8_t;
typedef   signed short  int16_t;
typedef unsigned short uint16_t;
/* note: 32 bit types may need tweaking for x64 compilation */
typedef   signed long   int32_t;
typedef unsigned long  uint32_t;

#pragma pack(push, 1)
typedef struct {
  uint16_t bfType; 
  uint32_t bfSize; 
  uint16_t bfReserved1; 
  uint16_t bfReserved2; 
  uint32_t bfOffBits; 
} bmp_file;

typedef struct {
  uint32_t biSize;
  int32_t  biWidth;
  int32_t  biHeight;
  uint16_t biPlanes;
  uint16_t biBitCount;
  uint32_t biCompression;
  uint32_t biSizeImage;
  int32_t  biXPelsPerMeter;
  int32_t  biYPelsPerMeter;
  uint32_t biClrUsed;
  uint32_t biClrImportant;
} bmp_info;

typedef struct {
  uint8_t rgbBlue; 
  uint8_t rgbGreen; 
  uint8_t rgbRed; 
  uint8_t rgbReserved; 
} bmp_quad;

typedef struct {
  uint16_t width;
  uint16_t height;
} gra_head;
#pragma pack(pop)

/* 0 / 128 / 192 / 255
   0 Black     |  1 Red          | 2 Green       | 3 Brown
   4 Blue      |  5 Magenta      | 6 Cyan        | 7 DarkGray
   8 LightGray |  9 LightRed     | 10 LightGreen | 11 Yellow
  12 LightBlue | 13 LightMagenta | 14 LightCyan  | 15 White */
static bmp_quad palwin[16] = {
  {0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x80, 0x00}, {0x00, 0x80, 0x00, 0x00}, {0x00, 0x80, 0x80, 0x00},
  {0x80, 0x00, 0x00, 0x00}, {0x80, 0x00, 0x80, 0x00}, {0x80, 0x80, 0x00, 0x00}, {0x80, 0x80, 0x80, 0x00},
  {0xC0, 0xC0, 0xC0, 0x00}, {0x00, 0x00, 0xFF, 0x00}, {0x00, 0xFF, 0x00, 0x00}, {0x00, 0xFF, 0xFF, 0x00},
  {0xFF, 0x00, 0x00, 0x00}, {0xFF, 0x00, 0xFF, 0x00}, {0xFF, 0xFF, 0x00, 0x00}, {0xFF, 0xFF, 0xFF, 0x00}
};
/* 0 / 85 / 170 / 255
   0 Black    |  1 Blue         |  2 Green      |  3 Cyan
   4 Red      |  5 Magenta      |  6 Brown      |  7 LightGray
   8 DarkGray |  9 LightBlue    | 10 LightGreen | 11 LightCyan
  12 LightRed | 13 LightMagenta | 14 Yellow     | 15 White */
static bmp_quad paldos[16] = {
  {0x00, 0x00, 0x00, 0x00}, {0xAA, 0x00, 0x00, 0x00}, {0x00, 0xAA, 0x00, 0x00}, {0xAA, 0xAA, 0x00, 0x00},
  {0x00, 0x00, 0xAA, 0x00}, {0xAA, 0x00, 0xAA, 0x00}, {0x00, 0x55, 0xAA, 0x00}, {0xAA, 0xAA, 0xAA, 0x00},
  {0x55, 0x55, 0x55, 0x00}, {0xFF, 0x55, 0x55, 0x00}, {0x55, 0xFF, 0x55, 0x00}, {0xFF, 0xFF, 0x55, 0x00},
  {0x55, 0x55, 0xFF, 0x00}, {0xFF, 0x55, 0xFF, 0x00}, {0x55, 0xFF, 0xFF, 0x00}, {0xFF, 0xFF, 0xFF, 0x00}
};

/* DOS <-> Windows palette mapping */
static uint8_t palmap[16] = {0, 4, 2, 6, 1, 5, 3, 8, 7, 12, 10, 14, 9, 13, 11, 15};

/* for one .BMP row */
static uint8_t bimage[32768U];
/* one plane for .GRA since same size can't be used here
   because of max DOS real time segment limitation */
static uint8_t bplane[32768U / 4];

char *basename(char *s) {
char *r;
  if (s) {
    for (r = s; *r; r++) {
      if ((*r == '/') || (*r == '\\')) {
        s = &r[1];
      }
    }
  }
  return(s);
}

void newext(char *name, char *ext) {
char *p;
  if (name && ext) {
    for (; (*name == '.'); name++);
    for (p = NULL; *name; name++) {
      if (*name == '.') {
        p = name;
      }
    }
    strcpy(p ? p : name, ext);
  }
}

uint32_t xsqr(int16_t v) {
  return(v * v);
}

int main(int argc, char *argv[]) {
uint32_t sz, l, k, d, clen[16][16];
uint16_t i, j, pi, pj, n;
uint8_t b, mask[2][16];
bmp_quad cpal[16];
gra_head gh;
bmp_file bf;
bmp_info bi;
char s[260]; /* Windows.MAX_PATH */
int fl, fb;
  puts(
    ".GRA <-> .BMP converter v1.1"
    #ifndef _WIN32
    " [DOS16]"
    #else
    " [Win32]"
    #endif
    "\n(c) -=CHE@TER=- 2009,2021\n"
    "http://ctpax-cheater.losthost.org/\n"
  );
  if ((argc < 2) || (argc > 3)) {
    puts(
      "Usage: gratools <filename.ext> [/p]\n"
      "filename.ext - input .GRA or .BMP file (required)\n"
      "/p - optional argument:\n"
      "     for .GRA -> .BMP - use EGA/VGA instead of Windows palette\n"
      "     for .BMP -> .GRA - keep all 16 colors even with mismatched palette\n"
      ".GRA - Borland Pascal/C EGA/VGA graphics format for GetImage/PutImage\n"
      ".BMP - Windows Bitmap image (only 16 colors uncompressed files supported)\n"
    );
    return(1);
  }
  fl = open(argv[1], O_RDONLY | O_BINARY);
  if (fl == -1) {
    puts("Error: can't open input file.\n");
    return(2);
  }
  fb = -1;
  lseek(fl, 0, SEEK_END);
  sz = tell(fl);
  if (sz >= (sizeof(bf) + sizeof(bi))) {
    lseek(fl, 0, SEEK_SET);
    memset(&bf, 0, sizeof(bf));
    read(fl, &bf, sizeof(bf));
    if ((bf.bfType == 0x4D42) && (bf.bfSize <= sz)) {
      memset(&bi, 0, sizeof(bi));
      read(fl, &bi, sizeof(bi));
      l = (bi.biHeight < 0) ? (-bi.biHeight) : bi.biHeight;
      if (
        (bi.biSize == sizeof(bi)) && (bi.biPlanes == 1) && (!bi.biCompression) && (bi.biBitCount == 4) &&
        (bi.biWidth > 0) && (l > 0) && (bi.biWidth <= 65536UL) && (l <= 65536UL)
      ) {
        /* check for default Windows palette */
        read(fl, cpal, sizeof(cpal));
        for (j = 0; j < 16; j++) {
          b = 16;
          for (i = 0; i < 16; i++) {
            if (
              (palwin[i].rgbBlue == cpal[j].rgbBlue) &&
              (palwin[i].rgbGreen == cpal[j].rgbGreen) &&
              (palwin[i].rgbRed == cpal[j].rgbRed)
            ) {
              b = palmap[i];
              break;
            }
          }
          /* color not found */
          if (b == 16) { break; }
          cpal[j].rgbReserved = b;
        }
        /* not default Windows palette - find nearest colors */
        if (b == 16) {
          if (argc == 2) {
            /* find nearest colors - calculate all distances */
            for (j = 0; j < 16; j++) {
              d = 255 * 255 * 3;
              b = 0;
              for (i = 0; i < 16; i++) {
                k =
                  xsqr(paldos[i].rgbBlue - cpal[j].rgbBlue) +
                  xsqr(paldos[i].rgbGreen - cpal[j].rgbGreen) +
                  xsqr(paldos[i].rgbRed - cpal[j].rgbRed);
                if (d > k) {
                  d = k;
                  b = i;
                }
              }
              cpal[j].rgbReserved = b;
            }
          } else {
            /* make sure all colors will be used only once */
            for (j = 0; j < 16; j++) {
              for (i = 0; i < 16; i++) {
                clen[j][i] =
                  xsqr(paldos[j].rgbBlue  - cpal[i].rgbBlue) +
                  xsqr(paldos[j].rgbGreen - cpal[i].rgbGreen) +
                  xsqr(paldos[j].rgbRed   - cpal[i].rgbRed);
              }
            }
            /* find best matched colors */
            memset(mask, 0, sizeof(mask));
            for (k = 0; k < 16; k++) {
              pi = 0;
              pj = 0;
              d = (uint32_t) -1;
              for (j = 0; j < 16; j++) {
                for (i = 0; i < 16; i++) {
                  if ((d > clen[j][i]) && (!mask[0][i]) && (!mask[1][j])) {
                    d = clen[j][i];
                    pi = i;
                    pj = j;
                  }
                }
              }
              /* block for further search */
              mask[0][pi] = 1;
              mask[1][pj] = 1;
              cpal[pi].rgbReserved = pj;
            }
          }
        }
        puts(".BMP -> .GRA\n");
        strcpy(s, basename(argv[1]));
        puts(s);
        newext(s, ".gra");
        puts(s);
        fb = open(s, O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
        if (fb == -1) {
          close(fl);
          puts("Error: can't create output file.\n\n");
          return(3);
        }
        gh.width = bi.biWidth - 1;
        gh.height = l - 1;
        write(fb, &gh, sizeof(gh));
        j = l;
        k = (((bi.biWidth * 4) + 31) & ~31) >> 3;
        l = (((gh.width + 1UL) + 7) & ~7) >> 1;
        l /= 4;
        lseek(fl, bf.bfOffBits, SEEK_SET);
        while (j--) {
          /* bottom-top .BMP image */
          if (bi.biHeight > 0) { lseek(fl, bf.bfOffBits + (j * k), SEEK_SET); }
          read(fl, bimage, (uint16_t) k);
          /* write back plane by plane */
          for (n = 0; n < 4; n++) {
            memset(bplane, 0, (uint16_t) l);
            for (i = 0; i < bi.biWidth; i++) {
              b = bimage[i >> 1] >> ((i & 1) ? 0 : 4);
              b = cpal[b & 0x0F].rgbReserved;
              b = b & (8 >> n);
              b = b ? (128 >> (i & 7)) : 0;
              bplane[(i >> 3)] |= b;
            }
            write(fb, bplane, (uint16_t) l);
          }
        }
        gh.width = 0;
        write(fb, &gh, sizeof(gh) / 2);
        close(fb);
      }
    }
  }
  /* header + min_data + reserved */
  if (sz >= (sizeof(gh) + 4 + 2)) {
    lseek(fl, 0, SEEK_SET);
    memset(&gh, 0, sizeof(gh));
    read(fl, &gh, sizeof(gh));
    l = (((gh.width + 1UL) + 7) & ~7) >> 1;
    if (sz >= (sizeof(gh) + (l * (1UL + gh.height)) + 2)) {
      puts(".GRA -> .BMP\n");
      strcpy(s, basename(argv[1]));
      puts(s);
      newext(s, ".bmp");
      puts(s);
      fb = open(s, O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
      if (fb == -1) {
        close(fl);
        puts("Error: can't create output file.\n");
        return(3);
      }
      memset(&bf, 0, sizeof(bf));
      memset(&bi, 0, sizeof(bi));
      bi.biSize = sizeof(bi);
      bi.biWidth = gh.width + 1UL;
      bi.biHeight = gh.height + 1UL;
      bi.biPlanes = 1;
      bi.biBitCount = 4;
      k = (((bi.biWidth * 4) + 31) & ~31) >> 3;
      bi.biSizeImage = k * bi.biHeight;
      bf.bfType = 0x4D42;
      bf.bfOffBits = sizeof(bf) + sizeof(bi) + sizeof(palwin);
      bf.bfSize = bi.biSizeImage + bf.bfOffBits;
      write(fb, &bf, sizeof(bf));
      write(fb, &bi, sizeof(bi));
      if (argc == 2) {
        write(fb, palwin, sizeof(palwin));
      } else {
        write(fb, paldos, sizeof(paldos));
      }
      l /= 4;
      j = bi.biHeight;
      while (j--) {
        lseek(fl, sizeof(gh) + (j * l * 4), SEEK_SET);
        memset(bimage, 0, (uint16_t) k);
        /* build image row plane by plane */
        for (n = 0; n < 4; n++) {
          read(fl, bplane, (uint16_t) l);
          for (i = 0; i < bi.biWidth; i++) {
            b = 128 >> (i & 7);
            b = (bplane[i >> 3] & b) ? (8 >> n) : 0;
            bimage[i >> 1] |= (i & 1) ? b : (b << 4);
          }
        }
        /* remap colors in current row */
        if (argc == 2) {
          for (i = 0; i < bi.biWidth; i++) {
            b = bimage[i >> 1] >> ((i & 1) ? 0 : 4);
            b = palmap[b & 0x0F];
            bimage[i >> 1] &= (i & 1) ? 0xF0 : 0x0F;
            bimage[i >> 1] |= (i & 1) ? b : (b << 4);
          }
        }
        write(fb, bimage, (uint16_t) k);
      }
      close(fb);
    }
  }
  close(fl);
  if (fb == -1) {
    puts("Error: unknown or unsupported input file format.\n");
    fb = 4;
  } else {
    puts("\ndone\n");
    fb = 0;
  }
  return(fb);
}
