Program DOSCSAdd;

Uses FileUnit;

Function BaseName(S: String): String;
Var I, J: Integer;
Begin
  J:=1;
  For I:=1 To Length(S) Do
    If ((S[I] = '/') Or (S[I] = '\')) Then J:=I + 1;
  BaseName:=Copy(S, J, Length(S) - J + 1);
End;

Function IntToHex(L: LongInt): String;
Var
  S: String;
  B: Byte;
Begin
  S:='';
  While (Length(S) < 8) Do
  Begin
    B:=(L ShR 28) And $0F;
    L:=L ShL 4;
    S:=S + Chr(48 + B + (Ord(B > 9) * 7));
  End;
  IntToHex:=S;
End;

Var
  Fl: File;
  Wd: Word;
  CS: LongInt;
Begin
  If ((ParamCount < 1) Or (ParamCount > 2)) Then Exit;
  CS:=GetExeChecksum(ParamStr(1));
  If ((CS And EXE_CS_READY) = 0) Then Exit;
  If (FlOpen(Fl, ParamStr(1), 2 * Ord(ParamCount = 2)) = 0) Then
  Begin
    WriteLn(BaseName(ParamStr(1)));
    Seek(Fl, 18);
    If (ParamCount = 2) Then
    Begin
      FlWrite(Fl, CS, 2);
      WriteLn('Checksum updated.');
    End
    Else
    Begin
      WriteLn('New:', Copy(IntToHex(CS And $FFFF), 5, 4));
      FlRead(Fl, CS, 2);
      WriteLn('Old:', Copy(IntToHex(CS And $FFFF), 5, 4));
    End;
    WriteLn;
    Close(Fl);
  End;
End.
