Unit DrawIM2;

{ v2.06 }
{.$DEFINE DEBUG}

Interface

Const
  IM2_VERS = '2.11'; { v2.09 }
  IM2_YEAR = '2024'; { v2.09 }
  StartX = 112;
  StartY = 62;
  MenuItemsMax = 12;
  MenuItems: Array[1..MenuItemsMax] Of String[11] = (
    '      ',
    '⥭   F3',
    '   F2',
    '    F5',
    '   F7',
    '㭪樨  F8',
    '१  F9', { v2.05 }
    ' ',
    '⬥     ',
    ' F4',
    '  F6',
    '室   Esc'
  );
  FMenuItemsMax = 6;
  FMenuItems: Array[1..FMenuItemsMax] Of String[17] = (
    '.   ᨬ',
    'ਧ.  ᨬ',
    '. ⮡ࠦ',
    'ਧ.⮡ࠦ',
    ' 梥',
    '⠡'
  );

Var { v2.11 }
  Ch: Word;
  FileEdit: String;
  StepValue: Byte; { v2.06 }
  PicX: Integer;
  PicY: Integer;
  PicXe: Integer;
  PicYe: Integer;
  Quit: Boolean;
  ECurs: Array[1..3] Of Pointer; { v2.06 }

Function AntiViralCheck: Boolean;
Procedure Intro;
Procedure Help(Whr: Byte);
Procedure OutFName(B: Boolean);
Procedure ErrorMessage(N: Byte);
Procedure ShowFile(S: String);
Procedure OutPutSize(Op: Boolean);
Procedure OutPutCoo(Op: Boolean);
Procedure Mode(MD: Boolean);
Procedure BarPicture;
Procedure SaveBackGround(B: Boolean);
Procedure IOButton(X1, Y1, X2, Y2: Integer; S: String; Stat, Center: Boolean);
Function EasyMenu(Ch: Byte; VPos: Integer; VMin, VMax: Integer; VHorz: Boolean): Integer; { v2.09 }
Procedure PictureSize;
Procedure Prepare(bInit: Boolean);
Procedure Cleanup;
Procedure Editor;
Procedure Rotate;
Procedure MoveTab(F7B: Boolean);
Procedure NewPicture;
Procedure AllArea;
Procedure CopyOfPic;
Procedure QuitQuestion;
Function EnterFileName(FileName: String): String;
Procedure OpnFl(S: String);
Procedure OpenFile;
Procedure SaveFile;
Procedure UndoFunc;
Procedure FuncMenu;
Procedure RunFunction(N: Byte);

Implementation

Uses Graph, FGraph, DOS, KeybUnit, FileUnit;

{$F+}
Procedure DOS8X8RU; External;
{$L DOS8X8RU}
{$F-}

{ v2.06 - help moved out to external file }
{$F+}
Procedure HelpFile; External;
{$L HELPFILE}
{$F-}

Procedure QOutTextXY(X, Y: Integer; S: String); { v2.02 }
Var
  I, J, K: Integer;
     C, L: Byte;
        P: ^Byte;
Begin
  C:=GetColor;
  For K:=0 To Length(S) - 1 Do
  Begin
    P:=@DOS8X8RU;
    Inc(LongInt(P), Ord(S[K + 1]) * Word(8));
    For J:=0 To 7 Do
    Begin
      { v2.03 }
      L:=$80;
      For I:=0 to 7 Do
      Begin
        If ((P^ And L) <> 0) Then PutPixel(X, Y, C);
        L:=L ShR 1;
        Inc(X);
      End;
      Dec(X, 8);
      Inc(Y);
      Inc(LongInt(P), 1);
    End;
    Inc(X, 8);
    Dec(Y, 8);
  End;
End;

Function AntiViralCheck: Boolean;
Var B: Boolean;
Begin
{$IFNDEF DEBUG}
  B:=((GetExeChecksum(ParamStr(0)) And EXE_CS_VALID) <> 0);
  If (B = False) Then
  Begin
    WriteLn('/!\ : ࠡ⠫ ⨢᭠ ஢ઠ!  稭:');
    WriteLn('-   䠩 ணࠬ;');
    WriteLn('-  ࠧ 䠩 ணࠬ;');
    WriteLn('- ୠ ஫쭠 㬬 䠩 ணࠬ.');
    WriteLn('/!\     ! /!\'#7);
  End;
{$ELSE}
  B:=True;
{$ENDIF}
  AntiViralCheck:=B;
End;

Procedure Intro;
Begin
  KeybFast; { v2.05 }
  WriteLn('Image Editor  " Wing " by Philippov Vladimir');
  WriteLn('Version 2.0 , Copyright (C) 1995 year');
  WriteLn('Index:200');
  WriteLn;
  WriteLn('alive version v'+IM2_VERS); { v2.05 }
  { v2.08 }
  WriteLn('(c) -=CHE@TER=- 2001-'+IM2_YEAR);
  WriteLn('web: http://ctpax-cheater.losthost.org/hack.htm');
  WriteLn('e-mail: _CTPAX_(a)MAIL.RU');
  WriteLn;
  WriteLn('im2new <filename.ext> - ⨥ 䠩  㪠    ப.');
  WriteLn('im2new <filemask.ext> /p - ᬮ 䠩  ᪥ (ਬ *.gra).');
  WriteLn('im2new <filemask.ext> /? - ᬮ 䠩  ᪥ (뢮 ࠧ  ).');
  WriteLn(' ० ᬮ: Esc - 室,  㣠  - ᫥騩 㭮.');
End;

{ v2.03 }
{ v2.06 - help moved out to external file }
Procedure ShowHelpText(N: Byte);
Var
  S: String;
  P: ^Char;
Begin
  If ((N < 1) Or (N > 14)) Then Exit;
  N:=N - 1;
  P:=@HelpFile;
  While (N > 0) Do
  Begin
    While (P^ <> '|') Do Inc(LongInt(P), 1);
    Inc(LongInt(P), 3); { skip | and CRLF }
    N:=N - 1;
    If (P^ = '|') Then
    Begin
      {N:=1;
      Break;}
      { v2.09 }
      N:=0;
      Inc(LongInt(P), 1);
    End;
  End;
  If (N = 0) Then
  Begin
    While (P^ <> '|') Do
    Begin
      S:='';
      While (P^ <> #13) Do
      Begin
        { #$%& -> udrl / #$&% -> udlr }
        If ((P^ >= '#') And (P^ <= '&')) Then
          S:=S + Chr(Ord(P^) - 35 + 24)
        Else
          S:=S + P^;
        Inc(LongInt(P), 1);
      End;
      Inc(LongInt(P), 2); { skip CRLF }
      QOutTextXY(176, 123 + (N * 10), S);
      N:=N + 1;
    End;
  End;
End;

Procedure Help(Whr: Byte);
Var Bk: Pointer; {304, 128}
Begin
  Bk:=Capture(168, 111, 168+304, 111+128);
  IOButton(168, 111, 168+304, 111+128, '', True, True);
  SetFillStyle(1, 3);
  Bar(168+2, 111+2, 168+304-2, 111+128-2);
  SetColor(0);
  Rectangle(168+4, 111+4, 168+304-4, 111+128-4);
  Rectangle(168+6, 111+6, 168+304-6, 111+128-6);
  Bar(294, 113, 346, 120);
  QOutTextXY(168+128, 111+2, '');
  ShowHelpText(Whr); { v2.03 }
  Ch:=KeybRead(KEYB_WAIT) And 0;
  PutImage(168, 111, Bk^, CopyPut);
  ImgRelease(Bk);
End;

Procedure OutFName(B: Boolean);
Begin
  If (B = True) Then SetColor(0) Else SetColor(7);
  QOutTextXY(10, 43+3, FileEdit); { v2.08 }
End;

Procedure ErrorMessage(N: Byte);
Var
  B: Pointer;
  S: String;
Begin
  B:=Capture(50, 100, 300, 150);
  IOButton(50, 100, 300, 150, '', True, True);
  SetFillStyle(1, 4);
  Bar(50+2, 100+2, 300-2, 150-2);
  SetColor(15);
  QOutTextXY(151, 108, '訡');
  QOutTextXY(91, 136, '  ');
  Case N Of
     2, 18: S:='  ';
     3: S:='  ';
     5: S:='訡 㯠';
     6: S:='⨬ ਯ';
     8: S:='筮 ';
    11: S:=' ଠ 䠩';
    19: S:='訡  䠩';
    Else S:='⭠ 訡';
  End;
  QOutTextXY(50 + ((250 - (Length(S)*8)) Div 2), 122, S);
  Ch:=KeybRead(KEYB_WAIT) And 0;
  PutImage(50, 100, B^, CopyPut);
  ImgRelease(B);
End;

Procedure ShowFile(S: String);
Var
  X, Y, I: LongInt;
     DStr: DirStr;
     NStr: NameStr;
     EStr: ExtStr;
        R: SearchRec;
        T: String; { v2.09 }
Begin
  SetColor(15); { v2.09 }
  SetFillStyle(1, 0); { v2.09 }
  FSplit(S, DStr, NStr, EStr);
  FindFirst(S, ReadOnly Or Hidden Or SysFile Or Archive, R);
  Ch:=0;
  While ((DOSError = 0) And (Ch <> VK_ESCAPE)) Do
  Begin
    ClearDevice;
    I:=AllGRAOpen(-1, -1, DStr + R.Name);
    If (I <> -1) Then
    Begin
      X:=(I And $FFFF);
      Y:=((I ShR 16) And $FFFF);
      If (X > GetMaxX) Then X:=0 Else X:=(GetMaxX - X) Div 2;
      If (Y > GetMaxY) Then Y:=0 Else Y:=(GetMaxY - Y) Div 2;
      I:=AllGRAOpen(X, Y, DStr + R.Name);
      { v2.09 }
      If (ParamStr(2) = '/?') Then
      Begin
        X:=GetMaxX Div 2;
        Y:=GetMaxY - 15;
        Bar(0, Y, GetMaxX, GetMaxY);
        Str((I And $FFFF), S);
        Str(((I ShR 16) And $FFFF), T);
        S:=S + 'x' + T;
        QOutTextXY(X - ((Length(S) * 8) Div 2), Y, S);
        S:=DStr + R.Name;
        QOutTextXY(X - ((Length(S) * 8) Div 2), Y + 8, S);
      End;
    End
    Else
    Begin
      { v2.09 }
      X:=GetMaxX Div 2;
      Y:=GetMaxY Div 2;
      S:='  䠩   ଠ:';
      QOutTextXY(X - ((Length(S) * 8) Div 2), Y - 8 - 4, S);
      S:=DStr + R.Name;
      QOutTextXY(X - ((Length(S) * 8) Div 2), Y + 4, S);
    End;
    Ch:=Hi(KeybRead(KEYB_READ));
    FindNext(R);
  End;
  Ch:=0;
End;

{ v2.06 }
Procedure ChangeStep(Ch: Word);
Var
  S: String[11];
  C: Byte;
Begin
  If (
    ((Ch = VK_PLUS) And (StepValue < 100)) Or
    ((Ch = VK_MINUS) And (StepValue >   1)) Or
    (Ch = $FFFF) Or (Ch = $FFFE)
  ) Then
  Begin
    Mode(True);
    C:=GetColor;
    SetColor(7);
    Str(StepValue, S);
    QOutTextXY(416, 34, S);
    If (Ch = VK_PLUS) Then StepValue:=StepValue + 1;
    If (Ch = VK_MINUS) Then StepValue:=StepValue - 1;
    If (Ch <> $FFFE) Then
    Begin
      SetColor(4{12});
      Str(StepValue, S);
      QOutTextXY(416, 34, S);
    End;
    SetColor(C);
    Mode(False);
  End;
End;

{ v2.06 }
Function AddSubValue(Value, VStep, VMin, VMax: Integer): Integer;
Begin
  Value:=Value + (StepValue*VStep);
  If (Value < VMin) Then Value:=VMin;
  If (Value > VMax) Then Value:=VMax;
  AddSubValue:=Value;
End;

Procedure OutPutSize(Op: Boolean);
Var
  S: String[11{3}];
  I: LongInt;
Begin
  Mode(True);
  If (Op = True) Then SetColor(4{12}) Else SetColor(7);
  Str(PicXe-PicX+1, S);
  QOutTextXY(416, 16, S);
  Str(PicYe-PicY+1, S);
  QOutTextXY(456, 16, S);
  { v2.05 }
  I:=CalcImageSize(PicX, PicY, PicXe, PicYe);
  Str(I, S);
  QOutTextXY(460+12+120 - (Length(S)*8), 16, S);
  { 64K - 8 (max segment size for GetMem) }
  If (I > 65528) Then
    QOutTextXY(460+12+32, 25, ' ᥣ!');
  Mode(False);
End;

Procedure OutPutCoo(Op: Boolean);
Var S: String[3];
Begin
  Mode(True);
  If (Op = True) Then SetColor(0) Else SetColor(7);
  Str(PicX-StartX-1, S);
  QOutTextXY(416, 25, S);
  Str(PicY-StartY-1, S);
  QOutTextXY(456, 25, S);
  Mode(False);
  SetColor(15);
End;

Procedure Mode(MD: Boolean);
Begin
  If (MD = True) Then SetWriteMode(CopyPut) Else SetWriteMode(XOrPut);
End;

Procedure BarPicture;
Begin
  SetColor(15);
  Mode(False);
  Rectangle(PicX, PicY, PicXe, PicYe);
  Mode(True);
End;

Procedure SaveBackGround(B: Boolean);
Var
  Bk: Pointer;
   I: Integer;
Begin
  If (B = True) Then BarPicture;
  { v2.06 }
  Bk:=Capture(StartX+1, 0, GetMaxX-1, 0);
  For I:=StartY+1 To GetMaxY-1 Do
  Begin
    SetActivePage(0);
    GetImage(StartX+1, I, GetMaxX-1, I, Bk^);
    SetActivePage(1);
    PutImage(StartX+1, I, Bk^, CopyPut);
  End;
  ImgRelease(Bk);
  SetActivePage(0);
  If (B = True) Then BarPicture;
End;

{ v2.11 }
Procedure IOButton(X1, Y1, X2, Y2: Integer; S: String; Stat, Center: Boolean);
Begin
  X2:=X2 - X1 + 1;
  Y2:=Y2 - Y1 + 1;
  If (X2 < 4) Then X2:=4;
  If (Y2 < 4) Then Y2:=4;
  SetFillStyle(1, 7);
  Bar(X1, Y1, X1 + X2 - 1, Y1 + Y2 - 1);
  If (Stat = True) Then
  Begin
    { default button }
    SetColor(15);
    Line(X1, Y1, X1 + X2 - 1, Y1); {-}
    Line(X1, Y1, X1, Y1 + Y2 - 1); {|}
    SetColor(8);
    Line(X1 + 1, Y1 + Y2 - 2, X1 + X2 - 2, Y1 + Y2 - 2); {-}
    Line(X1 + X2 - 2, Y1 + 1, X1 + X2 - 2, Y1 + Y2 - 1); {|}
    SetColor(0);
    Line(X1, Y1 + Y2 - 1, X1 + X2 - 1, Y1 + Y2 - 1); {-}
    Line(X1 + X2 - 1, Y1, X1 + X2 - 1, Y1 + Y2 - 1); {|}
  End
  Else
  Begin
    If (Length(S) > 0) Then
    Begin
      { pressed button }
      SetColor(8);
      Rectangle(X1 + 1, Y1 + 1, X1 + X2 - 2, Y1 + Y2 - 2);
      SetColor(0);
      Rectangle(X1, Y1, X1 + X2 - 1, Y1 + Y2 - 1);
    End
    Else
    Begin
      { empty panel }
      SetColor(15);
      Line(X1, Y1 + Y2 - 1, X1 + X2 - 1, Y1 + Y2 - 1); {-}
      Line(X1 + X2 - 1, Y1, X1 + X2 - 1, Y1 + Y2 - 1); {|}
      SetColor(8);
      Line(X1 + 1, Y1 + 1, X1 + X2 - 3, Y1 + 1); {-}
      Line(X1 + 1, Y1 + 1, X1 + 1, Y1 + Y2 - 3); {|}
      SetColor(0);
      Line(X1, Y1, X1 + X2 - 2, Y1); {-}
      Line(X1, Y1, X1, Y1 + Y2 - 2); {|}
    End;
  End;
  { centered text }
  If (Center = True) Then
  Begin
    X1:=X1 + ((X2 - (Length(S) * 8)) Div 2);
    Y1:=Y1 + ((Y2 - 8) Div 2);
  End;
  QOutTextXY(X1 + Ord(Not Stat), Y1 + Ord(Not Stat), S);
End;

{ v2.09 }
Function EasyMenu(Ch: Byte; VPos: Integer; VMin, VMax: Integer; VHorz: Boolean): Integer;
Var T: Word;
Begin
  T:=(VMax - VMin + 1) Div 4;
  If (T < 2) Then T:=2;
  Case Ch Of
       VK_UP: If (VHorz = False) Then
                If (VPos > VMin) Then VPos:=VPos - 1 Else VPos:=VMax;
     VK_DOWN: If (VHorz = False) Then
                If (VPos < VMax) Then VPos:=VPos + 1 Else VPos:=VMin;
     VK_LEFT: If (VHorz = True) Then
                If (VPos > VMin) Then VPos:=VPos - 1 Else VPos:=VMax;
    VK_RIGHT: If (VHorz = True) Then
                If (VPos < VMax) Then VPos:=VPos + 1 Else VPos:=VMin;
     VK_HOME: VPos:=VMin;
      VK_END: VPos:=VMax;
     VK_PGUP: If ((VPos - T) >= VMin) Then VPos:=(VPos - T) Else VPos:=VMin;
     VK_PGDN: If ((VPos + T) <= VMax) Then VPos:=(VPos + T) Else VPos:=VMax;
  End;
  EasyMenu:=VPos;
End;

Procedure PictureSize;
Var PicXOld, PicYOld: Integer;
Begin
  PicXOld:=PicXe;
  PicYOld:=PicYe;
  BarPicture;
  Mode(False);
  SetColor(4);
  Rectangle(PicX, PicY, PicXe, PicYe);
  Repeat
    Ch:=Hi(KeybRead(KEYB_READ));
    ChangeStep(Ch); { v2.06 }
    Rectangle(PicX, PicY, PicXe, PicYe);
    OutPutSize(False);
    { v2.06 }
    Case Ch Of
         VK_UP: PicYe:=AddSubValue(PicYe, -1, PicY, GetMaxY - 1);
       VK_DOWN: PicYe:=AddSubValue(PicYe,  1, PicY, GetMaxY - 1);
       VK_LEFT: PicXe:=AddSubValue(PicXe, -1, PicX, GetMaxX - 1);
      VK_RIGHT: PicXe:=AddSubValue(PicXe,  1, PicX, GetMaxX - 1);
    End;
    OutPutSize(True);
    Rectangle(PicX, PicY, PicXe, PicYe);
  Until ((Ch = VK_RETURN) Or (Ch = VK_ESCAPE));
  Rectangle(PicX, PicY, PicXe, PicYe);
  If (Ch = VK_ESCAPE) Then
  Begin
    OutPutSize(False);
    PicXe:=PicXOld;
    PicYe:=PicYOld;
    OutPutSize(True);
  End;
  BarPicture;
End;

{ v2.06 }
const
  { big cursor }
  ECur_1: Array[1..10+2] Of PointType = (
    (X:  0; Y: 10), { type, points }
    (X: 11; Y: 11), { width, height }
    (X:  1; Y:  1), { DrawPoly() bug }
    (X:  0; Y:  0),
    (X: 11; Y:  5),
    (X:  8; Y:  5),
    (X: 11; Y:  8),
    (X:  8; Y:  8),
    (X:  8; Y: 11),
    (X:  5; Y:  8),
    (X:  5; Y: 11),
    (X:  0; Y:  0)
  );
  { small cursor }
  ECur_2: Array[1..5+2] Of PointType = (
    (X:  1; Y:  5), { type, points }
    (X:  5; Y:  5), { width, height }
    (X:  5; Y:  5),
    (X:  0; Y:  0),
    (X:  0; Y:  3),
    (X:  0; Y:  0),
    (X:  3; Y:  0)
  );
  { circle }
  ECur_3: Array[1..1+2] Of PointType = (
    (X:  2; Y:  2), { type, points }
    (X:  8; Y:  6), { width, height }
    (X:  4; Y:  3)
  );
  ECur_c = 3;

Procedure Prepare(bInit: Boolean);
Var
  I, T, N: Integer;
        P: ^PointType;
Begin
  { v2.11 }
  If (bInit = True) Then
  Begin
    Ch:=0;
    FileEdit:='';
    StepValue:=1;
    Quit:=False;
    PicX:=StartX + 1;
    PicY:=StartY + 1;
    PicXe:=PicX + 59;
    PicYe:=PicY + 79;
    For I:=1 To ECur_c Do
      ECurs[I]:=Nil;
  End;
  { v2.06 }
  SetColor(15);
  SetFillStyle(1, 15);
  For I:=1 To ECur_c Do
  Begin
    If (ECurs[I] = Nil) Then
    Begin
      { v2.11 }
      Case I Of
        1: P:=@ECur_1;
        2: P:=@ECur_2;
        3: P:=@ECur_3;
      End;
      T:=P^.X;
      N:=P^.Y;
      Inc(LongInt(P), 2 * SizeOf(P^));
      If (T < 2) Then DrawPoly(N, P^)
      Else Circle(P^.X, P^.Y, P^.X);
      If (T = 0) Then FloodFill(2, 2, 15);
      Dec(LongInt(P), SizeOf(P^));
      ECurs[I]:=Capture(0, 0, P^.X, P^.Y);
      PutImage(0, 0, ECurs[I]^, XOrPut);
    End;
  End;
  { --- }
  SetFillStyle(1, 7);
  Bar(0, 0, GetMaxX, 60);
  Bar(0, 0, 100, 61+(MenuItemsMax-1)*20+20);
  IOButton(1, 1, GetMaxX-1, 59, '', True, True);
  SetColor(15);
  Rectangle(StartX, StartY, GetMaxX, GetMaxY);
  BarPicture;
  OutPutSize(True);
  OutPutCoo(True);
  ChangeStep($FFFF); { v2.06 }
  Mode(True); { v2.02 }
  OutFName(True);
  For I:=1 To MenuItemsMax Do {18 +2}
    IOButton(1, 62+((I-1)*20), 99, 62+((I-1)*20)+18, MenuItems[I], True, True);
  SetColor(15);
  QOutTextXY(10, 16, ' F1  맮 ࠢ.');
  QOutTextXY(10, 25, ' '+#24+'  '+#25+' - ।  .');
  QOutTextXY(10, 34, 'Enter - 믮 ࠭ 㭪.');
  SetColor(0);
  QOutTextXY(10+23, 6, 'Wing  2.0 (alive  v'+IM2_VERS+')');
  QOutTextXY(320+6*8,  6, '    x    y');
  QOutTextXY(320+4*8, 16, 'ࠧ:');
  QOutTextXY(320+3*8, 25, ':');
  { v2.06 }
  QOutTextXY(320+7*8, 34, '蠣:');
  { v2.05 }
  QOutTextXY(460+12+40,   6, 'ࠧ  ');
  QOutTextXY(460+12+128, 16, '');
  { v2.08 }
  QOutTextXY(460+12+32, 34, '-=CHE@TER=- '+IM2_YEAR);
  Ellipse(460+12+20, 34+3, 0, 360, 4, 4);
  Ellipse(460+12+20, 34+3, 0+45, 360-45, 2, 2);
End;

Procedure Editor;
Var
  PX, PY, I, J, Clr, T1, T2, K: Integer;
             InsMode, VisCoord: Boolean;
                            Bk: Pointer;
Procedure DrawPxl(C: Integer; IsFlood: Boolean);
Begin
  SetColor(C);
  { if not flood and color pixel with the same color - toggle it }
  Mode((IsFlood = True) Or (C <> GetPixel(500 + I, 10 + J)));
  { draw xored pixel }
  For C:=1 To K - 1 Do
    Line((I*K) + 1, (J*K) + C, (I*K) + K - 1, (J*K) + C);
  { pixel in upper-left preview }
  Line(500 + I, 10 + J, 500 + I, 10 + J);
  { change mode back }
  Mode(True);
End;
{ v2.10 }
Procedure ClrMark(C: Integer);
Begin
  PutImage((C * 20) + 7, 325 + 7, ECurs[2]^, XOrPut);
End;
Function SlctClr(C: Integer): Integer; { v2.04 }
Var O: Integer; { v2.11 }
Begin
  O:=C; { v2.11 }
  ClrMark(C); { v2.10 }
  PutImage(C*20+4, 329, ECurs[1]^, XOrPut);
  Repeat
    Ch:=Hi(KeybRead(KEYB_READ));
    PutImage(C*20+4, 329, ECurs[1]^, XOrPut);
    C:=EasyMenu(Ch, C, 0, 15, True); { v2.09 }
    PutImage(C*20+4, 329, ECurs[1]^, XOrPut);
  Until ((Ch = VK_RETURN) Or (Ch = VK_ESCAPE)); { v2.04 }
  PutImage(C*20+4, 329, ECurs[1]^, XOrPut);
  If (Ch = VK_ESCAPE) Then C:=O; { v2.11 }
  ClrMark(C); { v2.10 }
  Ch:=0; { v2.04 }
  SlctClr:=C; { v2.11 }
End;
{ v2.04 }
Procedure ToggleCursor;
Begin
  PutImage(1 + (I*K) + (K Div 2), 1 + (J*K) + (K Div 2), ECurs[1]^, XOrPut);
End;
{ v2.09 - OutTextXY should be faster than QOutTextXY }
Procedure OutPutCoord(Op: Boolean);
Var S: String[3];
Begin
  If (VisCoord = True) Then
  Begin
    If (Op = True) Then SetColor(15) Else SetColor(0);
    Str(I, S);
    OutTextXY(500 + 30, 0, S);
    Str(J, S);
    OutTextXY(500 + 30 + 40, 0, S);
  End;
End;
{ v2.10 }
Procedure WaitTextShow(B: Boolean);
Begin
  SetColor(Ord(B) * 15);
  QOutTextXY(480 + 8, 0, ' ᮢ...');
End;
Begin
  PX:=PicXe - PicX + 1;
  PY:=PicYe - PicY + 1;
  If (PX > 120) Then PX:=120;
  If (PY > 80) Then PY:=80;
  { v2.04 }
  I:=(120*4) Div PX;
  J:=( 80*4) Div PY;
  If (I < J) Then K:=I Else K:=J;
  { like in EDP }
  If (K > 30) Then K:=30;
  { /v2.04 }
  SaveBackGround(True);
  ClearDevice;
  WaitTextShow(True); { v2.10 }
  SetColor(8);
  { v2.04 - 4 => K }
  For J:=0 To PY Do Line(0, J*K, PX*K, J*K);
  For I:=0 To PX Do Line(I*K, 0, I*K, PY*K);
  PX:=PX - 1;
  PY:=PY - 1;
  For J:=0 To PY Do
    For I:=0 To PX Do
    Begin
      SetActivePage(1);
      Clr:=GetPixel(PicX + I, PicY + J{500+I, 10+J});
      SetActivePage(0);
      DrawPxl(Clr, False);
    End;
  { color bars }
  For I:=0 To 15 Do
  Begin
    SetFillStyle(1, I);
    Bar((I*20), 325, (I*20)+19, 325+19);
  End;
  WaitTextShow(False); { v2.10 }
  I:=0;
  J:=0;
  Clr:=15;
  ClrMark(Clr); { v2.10 }
  InsMode:=False;
  VisCoord:=True; { v2.09 }
  ToggleCursor;
  Repeat
    OutPutCoord(True); { v2.09 }
    Ch:=Hi(KeybRead(KEYB_READ));
    OutPutCoord(False); { v2.09 }
    ToggleCursor;
    T1:=1 + (Ord((KeybStat And 3) <> 0) * 9); { v2.10 }
    Case Ch Of
          VK_UP: J:=AddSubValue(J, -T1, 0, PY); { v2.10 }
        VK_DOWN: J:=AddSubValue(J,  T1, 0, PY); { v2.10 }
        VK_LEFT: I:=AddSubValue(I, -T1, 0, PX); { v2.10 }
       VK_RIGHT: I:=AddSubValue(I,  T1, 0, PX); { v2.10 }
          VK_F1: Help(13+1);
      VK_INSERT: {Insert} InsMode:=Not InsMode;
       VK_SPACE: DrawPxl(Clr, False);
      VK_DELETE: VisCoord:=Not VisCoord; { v2.09 }
        VK_HOME: I:=0; { v2.09 }
         VK_END: I:=PX; { v2.09 }
        VK_PGUP: J:=0; { v2.09 }
        VK_PGDN: J:=PY; { v2.09 }
      VK_RETURN: Clr:=SlctClr(Clr); { v2.04 }
         VK_TAB: Begin
                   WaitTextShow(True); { v2.10 }
                   SetViewPort(500, 10, 500 + PX, 10 + PY, True); { v2.03 }
                   SetFillStyle(1, Clr);
                   FloodFill(I, J, Clr);
                   SetViewPort(0, 0, GetMaxX, GetMaxY, True);
                   T1:=I;
                   T2:=J;
                   For J:=0 To PY Do
                     For I:=0 To PX Do
                       DrawPxl(GetPixel(500 + I, 10 + J), True);
                   I:=T1;
                   J:=T2;
                   WaitTextShow(False); { v2.10 }
                 End;
    End;
    { v2.06 }
    If ((Ch = VK_UP) Or (Ch = VK_DOWN) Or (Ch = VK_LEFT) Or (Ch = VK_RIGHT) Or (Ch = VK_INSERT)) Then
    Begin
      If (InsMode = True) Then DrawPxl(Clr, False);
    End;
    ToggleCursor;
  Until (Ch = VK_ESCAPE);
  ToggleCursor;
  Bk:=Capture(500, 10, 500+PX, 10+PY);
  ClearDevice;
  Prepare(False);
  UndoFunc;
  BarPicture;
  PutImage(PicX, PicY, Bk^, CopyPut);
  ImgRelease(Bk);
  BarPicture;
  Ch:=0;
End;

Procedure Rotate;
Var
  Bk: Pointer;
   Z: Char;
   S: String[3];
   X, Y, X1, Y1, W, H, I, J, C, D: LongInt;
   rAng, rSin, rCos, rDim, rAT2: Real;
Begin
  Bk:=Capture(200, 50, 300, 100);
  IOButton(200, 50, 300, 100, '', True, True);
  SetColor(0);
  QOutTextXY(223, 58, '');
  QOutTextXY(208, 67, ' :');
  S:='0';
  QOutTextXY(256, 67, S);
  Repeat
    Ch:=KeybRead(KEYB_READ);
    Z:=Chr(Lo(Ch));
    Ch:=Hi(Ch);
    SetColor(7);
    QOutTextXY(256, 67, S);
    If ((Ch <> VK_BACK) And (Length(S) < 3) And ((Z >= '0') And (Z <= '9'))) Then
    Begin
      If (S = '0') Then S[1]:=Z Else S:=S + Z;
    End;
    If ((Ch = VK_BACK) And (Length(S) > 0)) Then
    Begin
      Delete(S, Length(S), 1);
      If (S = '') Then S:='0';
    End;
   SetColor(0);
   QOutTextXY(256, 67, S);
  Until ((Ch = VK_ESCAPE) Or (Ch = VK_RETURN));
  PutImage(200, 50, Bk^, CopyPut);
  ImgRelease(Bk);
  C:=0;
  While (Length(S) > 0) Do
  Begin
    C:=(C * 10) + (Ord(S[1]) - Ord('0'));
    Delete(S, 1, 1);
  End;
  C:=C Mod 360;
  If ((Ch = VK_RETURN) And (C > 0)) Then
  Begin
    BarPicture;
    SaveBackGround(False);
    SetFillStyle(1, 0);
    Bar(PicX, PicY, PicXe, PicYe);
    { v2.08 }
    rAng:=(C * Pi) / 180;
    rSin:=Sin(rAng);
    rCos:=Cos(rAng);
    W:=PicXe - PicX + 1;
    H:=PicYe - PicY + 1;
    rDim:=Sqrt(Sqr(W) + Sqr(H));
    D:=Round(rDim);
    { atan2 = 2 * ArcTan(y / (Sqrt(Sqr(x) + Sqr(y)) + x)); }
    rAT2:=2 * ArcTan((-H / 2) / (Sqrt(Sqr(-W / 2) + Sqr(-H / 2)) + (-W / 2)));
    X1:=Round(Cos(rAT2 - rAng) * (rDim / 2));
    Y1:=Round(Sin(rAT2 - rAng) * (rDim / 2));
    X:=PicX + Round(W / 2) + X1;
    Y:=PicY + Round(H / 2) + Y1;
    For J:=-D To (D * 2) Do
    Begin
      {If ((Y + J) <= StartY) Then Continue;
      If ((Y + J) >= GetMaxY) Then Break;}
      If (((Y + J) > StartY) And ((Y + J) < GetMaxY)) Then { v2.09 }
      Begin
        For I:=-D To (D * 2) Do
        Begin
          {If ((X + I) <= StartX) Then Continue;
          If ((X + I) >= GetMaxX) Then Break;}
          If (((X + I) > StartX) And ((X + I) < GetMaxX)) Then { v2.09 }
          Begin
            X1:=Round((I * rCos) - (J * rSin));
            Y1:=Round((J * rCos) + (I * rSin));
            If ((X1 >= 0) And (X1 < W) And (Y1 >= 0) And (Y1 < H)) Then
            Begin
              SetActivePage(1);
              C:=GetPixel(PicX + X1, PicY + Y1);
              SetActivePage(0);
              PutPixel(X + I, Y + J, C);
            End;
          End;
        End;
      End;
    End;
    BarPicture;
  End;
  Ch:=0;
End;

Procedure MoveTab(F7B: Boolean);
Var PicXOld, PicYOld: Integer;
Begin
  Mode(False);
  SetColor(15);
  PicXOld:=PicX;
  PicYOld:=PicY;
  Ch:=0;
  Repeat
    Ch:=Hi(KeybRead(KEYB_READ));
    Rectangle(PicX, PicY, PicXe, PicYe);
    OutPutCoo(False);
    If (Ch = VK_TAB) Then Ch:=VK_RETURN; { v2.06 }
    ChangeStep(Ch); { v2.06 }
    Case Ch Of
      { v2.06 }
         VK_UP: Begin
                  PicYe:=PicYe - PicY;
                  PicY:=AddSubValue(PicY, -1, StartY + 1, GetMaxY - 1 - PicYe);
                  PicYe:=PicYe + PicY;
                End;
       VK_DOWN: Begin
                  PicYe:=PicYe - PicY;
                  PicY:=AddSubValue(PicY,  1, StartY + 1, GetMaxY - 1 - PicYe);
                  PicYe:=PicYe + PicY;
                End;
       VK_LEFT: Begin
                  PicXe:=PicXe - PicX;
                  PicX:=AddSubValue(PicX, -1, StartX + 1, GetMaxX - 1 - PicXe);
                  PicXe:=PicXe + PicX;
                End;
      VK_RIGHT: Begin
                  PicXe:=PicXe - PicX;
                  PicX:=AddSubValue(PicX,  1, StartX + 1, GetMaxX - 1 - PicXe);
                  PicXe:=PicXe + PicX;
                End;
         VK_F7: If (F7B = True) Then
                Begin
                  Rectangle(PicX, PicY, PicXe, PicYe);
                  OutPutCoo(True);
                  PictureSize;
                  OutPutCoo(False);
                  Mode(False);
                  Rectangle(PicX, PicY, PicXe, PicYe);
                End;
      { v2.09 }
       VK_HOME: Begin
                  PicXe:=PicXe - PicX;
                  PicX:=StartX + 1;
                  PicXe:=PicXe + PicX;
                End;
        VK_END: Begin
                  PicXe:=PicXe - PicX;
                  PicX:=GetMaxX - 1 - PicXe;
                  PicXe:=PicXe + PicX;
                End;
       VK_PGUP: Begin
                  PicYe:=PicYe - PicY;
                  PicY:=StartY + 1;
                  PicYe:=PicYe + PicY;
                End;
       VK_PGDN: Begin
                  PicYe:=PicYe - PicY;
                  PicY:=GetMaxY - 1 - PicYe;
                  PicYe:=PicYe + PicY;
                End;
    End;
    OutPutCoo(True);
    Rectangle(PicX, PicY, PicXe, PicYe);
  Until ((Ch = VK_RETURN) Or (Ch = VK_ESCAPE));
  If (Ch = VK_ESCAPE) Then
  Begin
    Rectangle(PicX, PicY, PicXe, PicYe);
    OutPutCoo(False);
    PicXe:=PicXe-PicX;
    PicYe:=PicYe-PicY;
    PicX:=PicXOld;
    PicY:=PicYOld;
    PicXe:=PicX+PicXe;
    PicYe:=PicY+PicYe;
    OutPutCoo(True);
    SetColor(15);
    Rectangle(PicX, PicY, PicXe, PicYe);
  End;
  Mode(True);
End;

Procedure NewPicture;
Var
  B: Pointer;
  C: Char;
Begin
  B:=Capture(20, 60, 150, 120);
  IOButton(20, 60, 150, 120, '', True, True);
  SetColor(0);
  QOutTextXY(33, 66, '⢨⥫쭮');{130}
  QOutTextXY(33, 76, 'ᮧ ');
  QOutTextXY(29, 86, '㭮 (Y/N)?');
  Repeat
    Ch:=KeybRead(KEYB_READ);
    C:=UpCase(Chr(Lo(Ch)));
    Ch:=Hi(Ch);
  Until ((C = 'Y') Or (C = 'N') Or (Ch = VK_ESCAPE)); { v2.03 }
  PutImage(20, 60, B^, CopyPut);
  ImgRelease(B);
  If (C = 'Y') Then
  Begin
    OutFName(False);
    BarPicture;
    SetActivePage(1);
    ClearDevice;
    SetActivePage(0);
    SetFillStyle(1, 0);
    Bar(StartX+1, StartY+1, GetMaxX-1, GetMaxY-1);
    OutPutSize(False);
    OutPutCoo(False);
    PicX:=StartX+1;
    PicY:=StartY+1;
    PicXe:=StartX+1+59;
    PicYe:=StartY+1+79;
    OutPutSize(True);
    OutPutCoo(True);
    BarPicture;
    FileEdit:='';
    OutFName(True);
  End;
  Ch:=0;
End;

Procedure AllArea;
Var
  I, J, Ic, Jc, Iclr, Cclr: Integer;
                    K1, K2: Word;
                    R1, R2: LongInt;
                    LF, SV: Byte;
Procedure GtClr(Clr: Boolean);
Var X, Y, W: Integer;
Begin
  If (Clr = True) Then
  Begin
    Y:=62+8+(MenuItemsMax)*20+3;
    W:=IClr;
  End
  Else
  Begin
    Y:=62+8+(MenuItemsMax+1)*20+3;
    W:=CClr;
  End;
  X:=5;
  Y:=Y+5;
  SetColor(15);
  QOutTextXY(105, Y, #17);
  Repeat
    Ch:=Hi(KeybRead(KEYB_READ));
    PutImage(X+(W*6), Y, ECurs[2]^, XOrPut);
    W:=EasyMenu(Ch, W, 0, 15, True); { v2.09 }
    PutImage(X+(W*6), Y, ECurs[2]^, XOrPut);
  Until ((Ch = VK_RETURN) Or (Ch = VK_ESCAPE));
  PutImage(X+(W*6), Y, ECurs[2]^, XOrPut);
  If (Ch = VK_RETURN) Then
  Begin
    If (Clr = True) Then IClr:=W Else CClr:=W;
  End
  Else
  Begin
    If (Clr = True) Then W:=IClr Else W:=CClr;
  End;
  PutImage(X+(W*6), Y, ECurs[2]^, XOrPut);
  SetColor(0);
  QOutTextXY(105, Y, #17);
  Ch:=KeybRead(KEYB_FREE);
  Ch:=0;
End;
{ v2.09 - OutTextXY should be faster than QOutTextXY }
Procedure OutPutArea(X1, Y1, X2, Y2: Word; Op: Boolean);
Var S: String[3];
Begin
  If (Op = True) Then SetColor(1) Else SetColor(7);
  Str(X1 - StartX - 1, S);
  OutTextXY(416, 16, S);
  Str(Y1 - StartY - 1, S);
  OutTextXY(456, 16, S);
  Str(X2 - StartX - 1, S);
  OutTextXY(416, 25, S);
  Str(Y2 - StartY - 1, S);
  OutTextXY(456, 25, S);
End;
Begin
  { v2.09 }
  OutPutSize(False);
  OutPutCoo(False);
  { v2.06 }
  SV:=StepValue;
  ChangeStep($FFFE);
  StepValue:=10;
  ChangeStep($FFFF);
  Mode(True);
  { --- }
  SaveBackGround(True);
  I:=MenuItemsMax{+1};
  SetFillStyle(1, 7);
  { v2.04 - fix +8 }
  Bar(0, 62+8+I*20-1, 103, 62+8+(I+2)*20-1);
  IOButton(1, 62+8+I*20, 102, 62+8+I*20+18, '', True, True);
  I:=I+1;
  IOButton(1, 62+8+I*20, 102, 62+8+I*20+18, '', True, True);
  For J:=0 To 15 Do
  Begin
    SetFillStyle(1, J);
    Bar(4+(6*J), 62+8+I*20+3, 4+(6*J)+5, 62+8+I*20+15);
    Bar(4+(6*J), 62+8+(I-1)*20+3, 4+(6*J)+5, 62+8+(I-1)*20+15);
  End;
  PutImage(95, 62+8+(I-1)*20+8, ECurs[2]^, XOrPut);
  PutImage(95, 62+8+I*20+8, ECurs[2]^, XOrPut);
  { v2.09 }
  I:=StartX + 1 + 10;
  J:=StartY + 1 + 10;
  Ic:=I - 4;
  Jc:=J - 3;
  {Ic:=StartX+1+10;
  Jc:=StartY+1+10;
  I:=Ic+4;
  J:=Jc+3;}
  LF:=VK_TAB;
  IClr:=15;
  CClr:=15;
  BarPicture;
  PutImage(I, J, ECurs[2]^, XOrPut);
  PutImage(Ic, Jc, ECurs[3]^, XOrPut);
  Repeat
    OutPutArea(I, J, Ic+4, Jc+3, True); { v2.09 }
    Ch:=Hi(KeybRead(KEYB_READ));
    OutPutArea(I, J, Ic+4, Jc+3, False); { v2.09 }
    PutImage(I, J, ECurs[2]^, XOrPut);
    PutImage(Ic, Jc, ECurs[3]^, XOrPut);
    ChangeStep(Ch); { v2.06 }
    Mode(True);
    If (Ch = VK_SPACE) Then Ch:=LF;
    { v2.09 - at least one Shift key pressed }
    If ((KeybStat And 3) <> 0) Then
    Begin
      Case Ch Of
        { cursor }
        VK_UP, VK_DOWN:
        Begin
          J:=J - (StartY+1);
          If (Ch = VK_UP) Then J:=((J Div StepValue) * StepValue) + StepValue
          Else J:=(((J + StepValue - 1) Div StepValue) * StepValue) - StepValue;
          J:=J + (StartY+1);
        End;
        VK_LEFT, VK_RIGHT:
        Begin
          I:=I - (StartX+1);
          If (Ch = VK_LEFT) Then I:=((I Div StepValue) * StepValue) + StepValue
          Else I:=(((I + StepValue - 1) Div StepValue) * StepValue) - StepValue;
          I:=I + (StartX+1);
        End;
        { circle }
        VK_W, VK_S:
        Begin
          Jc:=Jc - (StartY+1)+3;
          If (Ch = VK_W) Then Jc:=((Jc Div StepValue) * StepValue) + StepValue
          Else Jc:=(((Jc + StepValue - 1) Div StepValue) * StepValue) - StepValue;
          Jc:=Jc + (StartY+1)-3;
        End;
        VK_A, VK_D:
        Begin
          Ic:=Ic - (StartX+1)+4;
          If (Ch = VK_A) Then Ic:=((Ic Div StepValue) * StepValue) + StepValue
          Else Ic:=(((Ic + StepValue - 1) Div StepValue) * StepValue) - StepValue;
          Ic:=Ic + (StartX+1)-4;
        End;
      End;
    End;
    Case Ch Of
          VK_UP:  J:=AddSubValue(J , -1, StartY+1+3, GetMaxY-1-5  );
        VK_DOWN:  J:=AddSubValue(J ,  1, StartY+1+3, GetMaxY-1-5  );
        VK_LEFT:  I:=AddSubValue(I , -1, StartX+1+4, GetMaxX-1-5  );
       VK_RIGHT:  I:=AddSubValue(I ,  1, StartX+1+4, GetMaxX-1-5  );
       VK_W{Up}: Jc:=AddSubValue(Jc, -1, StartY+1  , GetMaxY-1-5-3);
     VK_S{Down}: Jc:=AddSubValue(Jc,  1, StartY+1  , GetMaxY-1-5-3);
     VK_A{Left}: Ic:=AddSubValue(Ic, -1, StartX+1  , GetMaxX-1-5-4);
    VK_D{Right}: Ic:=AddSubValue(Ic,  1, StartX+1  , GetMaxX-1-5-4);
        VK_HOME:  If ((KeybStat And 3) <> 0) Then Ic:=StartX+1 Else I:=StartX+1+4; { v2.10 }
         VK_END:  If ((KeybStat And 3) <> 0) Then Ic:=GetMaxX-1-5-4 Else I:=GetMaxX-1-5; { v2.10 }
        VK_PGUP:  If ((KeybStat And 3) <> 0) Then Jc:=StartY+1 Else J:=StartY+1+3; { v2.10 }
        VK_PGDN:  If ((KeybStat And 3) <> 0) Then Jc:=GetMaxY-1-5-3 Else J:=GetMaxY-1-5; { v2.10 }
     VK_TAB{#9}: Begin
                   Ic:=I - 4;
                   Jc:=J - 3;
                 End;
          VK_F1: Help(12+1);
      VK_DELETE: Begin {Delete}
                   SetViewPort(StartX+1, StartY+1, GetMaxX-1, GetMaxY-1, True); { v2.10 }
                   SetFillStyle(1, CClr);
                   Bar(Ic+4-10-StartX-1, Jc+3-10-StartY-1, Ic+4+10-StartX-1, Jc+3+10-StartY-1);
                   SetViewPort(0, 0, GetMaxX, GetMaxY, True); { v2.10 }
                 End;
    {Functions:}
           VK_L: Begin {~L~ine}
                   SetColor(IClr);
                   Line(I, J, Ic+4, Jc+3);
                   LF:=Ch;
                 End;
           VK_R: Begin {Ci~r~cle}
                   SetColor(IClr);
                   SetViewPort(StartX+1, StartY+1, GetMaxX-1, GetMaxY-1, True);
                   GetAspectRatio(K1, K2); { v2.07 }
                   R1:=I - (Ic + 4);
                   R2:=J - (Jc + 3);
                   Circle(Ic+4-StartX-1, Jc+3-StartY-1, Trunc(Sqrt(Sqr(R1) + Sqr((R2 * K2) / K1))));
                   SetViewPort(0, 0, GetMaxX, GetMaxY, True);
                   LF:=Ch;
                 End;
           VK_B: Begin {~B~ar}
                   SetColor(IClr);
                   Rectangle(I, J, Ic+4, Jc+3);
                   LF:=Ch;
                 End;
           VK_F: Begin {~F~lood}
                   SetViewPort(StartX+1, StartY+1, GetMaxX-1, GetMaxY-1, True);
                   SetFillStyle(1, CClr);
                   FloodFill(Ic+4-StartX-1, Jc+3-StartY-1, IClr);
                   SetViewPort(0, 0, GetMaxX, GetMaxY, True);
                   LF:=Ch;
                 End;
           VK_I: GtClr(False); {F~i~ll}
           VK_C: GtClr(True); {~C~olor}
    End;
    PutImage(Ic, Jc, ECurs[3]^, XOrPut);
    PutImage(I, J, ECurs[2]^, XOrPut);
  Until (Ch = VK_ESCAPE);
  PutImage(Ic, Jc, ECurs[3]^, XOrPut);
  PutImage(I, J, ECurs[2]^, XOrPut);
  BarPicture;
  I:=MenuItemsMax{+1};
  SetFillStyle(1, 0);
  Bar(0, 62+8+I*20-1, 103, 62+8+(I+2)*20+1);
  { v2.06 }
  ChangeStep($FFFE);
  StepValue:=SV;
  ChangeStep($FFFF);
  { v2.09 }
  OutPutCoo(True);
  OutPutSize(True);
  Mode(True);
End;

Procedure CopyOfPic;
Var
  PicXo, PicYo, Y: Integer;
               Bk: Pointer;
Begin
  PicXo:=PicX;
  PicYo:=PicY;
  MoveTab(False);
  If (Ch = VK_RETURN) Then
  Begin
    BarPicture;
    SaveBackGround(False);
    Bk:=Capture(PicXo, 0, PicXo+(PicXe-PicX), 0); { v2.09 }
    For Y:=PicYo To PicYo+(PicYe-PicY) Do
    Begin
      SetActivePage(1);
      GetImage(PicXo, Y, PicXo+(PicXe-PicX), Y, Bk^);
      SetActivePage(0);
      PutImage(PicX, PicY+(Y-PicYo), Bk^, CopyPut);
    End;
    ImgRelease(Bk);
    BarPicture;
  End;
  Ch:=0;
End;

Procedure QuitQuestion;
Var
  B: Pointer;
  C: Char;
Begin
  B:=Capture(20, 60, 150, 120);
  IOButton(20, 60, 150, 120, '', True, True);
  SetColor(0);
  QOutTextXY(37, 66, '室 (Y/N)?');
  Repeat
    Ch:=KeybRead(KEYB_READ);
    C:=UpCase(Chr(Lo(Ch)));
    Ch:=Hi(Ch);
  Until ((C = 'Y') Or (C = 'N') Or (Ch = VK_ESCAPE)); { v2.03 }
  Quit:=(C = 'Y');
  PutImage(20, 60, B^, CopyPut);
  ImgRelease(B);
End;

Function EnterFileName(FileName: String): String;
Var
  CrVis: Boolean;
  D, D1: Word;
     Bk: Pointer;
      C: Char;
Procedure DrawCur;
Begin
  Mode(False);
  SetColor(7);
  Rectangle(28+(Length(Copy(FileName, Length(FileName)-19, 20))*8), 77,
    28+(Length(Copy(FileName, Length(FileName)-19, 20))*8)+1, 86);
  Mode(True);
End;
Procedure Crsr;
Var T: Word;
Begin
  GetTime(T, T, D, T);
  If (D <> D1) Then
  Begin
    DrawCur;
    CrVis:=Not CrVis;
    D1:=D;
  End;
End;
Begin
  Bk:=Capture(20, 60, 200, 120);
  IOButton(20, 60, 200, 120, '', True, True);
  SetColor(0);
  QOutTextXY(28, 68, ' 䠩:');
  QOutTextXY(28, 78, Copy(FileName, Length(FileName)-19, 20));
  CrVis:=False;
  Repeat
    Crsr;
    If (KeybRead(KEYB_TEST) <> 0) Then
    Begin
      Ch:=KeybRead(KEYB_READ);
      C:=Chr(Lo(Ch));
      Ch:=Hi(Ch);
      If ((C <> #0) And (Ch <> VK_RETURN) And (Ch <> VK_ESCAPE)) Then { v2.03 }
      Begin
        If (CrVis = True) Then DrawCur;
        SetColor(7);
        QOutTextXY(28, 78, Copy(FileName, Length(FileName)-19, 20));
        If (Ch <> VK_BACK) Then
        Begin
          If ((Length(FileName) < 80) And (C >= #32)) Then FileName:=FileName + C; { v2.06 }
        End
        Else Delete(FileName, Length(FileName), 1);
        SetColor(0);
        QOutTextXY(28, 78, Copy(FileName, Length(FileName)-19, 20));
        If (CrVis = True) Then DrawCur;
      End;
    End;
  Until ((Ch = VK_RETURN) Or (Ch = VK_ESCAPE));
  PutImage(20, 60, Bk^, CopyPut);
  ImgRelease(Bk);
  If (Ch = VK_ESCAPE) Then FileName:='';
  EnterFileName:=FileName;
  Ch:=0;
End;

Procedure OpnFl(S: String);
Var I: LongInt;
Begin
  I:=AllGRAOpen(-1, -1, S);
  If (I <> -1) Then
  Begin
    OutPutSize(False);
    Mode(True);
    PicXe:=PicX + (I And $FFFF);
    PicYe:=PicY + ((I ShR 16) And $FFFF);
    I:=AllGRAOpen(PicX, PicY, S);
  End;
  SetColor(15);
  Rectangle(StartX, StartY, GetMaxX, GetMaxY);
  If (PicXe > (GetMaxX - 1)) Then PicXe:=(GetMaxX - 1);
  If (PicYe > (GetMaxY - 1)) Then PicYe:=(GetMaxY - 1);
  OutPutSize(True);
End;

Procedure OpenFile;
Var
  S: String;
  D: Byte;
Begin
  OutFName(False);
  S:=EnterFileName(FileEdit);
  If (S <> '') Then
  Begin
    D:=IsFileExist(S);
    If (D = 0) Then D:=11 * Ord(IsFileImage(S) = False); { v2.06 }
    If (D = 0) Then
    Begin
      FileEdit:=S;
      BarPicture;
      SaveBackGround(False);
      OpnFl(S);
      BarPicture;
    End
    Else ErrorMessage(D);
  End;
  OutFName(True);
End;

Procedure SaveFile;
Var
  Bk: Pointer;
   S: String;
   W: Byte;
   C: Char;
Begin
  OutFName(False);
  S:=EnterFileName(FileEdit);
  If (S <> '') Then
  Begin
    W:=IsFileExist(S);
    { DOS error 0 - file found }
    If (W = 0) Then
    Begin
      Bk:=Capture(20, 60, 150, 120);
      IOButton(20, 60, 150, 120, '', True, True);
      SetColor(0);
      QOutTextXY(36+9, 66, ' 䠩');{130}
      QOutTextXY(36+13, 76, '㦥 .');
      QOutTextXY(36+1, 86, '१');
      QOutTextXY(36+9, 96, ' (Y/N)?');
      Repeat
        Ch:=KeybRead(KEYB_READ);
        C:=UpCase(Chr(Lo(Ch)));
        Ch:=Hi(Ch);
      Until ((C = 'Y') Or (C = 'N') Or (Ch = VK_ESCAPE)); { v2.03 }
      PutImage(20, 60, Bk^, CopyPut);
      ImgRelease(Bk);
      If (C = 'Y') Then W:=2; { v2.06 }
    End;
    { DOS error 2 - file not found }
    If (W = 2) Then
    Begin
      BarPicture;
      { v2.06 }
      If (AllGRASave(PicX, PicY, PicXe, PicYe, S) = True) Then W:=0
      Else W:=19;
      BarPicture;
    End;
    { v2.06 }
    If (W <> 0) Then ErrorMessage(W)
    Else FileEdit:=S; { v2.10 }
  End;
  Ch:=0;
  OutFName(True);
End;

Procedure UndoFunc;
Var
  Bk: Pointer;
   I: Word;
Begin
  BarPicture;
  Bk:=Capture(StartX+1, 0, GetMaxX-1, 0); { v2.09 }
  For I:=StartY+1 To GetMaxY-1 Do
  Begin
    SetActivePage(1);
    GetImage(StartX+1, I, GetMaxX-1, I, Bk^);
    SetActivePage(0);
    PutImage(StartX+1, I, Bk^, CopyPut);
  End;
  ImgRelease(Bk);
  BarPicture;
End;

Procedure VSimFlip(Flip: Boolean);
Var
  Bk, Bk1: Pointer;
        I: Word;
Begin
  Bk:=Capture(0, PicY, 0, PicYe); { v2.09 }
  If (Flip = True) Then Bk1:=Capture(0, PicY, 0, PicYe); { v2.09 }
  For I:=PicX To (PicX+((PicXe-PicX) Div 2)) Do
  Begin
    GetImage(I, PicY, I, PicYe, Bk^);
    If (Flip = True) Then
    Begin
      GetImage(PicX+(PicXe-I), PicY, PicX+(PicXe-I), PicYe, Bk1^);
      PutImage(I, PicY, Bk1^, CopyPut);
    End;
    PutImage(PicX+(PicXe-I), PicY, Bk^, CopyPut);
  End;
  If (Flip = True) Then ImgRelease(Bk1);
  ImgRelease(Bk);
End;

Procedure HSimFlip(Flip: Boolean);
Var
  Bk, Bk1: Pointer;
        I: Word;
Begin
  Bk:=Capture(PicX, 0, PicXe, 0); { v2.09 }
  If (Flip = True) Then Bk1:=Capture(PicX, 0, PicXe, 0); { v2.09 }
  For I:=PicY To (PicY+((PicYe-PicY) Div 2)) Do
  Begin
    GetImage(PicX, I, PicXe, I, Bk^);
    If (Flip = True) Then
    Begin
      GetImage(PicX, PicY+(PicYe-I), PicXe, PicY+(PicYe-I), Bk1^);
      PutImage(PicX, I, Bk1^, CopyPut);
    End;
    PutImage(PicX, PicY+(PicYe-I), Bk^, CopyPut);
  End;
  If (Flip = True) Then ImgRelease(Bk1);
  ImgRelease(Bk);
End;

{ v2.05 }
Function SelectColorBar(bTwo: Boolean): Word;
Var
  I, R: Word;
     P: Pointer;
     S: String;
Begin
  P:=Capture(100, 50, 450, 100);
  IOButton(100, 50, 450, 100, '', True, True);
  SetColor(0);
  If (bTwo = True) Then S:='롥  梥:' Else S:='롥 梥 䮭:';
  QOutTextXY(200, 58, S);
  For I:=0 To 15 Do
  Begin
    SetFillStyle(1, I);
    Bar(110+(I*20), 70, 110+(I*20)+20, 70+20);
  End;
  I:=0;
  R:=0;
  PutImage(110+4+(I*20), 70+4, ECurs[1]^, XOrPut);
  Ch:=0;
  Repeat
    Ch:=Hi(KeybRead(KEYB_READ));
    PutImage(110+4+(I*20), 70+4, ECurs[1]^, XOrPut);
    I:=EasyMenu(Ch, I, 0, 15, True); { v2.09 }
    PutImage(110+4+(I*20), 70+4, ECurs[1]^, XOrPut);
    If (Ch = VK_RETURN) Then
    Begin
      If (bTwo = True) Then
      Begin
        SetColor(7);
        QOutTextXY(200, 58, S);
        SetColor(0);
        QOutTextXY(200, 58, '롥  梥:');
      End;
      If ((bTwo = False) Or ((R And $1000) <> 0)) Then R:=(R Or $8000);
      R:=(((R And $FF) Shl 4) Or (R And $F000));
      R:=R Or (I And $0F);
      R:=R Or $1000;
    End;
  Until ((Ch = VK_ESCAPE) Or ((Ch = VK_RETURN) And ((R And $8000) = $8000)));
  PutImage(100, 50, P^, CopyPut);
  ImgRelease(P);
  Ch:=0;
  SelectColorBar:=(R And $8FFF);
End;

Procedure ChangeColor;
Var I, J, C: Word;
Begin
  C:=SelectColorBar(True);
  If ((C And $8000) <> 0) Then
  Begin
    C:=(((C And $0F) ShL 8) Or ((C ShR 4) And $0F));
    C:=C Xor $0F0F;
    SaveBackGround(False);
    { v2.05 }
    SetColor(15);
    Mode(False);
    For J:=PicY To PicYe Do
    Begin
      Line(PicX, J, PicXe, J); { v2.05 }
      For I:=PicX To PicXe Do
        If (GetPixel(I, J) = Lo(C)) Then PutPixel(I, J, Hi(C));
      Line(PicX, J, PicXe, J); { v2.05 }
    End;
    Mode(True); { v2.05 }
  End;
End;

Procedure ScaleImage;
Var
  I, J, W, H, W2, H2, C: Integer;
  ZX, ZY, CX, CY: LongInt;
Begin
  I:=PicXe;
  J:=PicYe;
  BarPicture;
  PictureSize;
  BarPicture;
  If (Ch = VK_RETURN) Then
  Begin
    SaveBackGround(False);
    SetFillStyle(1, 0);
    Bar(PicX, PicY, I, J);
    { v2.08 }
    W:=I - PicX + 1;
    H:=J - PicY + 1;
    W2:=PicXe - PicX + 1;
    H2:=PicYe - PicY + 1;
    ZX:=W;
    ZY:=H;
    ZX:=(ZX ShL 16) Div W2;
    ZY:=(ZY ShL 16) Div H2;
    CY:=0;
    For J:=0 To (H2 - 1) Do
    Begin
      CX:=0;
      For I:=0 To (W2 - 1) Do
      Begin
        SetActivePage(1);
        C:=GetPixel(PicX + (CX ShR 16), PicY + (CY ShR 16));
        SetActivePage(0);
        PutPixel(PicX + I, PicY + J, C);
        CX:=CX + ZX;
      End;
      CY:=CY + ZY;
    End;
  End;
End;

Procedure FuncMenu;
Var
  Bk: Pointer;
   I: Byte;
Begin
  Bk:=Capture(50, 40, 215, 164);
  IOButton(50, 40, 215, 164, '', True, True);
  For I:=1 To FMenuItemsMax Do
  Begin
    IOButton(50+3, 40+3+((I-1)*20), 200, 40+3+((I-1)*20)+18, FMenuItems[I], True, True);
    PutImage(201, 40+3+((I-1)*20)+5, ECurs[1]^, OrPut);
    PutImage(201, 40+3+((I-1)*20)+5, ECurs[1]^, XOrPut);
  End;
  I:=1;
  PutImage(201, 40+3+5, ECurs[1]^, XOrPut);
  Ch:=0;
  Repeat
    Ch:=Hi(KeybRead(KEYB_READ));
    PutImage(201, 40+3+((I-1)*20)+5, ECurs[1]^, XOrPut);
    I:=EasyMenu(Ch, I, 1, FMenuItemsMax, False); { v2.09 }
    PutImage(201, 40+3+((I-1)*20)+5, ECurs[1]^, XOrPut);
  Until ((Ch = VK_ESCAPE) Or (Ch = VK_RETURN));
  If (Ch = VK_RETURN) Then
  Begin
    IOButton(50+3, 40+3+((I-1)*20), 200, 40+3+((I-1)*20)+18, FMenuItems[I], False, True);
    IOButton(50+3, 40+3+((I-1)*20), 200, 40+3+((I-1)*20)+18, FMenuItems[I], True, True);
  End;
  PutImage(50, 40, Bk^, CopyPut);
  ImgRelease(Bk);
  If (Ch = VK_RETURN) Then
  Begin
    BarPicture;
    If (I>=1) And (I<=4) Then SaveBackGround(False);
    Case I Of
      1: VSimFlip(False);
      2: HSimFlip(False);
      3: VSimFlip(True);
      4: HSimFlip(True);
      5: ChangeColor;
      6: ScaleImage;
    End;
    BarPicture;
  End;
  Ch:=0;
End;

{ v2.05 }
Procedure PictTrim;
Var
  I, J, C: Word;
        P: Array[1..4] Of Word;
Begin
  BarPicture;
  { get background color }
  C:=SelectColorBar(False);
  If ((C And $8000) <> 0) Then
  Begin
    { initial coords }
    P[1]:=PicXe;
    P[2]:=PicYe;
    P[3]:=PicX;
    P[4]:=PicY;
    C:=(C And $0F) XOr $0F;
    SetColor(15);
    Mode(False);
    For J:=PicY To PicYe Do
    Begin
      Line(PicX, J, PicXe, J);
      For I:=PicX To PicXe Do
      Begin
        If (GetPixel(I, J) <> Lo(C)) Then
        Begin
          If (I < P[1]) Then P[1]:=I;
          If (J < P[2]) Then P[2]:=J;
          If (I > P[3]) Then P[3]:=I;
          If (J > P[4]) Then P[4]:=J;
          { got something - not empty image }
          C:=C Or $100;
        End;
      End;
      Line(PicX, J, PicXe, J);
    End;
    Mode(True);
    { set trim coords }
    If ((C And $100) <> 0) Then
    Begin
      OutPutSize(False);
      OutPutCoo(False);
      PicX:=P[1];
      PicY:=P[2];
      PicXe:=P[3];
      PicYe:=P[4];
      OutPutCoo(True);
      OutPutSize(True);
    End;
  End;
  BarPicture;
End;

Procedure RunFunction(N: Byte);
Begin
  Ch:=0;
  IOButton(1, 62+((N-1)*20), 99, 62+((N-1)*20)+18, MenuItems[N], False, True);
  Case N Of
     1: NewPicture;
     2: OpenFile;
     3: SaveFile;
     4: CopyOfPic;
     5: PictureSize;
     6: FuncMenu;
     7: PictTrim; { v2.05 }
     7+1: AllArea;
     8+1: UndoFunc;
     9+1: Editor;
    10+1: Rotate;
    11+1: QuitQuestion;
  End;
  IOButton(1, 62+((N-1)*20), 99, 62+((N-1)*20)+18, MenuItems[N], True, True);
  Ch:=0;
End;

{ v2.06 }
Procedure Cleanup;
Var I: Integer;
Begin
  For I:=ECur_c DownTo 1 Do
    ImgRelease(ECurs[I]);
End;

End.
