Unit FGraph;

Interface

Function Capture(X1, Y1, X2, Y2: Integer): Pointer;
Function CalcImageSize(X1, Y1, X2, Y2: Integer): Longint; { v2.06 }
Procedure ImgRelease(Var P: Pointer); { v2.11 }
Function IsFileImage(FileName: String): Boolean; { v2.06 }
Function AllGRAOpen(X, Y: Integer; FileName: String): Longint;
Function AllGRASave(X1, Y1, X2, Y2: Integer; FileName: String): Boolean;

Implementation

Uses Graph, FileUnit;

{ v2.09 }
Procedure FixCoords(Var X1, Y1, X2, Y2: Integer);
Begin
  If (X2 < X1) Then
  Begin
    X1:=X1 Xor X2;
    X2:=X2 Xor X1;
    X1:=X1 Xor X2;
  End;
  If (Y2 < Y1) Then
  Begin
    Y1:=Y1 Xor Y2;
    Y2:=Y2 Xor Y1;
    Y1:=Y1 Xor Y2;
  End;
End;

Function Capture;
Var
  Sz: Word;
   P: Pointer;
Begin
  P:=Nil;
  FixCoords(X1, Y1, X2, Y2); { v2.09 }
  Sz:=ImageSize(X1, Y1, X2, Y2);
  { v2.03 }
  If (Sz > 0) Then
  Begin
    GetMem(P, Sz);
    If (P <> Nil) Then GetImage(X1, Y1, X2, Y2, P^);
  End;
  Capture:=P;
End;

{ v2.06 }
Function CalcImageSize;
Var Sz: Longint;
Begin
  FixCoords(X1, Y1, X2, Y2); { v2.09 }
  Sz:=(X2 - X1) + 1;
  Sz:=((Sz + 7) Div 8) * 4;
  Sz:=Sz * ((Y2 - Y1) + 1);
  CalcImageSize:=Sz + 6;
End;

{ v2.11 }
Procedure ImgRelease(Var P: Pointer);
Var C: Array[0..1] Of Word;
Begin
  If (P <> Nil) Then
  Begin
    Move(P^, C, SizeOf(C));
    FreeMem(P, CalcImageSize(0, 0, C[0], C[1]));
    P:=Nil;
  End;
End;

{ v2.06 }
Function IsFileImage;
Var
  W, H: Word;
    Fl: File;
Begin
  IsFileImage:=False;
  If (FlOpen(Fl, FileName, FILE_READ_ONLY) = 0) Then
  Begin
    If (FileSize(Fl) >= CalcImageSize(0, 0, 0, 0)) Then { v2.07 }
    Begin
      FlRead(Fl, W, 2);
      FlRead(Fl, H, 2);
      IsFileImage:=(CalcImageSize(0, 0, W, H) = FileSize(Fl));
    End;
    FlClose(Fl);
  End;
End;

Function AllGRAOpen;
Var
  w, h, ls: Word;
      P, D: ^Word;
        Fl: File;
Begin
  AllGRAOpen:=-1;
  If (FlOpen(Fl, FileName, FILE_READ_ONLY) = 0) Then
  Begin
    If (FileSize(Fl) >= ImageSize(0, 0, 0, 0)) Then
    Begin
      { v2.03 }
      FlRead(Fl, w, 2);
      FlRead(Fl, h, 2);
      { v2.09 }
      If (CalcImageSize(0, 0, w, h) = FileSize(Fl)) Then
      Begin
        AllGRAOpen:=(Longint(h) ShL 16) Or w;
        If ((X >= 0) And (X <= GetMaxX) And (Y >= 0) And (Y <= GetMaxY)) Then { v2.09 }
        Begin
          ls:=ImageSize(0, 0, w, 0);
          GetMem(P, ls);
          If (P <> Nil) Then
          Begin
            D:=P;
            D^:=w;
            Inc(LongInt(D), SizeOf(D^));
            D^:=0;
            Inc(LongInt(D), SizeOf(D^));
            If (h > GetMaxY) Then h:=GetMaxY; { v2.09 }
            h:=Y + h;
            ls:=ls - 6;
            While (Y <= h) Do
            Begin
              FlRead(Fl, D^, ls);
              PutImage(X, Y, P^, CopyPut);
              Y:=Y + 1;
            End;
            FreeMem(P, ls + 6);
          End;
        End;
      End;
    End;
    FlClose(Fl);
  End;
End;

Function AllGRASave;
Var
  w, h, ls: Word;
      P, D: ^Word;
        Fl: File;
Begin
  AllGRASave:=False;
  If (FlOpen(Fl, FileName, FILE_READ_WRITE Or FILE_REWRITE) = 0) Then
  Begin
    FixCoords(X1, Y1, X2, Y2); { v2.09 }
    { v2.03 }
    w:=X2 - X1;
    h:=Y2 - Y1;
    FlWrite(Fl, w, 2);
    FlWrite(Fl, h, 2);
    ls:=ImageSize(0, 0, w, 0);
    GetMem(P, ls);
    If (P <> Nil) Then
    Begin
      D:=P;
      Inc(LongInt(D), 2 * SizeOf(D^));
      ls:=ls - 6;
      While (Y1 <= Y2) Do
      Begin
        GetImage(X1, Y1, X2, Y1, P^);
        FlWrite(Fl, D^, ls);
        Y1:=Y1 + 1;
      End;
      FreeMem(P, ls + 6);
    End;
    ls:=0;
    FlWrite(Fl, ls, 2);
    AllGRASave:=(FileSize(Fl) = CalcImageSize(0, 0, w, h));
    FlClose(Fl);
  End;
End;

End.
