Unit FileUnit;

Interface

Const
  EXE_CS_READY = LongInt($10000);
  EXE_CS_VALID = LongInt($20000);
  FILE_REWRITE = Word($100);
  FILE_READ_ONLY = 0;
  FILE_WRITE_ONLY = 1;
  FILE_READ_WRITE = 2;

Function FlOpen(Var Fl: File; FName: String; FMode: Word): Integer;
Procedure FlRead(Var Fl: File; Var BPtr; BLen: Word);
Procedure FlWrite(Var Fl: File; Var BPtr; BLen: Word);
Procedure FlClose(Var Fl: File);
Function IsFileExist(FName: String): Byte;
Function GetExeChecksum(FName: String): LongInt;

Implementation
Uses DOS;

Function FlOpen;
Var B: Byte;
Begin
  Assign(Fl, FName);
  B:=FileMode;
  FileMode:=Lo(FMode);
  {$I-}
  If ((FMode And FILE_REWRITE) <> 0) Then ReWrite(Fl, 1) Else Reset(Fl, 1);
  {$I+}
  FileMode:=B;
  FlOpen:=IOResult;
End;

Procedure FlRead;
Var W: Integer;
Begin
  FillChar(BPtr, BLen, 0);
  {$I-}
  BlockRead(Fl, BPtr, BLen, W);
  {$I+}
  { reset error flags }
  W:=IOResult;
End;

Procedure FlWrite;
Var W: Integer;
Begin
  {$I-}
  BlockWrite(Fl, BPtr, BLen, W);
  {$I+}
  { reset error flags }
  W:=IOResult;
End;

Procedure FlClose;
Begin
  Close(Fl);
End;

Function IsFileExist(FName: String): Byte;
Var
  D, A: Word;
     F: File;
Begin
  A:=0;
  Assign(F, FName);
  GetFAttr(F, A);
  D:=DOSError;
  If (D = 0) Then
  Begin
    If ((A And (Directory Or VolumeID)) <> 0) Then D:=2 { v2.08 }
    Else
    Begin
      If (FlOpen(F, FName, FILE_READ_ONLY) = 0) Then FlClose(F) Else D:=2;
    End;
  End;
  IsFileExist:=D;
End;

Function GetExeChecksum;
Var
  W, CS, WL, WI: Word;
             Sz: LongInt;
             Fl: File;
             WB: Array[1..512] Of Word; { 1 Kb }
Begin
  GetExeChecksum:=0;
  If (FlOpen(Fl, FName, FILE_READ_ONLY) = 0) Then
  Begin
    Sz:=FileSize(Fl);
    WL:=28;
    { minimal DOS header size }
    If (Sz >= WL) Then
    Begin
      { full DOS header with extended information or empty unused values }
      If (Sz >= 64) Then WL:=64 Else FillChar(WB, 64, 0);
      FlRead(Fl, WB, WL);
      If (
        { check for 'MZ' signature and at least one page in file }
        (WB[1] = $5A4D) And (WB[3] > 0)
        { checksum doesn't work correctly with NE / LE / LX / PE extended format
          check that reloc table or new exe header overlaps with full header }
        And ((WB[13] < 64) Or (((LongInt(WB[32]) ShL 16) + WB[31]) < 64))
      ) Then
      Begin
        { executable image size (no overlays) }
        If (WB[2] > 0) Then Sz:=512 - WB[2] Else Sz:=0;
        Sz:=(WB[3] * LongInt(512)) - Sz;
        { check file size }
        If (FileSize(Fl) >= Sz) Then
        Begin
          { header block from file already readed }
          Sz:=Sz - WL;
          { checksum }
          CS:=WB[10];
          { before calculation checksum must be set to zero }
          WB[10]:=0;
          W:=0;
          WL:=WL Div 2;
          For WI:=1 To WL Do W:=W + WB[WI];
          { for the rest of file data }
          While (Sz > 0) Do
          Begin
            If (Sz >= SizeOf(WB)) Then WI:=SizeOf(WB) Else WI:=Sz;
            Sz:=Sz - WI;
            FlRead(Fl, WB, WI);
            WL:=(WI + (WI And 1)) Div 2;
            { odd size }
            If ((WI And 1) <> 0) Then WB[WL]:=WB[WL] And $FF;
            For WI:=1 To WL Do W:=W + WB[WI];
          End;
          { last step - invert checksum }
          W:=Not W;
          { checksum are ready to use (no other errors) }
          Sz:=W Or EXE_CS_READY;
          { checksum are valid }
          If (W = CS) Then Sz:=Sz Or EXE_CS_VALID;
          { return checksum with flags }
          GetExeChecksum:=Sz;
          {WriteLn(W, ' / ', CS);}
        End;
      End;
    End;
    FlClose(Fl);
  End;
End;

End.
