Unit KeybUnit;

Interface

Const
  { keys }
  VK_ESCAPE = $01;
  VK_RETURN = $1C;
  VK_SPACE  = $39;
  VK_UP     = $48;
  VK_DOWN   = $50;
  VK_LEFT   = $4B;
  VK_RIGHT  = $4D;
  VK_TAB    = $0F;
  VK_BACK   = $0E;
  VK_F1     = $3B;
  VK_F2     = $3C;
  VK_F3     = $3D;
  VK_F4     = $3E;
  VK_F5     = $3F;
  VK_F6     = $40;
  VK_F7     = $41;
  VK_F8     = $42;
  VK_F9     = $43;
  VK_W      = $11;
  VK_S      = $1F;
  VK_A      = $1E;
  VK_D      = $20;
  VK_L      = $26;
  VK_R      = $13;
  VK_B      = $30;
  VK_F      = $21;
  VK_I      = $17;
  VK_C      = $2E;
  VK_MINUS  = $4A;
  VK_PLUS   = $4E;
  VK_INSERT = $52;
  VK_DELETE = $53;
  VK_HOME   = $47;
  VK_END    = $4F;
  VK_PGUP   = $49;
  VK_PGDN   = $51;
  { flags }
  KEYB_TEST = 0;
  KEYB_FREE = 1;
  KEYB_READ = 2;
  KEYB_WAIT = KEYB_FREE Or KEYB_READ;

Procedure KeybFast;
Function KeybRead(Flag: Byte): Word;
Function KeybStat: Byte; { v2.09 }

Implementation

Uses DOS;

Procedure KeybFast;
Var Regs: Registers;
Begin
  Regs.AX:=$0305;
  Regs.BX:=0;
  Intr($16, Regs);
End;

Function KbRead: Word;
Var Regs: Registers;
Begin
  Regs.AH:=0;
  Intr($16, Regs);
  KBread:=Regs.AX;
End;

Function KbPress: Word;
Var Regs: Registers;
Begin
  Regs.AH:=1;
  Intr($16, Regs);
  If ((Regs.Flags And fZero) = 0) Then KbPress:=Regs.AX
  Else KbPress:=0;
End;

{ v2.09 }
Function KeybStat: Byte;
Var Regs: Registers;
Begin
  Regs.AH:=2;
  Intr($16, Regs);
  KeybStat:=Regs.AL;
End;

Function KeybRead(Flag: Byte): Word;
Begin
  { v2.09 }
  If ((Flag >= KEYB_FREE) And (Flag <= KEYB_WAIT)) Then
  Begin
    If ((Flag And KEYB_FREE) <> 0) Then
      While (KbPress <> 0) Do KeybRead:=KbRead;
    If ((Flag And KEYB_READ) <> 0) Then
      KeybRead:=KbRead;
  End
  Else
    KeybRead:=KbPress;
End;

End.
