unit Unit1;

interface

{$WARNINGS OFF}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, FileCtrl;
{$WARNINGS ON}

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label3: TLabel;
    Button4: TButton;
    Label4: TLabel;
    Label5: TLabel;
    OpenDialog1: TOpenDialog;
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

Const FBlockSize = $FFFF;

Type
     TRec = ^FRec;
     FRec = Record
              FOffs: Int64;
              FSize: Int64;
              Next: TRec;
            End;

Var
    Head, Cur: TRec;
           TF: LongInt;

Function VorbisParser(vFl: TFileStream): Int64;
Var
    B, I, T, Z: Byte;
             N: Int64;
Begin
  Repeat
    vFl.Seek(5, soFromCurrent); (* Seek(vFl, FilePos(vFl) + 5); *)
    vFl.ReadBuffer(B, 1); (* BlockRead(vFl, B, 1); *)
    vFl.Seek(20, soFromCurrent); (* Seek(vFl, FilePos(vFl) + 20); { Skips some infos } *)
    vFl.ReadBuffer(T, 1); (* BlockRead(vFl, T, 1); *)
    N:=0;
    For I:=1 To T Do
      Begin
        vFl.ReadBuffer(Z, 1); (* BlockRead(vFl, Z, 1); *)
        N:=N + Z;
        Application.ProcessMessages;
      End;
    Application.ProcessMessages;
    vFl.Seek(N, soFromCurrent); (* Seek(vFl, FilePos(vFl) + N); *)
  Until (((B And 4)<>0) Or (vFl.Position >= vFl.Size));
  VorbisParser:=vFl.Position; (* FilePos(vFl); *)
End;

Procedure ControlsStatus(Stat: Boolean);
Begin
  With Form1 Do
    Begin
      Edit1.Enabled:=Stat;
      Edit1.Color:=clWindow;
      Edit1.ParentColor:=Not Stat;
      Edit2.Enabled:=Stat;
      Edit2.Color:=clWindow;
      Edit2.ParentColor:=Not Stat;
      Button1.Enabled:=Stat;
      Button2.Enabled:=Stat;
      Button3.Enabled:=Stat;
      Button4.Enabled:=Stat;
    End;
End;

Procedure TForm1.Button4Click(Sender: TObject);
Begin
  Close;
End;

Procedure DestroyList;
Begin
  While Head <> Nil do
    Begin
      Cur:=Head^.Next;
      Dispose(Head);
      Head:=Cur;
    End;
End;

Procedure AddElem(FO, FS: Int64);
Var Tmp: TRec;
Begin
  New(Tmp);
  Tmp^.FOffs:=FO;
  Tmp^.FSize:=FS;
  Tmp^.Next:=Nil;
  If Head = Nil Then Head:=Tmp
  Else Cur^.Next:=Tmp;
  Cur:=Tmp;
End;

Procedure WriteBufferToFile(Buff: Pointer; BS: Int64; FName: String);
Var F: TFileStream;
Begin
  F:=TFileStream.Create(FName, fmCreate Or fmOpenWrite);
  F.WriteBuffer(Buff^, BS);
  F.Free;
End;

Function Boyer(S, Q: String): Integer;
Var
    N, M, I, J, K: Integer;
                D: Array[0..255] Of Byte;
Begin
  N:=Length(S);
  M:=Length(Q);
  FillChar(D, 256, M);
{  For I:=0 To 255 Do D[I]:=M; }
  For I:=1 To M-1 Do D[Ord(Q[I])]:=M-I;
  I:=M;
  Repeat
    J:=M;
    K:=I;
    While ((J<>0) And (Q[J]=S[K])) Do
      Begin
        K:=K-1;
        J:=J-1;
      End;
    I:=I + D[Ord(S[I])]
  Until ((J = 0) Or (I>N));
  If J = 0 Then Boyer:=K{+1} Else Boyer:=-1;
End;

Procedure TForm1.Button3Click(Sender: TObject);
Var
    S, Dir: String;
    PS, PO: Int64;
        Fl: TFileStream;
     I, CR: LongInt;
         P: Pointer;
         L: Byte;
      Buff: String;
Begin
  Label4.Caption:='0';
  If Not FileExists(Edit1.Text) Then
    Begin
      Edit1.SetFocus;
      MessageDlg('Input file not found!', mtError, [mbOK], 0);
      Exit;
    End;
  Dir:=Edit2.Text;
  If Length(Dir) = 0 Then Dir:=ExtractFilePath(ParamStr(0));
  If Dir[Length(Dir)] <> '\' Then Dir:=Dir + '\';
  If Not DirectoryExists(Dir) Then
    Begin
      Edit2.SetFocus;
      MessageDlg('Output path not found!', mtError, [mbOK], 0);
      Exit;
    End;
  TF:=0;
  Head:=Nil;
  ControlsStatus(False);
  Label5.Caption:='[Searching]';
  Fl:=TFileStream.Create(Edit1.Text, fmOpenRead);
  Cr:=FBlockSize;
  SetLength(Buff, Cr);
  While ((Cr = FBlockSize) And (Fl.Position < Fl.Size)) Do
    Begin
      Cr:=Fl.Read(Buff[1], Cr);
      SetLength(Buff, Cr);
      I:=Boyer(Buff, 'OggS');
      If I <> -1 Then
        Begin
          Fl.Seek(I-Cr, soFromCurrent);
          PO:=Fl.Position;
          PS:=VorbisParser(Fl) - PO;
          AddElem(PO, PS);
          TF:=TF + 1;
          Label4.Caption:=IntToStr(TF);
        End
      Else Fl.Seek(-3, soFromCurrent);
      Application.ProcessMessages;
    End;
  Label5.Caption:='[Extracting]';
  Application.ProcessMessages;
  L:=Length(IntToStr(TF));
  Cur:=Head;
  For I:=1 To TF Do
    Begin
      S:=IntToStr(I);
      Label4.Caption:=S;
      While Length(S) < L Do S:='0' + S;
      S:=Dir + S + '.ogg';
      Fl.Seek(Cur^.FOffs, soFromBeginning);
      GetMem(P, Cur^.FSize);
      Fl.ReadBuffer(P^, Cur^.FSize);
      WriteBufferToFile(P, Cur^.FSize, S);
      FreeMem(P, Cur^.FSize);
      Cur:=Cur^.Next;
      Application.ProcessMessages;
    End;
  DestroyList;
  Fl.Free;
  Label5.Caption:='[Done]';
  ControlsStatus(True);
End;

Procedure TForm1.Button1Click(Sender: TObject);
Begin
  If OpenDialog1.Execute = True Then Edit1.Text:=OpenDialog1.FileName;
End;

Procedure TForm1.Button2Click(Sender: TObject);
Var Dir: String;
Begin
  If SelectDirectory('Choose output directory:', '.', Dir) = True Then
    Begin
      If Dir[Length(Dir)] <> '\' Then Dir:=Dir + '\';
      Edit2.Text:=Dir;
    End;
End;

End.
 