Unit BMP16IO;
{ (DIB) - Device Independent Bitmap (⭮-ᨬ ⮢ ࠧ).
   Or
  (BMP) - Windows BitMaP }
Interface

Function BMP16Open(X, Y: Integer; BkColor: Byte; FName: String): ShortInt;
Function BMP16Save(X1, Y1, X2, Y2: Integer; FName: String): ShortInt;

Implementation
Uses Graph;
Const WinColor: Array[0..15] Of Byte =
      (0, 4, 2, 6, 1, 5, 3, 7, 8, 12, 10, 14, 9, 13, 11, 15);

      PalT: Array[0..15] Of Byte =
      (0, 1, 2, 3, 4, 5, 20, 7, 56, 57, 58, 59, 60, 61, 62, 63);

{ 0 -  ଠ쭮; -1    䠩; -2  BMP 䠩; -3  16 梥⮢ }
Function BMP16Open(X, Y: Integer; BkColor: Byte; FName: String): ShortInt;
Var Fl: File;
    Data, D: Byte;
    I, J: Integer;
    XP, Width, Height: LongInt;
    BPP: Word;

Procedure PutPix;
Begin
  If (BkColor<>WinColor[D]) And (J>=0) And (I<Width) Then PutPixel(X+I, Y+J, WinColor[D]);
  I:=I+1;
  If I>=XP Then
    Begin
      I:=0;
      J:=J-1;
    End;
End;
Begin
  Assign(Fl, FName);
  {$I-}
  Reset(Fl, 1);
  {$I+}
  If IOResult=0 Then
    Begin
      BlockRead(Fl, I, 2);
      If I=$4D42 Then {'BM'}
        Begin
          BlockRead(Fl, XP, 4);
          If XP=FileSize(Fl) Then {Is File Size True?}
            Begin
              Seek(Fl, FilePos(Fl)+4); {Reserved1}
              BlockRead(Fl, XP, 4); {Picture Offset at Start of file}
              Seek(Fl, FilePos(Fl)+4); {Reserved2 = $28 - start image}
              BlockRead(Fl, Width, 4); {Width of pictute}
              BlockRead(Fl, Height, 4); {Height of picture}
              Seek(Fl, FilePos(Fl)+2); {Plans = 1}
              BlockRead(Fl, BPP, 2); {BPP = Bits Per Pixel}
              If BPP=4 Then {4 Bits Per Pixel = 16 colors}
                Begin
                  {$I-}
                  Seek(Fl, XP);
                  XP:=(Width Div 8)*4;
                  If Width Mod 8<>0 Then XP:=XP+4;
                  XP:=XP*2;
                  I:=0;
                  J:=Height-1;
                  While (J>=0) And (Not EOF(FL)) Do
                    Begin
                      BlockRead(Fl, Data, 1);
                      D:=Data Shr 4;
                      PutPix;
                      D:=Data Shl 4;
                      D:=D Shr 4;
                      PutPix;
                    End;
                  {$I+}
                  BMP16Open:=0;
                End
              Else BMP16Open:=-3;
            End
          Else BMP16Open:=-2;
        End
      Else BMP16Open:=-2;
      Close(Fl);
    End
  Else BMP16Open:=-1;
End;

{ 0 -  ଠ쭮; -1 -   ᮧ/ 䠩 }
Function BMP16Save(X1, Y1, X2, Y2: Integer; FName: String): ShortInt;
Var
    Fl: File;
    Data, D: Byte;
    I, J: Integer;

    R, G, B: Byte;
    XP, Width, Height: LongInt;
    BPP: Word;

    P: Pointer; {  ⨬஢  ࠡ  !!! }
    W: Word;    {   ६ ᯥ樠쭮  ⮣ !!! }
                {   ⭮  ,  ࢥ ࠡ⠥ ! }
Begin
  Assign(Fl, FName);
  {$I-}
  ReWrite(Fl, 1);
  {$I+}
  If IOResult=0 Then
    Begin
      {$I-}
      If X1>X2 Then
        Begin
          I:=X1;
          X1:=X2;
          X2:=I;
        End;
      If Y1>Y2 Then
        Begin
          I:=Y1;
          Y1:=Y2;
          Y2:=I;
        End;
      I:=$4D42;
      BlockWrite(Fl, I, 2);
      XP:=((Abs(X2-X1)+1)*4) Div 8; {Summary File Size:}
      { -ப ஢  32-⭮ ࠭ - dword !!! }
      If XP Mod 4<>0 Then XP:=((XP Div 4)*4)+4;
      If XP*2<Abs(X2-X1+1) Then XP:=XP+4; {Some errors fixed...}
      XP:=XP*(Abs(Y2-Y1)+1);
      XP:=XP+30+88; {<- This is BMP file size...}
      BlockWrite(Fl, XP, 4);
      XP:=0;        {Reserved1 = 0}
      BlockWrite(Fl, XP, 4);
      XP:=118; {Offset image at start of file (54+((1 shl BPP)*4))}
      BlockWrite(Fl, XP, 4);
      XP:=$28;
      BlockWrite(Fl, XP, 4); {Reserved2 = $28}
      Width:=Abs(X2-X1)+1;{natural size}
      Height:=Abs(Y2-Y1)+1;
      BlockWrite(Fl, Width, 4);
      BlockWrite(Fl, Height, 4);
      BPP:=1;                {Plans = 1}
      BlockWrite(Fl, BPP, 2);
      BPP:=4;                 {BPP = 4 = 16 colors}
      BlockWrite(Fl, BPP, 2);
      D:=0;
      Data:=0;
      For I:=1 To 24 Do BlockWrite(Fl, Data, 1); {Other information not need}
      { Write Palette: }
      For I:=0 To 15 Do
         Begin
           D:=PalT[WinColor[I]];
           R:=0; {00rgbRGB}
           If D And 32<>0 Then R:=1;
           If D And 4<>0 Then R:=R+2;
           G:=0;
           If D And 16<>0 Then G:=1;
           If D And 2<>0 Then G:=G+2;
           B:=0;
           If D And 8<>0 Then B:=1;
           If D And 1<>0 Then B:=B+2;

           If R=3 Then R:=255 Else R:=R*64;
           If G=3 Then G:=255 Else G:=G*64;
           If B=3 Then B:=255 Else B:=B*64;
           BlockWrite(Fl, B, 1); {  ⭮ 浪!!! }
           BlockWrite(Fl, G, 1);
           BlockWrite(Fl, R, 1);
           BlockWrite(Fl, Data, 1);
         End;
      {Save Image:}
      I:=0;
      J:=Height-1;
      XP:=((Abs(X2-X1)+1)*4) Div 8;
      If XP=0 Then XP:=4;
      If XP Mod 4<>0 Then XP:=((XP Div 4)*4)+4;
      XP:=XP*2; { Total Pixels }
      If XP<Abs(X2-X1+1) Then XP:=XP+8; {Some errors fixed...}
      GetMem(P, 290); { !!! LAN Patch } {580/2=290 max size of pixel line}
      W:=0;           { !!! LAN Patch }
      While (J>=0) Do
        Begin
          Data:=0;
          If I<Width Then
            Begin
              D:=GetPixel(X1+I, Y1+J);
              D:=WinColor[D];
              Data:=D ShL 4;
            End;
          I:=I+1;
          If I<Width Then
            Begin
              D:=GetPixel(X1+I, Y1+J);
              Data:=Data+WinColor[D];
            End;
          I:=I+1;
          If I+1>=XP Then
            Begin
              I:=0;
              J:=J-1;
            End;
          Mem[Seg(P^):Ofs(P^)+W]:=Data; { !!! LAN Patch ...> }
          If (W+1=XP Div 2) {(W=289) Or (J<0)} Then
            Begin
              BlockWrite(Fl, P^, W+1);
              W:=0;
            End
          Else W:=W+1;                 { <... !!! LAN Patch }
        End;
        FreeMem(P, 290);             { !!! LAN Patch }
        BMP16Save:=0;
        Close(Fl);
      {$I+}
     End
  Else BMP16Save:=-1;
End;

End.

(*Type
  BMPHeader = Record
                B, M: Char; { 䠩  稭 ᨬ: 'BM' }
                FSize: LongInt; {  䠩 }
                Reserved1: LongInt; { १ࢨ஢ = 0 }
                OffSet: LongInt; { ᬥ饭  ⭮⥫쭮 砫 䠩 }
                Reserved2: LongInt; { १ࢨ஢ = $28 - 砫 ࠦ }
                Width: LongInt; { ਭ ⨭  ᥫ }
                Height: LongInt; {  ⨭  ᥫ }
                Plans: Word;    { - ,  ᮤঠ 1 }
                BPP: Word;    { - ⮢  ᥫ (1, 4, 8  24) }
                {
             |->30  .
             |  8  (DDWORD) - ⮤ ᦠ
             |  8  (DDWORD) - ࠧ ᮡ⢥ ஢ ࠦ  
             |  4  (DWORD) - ࠧ襭  ਧ  ᥫ  
             |  4  (DWORD) - ࠧ襭  ⨪  ᥫ  
             ---+24  (0 - ᫨  ᯮ)
                ᥣ: =54 
                : = 1 shl BPP
                BlueGreenRed0zerobyte = 4  BGR0
                ᫨  256 - _*4,
                ᫨  16 - _*64
                ᫨  (16) = 3 - 255 㤥
                }
              End;*)
