Unit FGraph;
Interface

Const
  FG_ERR = 0;
  FG_FP1 = 1;
  FG_FP2 = 2;
  FG_GRA = 3;

Procedure FPISave(X1, Y1, X2, Y2: Word; FileName: String; FPINum: Byte);
Procedure FPILoad(X, Y: Word; Clr: Boolean; FileName: String);
Function GRAOpen(FileName: String): Pointer;
Function Capture(X1, Y1, X2, Y2: Integer): Pointer;
Procedure AllGRAOpen(X, Y: Word; FileName: String);
Procedure AllGRASave(X1, Y1, X2, Y2: Word; FileName: String);
Function IsGRA(FileName: String): Byte; { 0 - error, 1 - fpi1, 2 - fpi2, 3 - gra }

Implementation
Uses Graph;

Function GRAOpen(FileName: String): Pointer;
Var Add: Pointer;
     Sz: Longint;
     Fl: File;
Begin
  Assign(Fl, FileName);
  {$I-}
  Reset(Fl, 1);
  {$I+}
  If IOResult=0 Then
    Begin
      Sz:=FileSize(Fl);
      If Sz<MemAvail Then
        Begin
          GetMem(Add, Sz);
          {$I-}
          BlockRead(Fl, Add^, Sz);
          Close(Fl);
          {$I+}
          GRAOpen:=Add;
        End
      Else GRAOpen:=Nil;
    End
  Else GRAOpen:=Nil;
End;

Function Capture;
Var Sz: Longint;
    DB: Pointer;
Begin
  Sz:=ImageSize(X1, Y1, X2, Y2);
  If Sz<MemAvail Then
    Begin
      GetMem(DB, Sz);
      GetImage(X1, Y1, X2, Y2, DB^);
      Capture:=DB;
    End
  Else Capture:=Nil;
End;

Procedure AllGRAOpen;
Var LineSize, CurrentLine: Longint;
    Width, Height: Word;
    P: Pointer;
    Fl: File;
Begin
  Assign(Fl, FileName);
  Reset(Fl, 1);
  GetMem(P, 4);
  BlockRead(Fl, P^, 4);
  Width:=MemW[Seg(P^):Ofs(P^)+0];
  Height:=MemW[Seg(P^):Ofs(P^)+2];
  FreeMem(P, 4);
  Width:=Width+1;
  Height:=Height+1;
  If Width Mod 8 <> 0 Then LineSize:=(((Width Div 8)+1)*4)
  Else LineSize:=((Width Div 8)*4);
  Width:=Width-1;
  Height:=Height-1;
  GetMem(P, LineSize+4);
  CurrentLine:=Y;
  MemL[Seg(P^):Ofs(P^)]:=Width;
  {$I-}
  While (IOResult=0) And (CurrentLine<=Y+Height) And (NOT EOF(Fl)) Do
    Begin
      BlockRead(Fl, Ptr(Seg(P^), Ofs(P^)+4)^, LineSize);
      Putimage(X, CurrentLine, P^, CopyPut);
      If CurrentLine-Y=Height Then Seek(Fl, FilePos(Fl)+2)
      Else CurrentLine:=CurrentLine+1;
    End;
  {$I+}
  FreeMem(P, LineSize+4);
  Close(Fl);
End;

Procedure AllGRASave;
Var LineSize, CurrentLine: Longint;
    Width, Height: Word;
    P: Pointer;
    Fl: File;
Begin
  Assign(Fl, FileName);
  ReWrite(Fl, 1);
  Width:=X2-X1;
  Height:=Y2-Y1;
  GetMem(P, 4);
  MemW[Seg(P^):Ofs(P^)]:=Width;
  MemW[Seg(P^):Ofs(P^)+2]:=Height;
  BlockWrite(Fl, P^, 4);
  FreeMem(P, 4);
  Width:=Width+1;
  Height:=Height+1;
  If Width Mod 8 <> 0 Then LineSize:=(((Width Div 8)+1)*4)
  Else LineSize:=((Width Div 8)*4);
  Width:=Width-1;
  Height:=Height-1;
  GetMem(P, LineSize+6);
  CurrentLine:=LineSize;
  While Y1<=Y2 Do
    Begin
      GetImage(X1, Y1, X2, Y1, P^);
      BlockWrite(Fl, Ptr(Seg(P^), Ofs(P^)+4)^, LineSize);
      Y1:=Y1+1;
    End;
  FreeMem(P, LineSize+6);
  Width:=0;
  BlockWrite(Fl, Width, 2);
  Close(Fl);
End;

Function IsGRA(FileName: String): Byte;
Var
    Width, Height, Sz1, Sz2: LongInt;
                         Fl: File;
                          B: Byte;
Begin
  B:=FG_ERR;
  Width:=0;
  Height:=0;
  Assign(Fl, FileName);
  Reset(Fl, 1);
  BlockRead(Fl, Width, 2);
  BlockRead(Fl, Height, 2);
  Width:=Width+1;
  Height:=Height+1;
  If Width Mod 8 <> 0 Then Width:=((Width Div 8)+1)*4
  Else Width:=(Width Div 8)*4;
  {$Q-}
  If (Width*Height)+6=FileSize(Fl) Then B:=FG_GRA;
  {$Q+}
  If B = FG_ERR Then
    Begin
      Seek(Fl, 0);
      BlockRead(Fl, Width, 4);
      BlockRead(Fl, Height, 4);
      {$Q-}
      Sz1:=(((Width+1)*2)*(Height+1))+12; {FPI1}
      Sz2:=((Width*2)*Height)+12;         {FPI2}
      {$Q+}
      BlockRead(Fl, Height, 4); { always null }
      {$B+}
      If ((FileSize(Fl) = Sz1) And (Height = 0)) Then B:=FG_FP1;
      If ((FileSize(Fl) = Sz2) And (Height = 0)) Then B:=FG_FP2;
      {$B-}
    End;
  Close(Fl);
  IsGRA:=B;
End;

Procedure FPISave(X1, Y1, X2, Y2: Word; FileName: String; FPINum: Byte);
Var I, J, Width, Height: LongInt;
                     Fl: File;
                      P: Pointer;
Begin
  Assign(Fl, FileName);
  ReWrite(Fl, 1);
  Width:=X2-X1+1;
  Height:=Y2-Y1+1;
  I:=0;
  If FPINum = FG_FP1 Then
    Begin
      Width:=Width-1;
      Height:=Height-1;
    End;
  BlockWrite(Fl, Width, 4);
  BlockWrite(Fl, Height, 4);
  If FPINum = FG_FP1 Then
    Begin
      Width:=Width+1;
      Height:=Height+1;
    End;
  BlockWrite(Fl, I, 4); { always null }
  GetMem(P, Width*2);
  For J:=Y1 To Y2 Do
    Begin
      For I:=X1 To X2 Do
        MemW[Seg(P^):Ofs(P^)+((I-X1)*2)]:=GetPixel(I, J);
      BlockWrite(Fl, P^, Width*2);
    End;
  FreeMem(P, Width*2);
  Close(Fl);
End;

Procedure FPILoad(X, Y: Word; Clr: Boolean; FileName: String);
Var I, J, Width, Height: LongInt;
                      W: Word;
                     Fl: File;
                      P: Pointer;
Begin
  I:=IsGRA(FileName);
  Assign(Fl, FileName);
  Reset(Fl, 1);
  BlockRead(Fl, Width, 4);
  BlockRead(Fl, Height, 4);
  If I = FG_FP1 Then
    Begin
      Width:=Width+1;
      Height:=Height+1;
    End;
  BlockRead(Fl, I, 4); { always null }
  GetMem(P, Width*2);
  For J:=0 To Height-1 Do
    Begin
      BlockRead(Fl, P^, Width*2);
      For I:=0 To Width-1 Do
        Begin
          W:=MemW[Seg(P^):Ofs(P^)+(I*2)];
          If ((Clr = True) Or ((Clr=False) And (W<>0))) Then
            PutPixel(X+I, Y+J, W);
        End;
    End;
  FreeMem(P, Width*2);
  Close(Fl);
End;

End.