Unit FUtils;

Interface

Function FileExist(FName: String): Boolean;

Function PathExist(PName: String): Boolean;

Implementation
Uses DOS;
{
ReadOnly       $01
Hidden         $02
SysFile        $04
VolumeID       $08
Directory      $10
Archive        $20
AnyFile        $3F
}
Function FileExist(FName: String): Boolean;
Var DirInfo: SearchRec;
Begin
  FindFirst(FName, ReadOnly+Hidden+SysFile+Archive, DirInfo);
  If DOSError=0 Then FileExist:=True
  Else FileExist:=False;
End;

Function PathExist(PName: String): Boolean;
Var DirInfo: SearchRec;
Begin
  If (PName[Length(PName)]='\') And (PName[2]<>':') Then Delete(PName, Length(PName), 1);
  FindFirst(PName, ReadOnly+Hidden+SysFile+Archive+Directory, DirInfo);
  If (DOSError=0) Or (DOSError=18) Then PathExist:=True
  Else PathExist:=False;
End;

End.