UNIT F_Mouse;
INTERFACE
type
  MouseItemType = record
    X1, Y1, X2, Y2: Integer;
    Butt: Word;
    Key: Word;
  end;
type
  MouseHandlerType = Procedure (Mask,Buttons,X,Y,DX,DY: Integer);
const
  LeftButton   = 1;
  RightButton  = 2;
  CenterButton = 4;
  AnyButton    = 7;
const
  TextRatioX: Byte = 8;
  TextRatioY: Byte = 8;
Function IsMouse: Boolean;
Function InitMouse: Boolean;
Procedure SetMousePage(Page: Byte);
Function GetMousePage: Byte;
Procedure SetStepToPixel(Hor,Ver: Integer);
Procedure GetStepToPixel(var Hor,Ver: Integer);
Procedure SetDoubleSpeed(Speed: Word);
Function GetDoubleSpeed: Word;
Function MouseTextCooX(X: Integer): Byte;
Function MouseTextCooY(Y: Integer): Byte;
Function MouseGraphCooX(X: Byte): Integer;
Function MouseGraphCooY(Y: Byte): Integer;
Procedure MouseWhereXY(var X,Y: Integer);
Procedure MouseGotoXY(X,Y: Integer);
Function MouseWhereX: Byte;
Function MouseWhereY: Byte;
Function MouseIn(X1,Y1,X2,Y2: Integer): Boolean;
Function NumButton: Byte;
Procedure GetMouseState(var Butt,X,Y: Integer);
Function MousePressed: Boolean;
Procedure MouseButtPressed(Butt: Integer; var Stat,Count,X,Y: Integer);
Procedure MouseButtReleased(Butt: Integer; var Stat,Count,X,Y: Integer);
Procedure MouseWindow(X1,Y1,X2,Y2: Integer);
Procedure MouseScreen;
Procedure ShowMouse;
Procedure HideMouse;
Procedure MouseTextCursor(ScrMask,CurMask: Word);
Procedure MouseBlink(YUp,YDn: Byte);
Procedure MouseGraphCursor(var ScrCurMask;X,Y:Byte);
Function MouseBuffSize: Word;
Procedure SaveMouse(var Buff);
Procedure RestoreMouse(var Buff);
Procedure SetMouseItem(NItem: Byte; var Items);
Procedure AddMouseItem(Item: MouseItemType);
Procedure ClearMouseItems;
Procedure GetMouseItem(var NItem: Byte; var Items);
Function KeyOrMousePressed: Boolean;
Function ReadKeyOrMouse: Char;
Procedure SetMouseHandler(Mask: Word; Proc: MouseHandlerType);
Procedure ChangeMouseHandler(Mask: Word; Proc: MouseHandlerType;
                             var OldMask: Word; var OldProc: Pointer);
Procedure ClearMouseHandler;
IMPLEMENTATION
Uses DOS, CRT;
type
  MouseItems = array[1..2*MaxInt Div
         SizeOf(MouseItemType)] of MouseItemType;
  PMouseIt = ^MouseItems;
const
  MousePresent: Boolean = False;
  ItemsList   : PMouseIt = NIL;
  NMouseItem  : Byte = 0;
  MouseVisible: Boolean = False;
  x1m: Integer = 0;
  y1m: Integer = 0;
  x2m: Integer = 639;
  y2m: Integer = 199;
  Speed2: Word = 128;
  VerRat: Integer = 8;
  HorRat: Integer = 8;
  NButton: Byte = 0;
var Reg: registers;
Function IsMouse: Boolean;
var
 p    : pointer;
 k,x,y: Integer;
 Is   : Boolean;
begin
  if NButton=0 then
    begin
      GetIntVec($33,p);
      Is:=p<>NIL;
      if Is then with Reg do
        begin
          ax:=$3;
          bx:=$FFFF;
          Intr($33,Reg);
          Is:=bx<>$FFFF;
         end;
      MousePresent:=Is;
    end;
  IsMouse:=MousePresent;
end;
Function InitMouse: Boolean;
begin
  with Reg do
    begin
      ax:=0;
      Intr($33,Reg);
      MousePresent:=ax=$FFFF;
      NButton:=bx;
    end;
  ClearMouseItems;
  SetMousePage(0);
  If MouseVisible=True Then HideMouse;{Added by -=CHE@TER=-}
  MouseScreen;
end;
Procedure SetMousePage(Page: Byte);
begin
  with Reg do
    begin
      ax:=$1D;
      bl:=Page;
      bh:=0;
      Intr($33,Reg);
    end;
end;
Function GetMousePage: Byte;
begin
  with Reg do
    begin
      ax:=$1E;
      Intr($33,Reg);
      GetMousePage:=bl;
    end;
end;
Procedure SetStepToPixel(Hor,Ver: Integer);
begin
  if IsMouse then with Reg do
    begin
      ax:=$0F;
      cx:=Hor and $7FFF;
      dx:=Ver and $7FFF;
      HorRat:=cx;
      VerRat:=dx;
      Intr($33,Reg);
    end;
end;
Procedure GetStepToPixel(var Hor,Ver: Integer);
begin
  if IsMouse then with Reg do
    begin
      Hor:=HorRat;
      Ver:=VerRat;
    end;
end;
Procedure SetDoubleSpeed(Speed: Word);
begin
  if IsMouse then with Reg do
    begin
      ax:=$13;
      dx:=Speed;
      Speed2:=Speed;
      Intr($33,Reg);
     end;
end;
Function GetDoubleSpeed: Word;
begin
  GetDoubleSpeed:=Speed2;
end;
Function MouseTextCooX(X: Integer): Byte;
begin
  MouseTextCooX:=X div TextRatioX+1;
end;
Function MouseTextCooY(Y: Integer): Byte;
begin
  MouseTextCooY:=Y div TextRatioY+1;
end;
Function MouseGraphCooX(X: Byte): Integer;
begin
  MouseGraphCooX:=(X-1)*TextRatioX;
end;
Function MouseGraphCooY(Y: Byte): Integer;
begin
  MouseGraphCooY:=(Y-1)*TextRatioY;
end;
Procedure MouseWhereXY(var X,Y: Integer);
begin
  if IsMouse then with Reg do
    begin
      ax:=$3;
      Intr($33,Reg);
      X:=cx;
      Y:=dx;
    end
  else
    begin
      X:=-1;
      Y:=-1;
    end;
end;
Procedure MouseGotoXY(X,Y: Integer);
begin
  if IsMouse then with Reg do
   begin
     ax:=$4;
     cx:=X;
     dx:=Y;
     Intr($33,Reg);
    end;
end;
Function MouseWhereX: Byte;
begin
  if IsMouse then with Reg do
    begin
      ax:=$3;
      Intr($33,Reg);
      MouseWhereX:=MouseTextCooX(cx);
    end
  else
    MouseWhereX:=0;
end;
Function MouseWhereY: Byte;
begin
  if IsMouse then with Reg do
    begin
      ax:=$3;
      Intr($33,Reg);
      MouseWhereY:=MouseTextCooY(dx);
    end
  else
    MouseWhereY:=0;
end;
Function MouseIn(X1,Y1,X2,Y2: Integer): Boolean;
begin
  if IsMouse then with Reg do
    begin
      ax:=$3;
      Intr($33,Reg);
      MouseIn:=(cx>=X1) and (cx<=X2) and (dx>=Y1) and (dx<=Y2);
    end
   else
     MouseIn:=False;
end;
Function NumButton: Byte;
begin
  NumButton:=NButton;
end;
Procedure GetMouseState(var Butt,X,Y:Integer);
begin
  if IsMouse then with Reg do
    begin
      ax:=$3;
      Intr($33,Reg);
      Butt:=bx;
      X:=cx;
      Y:=dx;
    end
  else
    begin
      Butt:=0;
      X:=0;
      Y:=0;
    end;
end;
Function MousePressed: Boolean;
begin
  if IsMouse then with Reg do
    begin
      ax:=$3;
      Intr($33,Reg);
      MousePressed:=bx<>0;
    end
  else
    MousePressed:=False;
end;
Procedure MouseButtPressed(Butt: Integer; var Stat,Count,X,Y:Integer);
begin
  if IsMouse then with Reg do
    begin
      ax:=$5;
      bx:=Butt;
      Intr($33,Reg);
      Count:=bx;
      X:=cx;
      Y:=dx;
      Stat:=bx;
    end
  else
end;
Procedure MouseButtReleased(Butt: Integer; var Stat,Count,X,Y: Integer);
begin
  if IsMouse then with Reg do
    begin
      ax:=$6;
      bx:=Butt;
      Intr($33,Reg);
      Count:=bx;
      X:=cx;
      Y:=dx;
      Stat:=bx;
    end
  else
end;
Procedure MouseWindow(X1,Y1,X2,Y2: Integer);
begin
  if IsMouse then
    begin
      x1m:=X1;
      y1m:=Y1;
      x2m:=X2;
      y2m:=Y2;
      with Reg do
        begin
          ax:=$7;
          cx:=X1;
          dx:=X2;
          Intr($33,Reg);
          ax:=$8;
          cx:=Y1;
          dx:=Y2;
          Intr($33,Reg);
        end;
    end;
end;
Procedure MouseScreen;
var
  x2,y2: Integer;
begin
  if IsMouse then with Reg do
    begin
      ah:=$F;
      Intr($10,Reg);
      case al of
      1,4,5,13: begin
                  x2:=319;
                  y2:=199;
                end;
      15,16: begin
               x2:=639;
               y2:=349;
             end;
      17,18: begin
               x2:=639;
               y2:=479;
             end;
      else
        begin
          x2:=639;
          y2:=199;
        end;
      end;
    end;
  MouseWindow(0,0,x2,y2);
end;
Procedure ShowMouse;
begin
  if IsMouse then with Reg do
    begin
      ax:=$1;
      Intr($33,Reg);
      MouseVisible:=True;
    end;
end;
Procedure HideMouse;
begin
  if IsMouse then with Reg do
    begin
      ax:=$2;
      Intr($33,Reg);
      MouseVisible:=False;
    end;
end;
Procedure MouseTextCursor(ScrMask,CurMask: Word);
begin
  if IsMouse then with Reg do
    begin
      ax:=$A;
      bx:=0;
      cx:=ScrMask;
      dx:=CurMask;
      Intr($33,Reg);
    end;
end;
Procedure MouseBlink(YUp,YDn: Byte);
begin
  if IsMouse then with Reg do
    begin
      ax:=$A;
      bx:=1;
      cx:=YUp;
      dx:=YDn;
      Intr($33,Reg);
    end;
end;
Procedure MouseGraphCursor(var ScrCurMask; X,Y: Byte);
begin
  if IsMouse then with Reg do
    begin
      ax:=$9;
      bx:=X;
      cx:=Y;
      es:=seg(ScrCurMask);
      dx:=ofs(ScrCurMask);
      Intr($33,Reg);
    end;
end;
Function MouseBuffSize: Word;
begin
  if IsMouse then with Reg do
    begin
      ax:=$15;
      bx:=0;
      Intr($33,Reg);
      MouseBuffSize:=bx;
    end
  else
    MouseBuffSize:=0;
end;
Procedure SaveMouse(var Buff);
begin
  if IsMouse then with Reg do
    begin
      ax:=$16;
      es:=seg(Buff);
      dx:=ofs(Buff);
      Intr($33,Reg);
    end;
end;
Procedure RestoreMouse(var Buff);
begin
  if IsMouse then with Reg do
    begin
      ax:=$17;
      es:=seg(Buff);
      dx:=ofs(Buff);
      Intr($33,Reg);
    end;
end;
const
  DoubleChars: Boolean = False;
var
  SecChar: Char;
Procedure SetMouseItem(NItem: Byte; var Items);
begin
  if IsMouse then
    begin
      ClearMouseItems;
      GetMem(ItemsList,NItem*SizeOf(MouseItemType));
      Move(Items,ItemsList^,NItem*SizeOf(MouseItemType));
      NMouseItem:=NItem;
    end;
end;
Procedure AddMouseItem(Item: MouseItemType);
var
  p: PMouseIt;
  k: byte;
begin
  if IsMouse then with Reg do
    begin
      k:=NMouseItem;
      GetMem(P, (k+1)*SizeOf(MouseItemType));
      Move(ItemsList^,P^,k*SizeOf(MouseItemType));
      Move(Item,P^[k+1],SizeOf(MouseItemType));
      ClearMouseItems;
      NMouseItem:=k+1;
      ItemsList:=P;
    end;
end;
Procedure ClearMouseItems;
begin
  if IsMouse and (NMouseItem<>0) then
    begin
      FreeMem(ItemsList,NMouseItem*SizeOf(MouseItemType));
      NMouseItem:=0;
    end;
end;
Procedure GetMouseItem(var NItem: Byte; var Items);
begin
  if IsMouse and (NMouseItem<>0) then
    begin
      NItem:=NMouseItem;
      Move(ItemsList^,Items,NMouseItem*SizeOf(MouseItemType));
    end;
end;
Function KeyOrMousePressed: Boolean;
var
  b,k: Integer;
  MouseActive: Boolean;
begin
  if keypressed then
     KeyOrMousePressed:=True
  else with Reg do
    begin
      ax:=$3;
      Intr($33,Reg);
      if (bx<>0) and (NMouseItem<>0) then
        begin
          MouseActive:=False;
          for k:=1 to NMouseItem do
          if not MouseActive then
            with ItemsList^[k] do
          begin
            case Butt of
              LeftButton  : b:=bx and LeftButton;
              RightButton : b:=bx and RightButton;
              CenterButton: b:=bx and CenterButton;
              AnyButton   : b:=bx;
            else
              b:=0;
            end;
            MouseActive:=(b<>0) and
              MouseIn(MouseGraphCooX(X1),MouseGraphCooY(Y1),
                      MouseGraphCooX(X2),MouseGraphCooY(Y2));
          end;
        KeyOrMousePressed:=MouseActive;
      end
    else
      KeyOrMousePressed:=False;
  end;
end;
Function ReadKeyOrMouse: Char;
var
  k: Byte;
  b,bb: Word;
  MouseActive: Boolean;
label
  loop;
begin
loop:
  if not IsMouse or KeyPressed then
    ReadKeyOrMouse:=ReadKey
   else if DoubleChars then
    begin
      DoubleChars:=False;
      ReadKeyOrMouse:=SecChar;
    end
  else if NMouseItem<>0 then with Reg do
    begin
      MouseActive:=False;
      ax:=$3;
      Intr($3,Reg);
      bb:=bx;
      if bb<>0 then
      for k:=1 to NMouseItem do
        if not MouseActive then
          with ItemsList^[k] do begin
            case Butt of
              LeftButton  : b:=bb and LeftButton;
              RightButton : b:=bb and RightButton;
              CenterButton: b:=bb and CenterButton;
              AnyButton   : b:=bb;
            else
              b:=0;
            end;
            if (B<>0) and MouseIn(
                   MouseGraphCooX(X1),MouseGraphCooY(Y1),
                   MouseGraphCooX(X2),MouseGraphCooY(Y2)) then
              begin
                MouseActive:=True;
                ReadKeyOrMouse:=Char(Lo(Key));
                if Lo(Key)=0 then
                  begin
                    DoubleChars:=True;
                    SecChar:=chr(Hi(Key));
                   end;
              end
          end;
      if not MouseActive then
        goto loop
    end
  else
    ReadKeyOrMouse:=ReadKey;
end;
const
  OldUserProc: Pointer = NIL;
var
  UserProc: MouseHandlerType absolute OldUserProc;
  OldAX: Word;
Procedure MouseHandler; Far; Assembler;
ASM
  push bp
  push ds
  push es
  push ax
  mov ax,SEG @DATA
  mov ds,ax
  pop ax
  mov OldAX,ax
  mov ax,Word ptr [OldUserProc]
  or  ax,Word ptr [OldUserProc+2]
  jz  @
  mov  ax,OldAx
  push ax
  push bx
  push cx
  push dx
  push di
  push si
  call [UserProc]
@:  pop  es
  pop  ds
  pop  bp
  ret  far
END;
Procedure SetMouseHandler(Mask: Word; Proc: MouseHandlerType);
begin
  if IsMouse then with Reg do
    Begin
      UserProc:=Proc;
      ax:=$0C;
      cx:=Mask;
      es:=seg(MouseHandler);
      dx:=ofs(MouseHandler);
      Intr($33,Reg);
    end;
end;
Procedure ChangeMouseHandler(Mask: Word; Proc: MouseHandlerType;
                var OldMask: Word; var OldProc: Pointer);
begin
  if IsMouse then with Reg do
    begin
       OldProc:=OldUserProc;
       ax:=$14;
       cx:=Mask;
       es:=seg(MouseHandler);
       dx:=ofs(MouseHandler);
       Intr($33,Reg);
       OldMask:=cx;
    end;
end;
Procedure ClearMouseHandler;
begin
  if IsMouse then with Reg do
    begin
      ax:=$0C;
      cx:=0;
      es:=0;
      dx:=0;
      Intr($33,Reg);
    end;
end;
end.