unit Unit1;

interface

uses
  Windows, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Menus, ExtCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    OpenGRAfile1: TMenuItem;
    ConverttoBMP1: TMenuItem;
    N1: TMenuItem;
    OpenBMPfile1: TMenuItem;
    ConverttoGRAfile1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Image1: TImage;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    About2: TMenuItem;
    Memo1: TMemo;
    Button1: TButton;
    OpenDialog2: TOpenDialog;
    SaveDialog2: TSaveDialog;
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure OpenGRAfile1Click(Sender: TObject);
    procedure ConverttoBMP1Click(Sender: TObject);
    procedure About2Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure OpenBMPfile1Click(Sender: TObject);
    procedure ConverttoGRAfile1Click(Sender: TObject);
    procedure OpenDialog1SelectionChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

Var
  Form1: TForm1;

Implementation

{$R *.dfm}

Const
      PalT: Array[0..15] Of Byte =
      (0, 1, 2, 3, 4, 5, 20, 7, 56, 57, 58, 59, 60, 61, 62, 63);

Function IsGRA(FileName: String): Boolean;
Var
    Width, Height: LongInt;
               Fl: File;
Begin
  IsGRA:=False;
  {$I-}
  AssignFile(Fl, FileName);
  FileMode:=0;
  Reset(Fl, 1);
  FileMode:=2;
  {$I+}
  If IOResult<>0 Then Exit;
  If FileSize(Fl) >= 6 Then
    Begin
      Width:=0;
      Height:=0;
      BlockRead(Fl, Width, 2);
      BlockRead(Fl, Height, 2);
      Width:=Width + 1;
      Height:=Height + 1;
      Width:=((Width Div 8) + Ord((Width Mod 8) <> 0))*4;
      IsGRA:=(((Width*Height) + 6) = FileSize(Fl));
    End;
  CloseFile(Fl);  
End;

Procedure EGARGB(C: Byte; Var R, G, B: Byte);
Begin {00rgbRGB}
  R:=Ord(C And 4<>0)*2 + Ord(C And 32<>0);
  G:=Ord(C And 2<>0)*2 + Ord(C And 16<>0);
  B:=Ord(C And 1<>0)*2 + Ord(C And  8<>0);
End;

Procedure OpenGRAFile(FileName: String);
Var
    LineSize, CurrentLine, Ls4, I, J: Longint;
                       Width, Height: Word;
                                  Fl: File;
                                 Buf: Array Of Byte;
                      BP, BR, BG, BB: Byte;
Begin
  If Not IsGRA(FileName) Then Exit;
  AssignFile(Fl, FileName);
  FileMode:=0;
  Reset(Fl, 1);
  FileMode:=2;
  BlockRead(Fl, Width, 2);
  BlockRead(Fl, Height, 2);
  Width:=Width+1;
  Height:=Height+1;
  Form1.ClientWidth:=Width;
  Form1.ClientHeight:=Height;
  Form1.Image1.Width:=Width;
  Form1.Image1.Height:=Height;
  Form1.Image1.Picture.Bitmap.Width:=Width;
  Form1.Image1.Picture.Bitmap.Height:=Height;
  Form1.Image1.Picture.Bitmap.PixelFormat:=pf24bit;
  Form1.Image1.Refresh;
  Form1.Refresh;
  Ls4:=(Width Div 8) + Ord((Width Mod 8) <> 0);
  LineSize:=Ls4*4;
  Width:=Width-1;
  Height:=Height-1;
  Form1.Image1.Hide;
  SetLength(Buf, LineSize);
  For CurrentLine:=0 To Height Do
    Begin
      BlockRead(Fl, Buf[0], LineSize);
      For I:=0 To Width Do
         Begin
           J:=I ShR 3;
           BB:=128 ShR (I And 7);
           BP:=Ord((Buf[J        ] And BB) <> 0)*8;
           BR:=Ord((Buf[J + Ls4  ] And BB) <> 0)*4;
           BG:=Ord((Buf[J + Ls4*2] And BB) <> 0)*2;
           BB:=Ord((Buf[J + Ls4*3] And BB) <> 0);
           EGARGB(PalT[BP + BR + BG + BB], BR, BG, BB);
           Form1.Image1.Picture.Bitmap.Canvas.Pixels[I, CurrentLine]:=RGB(BR * 85, BG * 85, BB * 85);
         End;
    End;
  SetLength(Buf, 0);
  CloseFile(Fl);
  Form1.Image1.Show;
End;

Function NormColor(B: Byte): Byte;
Begin
  If B <= 43 Then
    Begin
      result:=0;
      Exit;
    End;
  If B <= 128 Then
    Begin
      result:=1;
      Exit;
    End;
  If B <= 213 Then
    Begin
      result:=2;
      Exit;
    End;
  result:=3;
{
0..84
85..169
170..255

0..85..170..255

(0)..43 44..(85)..128 129..(170)..213 214..255
}
End;


Procedure SaveGRAFile(FName: String);
Var
        LineSize, Ls4, Idx: Longint;
       Width, Height, I, J: Word;
                       Pix: Cardinal;
                        Fl: File;
                       Buf: Array Of Byte;
    R, G, B, R2, G2, B2, P: Byte;
                    ra, rb: Real;
Begin
  AssignFile(Fl, FName);
  ReWrite(Fl, 1);
  Width:=Form1.Image1.Picture.Bitmap.Width-1;
  Height:=Form1.Image1.Picture.Bitmap.Height-1;
  BlockWrite(Fl, Width, 2);
  BlockWrite(Fl, Height, 2);
  Width:=Width + 1;
  Height:=Height + 1;
  Ls4:=(Width Div 8) + Ord((Width Mod 8) <> 0);
  LineSize:=Ls4*4;
  Width:=Width-1;
  Height:=Height-1;
  SetLength(Buf, LineSize);
  Form1.Image1.Hide;

  For J:=0 To Height Do
    Begin
      FillChar(Buf[0], LineSize, 0);
      For I:=0 To Width Do
        Begin
          Pix:=ColorToRGB(Form1.Image1.Picture.Bitmap.Canvas.Pixels[I, J]);
          R:=GetRValue(Pix);
          G:=GetGValue(Pix);
          B:=GetBValue(Pix);
          ra:=Cardinal($FFFFFFFF);
          Pix:=0;
          For P:=0 To 15 Do
            Begin
              EGARGB(PalT[P], R2, G2, B2);
              rb:=Sqrt(Sqr(R - (R2*85)) + Sqr(G - (G2*85)) + Sqr(B - (B2*85)));
              If rb < ra Then
                Begin
                  Pix:=P;
                  ra:=rb;
                End;
            End;
          B:=128 ShR (I And 7); // I Mod 8
          P:=Ord(Pix And 8<>0)*B;
          R:=Ord(Pix And 4<>0)*B;
          G:=Ord(Pix And 2<>0)*B;
          B:=Ord(Pix And 1<>0)*B;
          Idx:=I ShR 3; // I Div 8
          Buf[Idx          ]:=Buf[Idx          ] + P;
          Buf[Idx +  Ls4   ]:=Buf[Idx +  Ls4   ] + R;
          Buf[Idx + (Ls4*2)]:=Buf[Idx + (Ls4*2)] + G;
          Buf[Idx + (Ls4*3)]:=Buf[Idx + (LS4*3)] + B;
          EGARGB(PalT[Pix], R, G, B);
          Form1.Image1.Picture.Bitmap.Canvas.Pixels[I, J]:=RGB(R*85, G*85, B*85);
        End;
      BlockWrite(Fl, Buf[0], LineSize);
    End;
  Form1.Image1.Show;
  SetLength(Buf, 0);
  Width:=0;
  BlockWrite(Fl, Width, 2);
  CloseFile(Fl);
End;

Procedure TForm1.Exit1Click(Sender: TObject);
Begin
  Close;
End;

Procedure TForm1.FormCreate(Sender: TObject);
Begin
  Image1.Width:=Form1.ClientWidth;
  Image1.Height:=Form1.ClientHeight;
  Image1.Picture.Bitmap.Width:=Image1.Width;
  Image1.Picture.Bitmap.Height:=Image1.Height;
End;

Procedure TForm1.OpenGRAfile1Click(Sender: TObject);
Begin
  If ((OpenDialog1.Execute = True) And (OpenDialog1.FileName <> '')) Then
    OpenGRAFile(OpenDialog1.FileName);
End;

Procedure TForm1.ConverttoBMP1Click(Sender: TObject);
Begin
  If ((SaveDialog1.Execute = True) And (SaveDialog1.FileName <> '')) Then
    Image1.Picture.SaveToFile(SaveDialog1.FileName);
End;

Procedure TForm1.About2Click(Sender: TObject);
Begin
  MessageBox(Form1.Handle, 'WinGRA'+#10+'version 1.01'+#10+'T#i$ PR0GR@M bY'+#10+'-=CHE@TER=-', 'About', MB_ICONINFORMATION);
End;

Procedure TForm1.About1Click(Sender: TObject);
Begin
  Image1.Hide;
  Form1.Width:=328;
  Form1.Height:=286;
  Memo1.Top:=23;
  Memo1.Left:=0;
  Memo1.Width:=Form1.ClientWidth;
  Memo1.Height:=Form1.ClientHeight;
  MainMenu1.Items[0].Visible:=False;
  MainMenu1.Items[1].Visible:=False;
  Button1.Top:=0;
  Button1.Left:=0;
  Button1.Height:=23;
  Button1.Show;
  Memo1.WordWrap:=True;
  Memo1.Show;
End;

Procedure TForm1.Button1Click(Sender: TObject);
Begin
  Button1.Hide;
  Memo1.Hide;
  MainMenu1.Items[0].Visible:=True;
  MainMenu1.Items[1].Visible:=True;
  Form1.ClientWidth:=Image1.Width;
  Form1.ClientHeight:=Image1.Height;
  Image1.Show;
End;

Procedure TForm1.OpenBMPfile1Click(Sender: TObject);
Begin
  If ((OpenDialog2.Execute = True) And (OpenDialog2.FileName <> '')) Then
    Begin
      Image1.AutoSize:=True;
      Image1.Picture.Bitmap.LoadFromFile(OpenDialog2.FileName);
      Image1.Picture.Bitmap.PixelFormat:=pf24bit;
      Image1.AutoSize:=False;
      Form1.ClientWidth:=Image1.Width;
      Form1.ClientHeight:=Image1.Height;
      Form1.Refresh;
    End;
End;

Procedure TForm1.ConverttoGRAfile1Click(Sender: TObject);
Begin
  If ((SaveDialog2.Execute = True) And (SaveDialog2.FileName <> '')) Then
    SaveGRAFile(SaveDialog2.FileName);
End;

Procedure TForm1.OpenDialog1SelectionChange(Sender: TObject);
Begin
  If (FileExists(OpenDialog1.FileName)) And (IsGRA(OpenDialog1.FileName)) Then OpenGRAFile(opendialog1.FileName);
End;

End.
