#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <io.h>
#include <stdarg.h>

typedef unsigned char  uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long  uint32_t;

/* xor first byte with 0xFF to avoid this executable self-fix */
#define FIX_LEN 28
static uint8_t old_code[FIX_LEN] = {
  (0x8B ^ 0xFF), 0x06, 0x99, 0x31, 0xD0, 0x29, 0xD0,
  0x89, 0xC1, 0x8B, 0x03, 0x99, 0x31, 0xD0,
  0x29, 0xD0, 0x39, 0xC1, 0x7E, 0x12, 0x8B,
  0x03, 0x89, 0xC2, 0xB9, 0x03, 0x00, 0x00
};

static uint8_t new_code[FIX_LEN] = {
  (0xEB ^ 0xFF), 0x4C, 0x8B, 0x16, 0x0F, 0xAF, 0xD0,
  0xC1, 0xE2, 0x05, 0xC1, 0xFA, 0x0F, 0x89,
  0x16, 0x0F, 0xAF, 0x03, 0x6B, 0xC0, 0x60,
  0xC1, 0xF8, 0x0F, 0x89, 0x03, 0xEB, 0x41
};

/*

// original MACT386.LIB code (disassembled)
void CONTROL_GetMouseDelta(int32 *x, int32 *y) {
  MOUSE_GetDelta(x, y);
  // artificial priority for bigger delta axis
  if (abs(*x) <= abs(*y)) {
    *x /= 3;
  } else {
    *y /= 3;
  }
  *x = (*x * 32 * CONTROL_MouseSensitivity) >> 15;
  *y = *y * 96;
}

// new code (after this fix)
void CONTROL_GetMouseDelta(int32 *x, int32 *y) {
  MOUSE_GetDelta(x, y);
  *x = (*x * 32 * CONTROL_MouseSensitivity) >> 15;
  *y = (*y * 96 * CONTROL_MouseSensitivity) >> 15;
}

*/

/* this and next func needs to reduce DOS executable
   file size - avoid printf() tables and code linking */
void StrToHex(char *s, uint32_t n) {
uint16_t i;
  if (s) {
    i = 8;
    s += i;
    while (i--) {
      s--;
      *s = (n & 0x0F);
      *s += (*s <= 9) ? '0' : ('A' - 10);
      n >>= 4;
    }
  }
}

void StrMerge(char *buf, uint16_t len, ...) {
va_list args;
char *s;
  if (buf && len) {
    va_start(args, len);
    len--;
    do {
      s = va_arg(args, char *);
      if (s) {
        while (*s && len) {
          *buf = *s;
          buf++;
          s++;
          len--;
        }
      }
    } while (s && len);
    va_end(args);
    *buf = 0;
  }
}

void BuildLookupTable(uint8_t *q, uint16_t qs, uint8_t *t) {
uint16_t i;
  if (q && qs && t) {
    memset(t, qs, 256);
    qs--;
    for (i = 0; i < qs; i++) {
      t[q[i]] = qs - i;
    }
  }
}

uint16_t BoyerMooreHorspool(uint8_t *p, uint16_t ps, uint8_t *q, uint16_t qs, uint8_t *t) {
uint16_t i, s;
  if (p && ps && q && qs) {
    qs--;
    s = 0;
    while ((ps - s) > qs) {
      for (i = qs; (p[s + i] == q[i]); i--) {
        if (!i) {
          return(s + 1);
        }
      }
      s += t[p[s + qs]];
    }
  }
  return(0);
}

/* static buffer for real mode, max sign-safe 16bit value */
#define MAX_BUFF (0x7FFF)
static uint8_t buffer[MAX_BUFF], table[256];

int main(int argc, char *argv[]) {
uint16_t l, w;
uint32_t sz;
char s[80];
int fl;
  puts(
    "Build Mouse Fix v1.1\n"
    "(c) -=CHE@TER=- 2017,2020\n"
    "e-mail: _CTPAX_@MAIL.RU\n"
    "http://ctpax-cheater.losthost.org/\n"
    "\n"
    "(c) Drog Black Tooth 2017\n"
    "http://terra-arcanum.com/drog/\n"
  );
  if ((argc < 2) || (argc > 3)) {
    puts(
      "Usage: buildmfx <filename.exe> [/u]\n"
      "/u - undo, removes this fix if specified and revert all changes back.\n"
      "\n"
      "Supported games:\n"
      "- Blood\n"
      "- Duke Nukem 3D\n"
      "- Shadow Warrior\n"
      "- Redneck Rampage\n"
      "Maybe some other Build games which uses MACT386.LIB library for mouse control.\n"
      "This fix removes bigger delta axis priority and uses new formula calculation:\n"
      "x = (x * 32 * CONTROL_MouseSensitivity()) >> 15;\n"
      "y = (y * 96 * CONTROL_MouseSensitivity()) >> 15;\n"
    );
    return(1);
  }
  fl = open(argv[1], O_RDWR | O_BINARY);
  if (fl == -1) {
    puts("Error: can't open input file for read-write.\n");
    return(2);
  }
  /* restore first bytes */
  old_code[0] ^= 0xFF;
  new_code[0] ^= 0xFF;
  /* get file size */
  lseek(fl, 0, SEEK_END);
  sz = tell(fl);
  lseek(fl, 0, SEEK_SET);
  /* search */
  BuildLookupTable((argc == 2) ? old_code : new_code, FIX_LEN, table);
  while (sz >= FIX_LEN) {
    l = (sz < MAX_BUFF) ? sz : MAX_BUFF;
    sz -= l;
    read(fl, buffer, l);
    w = BoyerMooreHorspool(buffer, l, (argc == 2) ? old_code : new_code, FIX_LEN, table);
    if (w) {
      sz = tell(fl) - l + (w - 1);
      /* fix */
      lseek(fl, sz, SEEK_SET);
      write(fl, (argc == 2) ? new_code : old_code, FIX_LEN);
      /* 1D -> 05 // mov ebx, [CONTROL_MouseSensitivity] => mov eax, [CONTROL_MouseSensitivity] */
      lseek(fl, sz + 79, SEEK_SET);
      w = (argc == 2) ? 0x05 : 0x1D;
      write(fl, &w, 1);
      /* 8B 06 -> EB AC // jump back */
      lseek(fl, sz + 84, SEEK_SET);
      w = (argc == 2) ? 0xACEB : 0x068B;
      write(fl, &w, 2);
      StrToHex(s, sz - 12);
      StrMerge(
        &s[8], sizeof(s) - 8,
        ": CONTROL_GetMouseDelta() code ",
        (argc == 2) ? "found and fixed\n" : "reverted back to original\n",
        NULL
      );
      puts(s);
      /*printf(
        "%08lX: CONTROL_GetMouseDelta() code %s\n\n", sz - 12,
        (argc == 2) ? "found and fixed" : "reverted back to original"
      );*/
      break;
    } else {
      if (l == MAX_BUFF) {
        w = FIX_LEN - table[buffer[l - 1]];
        lseek(fl, tell(fl) - w, SEEK_SET);
        sz += w;
      }
    }
  }
  close(fl);
  if (sz < FIX_LEN) {
    puts("Error: required version of CONTROL_GetMouseDelta() code not found in this file.\n");
  }
  return(0);
}
