#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <bios.h>
#include <dir.h>
#include <dos.h>

#define NAME_IWAD 0x44415749UL

#pragma pack(push, 1)
typedef struct {
  char name[8]; /* CD&MMM [8] */
  unsigned long size;
  unsigned long offs;
} mad_head;

typedef struct {
  unsigned long name; /* "IWAD" */
  unsigned long size;
  unsigned long offs;
} wad_head;

typedef struct {
  unsigned long offs;
  unsigned long size;
  char name[8];
} wad_item;

/*
  packed data type
  {0x@@######UL, 0x$$}
  @@ - old byte
  $$ - new byte
  ###### - offset
*/
typedef struct {
  unsigned long offs;
  unsigned char data;
} fix_item;

/* for files to skip */
typedef struct {
  char name[13];
  char flag;
} skp_item;
#pragma pack(pop)

/*
  tiny buffers for the real mode DOS segmented model
  should be enough to hold whole "MARS.MAD" file FAT/TOC
  2376 items * 16 = 38016 (0x9480) bytes
  2376 +40 => 2416 (0x9700) bytes
*/
#define LIST_DATA_ITEM 2416
static wad_item listitem[LIST_DATA_ITEM];
/* to fit into the single 64Kb block */
static char copydata[(0xE000U - (LIST_DATA_ITEM * sizeof(listitem[0])))];

/* 3 (A:\) + 9 (FILENAME\) + 12 (FILENAME.EXT) + 1 (0) = 25 */
static char diskpath[25];

#define LIST_LEN(x) ((int)(sizeof((x)) / sizeof((x)[0])))

#define GET_OFFS(x) ((x) & 0x00FFFFFFUL)
#define GET_BYTE(x) ((x) >> 24)

static fix_item offsbyte[] = {
  /* mad_flag always 1 */
  {0x3001E8F5UL, 0xB4},
  {0xE401E8F6UL, 0x01},
  /* "c:" => "c\" (".\") */
  {0x3A01ED72UL, 0x5C},
  /* replace ReadCDMAD() => ReadIWAD() */
  {0xF201F4BDUL, 0x22},
  {0xF501F4BEUL, 0xF4},
  /* reverse hardcoded "B505" offset check (offset + first word from the file) */
  {0x7401F533UL, 0x75},
  /* MarsCDCheck() return 0 - all hardcoded offset checks can be reversed to "not match" */
  {0x53024B26UL, 0x33},
  {0x51024B27UL, 0xC0},
  {0x52024B28UL, 0xC3},
  /* reverse hardcoded "A101" offset check */
  {0x740258BDUL, 0x75},
  /* InitCDROM(): return '.' instead CD-ROM drive letter: 0xED + 'A' = 0x012E => 0x2E (".") */
  {0xBA026893UL, 0xB8},
  {0x00026894UL, 0x01},
  {0x15026895UL, 0xED},
  {0x8D026898UL, 0xEB},
  {0x5D026899UL, 0x1F},
  /* "c:" => "c\" (".\") */
  {0x3A02E22CUL, 0x5C},
  /* "c:" => "c\" (".\") */
  {0x3A02E24AUL, 0x5C},
  /* reverse hardcoded "TOP0004" offset check */
  {0x7402E8C2UL, 0x75},
  /* reverse hardcoded "A105" offset check (offset + first word from the file) */
  {0x7402EACDUL, 0x75},
  /* reverse hardcoded "TOP" offset check */
  {0x8403E099UL, 0x85},
  /* reverse hardcoded "HELP1" offset check */
  {0x8403E2FDUL, 0x85},
  /* "c:" => "c\" (".\") */
  {0x3A04C456UL, 0x5C}
};

/*
skip file list - flag meaning:
   1: skip file in CD root directory
  -1: skip file inside "INSTALL" directory (English only)
   0: skip for both cases
*/
static skp_item skiplist[] = {
  /* "3D.DAT" script decrypt: for (i = 0; i < size; i++) { data[i] -= 12; } */
  {"3D.DAT",       0},
  /* 463 Mb original file (will be rebuilded later) */
  {"MARS.MAD",     1},
  /* all file below from English version */
  {"INSTALL.BAT",  1},
  {"READTHIS",    -1},
  {"INSTALL.CFG", -1},
  {"INSTALL.EXE", -1}
};

int strmsk(char *s, char *m) {
char a, b;
  for (; *m; m++, s++) {
    a = *s;
    b = *m;
    a ^= ((a >= 'a') && (a <= 'z')) ? 0x20 : 0;
    b ^= ((b >= 'a') && (b <= 'z')) ? 0x20 : 0;
    if (b == '#') {
      if ((a < '0') || (a > '9')) { break; }
    } else {
      if (a != b) { break; }
    }
  }
  return(*s - *m);
}

char *MakeCDPath(char c, char *n) {
  diskpath[0] = (c < 0) ? (-c) : c;
  diskpath[1] = ':';
  diskpath[2] = '\\';
  diskpath[3] = 0;
  if (c < 0) { strcpy(&diskpath[3], "INSTALL\\"); }
  if (n) { strcpy(&diskpath[(c < 0) ? 11 : 3], n); }
  return(diskpath);
}

/* let OS to preallocate file space on the disk
   to reduce file fragmentation and increase speed */
void AllocFileSpace(int fd, unsigned long sz) {
unsigned long l;
  if ((fd != -1) && sz) {
    l = tell(fd);
    /* go to required offs */
    lseek(fd, l + sz - 1, SEEK_SET);
    /* write something */
    sz = 0;
    write(fd, &sz, 1);
    /* return back */
    lseek(fd, l, SEEK_SET);
  }
}

void CopyBlockData(int fd, int fs, unsigned long sz) {
unsigned long l;
  if ((fd != -1) && (fs != -1) && sz) {
    memset(copydata, 0, sizeof(copydata));
    /* copy file data */
    while (sz) {
      l = (sz < sizeof(copydata)) ? sz : sizeof(copydata);
      sz -= l;
      read(fs, copydata, (unsigned int) l);
      write(fd, copydata, (unsigned int) l);
    }
  }
}

void RebuildFiles(char c) {
unsigned int i, sz;
struct ftime ft;
mad_head mh;
wad_head wh;
char *p, s[9];
int fs, fd;
  wh.size = 0;
  fs = open(MakeCDPath(c, "MARS.MAD"), O_RDONLY | O_BINARY);
  if (fs != -1) {
    fd = open("MARS.MAD", O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
    if (fd != -1) {
      memset(&mh, 0, sizeof(mh));
      read(fs, &mh, sizeof(mh));
      /* strict string comparison - signature */
      if ((!strcmp("CD&MMM", mh.name)) && (mh.size <= LIST_DATA_ITEM)) {
        getftime(fs, &ft);
        sz = (unsigned int)(sizeof(listitem[0]) * mh.size);
        /* read FAT/TOC */
        lseek(fs, mh.offs, SEEK_SET);
        read(fs, listitem, sz);
        /* decrypt FAT/TOC */
        p = (char *) listitem;
        for (i = 0; i < sz; i++) { p[i] -= '0'; }
        /* make IWAD header */
        wh.name = NAME_IWAD;
        wh.size = 0;
        wh.offs = sizeof(wh);
        sz = 0;
        for (i = 0; i < mh.size; i++) {
          /* fix incorrect file size */
          if (!strmsk(listitem[i].name, "TEXTURE1")) {
            lseek(fs, listitem[i].offs, SEEK_SET);
            /* read file header records */
            listitem[i].size = 0;
            read(fs, &listitem[i].size, 4);
            /* records (4) first list 4 bytes each and second list 32 bytes each */
            listitem[i].size = 4 + (listitem[i].size * (4 + 32));
          }
          /* skip items for CD checks */
          if (strmsk(listitem[i].name, "TOP####")) {
            if (i != wh.size) {
              memcpy(&listitem[(unsigned int)wh.size], &listitem[i], sizeof(listitem[0]));
            }
            wh.offs += listitem[i].size;
            wh.size++;
            sz += sizeof(listitem[0]);
          }
        }
        /* allocate file space */
        AllocFileSpace(fd, wh.offs + sz);
        /* write output header */
        write(fd, &wh, sizeof(wh));
        /* copy file contents */
        s[8] = 0;
        mh.offs = sizeof(wh);
        for (i = 0; i < wh.size; i++) {
          /* show current item name */
          memcpy(s, listitem[i].name, 8);
          printf("%8s", s);
          /* copy item data */
          lseek(fs, listitem[i].offs, SEEK_SET);
          CopyBlockData(fd, fs, listitem[i].size);
          /* new item offset */
          listitem[i].offs = mh.offs;
          mh.offs += listitem[i].size;
          printf("\x0D");
        }
        /* write FAT/TOC */
        write(fd, listitem, sz);
        setftime(fd, &ft);
      }
      close(fd);
    }
    close(fs);
  }
  printf("%ld item(s) copied\n", wh.size);
}

int CopyFromCD(char *ns, char *nd) {
unsigned long sz;
struct ftime ft;
int r, i, fs, fd;
  r = 0;
  if (ns && nd) {
    fs = open(ns, O_RDONLY | O_BINARY);
    if (fs != -1) {
      fd = open(nd, O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
      if (fd != -1) {
        getftime(fs, &ft);
        lseek(fs, 0, SEEK_END);
        sz = tell(fs);
        lseek(fs, 0, SEEK_SET);
        /* non-empty file */
        if (sz) {
          AllocFileSpace(fd, sz);
          CopyBlockData(fd, fs, sz);
        }
        /* result */
        r = (((unsigned long) tell(fd)) == sz) ? 1 : 0;
        /* patch executable */
        if (!strmsk(nd, "MARS.EXE")) {
          for (i = 0; i < LIST_LEN(offsbyte); i++) {
            lseek(fd, GET_OFFS(offsbyte[i].offs), SEEK_SET);
            write(fd, &offsbyte[i].data, 1);
          }
        }
        setftime(fd, &ft);
        close(fd);
      }
      close(fs);
    }
  }
  return(r);
}

int SkipFileName(char c, char *n) {
int i, r;
  r = 0;
  c = (c < 0) ? (-1) : 1;
  for (i = 0; i < LIST_LEN(skiplist); i++) {
    if ((!strmsk(n, skiplist[i].name)) && ((!skiplist[i].flag) || (skiplist[i].flag == c))) {
      r = 1;
      break;
    }
  }
  return(r);
}

void CopyAllFiles(char c) {
struct ffblk fb;
int f, i, k;
  /* https://web.archive.org/web/20170808134457/http://www.drdos.net/documentation/sysprog/chap4.htm */
  /* if attrib = 0 only files without attributes, or with FA_RDONLY and/or FA_ARCH will be found */
  k = 0;
  for (i = 0; i < 2; i++) {
    f = findfirst(MakeCDPath(c, "*.*"), &fb, FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_ARCH);
    while (!f) {
      /* not label or directory - real file */
      if (!(fb.ff_attrib & (FA_LABEL | FA_DIREC))) {
        /* skip large resource archive and misc junk files */
        if (!SkipFileName(c, fb.ff_name)) {
          printf("%12s", fb.ff_name);
          k += CopyFromCD(MakeCDPath(c, fb.ff_name),
            /* Chinese INSTALL.EXE => SETUP.EXE */
            (char *) (((!strmsk(fb.ff_name, "INSTALL.EXE")) && (fb.ff_fsize == 20830)) ? "SETUP.EXE" : fb.ff_name)
          );
          printf("\x0D");
        }
      }
      f = findnext(&fb);
    }
    /* for English version */
    c = -c;
  }
  printf("%d file(s) copied\n", k);
}

int CheckMarsExe(char *ns) {
unsigned char b;
int fs, i;
  i = 0;
  fs = open(ns, O_RDONLY | O_BINARY);
  if (fs != -1) {
    /* check executable */
    for (i = 0; i < LIST_LEN(offsbyte); i++) {
      lseek(fs, GET_OFFS(offsbyte[i].offs), SEEK_SET);
      read(fs, &b, 1);
      if (b != GET_BYTE(offsbyte[i].offs)) { break; }
    }
    close(fs);
  }
  return((i < LIST_LEN(offsbyte)) ? 0 : 1);
}

#define EH_IGNORE 0
#define EH_RETRY  1
#define EH_ABORT  2
int errhandler(int errval, int ax, int bp, int si) {
  /* trick compiler: mark all arguments as used */
  ax &= (errval || ax || bp || si) ? errval : (-1);
  /* if this is not a disk error then it was another device having trouble */
  if (ax < 0) {
    /* return to the program directly requesting abort */
    hardretn(EH_ABORT);
  }
  /* otherwise it was a disk error */
  if ((ax & 0x00FF) == (diskpath[0] - 'A')) {
    /* directly return invalid handle */
    hardretn(-1);
  }
  /* ignore error */
  hardresume(EH_IGNORE);
  return(EH_ABORT);
}

char FindGameCD(void) {
int i;
  /* ignore input/output errors */
  harderr(errhandler);
  for (i = 'A'; i <= 'Z'; i++) {
    /* Chinese */
    if (CheckMarsExe(MakeCDPath(i, "MARS.EXE"))) { return(i); }
    /* English */
    if (CheckMarsExe(MakeCDPath(-i, "MARS.EXE"))) { return(-i); }
  }
  return(0);
}

int main(void) {
char c;
  printf(
    "Mars 3D (Engine Technology, 1997) No-CD installer v1.0\n"
    "(c) -=CHE@TER=- 2020\n"
    "e-mail: _CTPAX_@MAIL.RU\n"
    "http://ctpax-cheater.losthost.org/htmldocs/trouble.htm\n"
    "\n\n"
  );
  printf(
    "This program will install \"Mars 3D\" from the game CD to the current directory.\n"
    "Resources archive file \"MARS.MAD\" will be automatically rebuilt, modified and\n"
    "stripped from the excessive protection data. Main executable file \"MARS.EXE\"\n"
    "will be also patched according to all these changes.\n\n"
    "Around 80 Mb of free disk space required for this installation.\n\n"
    "Press 'Y' to continue or any other key to exit: [ ]\x08\x08"
  );
  c = bioskey(0) & 0xDFU;
  c = (c == 'Y') ? 'Y' : 'N';
  printf("%c\n\n", c);
  if (c != 'Y') { return(2); }
  printf("* search for the game CD\n");
  c = FindGameCD();
  if (!c) {
    printf("\nError: the game CD not found!\n\n");
    return(3);
  }
  printf("found game disk in the drive %c:\n", (c < 0) ? (-c) : c);
  printf("* copy game files from CD to the current directory\n");
  CopyAllFiles(c);
  /* rebuild archvie only for original Chinese version */
  if (c > 0) {
    printf("* rebuild \"MARS.MAD\" resource archive file\n");
    RebuildFiles(c);
  }
  printf("\ndone\n\n");
  return(0);
}
