#include <stdio.h>
#include <stdint.h>
#include <string.h>

#define UPCASE(c) ((((c) >= 'a') && ((c) <= 'z')) ? ((c) - ('a' - 'A')) : (c))

/* The Neverhood hash routine */
uint32_t NVH_Hash(char *s) {
uint32_t p, c, hash;
  hash = 0;
  if (s) {
    p = 0;
    while (*s) {
      c = (uint8_t) *s;
      s++;
      c = UPCASE(c);
      do {
        if ((c >= 'A') && (c <= 'Z')) { c -= ('A' - 1); break; }
        if ((c >= '0') && (c <= '9')) { c -= ('0' - 6); break; }
        c = 0;
      } while (0);
      /* only digits and letters allowed */
      if (c) {
        /* shift value from 0 till 31 */
        p = (p + c) & 0x1F;
        hash ^= (1 << p);
      }
    }
  }
  return(hash);
}

/* Hash to string generator. Thanks to Axsis for help! */
char *NVH_Text(uint32_t hash, char *s) {
uint32_t p, c;
  if (s) {
    p = 0;
    do {
      c = 0;
      do {
        c++;
        hash = ((hash >> 1) | (hash << 31));
        /* handle overflow (?PPP = 0; PPP = 1) */
        if ((c == 26) && (!(hash & 1))) {
          c = 16;
          hash = ((hash << 10) | (hash >> 22));
          break;
        }
      } while (!(hash & 1));
      hash ^= 1;
      s[p] = ('A' - 1) + c;
      p++;
    } while (hash && (p < 32));
    s[p] = 0;
  }
  return(s);
}

int main(int argc, char *argv[]) {
char s[33], *p;
uint32_t k;
  /* self-test */
  if (
    ((NVH_Hash("please") != 0x14210006)) ||
    (strcmp(NVH_Text(0x14210006, s), "AANEEB"))
  ) {
    printf("!!! SELF-TEST FAILED - CHECK HASH ROUTINE CODE !!!\n");
    return(100);
  }
  printf(
    "The Neverhood hash tool v1.3\n"
    "(c) -=CHE@TER=- 2011,2018,2020,2022\n"
    "http://ctpax-cheater.losthost.org/htmldocs/nvh.htm\n"
    "Thanks to Axsis for additional help, hints & tips!\n"
    "\n"
  );
  if (argc != 3) {
    printf(
      "Usage: nev_hash <h|t> <text|hash>\n"
      "h/t - type of action:\n"
      "  h - hash from text (second argument must be text string)\n"
      "  t - text from hash (second argument must be hash in hex)\n"
      "\n"
      "Example:\n"
      "nev_hash h fastforward\n"
      "nev_hash t 843070C0\n"
      "\n"
    );
    return(1);
  }
  k = UPCASE(argv[1][0]);
  if (((k != 'H') && (k != 'T')) || argv[1][1]) {
    printf("Error: unknown mode '%s'\n\n", argv[1]);
    return(2);
  }
  p = argv[2];
  k -= 'T';
  if (k) {
    /* H mode */
    k = NVH_Hash(p);
  } else {
    /* T mode */
    while (*p) {
      *s = UPCASE(*p);
      p++;
      do {
        if ((*s >= 'A') && (*s <= 'F')) { k <<= 4; k |= *s - ('A' - 10); break; }
        if ((*s >= '0') && (*s <= '9')) { k <<= 4; k |= *s - '0'; break; }
        *s = 0;
      } while (0);
      /* not hexdecimal notation - stop reading input string */
      if (!*s) { break; }
    }
    p = NVH_Text(k, s);
  }
  printf("%08X=%s\n\n", k, p);
  return(0);
}
