#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#pragma pack(push, 1)
typedef struct {
  uint8_t  IDLength;
  uint8_t  ColorMapType;
  uint8_t  ImageType;
  uint16_t CMapStart;
  uint16_t CMapLength;
  uint8_t  CMapDepth;
  uint16_t XOffset;
  uint16_t YOffset;
  uint16_t Width;
  uint16_t Height;
  uint8_t  PixelDepth;
  uint8_t  ImageDescriptor;
} tga_head;
#pragma pack(pop)

int CheckTGAFile(FILE *fl, char *tga_file) {
tga_head th;
  memset(&th, 0, sizeof(th));
  fread(&th, sizeof(th), 1, fl);
  if (
    (th.ColorMapType != 1) || (th.ImageType != 1) || (th.PixelDepth != 8) ||
    (th.CMapDepth != 24) || (th.CMapStart != 0) || (th.CMapLength != 256)
  ) {
    printf("Error: %s must be 8 BPP uncompressed image with full 24 BPP palette.\n\n", tga_file);
    tga_file = NULL;
  } else {
    fseek(fl, sizeof(th) + th.IDLength, SEEK_SET);
  }
  return(tga_file ? 1 : 0);
}

int main(int argc, char *argv[]) {
char cpal[256 * 3];
FILE *fl;
int x;
  if (argc != 3) {
    printf("Copy palette from src file to dst file.\n");
    printf("Usage: copypalt <dst.tga> <src.tga>\n\n");
    return(1);
  }
  fl = fopen(argv[2], "rb");
  if (!fl) {
    printf("Error: can't open file for read: %s\n", argv[2]);
    return(2);
  }
  x = CheckTGAFile(fl, argv[2]);
  if (x) { fread(cpal, sizeof(cpal), 1, fl); }
  fclose(fl);
  if (!x) { return(3); }
  fl = fopen(argv[1], "rb+");
  if (!fl) {
    printf("Error: can't open file for write: %s\n", argv[1]);
    return(4);
  }
  x = CheckTGAFile(fl, argv[1]);
  if (x) { fwrite(cpal, sizeof(cpal), 1, fl); }
  fclose(fl);
  if (!x) { return(5); }
  printf("\ndone\n\n");
  return(0);
}
