#include <stdio.h>
#include <windows.h>

#pragma pack(push, 1)
typedef struct {
  BITMAPFILEHEADER head;
  BITMAPINFOHEADER info;
  RGBQUAD cpal[2];
  BYTE data[256 * 16];
} bmp_file;
#pragma pack(pop)

TCHAR *basename(TCHAR *s) {
TCHAR *r;
  if (s) {
    for (r = s; *r; r++) {
      if ((*r == TEXT('/')) || (*r == TEXT('\\'))) {
        s = &r[1];
      }
    }
  }
  return(s);
}

void newext(TCHAR *name, TCHAR *ext) {
TCHAR *p;
  if (name && ext) {
    for (; (*name == TEXT('.')); name++);
    for (p = NULL; *name; name++) {
      if (*name == TEXT('.')) {
        p = name;
      }
    }
    lstrcpy(p ? p : name, ext);
  }
}

DWORD LoadData(TCHAR *filename, void *p, DWORD l) {
HANDLE fl;
DWORD dw;
  if (p && l) { ZeroMemory(p, l); }
  fl = INVALID_HANDLE_VALUE;
  if (filename) {
    fl = CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    if (fl != INVALID_HANDLE_VALUE) {
      dw = 0;
      ReadFile(fl, p, l, &dw, NULL);
      if (dw == l) { l = GetFileSize(fl, NULL); }
      CloseHandle(fl);
    }
  }
  return((fl != INVALID_HANDLE_VALUE) ? l : 0);
}

void SaveData(TCHAR *filename, void *p, DWORD l) {
HANDLE fl;
  if (filename) {
    fl = CreateFile(filename, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
    if (fl != INVALID_HANDLE_VALUE) {
      if (p && l) { WriteFile(fl, p, l, &l, NULL); }
      CloseHandle(fl);
    }
  }
}

int main(int argc, char *argv[]) {
TCHAR s[MAX_PATH];
BYTE p[256 * 16];
bmp_file bm;
DWORD i, j;
  if (argc != 3) {
    printf(
      "Usage: font2bmp <p|u> <filename.ext>\n\n"
      "Where:\n"
      "p - pack input .BMP file to .N0B\n"
      "u - unpack input .N0B file to .BMP\n\n"
    );
    return(1);
  }
  argv[1][0] |= 0x20;
  if ((argv[1][1]) || ((argv[1][0] != 'p') && (argv[1][0] != 'u'))) {
    printf("Error: invalid mode.\n\n");
    return(2);
  }
  if (argv[1][0] == 'p') {
    /* .BMP => .N0B */
    i = LoadData(argv[2], &bm, sizeof(bm));
    if (
      (i < sizeof(bm)) || (bm.head.bfType != 0x4D42) || (bm.head.bfSize < i) ||
      (bm.head.bfOffBits != (sizeof(bm) - sizeof(bm.data))) || (bm.info.biSize != sizeof(bm.info)) ||
      (bm.info.biWidth != (256 * 8)) || (bm.info.biHeight != 16) ||
      (bm.info.biPlanes != 1) || (bm.info.biBitCount != 1)
    ) {
      printf("Error: can't open input file, invalid or unsupported format.\n\n");
      return(3);
    }
    for (i = 0; i < 256; i++) {
      for (j = 0; j < 16; j++) {
        p[(i * 16) + j] = bm.data[((16 - j - 1) * 256) + i];
      }
    }
    /* save to disk */
    lstrcpy(s, basename(argv[2]));
    printf("%s -> ", s);
    newext(s, TEXT(".N0B"));
    printf("%s\n", s);
    SaveData(s, p, sizeof(p));
    printf("\ndone\n\n");
  } else {
    /* .N0B => .BMP */
    i = LoadData(argv[2], p, sizeof(p));
    if (i != sizeof(bm.data)) {
      printf("Error: can't open input file or invalid format.\n\n");
      return(3);
    }
    ZeroMemory(&bm, sizeof(bm));
    for (i = 0; i < 256; i++) {
      for (j = 0; j < 16; j++) {
        bm.data[((16 - j - 1) * 256) + i] = p[(i * 16) + j];
      }
    }
    bm.head.bfType = 0x4D42;
    bm.head.bfSize = sizeof(bm);
    bm.head.bfOffBits = sizeof(bm) - sizeof(bm.data);
    bm.info.biSize = sizeof(bm.info);
    bm.info.biWidth = 256 * 8;
    bm.info.biHeight = 16;
    bm.info.biPlanes = 1;
    bm.info.biBitCount = 1;
    bm.info.biSizeImage = sizeof(bm.data);
    bm.cpal[1].rgbBlue = 0xFF;
    bm.cpal[1].rgbGreen = 0xFF;
    bm.cpal[1].rgbRed = 0xFF;
    /* save to disk */
    lstrcpy(s, basename(argv[2]));
    printf("%s -> ", s);
    newext(s, TEXT(".BMP"));
    printf("%s\n", s);
    SaveData(s, &bm, sizeof(bm));
    printf("\ndone\n\n");
  }
  return(0);
}
