#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <stdint.h>

#include "../unpakblb/blb_pict.c"

char *basename(char *s) {
char *r;
  if (s) {
    for (r = s; *r; r++) {
      if ((*r == '/') || (*r == '\\')) {
        s = &r[1];
      }
    }
  }
  return(s);
}

void newext(char *name, char *ext) {
char *p;
  if (name && ext) {
    for (; (*name == '.'); name++);
    for (p = NULL; *name; name++) {
      if (*name == '.') {
        p = name;
      }
    }
    strcpy(p ? p : name, ext);
  }
}

int main(int argc, char *argv[]) {
uint8_t *p, *u;
uint32_t sz;
char s[260];
FILE *fl;
  printf("The Neverhood .N02 to .TGA image converter\n\n");
  if (argc != 2) {
    printf("Usage: n02image <filename.n02>\n\n");
    return(1);
  }
  fl = fopen(argv[1], "rb");
  if (!fl) {
    printf("Error: can't open input file for read.\n\n");
    return(2);
  }
  fseek(fl, 0, SEEK_END);
  sz = ftell(fl);
  if (sz <= 2) {
    fclose(fl);
    printf("Error: invalid input file format.\n\n");
    return(3);
  }
  p = (uint8_t *) malloc(sz);
  if (!p) {
    fclose(fl);
    printf("Error: can't allocate memory for input file data.\n\n");
    return(4);
  }
  fseek(fl, 0, SEEK_SET);
  fread(p, sz, 1, fl);
  fclose(fl);

  strcpy(s, basename(argv[1]));
  printf("%s -> ", s);
  newext(s, ".TGA");
  printf("%s\n\n", s);
  u = nvh_image(p, &sz);
  free(p);
  if (!u) {
    printf("Error: invalid image file format.\n\n");
    return(5);
  }
  fl = fopen(s, "wb");
  if (!fl) {
    free(u);
    printf("Error: can't create output file for write.\n\n");
    return(6);
  }
  fwrite(u, sz, 1, fl);
  fclose(fl);
  free(u);
  printf("done\n\n");
  return(0);
}
