#include <windows.h>
#include <commctrl.h>
#include "nhcfonts.h"
#include "wndtools.h"

#define BMP_FILE (sizeof(BITMAPFILEHEADER))
#define BMP_INFO (sizeof(BITMAPINFOHEADER))
#define BMP_CPAL (sizeof(RGBQUAD) * 256)
#define BMP_HEAD (BMP_FILE + BMP_INFO)
#define BMP_FULL (BMP_HEAD + BMP_CPAL)

#define GetMem(x) ((void *) LocalAlloc(LPTR, (x)))
#define FreeMem(x) LocalFree((x))

#define LIST_LEN(x) (sizeof((x)) / sizeof((x)[0]))

#define PCSD __attribute__ ((aligned(1))) const static

#pragma pack(push, 1)
typedef struct {
  DWORD dwHash;
  WORD  wOffs;
  WORD  wType;
} arf_item;

typedef struct {
  SHORT x;
  SHORT y;
} dot_item;
#pragma pack(pop)

/*
283CE401.N02 font red (Klogg)
C6604282.N02 font yellow (Willie)
0800090C.N02 font beige (walls)
0002486A.N05 data asRecFont (Klogg/Willie/walls size)
*/

// 40x60 char width
PCSD WORD item_pos[][5] = {
  // id, x, y, w, h
//  {IDC_AREA, 0, 0, 640, 480 + 60},
  {IDC_LIST, 640 + 4, 0, 64, (480 + 60) - 4 - 20},
  {IDC_TEXT, 0, (480 + 60) + 4, 640, 20},

  {IDC_WEDT, 640 + 4 + 64 - 24 - 16, (480 + 60) - 20, 24, 20},
  {IDC_WPOS, 640 + 4 + 64 - 16, (480 + 60) - 20, 16, 20},

  {IDC_FONT, 640 + 4, (480 + 60) - 23, 23, 23},

  {IDC_SAVE, 640 + 4, (480 + 60) + 4, 64, 23}
};

static BYTE backdraw[BMP_FULL + (640 * (480 + 60))];

// font data
static BYTE fontdata[2 + (6 * 8) +4 +4 +4 +4 +(2 + (256 * 4)) +2];
// font info: FirstChar, LastChar, WidthChar, HeightChar, TrackingChar (FontSize)
static WORD fontinfo[5];
// char width table
static dot_item *fontable;
// Hints, Klogg, Walls
static BYTE fontlist[3][BMP_FULL + (640 * 480)];
static BYTE fontused;

static BYTE loadpart[(2 * 5) + BMP_CPAL + (640 * 480)];

const static BYTE fonthead[] = {
  // items in table
  0x06, 0x00,
    // meNumRows
    0x0D, 0x00, 0x34, 0x04,
      0x00, 0x00, // offset relative to [DATA]
      0x01, 0x00, // type?
    // meFirstChar
    0x22, 0x20, 0x0C, 0x24,
      0x04, 0x00, // offset relative to [DATA]
      0x01, 0x00, // type?
    // meCharWidth
    0x80, 0x21, 0x35, 0x60,
      0x08, 0x00, // offset relative to [DATA]
      0x01, 0x00, // type?
    // meCharHeight
    0x40, 0x02, 0x05, 0x41,
      0x0C, 0x00, // offset relative to [DATA]
      0x01, 0x00, // type?
    // meTracking
    0xE0, 0x20, 0x05, 0x53,
      0x10, 0x00, // offset relative to [DATA]
      0x02, 0x00, // type?
    // unknown
    0x70, 0x0D, 0x02, 0x01,
      0x92, 0x03, // offset relative to [DATA]
      0x03, 0x00, // type?
    // [DATA] starts here
  // meNumRows value
  0x0E, 0x00, // x (value)
  0xFF, 0xFF, // y (unused)
  // meFirstChar
  0x20, 0x00, // x (value)
  0xFF, 0xFF, // y (unused)
  // meCharWidth
  0x28, 0x00, // x (value)
  0xFF, 0xFF, // y (unused)
  // meCharHeight
  0x22, 0x00, // x (value)
  0xFF, 0xFF, // y (unused)
  // meTracking
  0xE0, 0x00 // total characters in table
  // 4 * total characters bytes
  // 2 zero bytes for unknown value
};

#include "wndtools.c"

#include "miscfunc.c"

void LoadError(TCHAR *s) {
  MessageBox(0, s, TEXT("File not found or invalid format"), MB_OK | MB_ICONERROR);
}

BOOL InitData(void) {
TCHAR m[16];
DWORD i, l, k;
arf_item *a;
  // load font data
  wsprintf(m, TEXT("%08X.N05"), 0x0002486A); // font data (asFontRec)
  k = LoadData(m, fontdata, sizeof(fontdata));
  // FIXME: no font file - ask to create new: 128 (old) / 224 (new)
  // TODO: check file format more strict?
  if ((k < 2) || (fontdata[0] != 6)) {
    LoadError(m);
    return(FALSE);
  }
  // file size
  k = (k < sizeof(fontdata)) ? k : sizeof(fontdata);
  // font info: FirstChar, LastChar, WidthChar, HeightChar, TrackingChar
  ZeroMemory(fontinfo, sizeof(fontinfo));
  a = (arf_item *) &fontdata[2];
  l = 2 + (*((WORD *) fontdata) * sizeof(a[0]));
  for (i = 0; i < (*(WORD *) fontdata); i++) {
    // meNumRows:8
    if (a[i].dwHash == 0x0434000D) {
      fontinfo[1] = *((WORD *) &fontdata[l + a[i].wOffs]);
    }
    // meFirstChar:0
    if (a[i].dwHash == 0x240C2022) {
      fontinfo[0] = *((WORD *) &fontdata[l + a[i].wOffs]);
    }
    // meCharWidth:40
    if (a[i].dwHash == 0x60352180) {
      fontinfo[2] = *((WORD *) &fontdata[l + a[i].wOffs]);
    }
    // meCharHeight:60
    if (a[i].dwHash == 0x41050240) {
      fontinfo[3] = *((WORD *) &fontdata[l + a[i].wOffs]);
    }
    // meTracking:128
    if (a[i].dwHash == 0x530520E0) {
      fontinfo[4] = l + a[i].wOffs;
    }
  }
  // set last character
  l = *((WORD *) &fontdata[fontinfo[4]]);
  fontinfo[1] = l ? (fontinfo[0] + l - 1) : fontinfo[0];
  // skip characters count
  fontinfo[4] += 2;
  fontable = (dot_item *) &fontdata[fontinfo[4]];
  // file size
  fontinfo[4] = k;
  // test for translation font
  if ((fontinfo[0] != 32) || (fontinfo[1] != 255) || (fontinfo[2] != 40) || (fontinfo[3] != 34)) {
    if (MessageBox(0, TEXT(
      "Font data file incompatible with the translation.\n"
      "Create default translation font data for the whole ANSI range?"
    ), TEXT("Not a translation font data file"), MB_YESNO | MB_ICONQUESTION) == IDYES) {
      // generate default font
      ZeroMemory(fontdata, sizeof(fontdata));
      CopyMemory(fontdata, fonthead, sizeof(fonthead));
      fontinfo[0] = 32;
      fontinfo[1] = 255;
      fontinfo[2] = 40;
      fontinfo[3] = 34;
      k = fontinfo[1] - fontinfo[0] + 1;
      fontinfo[4] = sizeof(fonthead) + (k * 4) + 2;
      fontable = (dot_item *) &fontdata[sizeof(fonthead)];
      // default width
      for (i = 0; i < k; i++) {
        fontable[i].x = fontinfo[2];
        fontable[i].y = -1;
      }
    }
  }
  // load fonts
  fontused = 0;
  for (i = 0; i < 3; i++) {
    l = 0;
    if (i == 0) { l = 0xC6604282; } // Willie
    if (i == 1) { l = 0x283CE401; } // Klogg
    if (i == 2) { l = 0x0800090C; } // Records
    wsprintf(m, TEXT("%08X.N02"), l);
    l = LoadData(m, loadpart, sizeof(loadpart));
    if (loadpart[0] && (loadpart[0] & IMG_ALL) == loadpart[0]) {
      nvh_image(loadpart, l, fontlist[i], sizeof(fontlist[0]));
    } else {
      LoadError(m);
      return(FALSE);
    }
  }
  // background display
  ZeroMemory(backdraw, sizeof(backdraw));
  FillBitmapHeader(backdraw, 640, 480 + 60, 8);
  // default palette
  for (i = 0; i < 256; i++) {
    *((DWORD *) &backdraw[BMP_HEAD + (i * sizeof(RGBQUAD))]) = MAKELONG(MAKEWORD(i, i), MAKEWORD(i, 0));
  }
  // use first font
  CopyMemory(&backdraw[BMP_HEAD], &fontlist[fontused][BMP_HEAD], BMP_CPAL + (640 * 480));
  return(TRUE);
}

void DrawRect(BYTE *u, BYTE *p, int px, int py, int ux, int uy, int w, int h) {
int uw, uh, pw, ph, i, j, ul, pl;
BITMAPINFOHEADER *bi;
BYTE b;
  bi = (BITMAPINFOHEADER *) &u[BMP_FILE];
  uw = bi->biWidth;
  uh = (bi->biHeight < 0) ? (-bi->biHeight) : bi->biHeight;
  ul = BMPLINESIZE(bi->biWidth, bi->biBitCount);
  u += BMP_FULL;
  bi = (BITMAPINFOHEADER *) &p[BMP_FILE];
  pw = bi->biWidth;
  ph = (bi->biHeight < 0) ? (-bi->biHeight) : bi->biHeight;
  pl = BMPLINESIZE(bi->biWidth, bi->biBitCount);
  p += BMP_FULL;
  for (j = 0; j < h; j++) {
    if (((py + j) >= 0) && ((py + j) <= ph) && ((uy + j) >= 0) && ((uy + j) <= uh)) {
      for (i = 0; i < w; i++) {
        if (((px + i) >= 0) && ((px + i) <= pw) && ((ux + i) >= 0) && ((ux + i) <= uw)) {
          b = p[((py + j) * pl) + px + i];
          if (b) { u[((uy + j) * ul) + ux + i] = b; }
        }
      }
    }
  }
}

void FontDraw(TCHAR *s) {
DWORD i;
SHORT x;
BYTE b;
  ZeroMemory(&backdraw[BMP_FULL + (640 * 480)], sizeof(backdraw) - BMP_FULL - (640 * 480));
  CopyMemory(&backdraw[BMP_HEAD], &fontlist[fontused][BMP_HEAD], BMP_CPAL);
  x = 0;
  for (i = 0; s[i]; i++) {
    b = (BYTE) s[i];
    // in allowed range
    if ((b >= fontinfo[0]) && (b <= fontinfo[1])) {
      b -= fontinfo[0];
      DrawRect(
        backdraw, fontlist[fontused],
        (b & 0x0F) * fontinfo[2], (b >> 4) * fontinfo[3],
        x, 480,
        fontinfo[2], fontinfo[3]
      );
      x += fontable[b].x;
    } else {
      x += fontinfo[2];
    }
  }
}

void AllowControls(HWND wnd, BOOL ballow) {
  EnableWindow(GetDlgItem(wnd, IDC_WEDT), ballow);
  EnableWindow(GetDlgItem(wnd, IDC_WPOS), ballow);
}

void FmtListItem(TCHAR *s, DWORD i) {
  wsprintf(s, TEXT("%c%c%02u"),
    ((i + fontinfo[0]) >= 32) ? (i + fontinfo[0]) : TEXT('?'),
    (fontable[i].x >= 0) ? TEXT(' ') : TEXT('-'),
    (fontable[i].x >= 0) ? fontable[i].x : (-fontable[i].x)
  );
}

// Replace ListBox string by item index with item data preservation and flickering prevention.
void LB_ReplaceString(HWND hListBox, LRESULT lIndex, TCHAR *lpString) {
LRESULT lSel, lTop, lDat;
  // minimal sanity checks
  if (hListBox && lpString && (lIndex >= 0)) {
    // disable any window redraw
    SendMessage(hListBox, WM_SETREDRAW, (WPARAM) FALSE, 0);
    // save current selection
    lSel = SendMessage(hListBox, LB_GETCURSEL, 0, 0);
    // save top index
    lTop = SendMessage(hListBox, LB_GETTOPINDEX, 0, 0);
    // save item data
    lDat = SendMessage(hListBox, LB_GETITEMDATA, (WPARAM) lIndex, 0);
    // delete specified item
    SendMessage(hListBox, LB_DELETESTRING, (WPARAM) lIndex, 0);
    // insert new at this place
    SendMessage(hListBox, LB_INSERTSTRING, (WPARAM) lIndex, (LPARAM) lpString);
    // restore item data
    SendMessage(hListBox, LB_SETITEMDATA, (WPARAM) lIndex, (LPARAM) lDat);
    // restore top index
    SendMessage(hListBox, LB_SETTOPINDEX, (WPARAM) lTop, 0);
    // restore selection
    SendMessage(hListBox, LB_SETCURSEL, (WPARAM) lSel, 0);
    // enable window redraw
    SendMessage(hListBox, WM_SETREDRAW, (WPARAM) TRUE, 0);
    // drop any pending redraw messages
    RedrawWindow(hListBox, NULL, NULL, RDW_VALIDATE | RDW_NOERASE | RDW_NOFRAME | RDW_NOINTERNALPAINT | RDW_UPDATENOW | RDW_ALLCHILDREN);
    // redraw client area of window without erasing background to prevent flickering
    RedrawWindow(hListBox, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW | RDW_ALLCHILDREN);
  }
}

BOOL CALLBACK DlgPrc(HWND wnd, UINT umsg, WPARAM wparm, LPARAM lparm) {
DWORD i, mx, my;
PAINTSTRUCT ps;
TCHAR s[80];
BOOL result;
HFONT hf;
RECT rc;
HWND w;
HDC hc;
  result = FALSE;
  switch (umsg) {
    case WM_INITDIALOG:
      //ShowWindow(GetDlgItem(wnd, IDC_AREA), SW_HIDE);
      lparm = (LPARAM) LoadIcon(NULL, IDI_APPLICATION);
      SendMessage(wnd, WM_SETICON, ICON_BIG  , lparm);
      SendMessage(wnd, WM_SETICON, ICON_SMALL, lparm);
      hf = CreateFont(
        -16, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, DEFAULT_CHARSET,
        OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
        FIXED_PITCH | FF_MODERN, TEXT("Courier New")
      );
      SendMessage(GetDlgItem(wnd, IDC_LIST), WM_SETFONT, (WPARAM) hf, 0);
      // set default width range
      SendMessage(GetDlgItem(wnd, IDC_WPOS), UDM_SETRANGE, 0, MAKELPARAM(fontinfo[2], 0));
      // fill chars list
      w = GetDlgItem(wnd, IDC_LIST);
      for (i = 0; i <= (fontinfo[1] - fontinfo[0]); i++) {
        FmtListItem(s, i);
        SendMessage(w, LB_ADDSTRING, 0, (LPARAM) s);
      }
      // move and resize window items
      mx = 0;
      my = 0;
      for (i = 0; i < LIST_LEN(item_pos); i++) {
        MoveWindow(
          GetDlgItem(wnd, item_pos[i][0]),
          item_pos[i][1], item_pos[i][2],
          item_pos[i][3], item_pos[i][4],
          TRUE
        );
        if ((item_pos[i][1] + item_pos[i][3]) > mx) {
          mx = item_pos[i][1] + item_pos[i][3];
        }
        if ((item_pos[i][2] + item_pos[i][4]) > my) {
          my = item_pos[i][2] + item_pos[i][4];
        }
      }
      AllowControls(wnd, FALSE);
      // resize main window
      WndClient(wnd, mx, my);
      // center main window
      WndMoveTo(wnd, WMT_MID_X | WMT_MID_Y);
      result = TRUE;
      break;
    case WM_COMMAND:
      if (wparm == MAKEWPARAM(IDC_LIST, LBN_SELCHANGE)) {
        i = SendMessage((HWND) lparm, LB_GETCURSEL, 0, 0);
        SendMessage(GetDlgItem(wnd, IDC_WPOS), UDM_SETPOS, 0, MAKELPARAM(fontable[i].x, 0));
        AllowControls(wnd, TRUE);
      }
      if (wparm == MAKEWPARAM(IDC_TEXT, EN_CHANGE)) {
        w = ((HWND) lparm);
        s[GetWindowText(w, s, 80)] = 0;
        FontDraw(s);
        ZeroMemory(&rc, sizeof(rc));
        // update only bitmap area
        rc.right = 640;
        rc.bottom = 480 + 60;
        // FALSE - do not erase background before update (avoid flickering)
        InvalidateRect(wnd, &rc, FALSE);
      }
      if (HIWORD(wparm) == BN_CLICKED) {
        switch (LOWORD(wparm)) {
          //case IDOK:
          case IDCANCEL:
            if (MessageBox(wnd, TEXT("Exit?"), TEXT("Confirm"), MB_ICONQUESTION | MB_YESNO) == IDYES) {
              EndDialog(wnd, 0);
            }
            break;
          case IDC_SAVE:
            wsprintf(s, TEXT("%08X.N05"), 0x0002486A); // font data (asFontRec)
            // save as much as loaded
            SaveData(s, fontdata, fontinfo[4]);
            // FIXME: saved indicator?
            break;
          case IDC_FONT:
            fontused = (fontused + 1) % 3;
            CopyMemory(&backdraw[BMP_HEAD], &fontlist[fontused][BMP_HEAD], BMP_CPAL + (640 * 480));
            // update button text
            s[0] = TEXT('W'); // Willie
            s[1] = TEXT('K'); // Klogg
            s[2] = TEXT('R'); // Records
            s[0] = s[fontused];
            s[1] = 0;
            SetWindowText((HWND) lparm, s);
            // update image
            PostMessage(wnd, WM_COMMAND, MAKEWPARAM(IDC_TEXT, EN_CHANGE), (LPARAM) GetDlgItem(wnd, IDC_TEXT));
            break;
        }
      }
      break;
    case WM_PAINT:
      hc = BeginPaint(wnd, &ps);
      if (hc) {
        SetDIBitsToDevice(hc,
          0, 0, 640, 480 + 60,
          0, 0, 0, 480 + 60,
          (void *) &backdraw[BMP_FULL],
          (BITMAPINFO *) &backdraw[BMP_FILE],
          DIB_RGB_COLORS
        );
        EndPaint(wnd, &ps);
      }
      break;
    case WM_VSCROLL:
      w = ((HWND) lparm);
      if ((w == GetDlgItem(wnd, IDC_WPOS)) && (LOWORD(wparm) == SB_THUMBPOSITION)) {
        // get index
        w = GetDlgItem(wnd, IDC_LIST);
        i = SendMessage(w, LB_GETCURSEL, 0, 0);
        // update table
        fontable[i].x = (SHORT) HIWORD(wparm);
        // update list
        FmtListItem(s, i);
        // since there is no message for replace string in the list box...
        LB_ReplaceString(w, i, s);
        // update image
        PostMessage(wnd, WM_COMMAND, MAKEWPARAM(IDC_TEXT, EN_CHANGE), (LPARAM) GetDlgItem(wnd, IDC_TEXT));
      }
      break;
  }
  return(result);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {
  if (InitData()) {
    InitCommonControls();
    DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DLG1), 0, &DlgPrc);
  }
  ExitProcess(0);
  return(0);
}
