#include "wndtools.h"

/*
  move window to specific position on screen or parent element
  pos - flags field for horizontal and vertical placements
    for horizontal can be only one of the following values:
      no flags - keep current position
      WMT_MIN_X - screen left
      WMT_MAX_X - screen right
      WMT_MID_X - screen center
    for vertical can be only one of the following values:
      no flags - keep current position
      WMT_MIN_Y - screen top
      WMT_MAX_Y - screen bottom
      WMT_MID_Y - screen center
*/
static void WndMoveTo(HWND wnd, DWORD pos) {
RECT rc, rp;
  pos &= (WMT_MID_X | WMT_MID_Y);
  if (wnd && pos) {
    if (GetWindowRect(wnd, &rc)) {
      rc.right -= rc.left;
      rc.bottom -= rc.top;
      if (!GetClientRect(GetParent(wnd), &rp)) {
        rp.right = GetSystemMetrics(SM_CXSCREEN);
        rp.bottom = GetSystemMetrics(SM_CYSCREEN);
      }
      if (pos & WMT_MID_X) {
        rc.left = (pos & WMT_MAX_X) ? (rp.right - rc.right) : 0;
        if ((pos & WMT_MID_X) == WMT_MID_X) { rc.left /= 2; }
      }
      if (pos & WMT_MID_Y) {
        rc.top = (pos & WMT_MAX_Y) ? (rp.bottom - rc.bottom) : 0;
        if ((pos & WMT_MID_Y) == WMT_MID_Y) { rc.top /= 2; }
      }
      MoveWindow(wnd, rc.left, rc.top, rc.right, rc.bottom, TRUE);
    }
  }
}

/*
  resize window to match specified client size
  set CW_USEDEFAULT bit flag for width or height to keep current size
*/
static void WndClient(HWND wnd, DWORD width, DWORD height) {
RECT rc;
  if (wnd && ((!(width & CW_USEDEFAULT)) || (!(height & CW_USEDEFAULT)))) {
    if (GetClientRect(wnd, &rc)) {
      if (!(width & CW_USEDEFAULT)) { rc.right = width; }
      if (!(height & CW_USEDEFAULT)) { rc.bottom = height; }
      AdjustWindowRectEx(&rc,
        GetWindowLong(wnd, GWL_STYLE),
        GetMenu(wnd) ? TRUE : FALSE,
        GetWindowLong(wnd, GWL_EXSTYLE)
      );
      width = rc.right - rc.left;
      height = rc.bottom - rc.top;
      GetWindowRect(wnd, &rc);
      if (GetParent(wnd)) {
        ScreenToClient(GetParent(wnd), (POINT *) &rc);
      }
      MoveWindow(wnd, rc.left, rc.top, width, height, TRUE);
    }
  }
}
