#include <stdio.h>
#include <windows.h>

/*
  todo:
  - pack similar files (subtitles) - same offset
  - 2,3,4,5,6,7,8,10, 11,12,13

  dwFileType:
    Bitmap (2); Text (6); Video (10); <= 10 - normal;
    new types:
     11 B - SubFont (8x16 font)  FONT 0x544E4F46
     12 C - MsgText (messages)   TEXT 0x54584554
     13 D - SubText (subtitles)  ####

typedef struct {
  DWORD dwCheck; // archive magic signature "NHC\0"
  DWORD dwStamp; // archive build date 0xYYYYMMDD GMT as version
  DWORD dwSizes; // total archive size (sanity checks)
  DWORD dwTotal; // total files in archive
} nhc_head;
*/

#define GetMem(x) ((void *) LocalAlloc(LPTR, (x)))
#define FreeMem(x) LocalFree((x))

#pragma pack(push, 1)
typedef struct {
  DWORD dwFileHash;
  DWORD dwFileType;
  DWORD dwFileOffs;
  DWORD dwFileSize;
} nhc_item;
#pragma pack(pop)

DWORD HexToInt(char *s, DWORD l) {
DWORD r;
BYTE b;
  r = 0;
  while (l--) {
    r <<= 4;
    b = (BYTE) *s;
    b |= 0x20;
    b -= ((b >= '0') && (b <= '9')) ? '0' : ('a' - 10);
    if (b > 0x0F) { break; }
    r |= b;
    s++;
  }
  return(r);
}

int TestItem(nhc_item *a, nhc_item *b) {
  if (a->dwFileType == b->dwFileType) {
    if (a->dwFileHash == b->dwFileHash) { return(0); }
    return((a->dwFileHash < b->dwFileHash) ? -1 : 1);
  } else {
    return((a->dwFileType < b->dwFileType) ? -1 : 1);
  }
}

/*
  total files in all .BLB archives: 2751
  total Smacker video files (assuming each video has subtitle file): 82+1+13+455 = 551
  additional two files: 1+1 = 2 (font + error message)
  total possible items in .NHC archive: 2751+551+2 = 3304 including:
  - links to files (84 in total)
  - unused items (exact number unknown)
  - duplicates items which are unused too (exact number unknown)
  round up 3304 to 3520 - add few items just in case
  3520 * 16 bytes = 56320 / 1024 = 55 Kb exactly
*/
#define NHC_MAX_ITEM 3520
static nhc_item list[NHC_MAX_ITEM];

int main(int argc, char *argv[]) {
WIN32_FIND_DATA dfind;
nhc_item head, item;
SYSTEMTIME st;
HANDLE fl, f;
char s[32];
DWORD i, j;
void *p;
  if (argc != 3) {
    printf("Usage: nhcpacks <p|u> <filename.nhc>\nWhere: <p|u> - pack or unpack\n\n");
    return(1);
  }
  i = argv[1][0] | 0x20;
  if (((i != 'p') && (i != 'u')) || (argv[1][1])) {
    printf("Error: invalid mode type.\n\n");
    return(2);
  }
  if (i == 'p') {
    /* packing */
    GetSystemTime(&st);
    head.dwFileHash = 0x0043484E; /* magic */
    head.dwFileType = MAKELONG(MAKEWORD(st.wDay, st.wMonth), st.wYear); /* build date (version) */
    head.dwFileOffs = sizeof(head); /* whole archive size */
    head.dwFileSize = 0; /* file count */
    f = FindFirstFile("????????.N??", &dfind);
    if (f != INVALID_HANDLE_VALUE) {
      do {
         if (dfind.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) { continue; }
         list[head.dwFileSize].dwFileHash = HexToInt(dfind.cFileName, 8);
         list[head.dwFileSize].dwFileType = HexToInt(&dfind.cFileName[10], 2);
         wsprintf(s, "%08X.N%02X", list[head.dwFileSize].dwFileHash, list[head.dwFileSize].dwFileType);
         if (!lstrcmpi(s, dfind.cFileName)) {
           printf("%s\n", s);
           list[head.dwFileSize].dwFileSize = dfind.nFileSizeLow;
           head.dwFileOffs += sizeof(list[0]) + list[head.dwFileSize].dwFileSize;
           head.dwFileSize++;
           if (head.dwFileSize >= NHC_MAX_ITEM) {
             printf("Error: too much files to pack - increase buffer size.\n\n");
             return(3);
           }
         }
      } while (FindNextFile(f, &dfind));
      FindClose(f);
    }
    if (!head.dwFileSize) {
      printf("Error: no files found for packing.\n\n");
      return(4);
    }
    printf("Total files: %u\n", (unsigned int) head.dwFileSize);
    /* sort files: by flag, by hash */
    for (i = 0; i < head.dwFileSize; i++) {
      for (j = i; j > 0; j--) {
        if (TestItem(&list[j - 1], &list[j]) <= 0) {
          break;
        }
        /* exchange */
        item = list[j];
        list[j] = list[j - 1];
        list[j - 1] = item;
      }
    }
    /* fix offsets */
    for (i = 0; i < head.dwFileSize; i++) {
      list[i].dwFileOffs = i ? (list[i - 1].dwFileOffs + list[i - 1].dwFileSize) : (sizeof(head) * (head.dwFileSize + 1));
    }
    /* create archive */
    fl = CreateFile(argv[2], GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
    if (fl == INVALID_HANDLE_VALUE) {
      printf("Error: can't create output file.\n\n");
      return(5);
    }
    WriteFile(fl, &head, sizeof(head), &j, NULL);
    WriteFile(fl, &list, sizeof(list[0]) * head.dwFileSize, &j, NULL);
    /* pack data */
    f = INVALID_HANDLE_VALUE;
    for (i = 0; i < head.dwFileSize; i++) {
      wsprintf(s, "%08X.N%02X", list[i].dwFileHash, list[i].dwFileType);
      f = CreateFile(s, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, 0);
      if (f == INVALID_HANDLE_VALUE) {
        printf("Error: can't open input file \"%s\".\n\n", s);
        break;
      }
      p = GetMem(list[i].dwFileSize);
      if (!p) {
        CloseHandle(f);
        f = INVALID_HANDLE_VALUE;
        printf("Error: can't allocate memory for file \"%s\".\n\n", s);
        break;
      }
      ReadFile(f, p, list[i].dwFileSize, &j, NULL);
      WriteFile(fl, p, list[i].dwFileSize, &j, NULL);
      FreeMem(p);
      CloseHandle(f);
    }
    CloseHandle(fl);
    if (f == INVALID_HANDLE_VALUE) { DeleteFile(argv[2]); }
  } else {
    /* unpacking */
    fl = CreateFile(argv[2], GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, 0);
    if (fl == INVALID_HANDLE_VALUE) {
      printf("Error: can't open input file.\n\n");
      return(3);
    }
    i = GetFileSize(fl, NULL);
    ZeroMemory(&head, sizeof(head));
    ReadFile(fl, &head, sizeof(head), &j, NULL);
    if (
      (j != sizeof(head)) || (head.dwFileHash != 0x0043484E) || (!head.dwFileType) ||
      (i < head.dwFileOffs) || (i < ((head.dwFileSize + 1) * sizeof(head)))
    ) {
      CloseHandle(fl);
      printf("Error: invalid input file format.\n\n");
      return(4);
    }
    if (head.dwFileSize > NHC_MAX_ITEM) {
      CloseHandle(fl);
      printf("Error: too much files to unpack - increase buffer size.\n\n");
      return(4);
    }
    ReadFile(fl, &list, sizeof(list[0]) * head.dwFileSize, &j, NULL);
    for (i = 0; i < head.dwFileSize; i++) {
      wsprintf(s, "%08X.N%02X", list[i].dwFileHash, list[i].dwFileType);
      printf("%s\n", s);
      f = CreateFile(s, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
      if (f == INVALID_HANDLE_VALUE) {
        printf("Error: can't create output file \"%s\".\n\n", s);
        /* unpack what we can */
        continue;
      }
      p = GetMem(list[i].dwFileSize);
      if (!p) {
        printf("Error: can't allocate memory for file \"%s\".\n\n", s);
        CloseHandle(f);
        DeleteFile(s);
        /* unpack what we can */
        continue;
      }
      SetFilePointer(fl, list[i].dwFileOffs, NULL, FILE_BEGIN);
      ReadFile(fl, p, list[i].dwFileSize, &j, NULL);
      WriteFile(f, p, list[i].dwFileSize, &j, NULL);
      FreeMem(p);
      CloseHandle(f);
    }
    CloseHandle(fl);
  }
  return(0);
}
