#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <mmsystem.h>

#define PCSD __attribute__ ((aligned(1))) const static

DWORD* WINAPI _SmackOpen(char *name, DWORD flags, DWORD extrabuf);
void   WINAPI _SmackClose(DWORD *smk);
DWORD  WINAPI _SmackDoFrame(DWORD *smk);
void   WINAPI _SmackNextFrame(DWORD *smk);
void   WINAPI _SmackToBuffer(DWORD *smk, DWORD left, DWORD top, DWORD pitch, DWORD destheight, void *buf, DWORD flags);
DWORD  WINAPI _SmackWait(DWORD *smk);
void   WINAPI _SmackSoundUseWin(void);

#pragma pack(push, 1)
typedef struct {
  BITMAPINFOHEADER info;
  RGBQUAD cpal[256];
  BYTE data[320 * 240];
} bmpframe;
#pragma pack(pop)

static bmpframe bmp_info;

#include "../../nhcaddon/subtitle.c"

#define NHC_FONT 11
#define NHC_TEXT 12
#define NHC_SUBS 13

DWORD NHCLoad(DWORD hash, BYTE type, void *buff, DWORD size) {
DWORD result;
HANDLE fl;
CCHAR s[32];
  result = 0;
  wsprintf(s, "%08X.N%02X", hash, type);
  fl = CreateFileA(s, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, 0);
  if (fl != INVALID_HANDLE_VALUE) {
    if (buff && size) {
      ZeroMemory(buff, size);
      ReadFile(fl, buff, size, &result, NULL);
    } else {
      result = GetFileSize(fl, NULL);
    }
    CloseHandle(fl);
  }
  return(result);
}

DWORD LoadSubs(char *filename) {
CCHAR s[MAX_PATH];
HANDLE fl;
DWORD i;
  i = 0;
  lstrcpy(s, filename);
  lstrcpy(&s[lstrlen(filename) - 4], ".N0D");
  fl = CreateFile(s, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, 0);
  if (fl != INVALID_HANDLE_VALUE) {
    ZeroMemory(subslist, sizeof(subslist));
    ReadFile(fl, subslist, sizeof(subslist), &i, NULL);
    CloseHandle(fl);
    i /= sizeof(subslist[0]);
  }
  return(i);
}

void WINAPI hook_SmackToBuffer(DWORD *smk, DWORD left, DWORD top, DWORD pitch, DWORD height, void *buf, DWORD flags) {
  // init subtitles
  SubsInit(smk[220], left, top, pitch, height, smk[1], buf, flags);
  // prepare frame
  _SmackToBuffer(smk, left, top, pitch, height, buf, flags);
}

int WINAPI hook_SmackDoFrame(DWORD *smk) {
int r;
char s[1025];
  // render new frame to the buffer
  r = _SmackDoFrame(smk);
  // render subtitles on top of the new frame
  SubsDraw(0x00);
  // show current frame
  wsprintf(s, "%u", smk[220]);
  textdraw(subv.addr + (subv.pitch * (16 + 2)), subv.pitch, 16 + 2, (8 * 5) + 2, (BYTE *) s, 0x00);
  return(r);
}

int CheckForEscape(void) {
INPUT_RECORD r;
HANDLE h;
DWORD d;
  h = GetStdHandle(STD_INPUT_HANDLE);
  while ((PeekConsoleInput(h, &r, 1, &d)) && (d > 0)) {
    ReadConsoleInput(h, &r, 1, &d);
    if (
      (r.EventType == KEY_EVENT) &&
      (r.Event.KeyEvent.wVirtualKeyCode == VK_ESCAPE) &&
      (r.Event.KeyEvent.bKeyDown)
    ) {
      return(1);
    }
  }
  return(0);
}

int main(int argc, char *argv[]) {
CONSOLE_CURSOR_INFO cci;
DWORD i, *smk;
BYTE *p, xp[3];
HWND wh;
RECT rc;
HDC hc;
  if (argc != 2) { return(2); }
  if (!AllocConsole()) { return(1); }
  SetConsoleTitle("*:NHCSMACK:*");
  Sleep(100);
  for (i = 0; i < 20; i++) {
    wh = FindWindow(NULL, "*:NHCSMACK:*");
    if (wh) { break; }
    Sleep(50);
  }
  cci.dwSize = 1;
  cci.bVisible = FALSE;
  SetConsoleCursorInfo(GetStdHandle(STD_OUTPUT_HANDLE), &cci);
  if (!wh) { return(2); }
  _SmackSoundUseWin();
  smk = _SmackOpen(argv[1], 0xFE600, INVALID_FILE_ATTRIBUTES);
  if (smk) {
    hc = GetWindowDC(wh);
    if (hc) {
      // init subtitles
      SubsData();
      // load subtitles font
      if (NHCLoad(0x544E4F46, NHC_FONT, subsfont, sizeof(subsfont)) != sizeof(subsfont)) {
        // font not found - use something instead of font (not empty)
        SubsData();
        for (i = 0; i < 256; i++) {
          FillMemory(&subsfont[i * 16], 16, i);
        }
      }
      // load subtitles
      subl = LoadSubs(argv[1]);
      // init bitmap header
      ZeroMemory(&bmp_info, sizeof(bmp_info));
      bmp_info.info.biSize = sizeof(bmp_info.info);
      bmp_info.info.biPlanes = 1;
      bmp_info.info.biBitCount = 8;
      bmp_info.info.biWidth = 320;
      // negative height - top-down image
      bmp_info.info.biHeight = -smk[2];
      //timeBeginPeriod(1);
      while (((smk[220] + 1) < smk[3]) && (!CheckForEscape())) {
        // set buffer to output
        hook_SmackToBuffer(smk, 0, 0, 320, smk[2], bmp_info.data, 0);
        // output current frame
        hook_SmackDoFrame(smk);
        // new palette flag
        if (smk[26]) {
          p = (BYTE *) &smk[27];
          for (i = 0; i < 256; i++) {
            CopyMemory(xp, &p[i * 3], 3);
            // fast VGA (0..63) to RGB (0..255)
            bmp_info.cpal[i].rgbRed = (xp[0] << 2) | (xp[0] >> 4);
            bmp_info.cpal[i].rgbGreen = (xp[1] << 2) | (xp[1] >> 4);
            bmp_info.cpal[i].rgbBlue = (xp[2] << 2) | (xp[2] >> 4);
          }
          // black
          bmp_info.cpal[0x00].rgbRed = 0;
          bmp_info.cpal[0x00].rgbGreen = 0;
          bmp_info.cpal[0x00].rgbBlue = 0;
          // white
          bmp_info.cpal[0xFF].rgbRed = 0xFF;
          bmp_info.cpal[0xFF].rgbGreen = 0xFF;
          bmp_info.cpal[0xFF].rgbBlue = 0xFF;
        }
        // draw to screen
        GetWindowRect(wh, &rc);
        SetDIBitsToDevice(hc,
          ((rc.right - rc.left) - 320) / 2, ((rc.bottom - rc.top) - smk[2]) / 2,
          320, smk[2], 0, 0,
          0, smk[2],
          (void *) bmp_info.data,
          (BITMAPINFO *) &bmp_info,
          DIB_RGB_COLORS
        );
        // decode next frame
        _SmackNextFrame(smk);
        // wait for next frame
        while (_SmackWait(smk)) { Sleep(1); }
      }
      //timeEndPeriod(1);
      ReleaseDC(wh, hc);
    }
    _SmackClose(smk);
  }
  FreeConsole();
  return(0);
}
