#include <stdio.h>
#include <windows.h>
#include <mmsystem.h>

#define XFCC_RIFF MAKEFOURCC('R','I','F','F')
#define XFCC_WAVE MAKEFOURCC('W','A','V','E')
#define XFCC_FMT_ MAKEFOURCC('f','m','t',' ')
#define XFCC_DATA MAKEFOURCC('d','a','t','a')

#pragma pack(push, 1)
typedef struct {
  FOURCC ckid;
  DWORD  cksz;
} rffchunk;

typedef struct {
  rffchunk ckRIFF;
  FOURCC   ckid;
} wav_head;
#pragma pack(pop)

TCHAR *basename(TCHAR *s) {
TCHAR *r;
  if (s) {
    for (r = s; *r; r++) {
      if ((*r == TEXT('/')) || (*r == TEXT('\\'))) {
        s = &r[1];
      }
    }
  }
  return(s);
}

void newext(TCHAR *name, TCHAR *ext) {
TCHAR *p;
  if (name && ext) {
    for (; (*name == TEXT('.')); name++);
    for (p = NULL; *name; name++) {
      if (*name == TEXT('.')) {
        p = name;
      }
    }
    lstrcpy(p ? p : name, ext);
  }
}

int main(int argc, char *argv[]) {
PCMWAVEFORMAT pcm;
TCHAR s[MAX_PATH];
DWORD dw, sz, l;
wav_head wh;
rffchunk ck;
HANDLE fl;
void *p;
  if (argc != 2) {
    printf("Usage: nhcsound <filename.wav>\n\n");
    return(1);
  }
  fl = CreateFile(argv[1], GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
  if (fl == INVALID_HANDLE_VALUE) {
    printf("Error: can't open input file.\n\n");
    return(2);
  }
  sz = GetFileSize(fl, NULL);
  if (sz <= sizeof(wh)) {
    CloseHandle(fl);
    printf("Error: invalid file format (too small).\n\n");
    return(3);
  }
  ZeroMemory(&wh, sizeof(wh));
  ReadFile(fl, &wh, sizeof(wh), &dw, NULL);
  if (
    (dw < sizeof(wh)) || (wh.ckRIFF.ckid != XFCC_RIFF) ||
    ((wh.ckRIFF.cksz + 8) > sz) || (wh.ckid != XFCC_WAVE)
  ) {
    CloseHandle(fl);
    printf("Error: invalid file format.\n\n");
    return(4);
  }
  /* find chunks */
  ZeroMemory(&pcm, sizeof(pcm));
  ZeroMemory(&ck, sizeof(ck));
  p = NULL;
  l = sizeof(wh);
  while ((l + sizeof(ck)) < sz) {
    SetFilePointer(fl, l, NULL, FILE_BEGIN);
    ZeroMemory(&ck, sizeof(ck));
    ReadFile(fl, &ck, sizeof(ck), &dw, NULL);
    if ((ck.ckid == XFCC_FMT_) && (ck.cksz >= sizeof(pcm))) {
      ReadFile(fl, &pcm, sizeof(pcm), &dw, NULL);
      if (
        (dw < sizeof(pcm)) ||
        (pcm.wf.wFormatTag != WAVE_FORMAT_PCM) || (pcm.wf.nChannels != 1) || (pcm.wf.nSamplesPerSec != 22050) ||
        (pcm.wf.nAvgBytesPerSec != (22050 * 2)) || (pcm.wf.nBlockAlign != 2) || (pcm.wBitsPerSample != 16)
      ) {
        printf(
          "Error: invalid format block found:\n"
          "  formatag: %d (must be 1)\n"
          "  channels: %d (must be 1)\n"
          "  streamhz: %d (must be 22050)\n"
          "  avgbytes: %d (must be 44100)\n"
          "  blkalign: %d (must be 2)\n"
          "  bitspsec: %d (must be 16)\n",
          pcm.wf.wFormatTag, pcm.wf.nChannels, pcm.wf.nSamplesPerSec,
          pcm.wf.nAvgBytesPerSec, pcm.wf.nBlockAlign, pcm.wBitsPerSample
        );
        break;
      }
    }
    if ((ck.ckid == XFCC_DATA) && (ck.cksz <= (sz - l))) {
      if (pcm.wf.wFormatTag != WAVE_FORMAT_PCM) {
        printf("Error: data block found, but no valid format block before it.\n\n");
      } else {
        p = (void *) LocalAlloc(LPTR, ck.cksz);
        if (p) { ReadFile(fl, p, ck.cksz, &dw, NULL); }
      }
      break;
    }
    l += sizeof(ck) + ck.cksz;
  }
  CloseHandle(fl);
  if (p) {
    /* save to disk */
    lstrcpy(s, basename(argv[1]));
    printf("%s -> ", s);
    newext(s, TEXT(".N07"));
    printf("%s\n", s);
    fl = CreateFile(s, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
    if (fl != INVALID_HANDLE_VALUE) {
      WriteFile(fl, p, ck.cksz, &dw, NULL);
      CloseHandle(fl);
      printf("\ndone\n\n");
    }
    LocalFree(p);
  }
  return(0);
}
