#define BMPLINESIZE(w, b) (((((w) * (b)) + 31) & ~31) >> 3)
int FillBitmapHeader(BYTE *buf, int iwidth, int iheight, int ibpp) {
BITMAPFILEHEADER *bf;
BITMAPINFOHEADER *bi;
int hsize, dsize;
  hsize = sizeof(bf[0]) + sizeof(bi[0]) + (((ibpp <= 8) ? (1 << ibpp) : 0) * 4);
  dsize = BMPLINESIZE(iwidth, ibpp) * iheight;
  if (buf) {
    bf = (BITMAPFILEHEADER *) buf;
    bi = (BITMAPINFOHEADER *) &buf[sizeof(bf[0])];
    ZeroMemory(bf, sizeof(bf[0]));
    ZeroMemory(bi, sizeof(bi[0]));
    bi->biSize = sizeof(bi[0]);
    bi->biWidth = iwidth;
    bi->biHeight = -iheight; // negative height: top to bottom image
    bi->biPlanes = 1;
    bi->biBitCount = ibpp;
    bf->bfType = 0x4D42;
    bf->bfSize = hsize + dsize;
    bf->bfOffBits = hsize;
    hsize = sizeof(bf[0]) + sizeof(bi[0]);
    dsize = 0;
  }
  return(hsize + dsize);
}

DWORD NHC_Hash(TCHAR *s) {
DWORD p, c, k, hash;
  hash = 0;
  if (s) {
    for (p = 0; *s; s++) {
      c = (BYTE) *s;
      // uppercase
      if ((c >= 'a') && (c <= 'z')) { c ^= 0x20; }
      k = 0;
      if ((c >= 'A') && (c <= 'Z')) { k = c - 0x40; }
      if ((c >= '0') && (c <= '9')) { k = c - 0x2A; }
      // only digits and chars - ignore all other
      if (k) {
        // shift value from 0 till 31
        p = (p + k) & 0x1F;
        hash ^= (1 << p);
      }
    }
  }
  return(hash);
}

void TextTrim(TCHAR *s) {
DWORD i, j, k, l;
  if (s && *s) {
    i = 0;
    j = 0;
    l = 0;
    while (s[i]) {
      k = j;
      while ((s[i]) && (s[i] != TEXT('\r')) && (s[i] != TEXT('\n'))) {
        s[j] = s[i];
        if ((s[i] != TEXT(' ')) && (s[i] != TEXT('\t'))) {
          k = j + 1;
          l = k;
        }
        i++;
        j++;
      }
      j = k;
      s[j] = s[i];
      j += s[i] ? 1 : 0;
      i += s[i] ? 1 : 0;
    }
    s[l] = 0;
  }
}

void RLE_Unpack(BYTE *p, DWORD ps, BYTE *u, DWORD us, DWORD l) {
DWORD r, c, i, k;
  if (p && u) {
    k = 1;
    while ((us) && (ps >= 4)) {
      r = *((WORD *) &p[0]);
      c = *((WORD *) &p[2]);
      if ((!k) && (!r)) { break; }
      p += 4;
      ps -= 4;
      if (!c) {
        c = (us < (r * l)) ? us : (r * l);
        u += c;
        us -= c;
      } else {
        while ((r--) && (us) && (ps >= 4)) {
          for (i = c; i; i--) {
            k = *((WORD *) &p[2]);
            CopyMemory(&u[*((WORD *) &p[0])], &p[4], k);
            k = ((k + 4) < ps) ? (k + 4) : ps;
            p += k;
            ps -= k;
            if (ps < 4) { break; }
          }
          k = (l < us) ? l : us;
          u += k;
          us -= k;
        }
      }
      k = 0;
    }
  }
}

#define IMG_RLE 1
#define IMG_WXH 2
#define IMG_POS 4
#define IMG_PAL 8
#define IMG_BMP 16
#define IMG_ALL (IMG_RLE | IMG_WXH | IMG_POS | IMG_PAL | IMG_BMP)

void nvh_image(BYTE *p, DWORD ps, BYTE *u, DWORD us) {
WORD t, w, h, f; //x, y;
DWORD i, l;
  l = BMP_FULL;
  if (p && (ps > 2) && u && (us > l)) {
    f = *((WORD *) p); p += 2; ps -= 2;
    t = 0;
    w = 0;
    h = 0;
    // has width and height
    if (f & IMG_WXH) {
      if (ps >= 4) {
        w = *((WORD *) p); p += 2; ps -= 2;
        h = *((WORD *) p); p += 2; ps -= 2;
        t = w;
        for (; w & 3; w++);
      }
    }
    // has position
    //x = 0;
    //y = 0;
    if (f & IMG_POS) {
      if (ps >= 4) {
        p += 4;
        ps -= 4;
        //x = *((WORD *) p); p += 2; ps -= 2;
        //y = *((WORD *) p); p += 2; ps -= 2;
      }
    }
    // has image bitmap data
    if ((f & IMG_BMP) && w && h) {
      ZeroMemory(u, us);
      us -= l;
      FillBitmapHeader(u, t, h, 8);
      /* default palette */
      l -= BMP_CPAL;
      for (i = 0; i < 256; i++) {
        u[l + (i * 4)    ] = i;
        u[l + (i * 4) + 1] = i;
        u[l + (i * 4) + 2] = i;
      }
      /* has palette */
      if (f & IMG_PAL) {
        if (ps >= BMP_CPAL) {
          for (i = 0; i < 256; i++) {
            u[l + (i * 4)    ] = p[(i * 4) + 2];
            u[l + (i * 4) + 1] = p[(i * 4) + 1];
            u[l + (i * 4) + 2] = p[(i * 4)    ];
          }
          p += BMP_CPAL;
          ps -= BMP_CPAL;
        }
      }
      l += BMP_CPAL;
      if (f & IMG_RLE) {
        ps = ((w * h) < ps) ? (w * h) : ps;
        RLE_Unpack(p, ps, &u[l], us, w);
      } else {
        ps = ((w * h) < ps) ? (w * h) : ps;
        CopyMemory(&u[l], p, (ps < us) ? ps : us);
      }
    }
  }
}

DWORD LoadData(TCHAR *filename, void *p, DWORD l) {
HANDLE fl;
DWORD dw;
  if (p && l) { ZeroMemory(p, l); }
  fl = INVALID_HANDLE_VALUE;
  if (filename) {
    fl = CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    if (fl != INVALID_HANDLE_VALUE) {
      dw = 0;
      ReadFile(fl, p, l, &dw, NULL);
      if (dw == l) { l = GetFileSize(fl, NULL); }
      CloseHandle(fl);
    }
  }
  return((fl != INVALID_HANDLE_VALUE) ? l : 0);
}

void SaveData(TCHAR *filename, void *p, DWORD l) {
HANDLE fl;
  if (filename) {
    fl = CreateFile(filename, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
    if (fl != INVALID_HANDLE_VALUE) {
      if (p && l) { WriteFile(fl, p, l, &l, NULL); }
      CloseHandle(fl);
    }
  }
}
