#include <windows.h>
#include <commctrl.h>
#include "nhctexts.h"
#include "wndtools.h"

#define BMP_FILE (sizeof(BITMAPFILEHEADER))
#define BMP_INFO (sizeof(BITMAPINFOHEADER))
#define BMP_CPAL (sizeof(RGBQUAD) * 256)
#define BMP_HEAD (BMP_FILE + BMP_INFO)
#define BMP_FULL (BMP_HEAD + BMP_CPAL)

#define GetMem(x) ((void *) LocalAlloc(LPTR, (x)))
#define FreeMem(x) LocalFree((x))

#define LIST_LEN(x) (sizeof((x)) / sizeof((x)[0]))

#define PCSD __attribute__ ((aligned(1))) const static

#pragma pack(push, 1)
typedef struct {
  DWORD dwHash;
  WORD  wOffs;
  WORD  wType;
} arf_item;

/*typedef struct {
  SHORT x;
  SHORT y;
} dot_item;*/
#pragma pack(pop)

/*
283CE401.N02 font red (Klogg)
C6604282.N02 font yellow (Willie)
0800090C.N02 font beige (walls)
0002486A.N05 data asRecFont (Klogg/Willie/walls size)
2800E011.N02 back Klogg
8870A546.N02 back Willie
08100289.N02 back Walls
*/

PCSD TCHAR filelist[] = TEXT(
  "stSolutionList\0"
  "stWillieHints\0"
  "stLineagex\0"
  "stFather\0"
  "stQuater\0"
  "stOgdilla\0"
  "stBertBert\0"
  "stNumeron\0"
  "stOttoborg\0"
  "stHomen\0"
  "stHoborg\0"
  "stArven\0"
);

PCSD WORD item_pos[][5] = {
  // id, x, y, w, h
//  {IDC_AREA, 0, 0, 640, 480},
  {IDC_SBAR, 640, 0, 16, 480},
  {IDC_FILE, 640 + 16, 0, 124, 160},
  {IDC_ITEM, 640 + 16 + 124, 0, 40, 160},
  {IDC_TEXT, 640 + 16, 160, 344, 480 - 160},

  {IDC_VTXT, 640 + 16 + 124 + 40 + 4, 0 + 2, 12, 16},
  {IDC_VEDT, 640 + 16 + 124 + 40 + 4 + 12, 0, 24, 20},
  {IDC_VPOS, 640 + 16 + 124 + 40 + 4 + 12 + 24, 0, 16, 20},

  {IDC_HTXT, 640 + 16 + 124 + 40 + 4 + 12 + 24 + 4 + 16, 0 + 2, 12, 16},
  {IDC_HEDT, 640 + 16 + 124 + 40 + 4 + 12 + 24 + 4 + 16 + 12, 0, 24, 20},
  {IDC_HPOS, 640 + 16 + 124 + 40 + 4 + 12 + 24 + 4 + 16 + 12 + 24, 0, 16, 20},

  {IDC_STXT, 640 + 16 + 124 + 40 + 4 + 12 + 24 + 4 + 16 + 12 + 24 + 4 + 16, 0 + 2, 12, 16},
  {IDC_SEDT, 640 + 16 + 124 + 40 + 4 + 12 + 24 + 4 + 16 + 12 + 24 + 4 + 16 + 12, 0, 24, 20},
  {IDC_SPOS, 640 + 16 + 124 + 40 + 4 + 12 + 24 + 4 + 16 + 12 + 24 + 4 + 16 + 12 + 24, 0, 16, 20},

  {IDC_SAVE, 640 + 16 + 124 + 40 + 4, 20 + 4, 75, 23},
  {IDC_DRAW, 640 + 16 + 124 + 40 + 4, 20 + 4 + 23 + 4, 75, 23},
  {IDC_DUMP, 640 + 16 + 124 + 40 + 4, 20 + 4 + 23 + 4 + 23 + 4, 75, 23},

  {IDC_INFO, 640 + 16 + 344 - 60, 160 - 20, 60, 20}
};

static BYTE backdraw[BMP_FULL + (640 * 1712)];

// font data
static BYTE fontdata[2 + (6 * 8) +4 +4 +4 +4 +(2 + (256 * 4)) +2];
// font info: FirstChar, LastChar, WidthChar, HeightChar, TrackingChar
static WORD fontinfo[5];
// Hints, Klogg, Walls
static BYTE fontlist[3][BMP_FULL + (640 * 480)];
static BYTE fontused;
// backgrounds
static BYTE backlist[3][BMP_FULL + (640 * 480)];

static BYTE loadpart[(2 * 5) + BMP_CPAL + (640 * 480)];

#include "wndtools.c"

#include "miscfunc.c"

static BYTE *textdata;
static DWORD textsize;

DWORD GetFileHash(DWORD n) {
TCHAR *s;
  // filename to open
  s = (TCHAR *) filelist;
  while (*s && n) {
    while (*s) { s++; }
    s++;
    n--;
  }
  return(*s ? NHC_Hash(s) : 0);
}

void MakeTextDump(HWND wnd) {
TCHAR *s, a[16 + 16];
DWORD *o, i, j, l;
BYTE *p;
  if (SendMessage(GetDlgItem(wnd, IDC_FILE), LB_GETCURSEL, 0, 0) < 0) {
    MessageBox(wnd, TEXT("Text resource file not selected."), TEXT(""), MB_OK | MB_ICONWARNING);
    return;
  }
  if (textdata && textsize) {
    o = (DWORD *) textdata;
    p = &textdata[(*o + 1) * sizeof(o[0])];
    // count size
    l = 0;
    for (j = 1; j < o[0]; j++) {
      for (i = o[j]; i < o[j + 1]; i++) {
        l += p[i] ? 1 : 2;
      }
      l += 30 + 2 + 2;
    }
    s = (TCHAR *) GetMem((l + 1) * sizeof(s[0]));
    if (s) {
      l = 0;
      for (j = 1; j < o[0]; j++) {
        for (i = 0; i < 30; i++) { s[l] = TEXT('-'); l++; }
        s[l] = (j > 9) ? (TEXT('0') + (j / 10)) : TEXT(' '); l++;
        s[l] = TEXT('0') + (j % 10); l++;
        s[l] = TEXT('\r'); l++;
        s[l] = TEXT('\n'); l++;
        for (i = o[j]; i < o[j + 1]; i++) {
          s[l] = p[i];
          if (!p[i]) {
            s[l] = TEXT('\r');
            s[l + 1] = TEXT('\n');
          }
          l += p[i] ? 1 : 2;
        }
      }
      s[l] = 0;
      TextTrim(s);
      // save to disk
      i = SendMessage(GetDlgItem(wnd, IDC_FILE), LB_GETCURSEL, 0, 0);
      j = GetFileHash(i);
      l = 0;
      while (i && filelist[l]) {
        while (filelist[l]) { l++; }
        l++;
        i--;
      }
      wsprintf(a, TEXT("%08X %s.txt"), j, &filelist[l]);
      SaveData(a, s, lstrlen(s));
      FreeMem(s);
      MessageBox(wnd, TEXT("Whole text resource rendered to the text file in current folder for spell checking."), TEXT(""), MB_OK | MB_ICONINFORMATION);
    }
  }
}

BOOL SaveText(HWND wnd) {
DWORD i, j, k, l, m, *o, *n;
CCHAR s[(32 + 1) * 30];
BYTE *p;
HWND w;
  if (SendMessage(GetDlgItem(wnd, IDC_FILE), LB_GETCURSEL, 0, 0) < 0) {
    MessageBox(wnd, TEXT("Text resource file not selected."), TEXT(""), MB_OK | MB_ICONWARNING);
    return(FALSE);
  }
  if (SendMessage(GetDlgItem(wnd, IDC_ITEM), LB_GETCURSEL, 0, 0) < 0) {
    MessageBox(wnd, TEXT("Text resource item not selected."), TEXT(""), MB_OK | MB_ICONWARNING);
    return(FALSE);
  }
  if ((!textdata) || (!textsize)) {
    MessageBox(wnd, TEXT("Text resource not loaded."), TEXT(""), MB_OK | MB_ICONWARNING);
    return(FALSE);
  }
  w = GetDlgItem(wnd, IDC_TEXT);
  k = SendMessage(w, EM_GETLINECOUNT, 0, 0);
  if (k > 30) {
    MessageBox(wnd, TEXT("More than 30 lines of text."), TEXT(""), MB_OK | MB_ICONWARNING);
    return(FALSE);
  }
  l = 0;
  for (i = 0; i < k; i++) {
    j = SendMessage(w, EM_LINELENGTH, SendMessage(w, EM_LINEINDEX, i, 0), 0);
    if (j > 32) {
      MessageBox(wnd, TEXT("More than 32 chars on line."), TEXT(""), MB_OK | MB_ICONWARNING);
      return(FALSE);
    }
    // get line
    *((WORD *) &s[l]) = 32;
    j = SendMessageA(w, EM_GETLINE, i, (LPARAM) &s[l]);
    s[l + j] = 0;
    // trim line
    j = 0;
    while (s[l + j]) {
      if ((s[l + j] != TEXT(' ')) && (s[l + j] != TEXT('\t'))) {
        l += j + 1;
        j = 0;
      } else {
        j++;
      }
    }
    s[l] = 0;
    l++;
  }
  // BOBBY puzzle
  if (!SendMessage(GetDlgItem(wnd, IDC_FILE), LB_GETCURSEL, 0, 0)) {
    if ((k != 1) || (l != (5 + 1))) {
      MessageBox(wnd, TEXT("Solution must be a single line of 5 chars."), TEXT(""), MB_OK | MB_ICONWARNING);
      return(FALSE);
    }
    for (i = 0; s[i]; i++) {
      if (
        (s[i] != 'R') && (s[i] != 'O') && (s[i] != 'Y') &&
        (s[i] != 'G') && (s[i] != 'B') && (s[i] != 'V')
      ) {
        MessageBox(wnd, TEXT(
          "Each solution char must be\n"
          "one of the uppercase letter:\n\n"
          "R - red\n"
          "O - orange\n"
          "Y - yellow\n"
          "G - green\n"
          "B - blue\n"
          "V - violet"
        ), TEXT(""), MB_OK | MB_ICONWARNING);
        return(FALSE);
      }
    }
  }
  // rebuild text resource
  j = SendMessage(GetDlgItem(wnd, IDC_ITEM), LB_GETCURSEL, 0, 0);
  o = (DWORD *) textdata;
  i = textsize + l - (o[1 + j + 1] - o[1 + j]);
  p = (BYTE *) GetMem(i + 1);
  if (p) {
    textsize = i;
    ZeroMemory(p, textsize);
    // copy header
    i = (o[0] + 1) * sizeof(o[0]);
    CopyMemory(p, textdata, i);
    // copy items
    n = (DWORD *) p;
    p += i;
    textdata += i;
    for (i = 0; i < (*o - 1); i++) {
      if (i != j) {
        // copy old
        n[1 + i + 1] = 0;
        m = 0;
        // trim old
        for (k = 0; k < (o[1 + i + 1] - o[1 + i]); k++) {
          if (!textdata[o[1 + i] + k]) {
            m = n[1 + i + 1];
            n[1 + i + 1]++;
          } else {
            if ((textdata[o[1 + i] + k] != ' ') && (textdata[o[1 + i] + k] != '\t')) {
              n[1 + i + 1] = m + 1;
            }
          }
          p[n[1 + i] + m] = textdata[o[1 + i] + k];
          m++;
        }
        if (m) { p[n[1 + i] + m - 1] = 0; }
        n[1 + i + 1] += n[1 + i];
        //CopyMemory(&p[n[1 + i]], &textdata[o[1 + i]], o[1 + i + 1] - o[1 + i]);
        //n[1 + i + 1] = n[1 + i] + (o[1 + i + 1] - o[1 + i]);
      } else {
        // copy new
        CopyMemory(&p[n[1 + i]], s, l);
        n[1 + i + 1] = n[1 + i] + l;
      }
    }
    textsize = ((1 + n[0]) * sizeof(n[0])) + n[n[0]];
    i = (o[0] + 1) * sizeof(o[0]);
    textdata -= i;
    p -= i;
    FreeMem(textdata);
    textdata = p;
  }
  return(p ? TRUE : FALSE);
}

void LoadText(HWND wnd, DWORD n) {
TCHAR m[16];
HANDLE fl;
DWORD dw;
  if (n <= 11) {
    // clear list box
    SendMessage(wnd, LB_RESETCONTENT, 0, 0);
    // open file
    wsprintf(m, TEXT("%08X.N06"), GetFileHash(n));
    fl = CreateFile(m, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    if (fl != INVALID_HANDLE_VALUE) {
      n = GetFileSize(fl, NULL);
      if (n >= ((4 * 3) + 1)) {
        if (textdata) {
          FreeMem(textdata);
          textdata = NULL;
        }
        textsize = n;
        n = 0;
        ReadFile(fl, &n, 4, &dw, NULL);
        // sanity checks: min and max records in game
        if ((n >= 2) && (n <= 52)) {
          SetFilePointer(fl, 0, NULL, FILE_BEGIN);
          textdata = (BYTE *) GetMem(textsize + 1);
          if (textdata) {
            ReadFile(fl, textdata, textsize, &dw, NULL);
            textdata[textsize] = 0;
            // fill items in listbox
            for (dw = 1; dw < n; dw++) {
              wsprintf(m, TEXT("%u"), dw);
              SendMessage(wnd, LB_ADDSTRING, 0, (WPARAM) m);
            }
          }
        }
        if (!textdata) {
          textsize = 0;
        }
      }
      CloseHandle(fl);
    }
  }
}

void LoadItem(HWND wnd, DWORD n) {
DWORD *o, i, l;
BYTE *p;
TCHAR *s;
  if (textdata && textsize) {
    n++;
    o = (DWORD *) textdata;
    p = &textdata[(*o + 1) * sizeof(o[0])];
    // count size
    l = 0;
    for (i = o[n]; i < o[n + 1]; i++) {
      l += p[i] ? 1 : 2;
    }
    s = (TCHAR *) GetMem((l + 1) * sizeof(s[0]));
    if (s) {
      l = 0;
      for (i = o[n]; i < o[n + 1]; i++) {
        s[l] = p[i];
        if (!p[i]) {
          s[l] = TEXT('\r');
          s[l + 1] = TEXT('\n');
        }
        l += p[i] ? 1 : 2;
      }
      s[l] = 0;
      TextTrim(s);
      SetWindowText(wnd, s);
      FreeMem(s);
    }
  }
}

void LoadBack(void) {
DWORD i;
  FillBitmapHeader(backdraw, 640, 1712, 8);
  CopyMemory(
    &backdraw[BMP_HEAD],
    &backlist[fontused][BMP_HEAD],
    BMP_CPAL + (640 * 480)
  );
  // Walls
  if (fontused == 2) {
    CopyMemory(
      &backdraw[BMP_FULL + ((192 + 480) * 640)],
      &backdraw[BMP_FULL],
      640 * 480
    );
    CopyMemory(
      &backdraw[BMP_FULL + ((192) * 640)],
      &backdraw[BMP_FULL + ((192 + 480) * 640)],
      640 * 480
    );
    for (i = 192; i < 1712; i++) {
      CopyMemory(
        &backdraw[BMP_FULL + (i * 640)],
        &backdraw[BMP_FULL + ((192 + ((i - 192) % 480)) * 640)],
        640
      );
    }
    //ZeroMemory(&backdraw[BMP_FULL], 192 * 640);
    CopyMemory(&backdraw[BMP_FULL], &backdraw[BMP_FULL + (480 * 640)], 192 * 640);
  }
}

void DrawRect(BYTE *u, BYTE *p, int px, int py, int ux, int uy, int w, int h) {
int uw, uh, pw, ph, i, j, ul, pl;
BITMAPINFOHEADER *bi;
BYTE b;
  bi = (BITMAPINFOHEADER *) &u[BMP_FILE];
  uw = bi->biWidth;
  uh = (bi->biHeight < 0) ? (-bi->biHeight) : bi->biHeight;
  ul = BMPLINESIZE(bi->biWidth, bi->biBitCount);
  u += BMP_FULL;
  bi = (BITMAPINFOHEADER *) &p[BMP_FILE];
  pw = bi->biWidth;
  ph = (bi->biHeight < 0) ? (-bi->biHeight) : bi->biHeight;
  pl = BMPLINESIZE(bi->biWidth, bi->biBitCount);
  p += BMP_FULL;
  for (j = 0; j < h; j++) {
    if (((py + j) >= 0) && ((py + j) <= ph) && ((uy + j) >= 0) && ((uy + j) <= uh)) {
      for (i = 0; i < w; i++) {
        if (((px + i) >= 0) && ((px + i) <= pw) && ((ux + i) >= 0) && ((ux + i) <= uw)) {
          b = p[((py + j) * pl) + px + i];
          if (b) { u[((uy + j) * ul) + ux + i] = b; }
        }
      }
    }
  }
}

void FontDraw(HWND wnd, BOOL bHints, BOOL bBacks) {
DWORD i, j, l;
TCHAR s[32 + 1];
SHORT vhs[3], x, y;
BYTE b;
  vhs[0] = SendMessage(GetDlgItem(GetParent(wnd), IDC_VPOS), UDM_GETPOS, 0, 0);
  vhs[1] = SendMessage(GetDlgItem(GetParent(wnd), IDC_HPOS), UDM_GETPOS, 0, 0);
  vhs[2] = SendMessage(GetDlgItem(GetParent(wnd), IDC_SPOS), UDM_GETPOS, 0, 0);
  ZeroMemory(&backdraw[BMP_FULL], sizeof(backdraw) - BMP_FULL);
  CopyMemory(&backdraw[BMP_HEAD], &fontlist[fontused][BMP_HEAD], BMP_CPAL);
  // load background
  if (bBacks) { LoadBack(); }
  l = SendMessage(wnd, EM_GETLINECOUNT, 0, 0);
  l = (l < 30) ? l : 30;
  y = bHints ? 36 : 192;
  // translation asFontRec file
  if ((fontinfo[0] == 32) && (fontinfo[1] == 255)) { y += 18; }
  for (j = 0; j < l; j++) {
    // EM_GETLINE: first word of the buffer specifies maximum number of characters that can be copied
    *((WORD *) &s[0]) = 32;
    i = SendMessage(wnd, EM_GETLINE, j, (LPARAM) s);
    // EM_GETLINE: copied line does not contain a terminating null character
    s[i] = 0;
    x = bHints ? 188 : 95;
    // translation asFontRec file
    if ((fontinfo[0] == 32) && (fontinfo[1] == 255)) { x += 15; }
    for (i = 0; s[i]; i++) {
      b = (BYTE) s[i];
      // in allowed range
      b = ((b >= fontinfo[0]) && (b <= fontinfo[1])) ? b : fontinfo[0];
      b -= fontinfo[0];
      DrawRect(
        backdraw, fontlist[fontused],
        (b & 0x0F) * fontinfo[2], (b >> 4) * fontinfo[3],
        x, y,
        fontinfo[2], fontinfo[3]
      );
      /*for (i = 0; i < fontinfo[3]; i++) {
        u = &backdraw[BMP_FULL + ((y + i) * 640) + x];
        p = &fontlist[fontused][BMP_FULL + ((((b >> 4) * fontinfo[3]) + i) * 640) + ((b & 0x0F) * fontinfo[2])];
        // skip transparent pixels
        for (z = 0; z < fontinfo[2]; z++) {
          u[z] = p[z] ? p[z] : u[z];
        }
      }*/
      x += (s[i] == ' ') ? vhs[2] : fontdata[fontinfo[4] + (b * 4)];
      x += vhs[1];
    }
    y += bHints ? 36 : 48;
    y += vhs[0];
  }
}

void LoadError(TCHAR *s) {
  MessageBox(0, s, TEXT("File not found or invalid format"), MB_OK | MB_ICONERROR);
}

BOOL InitData(void) {
TCHAR m[16];
DWORD i, l;
arf_item *a;
  textdata = NULL;
  textsize = 0;
  // load font data
  wsprintf(m, TEXT("%08X.N05"), 0x0002486A); // font data (asFontRec)
  i = LoadData(m, fontdata, sizeof(fontdata));
  // TODO: check file format more strict?
  if ((i < 2) || (fontdata[0] != 6)) {
    LoadError(m);
    return(FALSE);
  }
  // font info: FirstChar, LastChar, WidthChar, HeightChar, TrackingChar
  ZeroMemory(fontinfo, sizeof(fontinfo));
  a = (arf_item *) &fontdata[2];
  l = 2 + (*((WORD *) fontdata) * sizeof(a[0]));
  for (i = 0; i < (*(WORD *) fontdata); i++) {
    // meNumRows:8
    if (a[i].dwHash == 0x0434000D) {
      fontinfo[1] = *((WORD *) &fontdata[l + a[i].wOffs]);
    }
    // meFirstChar:0
    if (a[i].dwHash == 0x240C2022) {
      fontinfo[0] = *((WORD *) &fontdata[l + a[i].wOffs]);
    }
    // meCharWidth:40
    if (a[i].dwHash == 0x60352180) {
      fontinfo[2] = *((WORD *) &fontdata[l + a[i].wOffs]);
    }
    // meCharHeight:60
    if (a[i].dwHash == 0x41050240) {
      fontinfo[3] = *((WORD *) &fontdata[l + a[i].wOffs]);
    }
    // meTracking:128
    if (a[i].dwHash == 0x530520E0) {
      fontinfo[4] = l + a[i].wOffs;
    }
  }
  // set last character
  l = *((WORD *) &fontdata[fontinfo[4]]);
  fontinfo[1] = l ? (fontinfo[0] + l - 1) : fontinfo[0];
  // skip characters count
  fontinfo[4] += 2;
  // load fonts
  fontused = 0;
  for (i = 0; i < 3; i++) {
    l = 0;
    if (i == 0) { l = 0xC6604282; } // Hints
    if (i == 1) { l = 0x283CE401; } // Klogg
    if (i == 2) { l = 0x0800090C; } // Walls
    wsprintf(m, TEXT("%08X.N02"), l);
    l = LoadData(m, loadpart, sizeof(loadpart));
    if (loadpart[0] && (loadpart[0] & IMG_ALL) == loadpart[0]) {
      nvh_image(loadpart, l, fontlist[i], sizeof(fontlist[0]));
    } else {
      LoadError(m);
      return(FALSE);
    }
  }
  // load backgrounds
  for (i = 0; i < 3; i++) {
    l = 0;
    if (i == 0) { l = 0x8870A546; } // Hints
    if (i == 1) { l = 0x2800E011; } // Klogg
    if (i == 2) { l = 0x08100289; } // Walls
    wsprintf(m, TEXT("%08X.N02"), l);
    l = LoadData(m, loadpart, sizeof(loadpart));
    if (loadpart[0] && (loadpart[0] & IMG_ALL) == loadpart[0]) {
      nvh_image(loadpart, l, backlist[i], sizeof(backlist[0]));
    } else {
      LoadError(m);
      return(FALSE);
    }
    // load "K" for Klogg
    if (i == 1) {
      wsprintf(m, TEXT("%08X.N02"), 0x492D5AD7);
      l = LoadData(m, loadpart, sizeof(loadpart));
      if (loadpart[0] && (loadpart[0] & IMG_ALL) == loadpart[0]) {
        nvh_image(loadpart, l, backdraw, sizeof(backdraw));
        // DrawRect(BYTE *u, BYTE *p, int px, int py, int ux, int uy, int w, int h);
        l = (((BITMAPINFOHEADER *)&backdraw[BMP_FILE])->biHeight >= 0) ?
            (((BITMAPINFOHEADER *)&backdraw[BMP_FILE])->biHeight) :
            (-((BITMAPINFOHEADER *)&backdraw[BMP_FILE])->biHeight);
        DrawRect(
          backlist[i], backdraw, 0, 0, 278, 25,
          ((BITMAPINFOHEADER *)&backdraw[BMP_FILE])->biWidth, l
        );
      } else {
        LoadError(m);
        return(FALSE);
      }
    }
  }
  // background display
  ZeroMemory(backdraw, sizeof(backdraw));
  FillBitmapHeader(backdraw, 640, 1712, 8);
  // default palette
  for (i = 0; i < 256; i++) {
    *((DWORD *) &backdraw[BMP_HEAD + (i * sizeof(RGBQUAD))]) = MAKELONG(MAKEWORD(i, i), MAKEWORD(i, 0));
  }
  return(TRUE);
}

void AllowControls(HWND wnd, BOOL ballow) {
DWORD i;
  for (i = 0; i < LIST_LEN(item_pos); i++) {
    if (
      (item_pos[i][0] != IDC_SBAR) &&
      (item_pos[i][0] != IDC_FILE) &&
      (item_pos[i][0] != IDC_ITEM)
    ) {
      EnableWindow(GetDlgItem(wnd, item_pos[i][0]), ballow);
    }
  }
}

BOOL CALLBACK DlgPrc(HWND wnd, UINT umsg, WPARAM wparm, LPARAM lparm) {
DWORD i, l, mx, my;
PAINTSTRUCT ps;
SCROLLINFO si;
TCHAR s[32];
BOOL result;
HFONT hf;
RECT rc;
HWND w;
HDC hc;
  result = FALSE;
  switch (umsg) {
    case WM_INITDIALOG:
      //ShowWindow(GetDlgItem(wnd, IDC_AREA), SW_HIDE);
      lparm = (LPARAM) LoadIcon(NULL, IDI_APPLICATION);
      SendMessage(wnd, WM_SETICON, ICON_BIG  , lparm);
      SendMessage(wnd, WM_SETICON, ICON_SMALL, lparm);
      ZeroMemory(&si, sizeof(si));
      // https://docs.microsoft.com/en-us/windows/win32/controls/using-scroll-bars
      si.cbSize = sizeof(si);
      si.fMask = SIF_ALL;
      si.nMax = 1712 - 480;
      si.nPage = 60; // 40x60 char
      SetScrollInfo(GetDlgItem(wnd, IDC_SBAR), SB_CTL, &si, TRUE);
      hf = CreateFont(
        -16, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, DEFAULT_CHARSET,
        OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
        FIXED_PITCH | FF_MODERN, TEXT("Courier New")
      );
      SendMessage(GetDlgItem(wnd, IDC_TEXT), WM_SETFONT, (WPARAM) hf, 0);
      SendMessage(GetDlgItem(wnd, IDC_INFO), WM_SETFONT, (WPARAM) hf, 0);
      // set spacing
      SendMessage(GetDlgItem(wnd, IDC_VPOS), UDM_SETRANGE, 0, MAKELPARAM(fontinfo[3]*2, -fontinfo[3]*2));
      SendMessage(GetDlgItem(wnd, IDC_HPOS), UDM_SETRANGE, 0, MAKELPARAM(fontinfo[2]*2, -fontinfo[2]*2));
      SendMessage(GetDlgItem(wnd, IDC_SPOS), UDM_SETRANGE, 0, MAKELPARAM(fontinfo[2]*2, -fontinfo[2]*2));
      i = 32;
      if ((i >= fontinfo[0]) && (i <= fontinfo[1])) {
        i -= fontinfo[0];
        i = fontdata[fontinfo[4] + (i * 4)];
      } else {
        i = fontinfo[2];
      }
      SendMessage(GetDlgItem(wnd, IDC_SPOS), UDM_SETPOS, 0, MAKELPARAM(i, 0));
      // fill file list
      w = GetDlgItem(wnd, IDC_FILE);
      i = 0;
      while (filelist[i]) {
        wsprintf(s, TEXT("%08X %s"), NHC_Hash((TCHAR *) &filelist[i]), &filelist[i]);
        SendMessage(w, LB_ADDSTRING, 0, (LPARAM) s);
        for (; filelist[i]; i++);
        i++;
      }
      // move and resize window items
      mx = 0;
      my = 0;
      for (i = 0; i < LIST_LEN(item_pos); i++) {
        MoveWindow(
          GetDlgItem(wnd, item_pos[i][0]),
          item_pos[i][1], item_pos[i][2],
          item_pos[i][3], item_pos[i][4],
          TRUE
        );
        if ((item_pos[i][1] + item_pos[i][3]) > mx) {
          mx = item_pos[i][1] + item_pos[i][3];
        }
        if ((item_pos[i][2] + item_pos[i][4]) > my) {
          my = item_pos[i][2] + item_pos[i][4];
        }
      }
      //SetDlgItemText(wnd, IDC_TEXT, TEXT("12345678901234567890123456789012"));
      AllowControls(wnd, FALSE);
      // resize main window
      WndClient(wnd, mx, my);
      // center main window
      WndMoveTo(wnd, WMT_MID_X | WMT_MID_Y);
      result = TRUE;
      break;
    case WM_COMMAND:
      if (wparm == MAKEWPARAM(IDC_FILE, LBN_SELCHANGE)) {
        AllowControls(wnd, FALSE);
        i = SendMessage((HWND) lparm, LB_GETCURSEL, 0, 0);
        LoadText(GetDlgItem(wnd, IDC_ITEM), i);
        // font to use
        fontused = (i < 2) ? 0 : 2;
      }
      if (wparm == MAKEWPARAM(IDC_ITEM, LBN_SELCHANGE)) {
        AllowControls(wnd, TRUE);
        i = SendMessage((HWND) lparm, LB_GETCURSEL, 0, 0);
        w = GetDlgItem(wnd, IDC_TEXT);
        LoadItem(w, i);
        // font to use
        if (SendMessage(GetDlgItem(wnd, IDC_FILE), LB_GETCURSEL, 0, 0) < 2) {
          fontused = ((i >= 40) && (i <= 49)) ? 1 : 0;
        } else {
          fontused = 2;
        }
        // update controls
        PostMessage(wnd, WM_COMMAND, MAKEWPARAM(IDC_TEXT, EN_CHANGE), (LPARAM) w);
      }
      if (wparm == MAKEWPARAM(IDC_TEXT, EN_CHANGE)) {
        w = (HWND) lparm;
        my = SendMessage(w, EM_GETLINECOUNT, 0, 0);
        mx = 0;
        for (i = 0; i < my; i++) {
          l = SendMessage(w, EM_LINEINDEX, i, 0);
          l = SendMessage(w, EM_LINELENGTH, l, 0);
          mx = (mx < l) ? l : mx;
        }
        wsprintf(s, TEXT("%u, %u"), mx, my);
        SetDlgItemText(wnd, IDC_INFO, s);
        FontDraw(w, (SendMessage(GetDlgItem(wnd, IDC_FILE), LB_GETCURSEL, 0, 0) < 2) ? TRUE : FALSE, TRUE);
        InvalidateRect(wnd, NULL, FALSE);
        // save text if not first (puzzle)
        if (SendMessage(GetDlgItem(wnd, IDC_FILE), LB_GETCURSEL, 0, 0) > 0) {
          SaveText(wnd);
        }
      }
      if (HIWORD(wparm) == BN_CLICKED) {
        switch (LOWORD(wparm)) {
          //case IDOK:
          case IDCANCEL:
            if (MessageBox(wnd, TEXT("Exit?"), TEXT("Confirm"), MB_ICONQUESTION | MB_YESNO) == IDYES) {
              EndDialog(wnd, 0);
            }
            break;
          case IDC_SAVE:
            // save to disk
            if (SaveText(wnd)) {
              wsprintf(s, TEXT("%08X.N06"), GetFileHash(SendMessage(GetDlgItem(wnd, IDC_FILE), LB_GETCURSEL, 0, 0)));
              SaveData(s, textdata, textsize);
              SetWindowText(GetDlgItem(wnd, IDC_INFO), TEXT("SAVED"));
            }
            break;
          case IDC_DRAW:
            w = GetDlgItem(wnd, IDC_TEXT);
            i = (SendMessage(GetDlgItem(wnd, IDC_FILE), LB_GETCURSEL, 0, 0) < 2) ? 1 : 0;
            FontDraw(w, i ? TRUE : FALSE, FALSE);
            SaveData(TEXT("textdump.bmp"), backdraw, sizeof(backdraw));
            FontDraw(w, i ? TRUE : FALSE, TRUE);
            MessageBox(wnd, TEXT("Current wall text rendered to the \"TEXTDUMP.BMP\" file."), TEXT(""), MB_OK | MB_ICONINFORMATION);
            break;
          case IDC_DUMP:
            MakeTextDump(wnd);
            break;
        }
      }
      break;
    // STM_SETIMAGE ?
    case WM_PAINT:
      hc = BeginPaint(wnd, &ps);
      if (hc) {
        ZeroMemory(&si, sizeof(si));
        si.cbSize = sizeof(si);
        si.fMask = SIF_POS;
        GetScrollInfo(GetDlgItem(wnd, IDC_SBAR), SB_CTL, &si);
        // https://titanwolf.org/Network/Articles/Article?AID=ff3ef87c-67bf-4ab4-a3b2-89b53c1de705
        // Windows Graphics Programming: Win32 GDI and DirectDraw: copy to yDest + uStartScan
        // https://www-user.tu-chemnitz.de/~heha/petzold/ch15c.htm
        // http://winapi.freetechsecrets.com/win32/WIN32SetDIBitsToDevice.htm
        SetDIBitsToDevice(hc,
          0, 0, 640, 480,
          0, 0, 0, 480,
          (void *) &backdraw[*((DWORD *) &backdraw[10]) + (si.nPos * 640)],
          (BITMAPINFO *) &backdraw[BMP_FILE],
          DIB_RGB_COLORS
        );
        EndPaint(wnd, &ps);
      }
      break;
    case WM_VSCROLL:
      w = ((HWND) lparm);
      if ((w == GetDlgItem(wnd, IDC_VPOS)) || (w == GetDlgItem(wnd, IDC_HPOS)) || (w == GetDlgItem(wnd, IDC_SPOS))) {
        // update image
        if (LOWORD(wparm) == SB_THUMBPOSITION) {
          PostMessage(wnd, WM_COMMAND, MAKEWPARAM(IDC_TEXT, EN_CHANGE), (LPARAM) GetDlgItem(wnd, IDC_TEXT));
        }
      }
      if (w == GetDlgItem(wnd, IDC_SBAR)) {
        ZeroMemory(&si, sizeof(si));
        si.cbSize = sizeof(si);
        si.fMask = SIF_ALL;
        GetScrollInfo(w, SB_CTL, &si);
        switch (LOWORD(wparm)) {
          case SB_THUMBPOSITION:
          case SB_THUMBTRACK:
            si.fMask = SIF_POS;
            si.nPos = HIWORD(wparm);
            break;
          case SB_TOP:
            si.nPos = si.nMin;
            break;
          case SB_BOTTOM:
            si.nPos = si.nMax;
            break;
          case SB_LINEUP:
            si.nPos--;
            break;
          case SB_LINEDOWN:
            si.nPos++;
            break;
          case SB_PAGEUP:
            si.nPos -= si.nPage;
            break;
          case SB_PAGEDOWN:
            si.nPos += si.nPage;
            break;
        }
        SetScrollInfo(w, SB_CTL, &si, TRUE);
        ZeroMemory(&rc, sizeof(rc));
        rc.right = 640;
        rc.bottom = 480;
        InvalidateRect(wnd, &rc, FALSE);
      }
      break;
  }
  return(result);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {
  if (InitData()) {
    InitCommonControls();
    DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DLG1), 0, &DlgPrc);
    if (textdata) { FreeMem(textdata); }
  }
  ExitProcess(0);
  return(0);
}
