#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <windows.h>

#pragma pack(push, 1)
typedef struct {
  DWORD from;
  DWORD till;
  char  text[40];
} sub_item;
#pragma pack(pop)

char *basename(char *s) {
char *r;
  if (s) {
    for (r = s; *r; r++) {
      if ((*r == '/') || (*r == '\\')) {
        s = &r[1];
      }
    }
  }
  return(s);
}

void newext(char *name, char *ext) {
char *p;
  if (name && ext) {
    for (; (*name == '.'); name++);
    for (p = NULL; *name; name++) {
      if (*name == '.') {
        p = name;
      }
    }
    strcpy(p ? p : name, ext);
  }
}

int main(int argc, char *argv[]) {
char s[10+1+10+1+40+1+2], n[MAX_PATH];
DWORD sz, i, j, test[2];
sub_item si;
FILE *fl;
BYTE *p;
  if (argc != 3) {
    printf(
      "Usage: substext <p|u|t> <filename.ext>\n\n"
      "Where:\n"
      "p - pack to binary file\n"
      "u - unpack to text file\n"
      "t - unpack with test to text file (mark line endings with '|' character)\n"
      "m - pack error messages to binary file\n\n"
    );
    return(1);
  }
  argv[1][0] |= 0x20;
  if ((argv[1][1]) || ((argv[1][0] != 'p') && (argv[1][0] != 'u') && (argv[1][0] != 't') && (argv[1][0] != 'm'))) {
    printf("Error: invalid mode.\n\n");
    return(2);
  }
  fl = fopen(argv[2], "rb");
  if (!fl) {
    printf("Error: can't open input file.\n\n");
    return(3);
  }
  fseek(fl, 0, SEEK_END);
  sz = ftell(fl);
  p = (BYTE *) malloc(sz);
  if (!p) {
    fclose(fl);
    printf("Error: not enough memory to load input file.\n\n");
    return(4);
  }
  fseek(fl, 0, SEEK_SET);
  fread(p, sz, 1, fl);
  fclose(fl);
  if ((argv[1][0] == 'u') || (argv[1][0] == 't')) {
    lstrcpy(n, basename(argv[2]));
    newext(n, ".TXT");
    fl = fopen(n, "wb");
    if (fl) {
      sz /= sizeof(si);
      for (i = 0; i < sz; i++) {
        CopyMemory(&si, &p[i * sizeof(si)], sizeof(si));
        si.text[39] = 0;
        wsprintf(s, "%04u %04u|%s%s\r\n", si.from, si.till, si.text, (argv[1][0] == 't') ? "|" : "");
        fwrite(s, lstrlen(s), 1, fl);
      }
      fclose(fl);
      printf("\ndone\n\n");
    } else {
      printf("Error: can't create output file.\n\n");
    }
  } else {
    lstrcpy(n, basename(argv[2]));
    newext(n, (argv[1][0] != 'm') ? ".N0D" : ".N0C");
    fl = fopen(n, "wb");
    if (fl) {
      i = 0;
      j = 0;
      test[0] = 0;
      test[1] = 0;
      while (i < sz) {
        ZeroMemory(&si, sizeof(si));
        /* whitespace */
        while ((i < sz) && ((p[i] == 9) || (p[i] == 13) || (p[i] == 10) || (p[i] == 32))) { i++; }
        /* from */
        while ((i < sz) && (p[i] >= '0') && (p[i] <= '9')) {
          si.from *= 10;
          si.from += p[i] - '0';
          i++;
        }
        /* whitespace */
        while ((i < sz) && ((p[i] == 9) || (p[i] == 32))) { i++; }
        /* till */
        while ((i < sz) && (p[i] >= '0') && (p[i] <= '9')) {
          si.till *= 10;
          si.till += p[i] - '0';
          i++;
        }
        /* whitespace */
        while ((i < sz) && ((p[i] == 9) || (p[i] == 32))) { i++; }
        if (p[i] != '|') {
          printf("Error: missing separator '|' for line %lu.\n\n", (ftell(fl) / sizeof(si)) + 1);
          j = 40;
          break;
        }
        i++;
        /* text */
        j = 0;
        while ((i < sz) && (p[i] != 10) && (p[i] != 13)) {
          if (j == 39) {
            printf("Error: text too long for line %lu.\n\n", (ftell(fl) / sizeof(si)) + 1);
            j = 40;
            break;
          }
          si.text[j] = p[i];
          j++;
          i++;
        }
        /* test time */
        if (argv[1][0] != 'm') {
          if (si.from > si.till) {
            printf("Error: start frame number larger than end frame number on line %lu.\n\n", (ftell(fl) / sizeof(si)) + 1);
            j = 40;
          }
          if ((si.from + 1) <= test[(si.text[0] == '^') ? 1 : 0]) {
            printf("Error: frame number overlaps with last titre on line %lu.\n\n", (ftell(fl) / sizeof(si)) + 1);
            j = 40;
          }
        } else {
          if ((si.text[0] != '+') && (si.text[0] != '-')) {
            printf("Error: error message must start with '+' or '-' character.\n\n");
            j = 40;
          }
          /* max lines reached */
          if ((ftell(fl) / sizeof(si)) >= 33) {
            printf("Error: more than 33 messages in errors file.\n\n");
            j = 40;
          }
        }
        /* max lines reached */
        if ((ftell(fl) / sizeof(si)) >= 128) {
          printf("Error: more than 128 titres in one file.\n\n");
          j = 40;
        }
        if (j == 40) { break; }
        test[(si.text[0] == '^') ? 1 : 0] = si.till + 1;
        fwrite(&si, sizeof(si), 1, fl);
        /* whitespace */
        while ((i < sz) && ((p[i] == 9) || (p[i] == 13) || (p[i] == 10) || (p[i] == 32))) { i++; }
      }
      fclose(fl);
      if (j == 40) {
        unlink(n);
      } else {
        printf("\ndone\n\n");
      }
    } else {
      printf("Error: can't create output file.\n\n");
    }
  }
  free(p);
  return(0);
}
