#include <setjmp.h>
#undef setjmp
#undef longjmp
#define setjmp __builtin_setjmp
#define longjmp __builtin_longjmp

/*
To compile this source code you'll need "blast.c" and "blast.h" files from zlib package.
Get this package from official site: http://zlib.net/
Requered files can be found in /contrib/blast/ folder inside archive.
*/

#include "blast.c"

#define PKW_CHUNK 16384

typedef struct {
  uint8_t *data;
  uint32_t size;
} pkw_item;

unsigned inf(void *how, unsigned char **buf) {
unsigned r;
pkw_item *x;
  x = (pkw_item *) how;
  *buf = x->data;
  r = (x->size < PKW_CHUNK) ? x->size : PKW_CHUNK;
  x->size -= r;
  x->data += r;
  return(r);
}

int outf(void *how, unsigned char *buf, unsigned len) {
int r;
pkw_item *x;
  x = (pkw_item *) how;
  r = (x->size < len) ? x->size : len;
  x->size -= r;
  memcpy(x->data, buf, r);
  x->data += r;
  return(r != len);
}

uint32_t unp_blast(uint8_t *p, uint8_t *u, uint32_t ps, uint32_t us) {
pkw_item ip, iu;
int r;
  ip.data = p;
  ip.size = ps;
  iu.data = u;
  iu.size = us;
  r = blast(inf, &ip, outf, &iu, NULL, NULL);
  return(((r == 0) || (r == 1)) ? (us - iu.size) : 0);
}
