#pragma pack(push, 1)
typedef struct {
  uint8_t  IDLength;
  uint8_t  ColorMapType;
  uint8_t  ImageType;
  uint16_t CMapStart;
  uint16_t CMapLength;
  uint8_t  CMapDepth;
  uint16_t XOffset;
  uint16_t YOffset;
  uint16_t Width;
  uint16_t Height;
  uint8_t  PixelDepth;
  uint8_t  ImageDescriptor;
} tga_head;
#pragma pack(pop)

void RLE_Unpack(uint8_t *p, uint32_t ps, uint8_t *u, uint32_t us, uint32_t l) {
uint32_t r, c, i, k;
  if (p && u) {
    k = 1;
    while ((us) && (ps >= 4)) {
      r = *((uint16_t *) &p[0]);
      c = *((uint16_t *) &p[2]);
      if ((!k) && (!r)) { break; }
      p += 4;
      ps -= 4;
      if (!c) {
        c = (us < (r * l)) ? us : (r * l);
        u += c;
        us -= c;
      } else {
        while ((r--) && (us) && (ps >= 4)) {
          for (i = c; i; i--) {
            k = *((uint16_t *) &p[2]);
            memcpy(&u[*((uint16_t *) &p[0])], &p[4], k);
            k = ((k + 4) < ps) ? (k + 4) : ps;
            p += k;
            ps -= k;
            if (ps < 4) { break; }
          }
          k = (l < us) ? l : us;
          u += k;
          us -= k;
        }
      }
      k = 0;
    }
  }
}

#define IMG_RLE 1
#define IMG_WXH 2
#define IMG_POS 4
#define IMG_PAL 8
#define IMG_BMP 16
#define IMG_ALL (IMG_RLE | IMG_WXH | IMG_POS | IMG_PAL | IMG_BMP)

uint8_t *nvh_image(uint8_t *p, uint32_t *len) {
uint16_t t, w, h, x, y, f;
uint32_t i, l;
uint8_t *u;
tga_head *th;
  u = NULL;
  if (p && len && (*len > 2)) {
    l = *len;
    f = *((uint16_t *) p); p += 2; l -= 2;
    t = 0;
    w = 0;
    h = 0;
    x = 0;
    y = 0;
    u = NULL;
    /* has width and height */
    if (f & IMG_WXH) {
      if (l >= 4) {
        w = *((uint16_t *) p); p += 2; l -= 2;
        h = *((uint16_t *) p); p += 2; l -= 2;
        t = w;
        for (; w & 3; w++);
      }
    }
    /* has position */
    if (f & IMG_POS) {
      if (l >= 4) {
        x = *((uint16_t *) p); p += 2; l -= 2;
        y = *((uint16_t *) p); p += 2; l -= 2;
      }
      printf(" %3u %3u\n", x, y);
    }
    /* has image bitmap data */
    if ((f & IMG_BMP) && w && h) {
      i = sizeof(th[0]) + (256 * 3) + (w * h);
      u = (uint8_t *) malloc(i);
      if (u) {
        memset(u, 0, i);
        th = (tga_head *) u;
        th->Width = w;
        th->Height = h;
        th->ImageDescriptor = 0x20;
        th->ColorMapType = 1;
        th->ImageType = 1;
        th->CMapLength = 256;
        th->CMapDepth = 24;
        th->PixelDepth = 8;
        /* default palette */
        for (i = 0; i < 256; i++) {
          u[sizeof(th[0]) + (i * 3)    ] = i;
          u[sizeof(th[0]) + (i * 3) + 1] = i;
          u[sizeof(th[0]) + (i * 3) + 2] = i;
        }
        /* has palette */
        if (f & IMG_PAL) {
          if (l >= (256 * 4)) {
            for (i = 0; i < 256; i++) {
              u[sizeof(th[0]) + (i * 3)    ] = p[(i * 4) + 2];
              u[sizeof(th[0]) + (i * 3) + 1] = p[(i * 4) + 1];
              u[sizeof(th[0]) + (i * 3) + 2] = p[(i * 4)    ];
            }
            p += (256 * 4);
            l -= (256 * 4);
          }
        }
        i = sizeof(th[0]) + (256 * 3);
        if (f & IMG_RLE) {
          RLE_Unpack(p, l, &u[i], w * h, w);
        } else {
          l = ((w * h) < l) ? (w * h) : l;
          memcpy(&u[i], p, l);
        }
        *len = i + (w * h);
        /* cleanup padding bytes */
        if (w > t) {
          *len = i + (t * h);
          th->Width = t;
          l = i;
          for (i = 1; i < h; i++) {
            memmove(&u[l + (i * t)], &u[l + (i * w)], t);
          }
          /*for (i = 0; i < h; i++) {
            memset(&u[l + (i * w) + t], 0x00, w - t);
          }*/
        }
      }
    }
  }
  return(u);
}
