static char rudr_old[] = "@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]`abcdefghijklmnopqrstuvwxyz";
static char rudr_new[] = "";
static char rufg_old[] = "#$%&@abcdefghijklmnopqrstuvwxyz";
static char rufg_new[] = "";

static uint32_t rutab[11 + 11][4] = {
  /* RU_DR */
  {0x80283101, 0x00C7F6C9, 0x000007A9, 0x00000E80},
  {0x00918480, 0x010DB881, 0x00000245, 0x00000394},
  {0x04290188, 0x025BF397, 0x00001C81, 0x000069FB},
  {0x08586283, 0x025C1018, 0x00002F7B, 0x00007423},
  {0x0008E486, 0x025C3F93, 0x000000F0, 0x000001C6},
  {0x40080183, 0x025C4083, 0x00000B27, 0x00003458},
  {0x00098880, 0x025C4BAA, 0x00000BD4, 0x00002A6C},
  {0x30A84C80, 0x025C577E, 0x00001345, 0x00003FB1},
  {0x2008048E, 0x025C6AC3, 0x00000ED6, 0x00005261},
  {0x00C9A480, 0x025C7999, 0x00001AE2, 0x00005D6B},
  {0x03086004, 0x025C947B, 0x000001E2, 0x00000266},
  /* RU_FG */
  {0x80283101, 0x00C9A2CC, 0x00000F06, 0x00000F06},
  {0x00918480, 0x011D9658, 0x00000357, 0x00000357},
  {0x04290188, 0x027D7A1C, 0x000049FF, 0x000049FF},
  {0x08586283, 0x027DC41C, 0x00006461, 0x00006461},
  {0x0008E486, 0x027E2880, 0x0000018E, 0x0000018E},
  {0x40080183, 0x027E2A10, 0x00002927, 0x00002927},
  {0x00098880, 0x027E5338, 0x00002257, 0x00002257},
  {0x30A84C80, 0x027E7590, 0x0000310A, 0x0000310A},
  {0x2008048E, 0x027EA69C, 0x00004392, 0x00004392},
  {0x00C9A480, 0x027EEA30, 0x00003079, 0x00003079},
  {0x03086004, 0x027F1AAC, 0x0000018E, 0x0000018E}
};

void tab_make(uint8_t *t, uint8_t *o, uint8_t *n) {
  if (t && o && n) {
    while (*o) {
      t[*o] = *n;
      o++;
      n++;
    }
  }
}

uint8_t *nvh_texts(uint8_t *src, uint32_t *len, blb_item *item) {
uint32_t i, j, k, l, *o;
uint8_t *u, *p, t[256];
  u = NULL;
  if (src && len && *len) {
    for (i = 0; i < 256; i++) { t[i] = i; }
    /* fix Russian text */
    for (i = 0; i < (sizeof(rutab) / sizeof(rutab[0])); i++) {
      if (
        (item->dwNameHash == rutab[i][0]) &&
        (item->dwFileOffs == rutab[i][1]) &&
        (item->dwPackSize == rutab[i][2]) &&
        (item->dwFileSize == rutab[i][3])
      ) {
        if (i < 11) {
          tab_make(t, (uint8_t *) rudr_old, (uint8_t *) rudr_new);
        } else {
          tab_make(t, (uint8_t *) rufg_old, (uint8_t *) rufg_new);
        }
        break;
      }
    }
    l = 0;
    for (i = 0; i < 2; i++) {
      if (i) {
        u = (uint8_t *) malloc(l);
        if (!u) { break; }
        *len = l;
        l = 0;
      }
      o = (uint32_t *) src;
      for (j = 1; j < *o; j++) {
        if (u) {
          u[l] = '#';
          u[l + 1] = '0' + ((j / 10) % 10);
          u[l + 2] = '0' + (j % 10);
          u[l + 3] = '\r';
          u[l + 4] = '\n';
        }
        l += 5;
        p = src;
        p += ((*o + 1) * sizeof(o[0])) + o[j];
        k = o[j + 1] - o[j];
        while (k--) {
          if (*p) {
            if (u) {
              u[l] = t[*p];
            }
            l++;
          } else {
            if (u) {
              u[l] = '\r';
              u[l + 1] = '\n';
            }
            l += 2;
          }
          p++;
        }
      }
    }
  }
  return(u);
}
