#pragma pack(push, 1)
typedef struct {
  uint32_t dwRIFFSign;
  uint32_t dwRIFFSize;
  uint32_t dwWAVESign;
  uint32_t dwfmt_Sign;
  uint32_t dwfmt_Size;
  /* PCMWAVEFORMAT */
  /* WAVEFORMAT */
  uint16_t wFormatTag;
  uint16_t nChannels;
  uint32_t nSamplesPerSec;
  uint32_t nAvgBytesPerSec;
  uint16_t nBlockAlign;
  /* /WAVEFORMAT */
  uint16_t wBitsPerSample;
  /* /PCMWAVEFORMAT */
  uint32_t dwdataSign;
  uint32_t dwdataSize;
} wav_head;
#pragma pack(pop)

void FillWaveHeader(wav_head *hdr, uint32_t len, uint32_t sps, uint16_t chn, uint16_t bps) {
  if (hdr) {
    memset(hdr, 0, sizeof(hdr[0]));
    hdr->dwRIFFSign = 0x46464952;
    hdr->dwRIFFSize = sizeof(hdr[0]) - 8 + len;
    hdr->dwWAVESign = 0x45564157;
    hdr->dwfmt_Sign = 0x20746D66;
    hdr->dwfmt_Size = 16;
    hdr->wFormatTag = 1;
    hdr->nChannels  = chn;
    hdr->nSamplesPerSec = sps;
    hdr->wBitsPerSample = bps;
    hdr->nBlockAlign = hdr->nChannels * (hdr->wBitsPerSample / 8);
    hdr->nAvgBytesPerSec = hdr->nBlockAlign * hdr->nSamplesPerSec;
    hdr->dwdataSign = 0x61746164;
    hdr->dwdataSize = len;
  }
}

void Decode_DW_ADPCM(int8_t *p, int16_t *u, uint32_t l, uint8_t s) {
int16_t v;
  if (p && u && l) {
    v = 0;
    while (l--) {
      v += (int16_t) *p; p++;
      *u = v << s; u++;
    }
  }
}

uint8_t *nvh_sound(uint8_t *src, uint32_t *len, uint8_t cof) {
uint8_t *u;
uint32_t l;
  u = NULL;
  if (src && len && *len) {
    l = sizeof(wav_head);
    l += *len * ((cof == 0xFF) ? 1 : 2);
    u = (uint8_t *) malloc(l);
    if (u) {
      memset(u, 0, l);
      if (cof == 0xFF) {
        memcpy(&u[sizeof(wav_head)], src, *len);
      } else {
        Decode_DW_ADPCM((int8_t *) src, (int16_t *) &u[sizeof(wav_head)], *len, cof);
      }
      FillWaveHeader((wav_head *) u, l - sizeof(wav_head), 22050, 1, 16);
      *len = l;
    }
  }
  return(u);
}
