static uint32_t tocfixes[][5] = {
/* dwFileHash  dwFileOffs  dwPackSize  dwFileSize  fixed size */
  /* RU_DR */
  /* I.BLB: increase unpacked size for compressed items */
  {0x08081004, 0x027B31E5, 0x000017CF, 0x00004776, 0x00004CC0},
  /* HD.BLB: increase unpacked size for compressed items */
  {0x5284221A, 0x00004237, 0x0000434F, 0x00007592, 0x00007692},
  {0x0022C074, 0x000324E4, 0x0000495F, 0x00007592, 0x000083F3},
  {0x08C0090D, 0x00093E7E, 0x00004CDB, 0x00007592, 0x00008588},
  {0x51280205, 0x000FC8AC, 0x0000434F, 0x00007592, 0x00007692},
  /* A.BLB: fix unpacked size for non-compressed items */
  {0x02B22008, 0x01CC2F38, 0x0007F44E, 0x0008984F, 0x0007F44E},
  /* RU_FG */
  /* HD.BLB: fix unpacked size for non-compressed items */
  {0x0CA04202, 0x0000081C, 0x000059CC, 0x00076886, 0x000059CC},
  {0x728523ED, 0x00029750, 0x0000A7A8, 0x0001A7A6, 0x0000A7A8},
  {0x80083C01, 0x0003C6AC, 0x000019BD, 0x0001187A, 0x000019BD},
  {0x201C2474, 0x0006389C, 0x0000A7A8, 0x0001A7A6, 0x0000A7A8},
  {0x0BC600A3, 0x00077138, 0x00002C67, 0x00012B1A, 0x00002C67},
  {0x0C24C0EE, 0x000B833C, 0x00000EBB, 0x00001D2A, 0x00000EBB},
  {0x61842011, 0x000E4AD4, 0x00000BBE, 0x00001A62, 0x00000BBE},
  {0x94188D4D, 0x0010BC10, 0x0000A7A8, 0x0001A7A6, 0x0000A7A8},
  {0x2328121A, 0x00140E24, 0x0000A7A8, 0x0001A7A6, 0x0000A7A8},
  {0x1301A7EA, 0x00152ECC, 0x000011B6, 0x000030F8, 0x000011B6},
  {0x1340A5C2, 0x00154084, 0x00002511, 0x0001237A, 0x00002511},
  /* I.BLB: fix unpacked size for non-compressed items */
  {0xC6604282, 0x00C51648, 0x00006798, 0x00008C36, 0x00006798},
  {0x80283101, 0x00C9A2CC, 0x00000F06, 0x00001E80, 0x00000F06},
  {0x0800090C, 0x0104E670, 0x0000647E, 0x00019676, 0x0000647E},
  {0x00918480, 0x011D9658, 0x00000357, 0x00001394, 0x00000357},
  {0x04290188, 0x027D7A1C, 0x000049FF, 0x000169FB, 0x000049FF},
  {0x08586283, 0x027DC41C, 0x00006461, 0x00007423, 0x00006461},
  {0x0008E486, 0x027E2880, 0x0000018E, 0x000011C6, 0x0000018E},
  {0x40080183, 0x027E2A10, 0x00002927, 0x00003458, 0x00002927},
  {0x00098880, 0x027E5338, 0x00002257, 0x00002A6C, 0x00002257},
  {0x30A84C80, 0x027E7590, 0x0000310A, 0x00003FB1, 0x0000310A},
  {0x2008048E, 0x027EA69C, 0x00004392, 0x00015261, 0x00004392},
  {0x00C9A480, 0x027EEA30, 0x00003079, 0x00005D6B, 0x00003079},
  {0x03086004, 0x027F1AAC, 0x0000018E, 0x00000266, 0x0000018E}
};

static uint32_t blbfixes[][5] = {
/* dwFileHash  dwFileOffs  dwPackSize  dwFileSize  fixed size */
  /* RU_FG */
  /* HD.BLB */
  {0xC10B2015, 0x000C0368, 0x0000113E, 0x00003DE8, 0x1A83},
  {0x1301A7EA, 0x00152ECC, 0x000011B6, 0x000011B6, 0x013111AE},/* MAKELONG(0x11AE, 305)},*/
  {0x84181E81, 0x0003B5F8, 0x000010B4, 0x000043C2, 0x1602},
  {0x0F960021, 0x00076278, 0x00000EBD, 0x00002297, 0x1178},
  /* RU_DR */
  /* I.BLB */
  {0x00918480, 0x010DB881, 0x00000245, 0x00000394, 0},
  {0x04290188, 0x025BF397, 0x00001C81, 0x000069FB, 0},
  {0x08586283, 0x025C1018, 0x00002F7B, 0x00007423, 0},
  {0x40080183, 0x025C4083, 0x00000B27, 0x00003458, 0},
  {0x00098880, 0x025C4BAA, 0x00000BD4, 0x00002A6C, 0},
  {0x30A84C80, 0x025C577E, 0x00001345, 0x00003FB1, 0},
  {0x2008048E, 0x025C6AC3, 0x00000ED6, 0x00005261, 0},
  {0x00C9A480, 0x025C7999, 0x00001AE2, 0x00005D6B, 0},
  {0x03086004, 0x025C947B, 0x000001E2, 0x00000266, 0}
};

void ApplyTOCFixes(uint32_t hash, blb_item *item) {
uint32_t i;
  if (item) {
    for (i = 0; i < (sizeof(tocfixes) / sizeof(tocfixes[0])); i++) {
      if (
        (hash == tocfixes[i][0]) && (item->dwFileOffs == tocfixes[i][1]) &&
        (item->dwPackSize == tocfixes[i][2]) && (item->dwFileSize == tocfixes[i][3])
      ) {
        item->dwFileSize = tocfixes[i][4];
        break;
      }
    }
  }
}

void ApplyBLBFixes(uint32_t hash, blb_item *item, uint8_t *p, uint32_t sz) {
uint32_t i;
  if (item && p && sz) {
    for (i = 0; i < (sizeof(blbfixes) / sizeof(blbfixes[0])); i++) {
      if (
        (sz >= (blbfixes[i][4] & 0xFFFF)) && (hash == blbfixes[i][0]) &&
        (item->dwFileOffs == blbfixes[i][1]) &&
        (item->dwPackSize == blbfixes[i][2]) &&
        (item->dwFileSize == blbfixes[i][3])
      ) {
        if (blbfixes[i][4]) {
          /* early stop for image decoding to prevent buffer overflow */
          memset(&p[blbfixes[i][4] & 0xFFFF], 0, sz - (blbfixes[i][4] & 0xFFFF));
          /* fix image height overflow */
          if (blbfixes[i][4] >> 16) {
            *((uint16_t *) &p[2 + (2)]) = (blbfixes[i][4] >> 16);
          }
        }
        break;
      }
    }
  }
}
