#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <stdint.h>

#pragma pack(push, 1)
typedef struct {
  uint32_t dwMagic;
  uint16_t wVersion;
  uint16_t wDataSize;
  uint32_t dwFileSize;
  uint32_t dwCount;
} blb_head;

typedef struct {
  uint8_t  bFileType;
  uint8_t  bPackType;
  uint16_t wDataIndex;
  uint32_t dwTimeStamp;
  uint32_t dwFileOffs;
  uint32_t dwPackSize;
  uint32_t dwFileSize;
  /* --- */
  uint32_t dwNameHash;
} blb_item;
#pragma pack(pop)

#include "blb_pack.c"
#include "blb_wave.c"
#include "blb_pict.c"
#include "blb_text.c"

/* PATCH_01: Russian version invalid resources */
#include "ru2fixes.c"

static char sFileExt[] = "N##\0smk\0wav\0tga\0txt";

char blb_flag(uint8_t f) {
char c;
  c = '?';
  if (f == 0x01) { c = '-'; }
  if (f == 0x03) { c = '+'; }
  if (f == 0x65) { c = '@'; }
  return(c);
}

#define RES_LIST ' '
#define RES_KEEP '+'
#define RES_CONV '-'
#define FINDHASH 0x100
int main(int argc, char *argv[]) {
uint32_t i, sz, k, hash, t;
uint8_t *p, *u, v, r;
blb_head head;
blb_item *list;
FILE *fl, *f;
char s[16];
  if ((argc < 2) || (argc > 3)) {
    printf(
      "Usage: unpakblb <filename.blb> [#]\n\n"
      "Where # is an optional argument - filename hash (8 char in hex) or file type:\n"
      " 0 * <all types>\n"
      " 2 * bitmap\n 3 - palette\n 4 - animation\n 5 - data\n"
      " 6 * text\n 7 * sound\n 8 * music\n10 * video\n"
      "Positive number will extract * resources as-is without converting.\n"
      "Negative number will convert * resources to commonly used formats.\n"
      "Number without sign will only list resources with specified type.\n"
      "Convert all resources: unpakblb i.blb -0\nExtract bitmaps as is: unpakblb i.blb +2\n"
      "\n"
    );
    return(1);
  }
  fl = fopen(argv[1], "rb");
  if (!fl) {
    printf("Error: can't open input file.\n\n");
    return(2);
  }
  /* type to unpack */
  t = 0;
  hash = 0;
  r = RES_LIST;
  if (argc == 3) {
    if (argv[2][0] == RES_KEEP) {
      r = RES_KEEP;
    }
    if (argv[2][0] == RES_CONV) {
      r = RES_CONV;
    }
    i = (r != RES_LIST) ? 1 : 0;
    if (strlen(&argv[2][i]) == 8) {
      t = FINDHASH;
      while (argv[2][i]) {
        v = argv[2][i]; i++;
        if ((v >= '0') && (v <= '9')) {
          hash <<= 4;
          hash |= v - '0';
          continue;
        }
        v |= 0x20;
        if ((v >= 'a') && (v <= 'f')) {
          hash <<= 4;
          hash |= v - 'a' + 10;
          continue;
        }
        break;
      }
    } else {
      while (argv[2][i]) {
        v = argv[2][i]; i++;
        if ((v >= '0') && (v <= '9')) {
          t *= 10;
          t += v - '0';
          continue;
        }
        break;
      }
    }
  }
  memset(&head, 0, sizeof(head));
  fread(&head, sizeof(head), 1, fl);
  fseek(fl, 0, SEEK_END);
  sz = ftell(fl);
  if (
    (head.dwMagic != 0x02004940) || (head.wVersion != 0x0007) || (!head.dwCount) ||
    (head.dwFileSize != sz) || (sz < (sizeof(head) + (sizeof(list[0]) * head.dwCount) + head.wDataSize))
  ) {
    fclose(fl);
    printf("Error: invalid input file format.\n\n");
    return(3);
  }
  list = (blb_item *) malloc(sizeof(list[0]) * head.dwCount);
  if (!list) {
    fclose(fl);
    printf("Error: not enough memory for index table.\n\n");
    return(4);
  }
  fseek(fl, sizeof(head), SEEK_SET);
  /* name hashes */
  for (i = 0; i < head.dwCount; i++) { fread(&list[i].dwNameHash, 4, 1, fl); }
  /* other info */
  for (i = 0; i < head.dwCount; i++) { fread(&list[i], sizeof(list[0]) - 4, 1, fl); }
  /* read shift index */
  sz = ftell(fl);
  for (i = 0; i < head.dwCount; i++) {
    if ((list[i].bFileType == 7) || (list[i].bFileType == 8)) {
      if ((list[i].wDataIndex) && (list[i].wDataIndex <= head.wDataSize)) {
        fseek(fl, sz + list[i].wDataIndex - 1, SEEK_SET);
        list[i].wDataIndex = 0;
        fread(&list[i].wDataIndex, 1, 1, fl);
      } else {
        list[i].wDataIndex = 0xFF; /* uncompressed */
      }
    } else {
      list[i].wDataIndex = 0x00;
    }
  }
  printf("RT F NameHash | FileOffs FilePack FileSize\n");
  for (i = 0; i < head.dwCount; i++) {
    if (t == FINDHASH) {
      if (list[i].dwNameHash != hash) { continue; }
    } else{
      if ((t) && (list[i].bFileType != t)) { continue; }
    }
    printf("%2u %c %08X | %08X %08X %08X\n",
      list[i].bFileType, blb_flag(list[i].bPackType), list[i].dwNameHash,
      list[i].dwFileOffs, list[i].dwPackSize, list[i].dwFileSize
    );
    /* skip link to another resource (dwFileOffs and dwFileSize are zero, dwPackSize - hash to link) */
    if (list[i].bPackType == 0x65) { continue; }
    /* PATCH_02: Russian version invalid resources */
    ApplyTOCFixes(list[i].dwNameHash, &list[i]);
    /* list only */
    if (r == RES_LIST) { continue; }
    sz = list[i].dwPackSize;
    p = (uint8_t *) malloc(sz);
    if (!p) { continue; }
    fseek(fl, list[i].dwFileOffs, SEEK_SET);
    memset(p, 0, sz);
    fread(p, sz, 1, fl);
    /* unpack */
    if (list[i].bPackType == 0x03) {
      u = (uint8_t *) malloc(list[i].dwFileSize);
      if (u) {
        memset(u, 0, list[i].dwFileSize);
        unp_blast(p, u, sz, list[i].dwFileSize);
        free(p);
        p = u;
        sz = list[i].dwFileSize;
      }
    }
    /* PATCH_03: Russian version invalid resources */
    ApplyBLBFixes(list[i].dwNameHash, &list[i], p, sz);
    v = 0;
    if (list[i].bFileType == 10) { v = 1; }
    if ((list[i].bFileType == 7) || (list[i].bFileType == 8)) { v = 2; }
    if (list[i].bFileType == 2) { v = 3; }
    if (list[i].bFileType == 6) { v = 4; }
    /* convert or not convert */
    v *= (r == RES_CONV) ? 1 : 0;
    if (v == 2) {
      k = sz;
      u = nvh_sound(p, &k, list[i].wDataIndex);
      if (u) {
        free(p);
        p = u;
        sz = k;
      }
    }
    if (v == 3) {
      k = sz;
      u = nvh_image(p, &k);
      if (u) {
        free(p);
        p = u;
        sz = k;
      }
    }
    if (v == 4) {
      k = sz;
      u = nvh_texts(p, &k, &list[i]);
      if (u) {
        free(p);
        p = u;
        sz = k;
      }
    }
    if (v) {
      sprintf(s, "%08X.%s", list[i].dwNameHash, &sFileExt[v * 4]);
    } else {
      sprintf(s, "%08X.N%02X", list[i].dwNameHash, list[i].bFileType);
    }
    f = fopen(s, "wb");
    if (f) {
      fwrite(p, sz, 1, f);
      fclose(f);
    }
    free(p);
  }
  free(list);
  fclose(fl);
  printf("\ndone\n\n");
  return(0);
}
