#define NONAMELESSUNION 1
#define CINTERFACE 1
#undef WINNT
#include "ddraw.h"
#define WINNT 1

#define GetMem(x) ((void *) LocalAlloc(LPTR, (x)))
#define FreeMem(x) LocalFree((x))

#include <mmsystem.h>

#pragma pack(push, 1)
typedef struct {
  BITMAPFILEHEADER bf;
  BITMAPINFOHEADER bi;
  BYTE palette[256][4];
} bmp_head;
#pragma pack(pop)

typedef struct {
  bmp_head bh; // bitmap image header
  DWORD _w;    // fullscreen (desktop) width
  DWORD _h;    // fullscreen (desktop) height
  DWORD w;     // width of resized image for fullscreen mode
  DWORD h;     // height of resized image for fullscreen mode
  DWORD x;     // x position of image for keep-aspect fullscreen mode (black bars)
  DWORD y;     // y position of image for keep-aspect fullscreen mode (black bars)
  DWORD wx;    // windowed mode top window position
  DWORD wy;    // windowed mode left window position
  BYTE *p;     // bitmap data buffer for resized image
  BOOL b;      // block any operations in fullscreen <-> windowed transition (1/0)
  BOOL f;      // fullscreen flag (1/0)
} scr_head;

typedef struct {
  void *self_ptr;
  void *list[23];
//  DWORD dwFlags; // v1.02 unused
  HWND  wnd;
  DWORD dwFullscreen;
  DWORD dwWidth;
  DWORD dwHeight;
  DWORD dwBPP;
} ddm_xhdr;

typedef struct {
  void *self_ptr;
  void *list[7];
  ddm_xhdr *ddmx;
  BYTE palette[256][4];
} ddp_xhdr;

typedef struct {
  void *self_ptr;
  void *list[36 +3]; // v1.02 add 3 for usage with IDirectDrawSurface2
  ddm_xhdr *ddmx;
  ddp_xhdr *ddpx;
  DDSURFACEDESC ddsd;
  bmp_head bh;
  BYTE *lpScreen;
  DWORD dwSize;
  DWORD dwActive;
  DWORD dwLength;
} dds_xhdr;

typedef HRESULT (WINAPI* LPDIRECTDRAWCREATE)(GUID FAR *lpGUID, LPDIRECTDRAW FAR *lplpDD, IUnknown FAR *pUnkOuter);
static LPDIRECTDRAWCREATE hook_DirectDrawCreate;
static LPDIRECTDRAW LPDDO;

static scr_head fscr;

// fast image resize
void ResizeToScreen(const BYTE *sb) {
DWORD i, j, coffx, coffy, cx, cy;
BYTE *p;
  if (sb && fscr.f && fscr.p && (!fscr.b)) {
    // TODO: replace hardcoded 640 and 480
    coffx = (640UL << 16) / fscr.w;
    coffy = (480UL << 16) / fscr.h;
    cy = 0;
    for (j = 0; j < fscr.h; j++) {
      p = (BYTE *) &fscr.p[((j + fscr.y) * fscr._w) + fscr.x];
      cx = 0;
      for (i = 0; i < fscr.w; i++) {
        *p = sb[((cy >> 16) * 640) + (cx >> 16)];
        cx += coffx;
        p++;
      }
      cy += coffy;
    }
  }
}

// helpers functions
void FillWithStub(DWORD *ptr, DWORD sz, DWORD prfx) {
DWORD i;
  for (i = 0; i < sz; i++) {
    ptr[i] = MAKEWORD(i, prfx);
  }
}

#define BMPLINESIZE(w, b) (((((w) * (b)) + 31) & ~31) >> 3)
int FillBitmapHeader(BYTE *buf, int iwidth, int iheight, int ibpp) {
BITMAPFILEHEADER *bf;
BITMAPINFOHEADER *bi;
int hsize, dsize;
  hsize = sizeof(bf[0]) + sizeof(bi[0]) + (((ibpp <= 8) ? (1 << ibpp) : 0) * 4);
  dsize = BMPLINESIZE(iwidth, ibpp) * iheight;
  if (buf) {
    bf = (BITMAPFILEHEADER *) buf;
    bi = (BITMAPINFOHEADER *) &buf[sizeof(bf[0])];
    ZeroMemory(bf, sizeof(bf[0]));
    ZeroMemory(bi, sizeof(bi[0]));
    bi->biSize = sizeof(bi[0]);
    bi->biWidth = iwidth;
    bi->biHeight = -iheight; // negative height: top to bottom image
    bi->biPlanes = 1;
    bi->biBitCount = ibpp;
    bf->bfType = 0x4D42;
    bf->bfSize = hsize + dsize;
    bf->bfOffBits = hsize;
    hsize = sizeof(bf[0]) + sizeof(bi[0]);
    dsize = 0;
  }
  return(hsize + dsize);
}

// *****************************************
// * DirectDrawPalette interface functions *
// *****************************************

// OK
HRESULT WINAPI DP_Release(
  ddp_xhdr *ddpx
) {
  DebugOut("DP_Release [%08X]", ddpx);
  FreeMem(ddpx);
  return(DD_OK);
}

// OK
HRESULT WINAPI DP_SetEntries(
  ddp_xhdr *ddpx,
  DWORD dwFlags,
  DWORD dwStartingEntry,
  DWORD dwCount,
  LPPALETTEENTRY lpEntries
) {
  DebugOut("DP_SetEntries [%08X], %08X, %u, %u", ddpx, dwFlags, dwStartingEntry, dwCount);
  for (dwCount += dwStartingEntry; dwStartingEntry < dwCount; dwStartingEntry++) {
    ddpx->palette[dwStartingEntry][2] = lpEntries[dwStartingEntry].peRed;
    ddpx->palette[dwStartingEntry][1] = lpEntries[dwStartingEntry].peGreen;
    ddpx->palette[dwStartingEntry][0] = lpEntries[dwStartingEntry].peBlue;
  }
  // TODO: is first color always black?
  dwFlags = 0;
  CopyMemory(&ddpx->palette[0x00], &dwFlags, 3);
  // TODO: is last color always white?
  dwFlags = (DWORD) -1;
  CopyMemory(&ddpx->palette[0xFF], &dwFlags, 3);
  return(DD_OK);
}

// *****************************************
// * DirectDrawSurface interface functions *
// *****************************************

HRESULT WINAPI DS_Release(
  dds_xhdr *ddsx
) {
  DebugOut("DS_Release [%08X]", ddsx);
  if (ddsx->lpScreen) { FreeMem(ddsx->lpScreen); }
  FreeMem(ddsx);
  return(DD_OK);
}

void TestRect(RECT *rc, DWORD w, DWORD h) {
  rc->left = max(0, rc->left);
  rc->left = min(w, rc->left);
  rc->top = max(0, rc->top);
  rc->top = min(h, rc->top);
  rc->right = max(0, rc->right);
  rc->right = min(w, rc->right);
  rc->bottom = max(0, rc->bottom);
  rc->bottom = min(h, rc->bottom);
  if (rc->left > rc->right) {
    rc->left ^= rc->right;
    rc->right ^= rc->left;
    rc->left ^= rc->right;
  }
  if (rc->top > rc->bottom) {
    rc->top ^= rc->bottom;
    rc->bottom ^= rc->top;
    rc->top ^= rc->bottom;
  }
}

HRESULT WINAPI DS_Blt(
  dds_xhdr *ddsx,
  LPRECT lpDestRect,
  LPDIRECTDRAWSURFACE lpDDSrcSurface,
  LPRECT lpSrcRect,
  DWORD dwFlags,
  LPDDBLTFX lpDDBltFx
) {
dds_xhdr *ddsr;
DWORD i, j, w, h, ds, dd;
RECT rd, rs;
BYTE *ps, *pd;
  ddsr = (dds_xhdr *) lpDDSrcSurface;
  DebugOut("DS_Blt [%08X], [%08X]", ddsx, ddsr);
  // looks like this used just to clear surface
  if (!ddsr) {
    ZeroMemory(
      &ddsx->lpScreen[((ddsx->dwActive + 1) % ddsx->dwLength) * ddsx->dwSize],
      ddsx->dwSize
    );
    return(DD_OK);
  }
  if (lpDestRect) {
    CopyMemory(&rd, lpDestRect, sizeof(rd));
  } else {
    rd.top = 0;
    rd.left = 0;
    rd.right = ddsx->ddsd.dwWidth;
    rd.bottom = ddsx->ddsd.dwHeight;
  }
  TestRect(&rd, ddsx->ddsd.dwWidth, ddsx->ddsd.dwHeight);
  if (lpSrcRect) {
    CopyMemory(&rs, lpSrcRect, sizeof(rs));
  } else {
    rs.top = 0;
    rs.left = 0;
    rs.right = ddsr->ddsd.dwWidth;
    rs.bottom = ddsr->ddsd.dwHeight;
  }
  TestRect(&rs, ddsr->ddsd.dwWidth, ddsr->ddsd.dwHeight);
  // dwFlags = DDBLT_WAIT
  // update screen
  w = rs.right - rs.left;
  h = rs.bottom - rs.top;
  dd = ddsx->ddsd.u1.lPitch;
  ds = ddsr->ddsd.u1.lPitch;
  pd = &ddsx->lpScreen[(rd.top * dd) + rd.left + (((ddsx->dwActive + 1) % ddsx->dwLength) * ddsx->dwSize)];
  ps = &ddsr->lpScreen[(rs.top * ds) + rs.left + (((ddsr->dwActive + 1) % ddsr->dwLength) * ddsr->dwSize)];
  for (j = 0; j < h; j++) {
    if (dwFlags & DDBLT_KEYSRC) {
      for (i = 0; i < w; i++) {
        pd[i] = ps[i] ? ps[i] : pd[i];
      }
    } else {
      CopyMemory(pd, ps, w);
    }
    pd += dd;
    ps += ds;
  }
  return(DD_OK);
}

HRESULT WINAPI DS_BltFast(
  dds_xhdr *ddsx,
  DWORD dwX,
  DWORD dwY,
  LPDIRECTDRAWSURFACE lpDDSrcSurface,
  LPRECT lpSrcRect,
  DWORD dwTrans
) {
DDBLTFX ddbf;
DWORD dwFlags;
RECT rc;
  DebugOut("DS_BltFast [%08X], %u, %u, [%08X], (%u %u %u %u), %08X",
    ddsx, dwX, dwY, lpDDSrcSurface,
    lpSrcRect ? lpSrcRect->left : 0,
    lpSrcRect ? lpSrcRect->top : 0,
    lpSrcRect ? lpSrcRect->right : 0,
    lpSrcRect ? lpSrcRect->bottom : 0,
    dwTrans
  );
  dwFlags = 0;
  dwFlags |= (dwTrans & DDBLTFAST_WAIT) ? DDBLT_WAIT : 0;
  dwFlags |= (dwTrans & DDBLTFAST_SRCCOLORKEY) ? DDBLT_KEYSRC : 0;
  rc.left = dwX;
  rc.top = dwY;
  rc.right = dwX + (lpSrcRect->right - lpSrcRect->left);
  rc.bottom = dwY + (lpSrcRect->bottom - lpSrcRect->top);
  ZeroMemory(&ddbf, sizeof(ddbf));
  ddbf.dwSize = sizeof(ddbf);
  DS_Blt(ddsx, &rc, lpDDSrcSurface, lpSrcRect, dwFlags, &ddbf);
  return(DD_OK);
}

HRESULT WINAPI DS_Flip(
  dds_xhdr *ddsx,
  LPDIRECTDRAWSURFACE lpDDSurfaceTargetOverride,
  DWORD dwFlags
) {
HDC hc;
  // lpDDSurfaceTargetOverride == NULL
  // dwFlags == DDFLIP_WAIT
  DebugOut("DS_Flip [%08X], [%08X], %08X", ddsx, lpDDSurfaceTargetOverride, dwFlags);
  if (ddsx && ddsx->lpScreen && (ddsx->ddsd.ddsCaps.dwCaps & DDSCAPS_PRIMARYSURFACE)) {
    DebugOut("PAGE:%u", ddsx->dwActive);
    if (ddsx->ddpx) {
      CopyMemory(ddsx->bh.palette, ddsx->ddpx->palette, 256 * 4);
    }
    hc = GetDC(ddsx->ddmx->wnd);
    if (hc) {
      if ((!fscr.f) || (!fscr.p) || (fscr.b)) {
        // direct screen output
        SetDIBitsToDevice(hc,
          0, 0, ddsx->ddsd.dwWidth, ddsx->ddsd.dwHeight,
          0, 0, 0, ddsx->ddsd.dwHeight,
          (void *) &ddsx->lpScreen[ddsx->dwActive * ddsx->dwSize],
          (BITMAPINFO *) &ddsx->bh.bi,
          DIB_RGB_COLORS
        );
      } else {
        // resize image - a lot faster than call to StretchDIBits()
        ResizeToScreen(&ddsx->lpScreen[ddsx->dwActive * ddsx->dwSize]);
        // update palette
        CopyMemory(fscr.bh.palette, ddsx->bh.palette, sizeof(fscr.bh.palette));
        // direct screen output
        SetDIBitsToDevice(hc,
          0, 0, fscr._w, fscr._h,
          0, 0, 0, fscr._h,
          (void *) fscr.p,
          (BITMAPINFO *) &fscr.bh.bi,
          DIB_RGB_COLORS
        );
      }
      ReleaseDC(ddsx->ddmx->wnd, hc);
      ValidateRect(ddsx->ddmx->wnd, NULL);
      //GdiFlush();
    }
    // palette a bit too late to the party - new screen already in the surface buffer (original game bug)
    // so need to fall behind for one single frame to avoid ugly mismatching colors flickering
    ddsx->dwActive = (ddsx->dwActive + 1) % ddsx->dwLength;
    CopyMemory(
      &ddsx->lpScreen[((ddsx->dwActive + 1) % ddsx->dwLength) * ddsx->dwSize],
      &ddsx->lpScreen[ddsx->dwActive * ddsx->dwSize],
      ddsx->dwSize
    );
  }
  return(DD_OK);
}

HRESULT WINAPI DS_GetAttachedSurface(
  dds_xhdr *ddsx,
  LPDDSCAPS lpDDSCaps,
  LPDIRECTDRAWSURFACE FAR *lplpDDAttachedSurface
) {
  // fullscreen:
  // 1: (lpDDSCaps->dwCaps & DDSCAPS_VIDEOMEMORY)
  // 2: (lpDDSCaps->dwCaps & DDSCAPS_BACKBUFFER)
  *lplpDDAttachedSurface = (LPDIRECTDRAWSURFACE) ddsx;
  // 4 = DDSCAPS_BACKBUFFER // only one call to DS_GetAttachedSurface()
  DebugOut("DS_GetAttachedSurface [%08X], %08X", ddsx, lpDDSCaps->dwCaps);
  return(DD_OK/*DDERR_NOTFOUND*/);
}

// OK
HRESULT WINAPI DS_IsLost(
  dds_xhdr *ddsx
) {
  DebugOut("DS_IsLost [%08X]", ddsx);
  // always return DD_OK to avoid DS_Restore() call
  return(DD_OK);
}

// OK
HRESULT WINAPI DS_SetPalette(
  dds_xhdr *ddsx,
  LPDIRECTDRAWPALETTE lpDDPalette
) {
  DebugOut("DS_SetPalette [%08X], [%08X]", ddsx, lpDDPalette);
  ddsx->ddpx = (ddp_xhdr *) lpDDPalette;
  return(DD_OK);
}

HRESULT WINAPI DS_Lock(
  dds_xhdr *ddsx,
  LPRECT lpDestRect,
  LPDDSURFACEDESC lpDDSurfaceDesc,
  DWORD dwFlags,
  HANDLE hEvent
) {
  // dwFlags = DDLOCK_WAIT
  DebugOut("DS_Lock [%08X]", ddsx);
  CopyMemory(lpDDSurfaceDesc, &ddsx->ddsd, sizeof(ddsx->ddsd));
  lpDDSurfaceDesc->lpSurface = (void *) &ddsx->lpScreen[((ddsx->dwActive + 1) % ddsx->dwLength) * ddsx->dwSize];
  // TODO: is this flags even needed?
  lpDDSurfaceDesc->dwFlags |= DDSD_LPSURFACE;
  lpDDSurfaceDesc->ddsCaps.dwCaps |= DDSCAPS_LOCALVIDMEM;
  return(DD_OK);
}

HRESULT WINAPI DS_Unlock(
  dds_xhdr *ddsx,
  LPVOID lpSurfaceData
) {
  DebugOut("DS_Unlock [%08X]", ddsx);
  return(DD_OK);
}

// DS_QueryInterface, DS_PageLock and DS_PageUnlock
// probably used only to test for the system-memory surface
// quote on the PageLock from the DirectX manual:
// "This method works only on system-memory surfaces; it will not page
// lock a display-memory surface or an emulated primary surface.
// If an application calls this method on a display memory surface,
// the method will do nothing except return DD_OK."
// riid = IDirectDraw2
HRESULT WINAPI stub_PageLockUnlock(dds_xhdr *ddsx, DWORD dwFlags) { return(DD_OK); }
HRESULT WINAPI stub_Release(dds_xhdr *ddsx) { return(DD_OK); }
static dds_xhdr virtsurf;

// OK
HRESULT WINAPI DS_QueryInterface(
  dds_xhdr *ddsx,
  REFIID riid,
  LPVOID *obp
) {
  virtsurf.list[ 2] = (void *) stub_Release; // !
  // IDirectDrawSurface2
  virtsurf.list[37] = (void *) stub_PageLockUnlock; // PageLock
  virtsurf.list[38] = (void *) stub_PageLockUnlock; // PageUnlock
  virtsurf.self_ptr = &virtsurf.list;
  *((dds_xhdr **) obp) = &virtsurf;
  return(DD_OK);
}

// OK
HRESULT WINAPI DS_GetCaps(
  dds_xhdr *ddsx,
  LPDDSCAPS2 lpDDSCaps
) {
  DebugOut("DS_GetCaps [%08X]", ddsx);
  // always return 0 to prevent some more surfaces allocations
  ZeroMemory(lpDDSCaps, sizeof(*lpDDSCaps));
  return(DD_OK);
}

// OK
HRESULT WINAPI DS_SetColorKey(
  dds_xhdr *ddsx,
  DWORD dwFlags,
  LPDDCOLORKEY lpDDColorKey
) {
  DebugOut("DS_SetColorKey [%08X], %08X, %u, %u", ddsx, dwFlags, lpDDColorKey->dwColorSpaceLowValue, lpDDColorKey->dwColorSpaceHighValue);
  // set color index 0 as transparent
  // dwFlags = DDCKEY_SRCBLT [8]
  // lpDDColorKey->dwColorSpaceLowValue == 0
  // lpDDColorKey->dwColorSpaceHighValue == 0
  return(DD_OK);
}

HRESULT WINAPI DS_Restore(
  dds_xhdr *ddsx
) {
  DebugOut("DS_Restore [%08X]", ddsx);
  return(DD_OK);
}

// OK
HRESULT WINAPI DS_GetDC(
  dds_xhdr *ddsx,
  HDC FAR *lphDC
) {
  *lphDC = GetDC(ddsx->ddmx->wnd);
  return(DD_OK);
}

// OK
HRESULT WINAPI DS_ReleaseDC(
  dds_xhdr *ddsx,
  HDC hDC
) {
  ReleaseDC(ddsx->ddmx->wnd, hDC);
  return(DD_OK);
}

// ***************************************
// * DirectDraw main interface functions *
// ***************************************

// OK
HRESULT WINAPI DD_RestoreDisplayMode(
  ddm_xhdr *ddmx
) {
  DebugOut("DD_RestoreDisplayMode", NULL); // NULL to shut up compiler warnings
  ddmx->dwFullscreen = 0;
  return(DD_OK);
}

// OK
HRESULT WINAPI DD_Release(
  ddm_xhdr *ddmx
) {
  DebugOut("DD_Release", NULL); // NULL to shut up compiler warnings
  // cleanup
  if (LPDDO) {
    IDirectDraw_Release(LPDDO);
    LPDDO = NULL;
  }
  FreeMem(ddmx);
  return(DD_OK);
}

// OK
HRESULT WINAPI DD_CreatePalette(
  ddm_xhdr *ddmx,
  DWORD dwFlags,
  LPPALETTEENTRY lpColorTable,
  LPDIRECTDRAWPALETTE FAR *lplpDDPalette,
  IUnknown FAR *pUnkOuter
) {
ddp_xhdr *ddpx;
  DebugOut("DD_CreatePalette [%08X %08X %08X]", dwFlags, lpColorTable, lplpDDPalette);
  ddpx = GetMem(sizeof(ddpx[0]));
  if (ddpx) {
    // fill with stubs so called but missing function can be identified by address
    FillWithStub((DWORD *) ddpx->list, 7, 0xD7); // (D)irect (7)alette
    // fill with the actual structs
    // IUnknown methods
//    ddpx->list[ 0] = (void *) DP_QueryInterface;
//    ddpx->list[ 1] = (void *) DP_AddRef;
    ddpx->list[ 2] = (void *) DP_Release;
    // IDirectDrawPalette methods
//    ddpx->list[ 3] = (void *) DP_GetCaps;
//    ddpx->list[ 4] = (void *) DP_GetEntries;
//    ddpx->list[ 5] = (void *) DP_Initialize;
    ddpx->list[ 6] = (void *) DP_SetEntries;
    ddpx->ddmx = ddmx;
    ddpx->self_ptr = &ddpx->list;
    DP_SetEntries(ddpx, 0, 0, 256, lpColorTable);
    // return result
    *lplpDDPalette = (LPDIRECTDRAWPALETTE) ddpx;
  }
  DebugOut("DP:%08X", ddpx);
  return(ddpx ? DD_OK : DDERR_GENERIC);
}

HRESULT WINAPI DD_CreateSurface(
  ddm_xhdr *ddmx,
  LPDDSURFACEDESC lpDDSurfaceDesc,
  LPDIRECTDRAWSURFACE FAR *lplpDDSurface,
  IUnknown FAR *pUnkOuter
) {
dds_xhdr *ddsx;
DWORD sz;
  DebugOut("DD_CreateSurface [%08X %08X]", lpDDSurfaceDesc->dwFlags, lpDDSurfaceDesc->ddsCaps.dwCaps);
/*
  // primary surface with back buffer
  dwFlags: 0x21 = DDSD_BACKBUFFERCOUNT [0x20] | DDSD_CAPS [0x01]
  dwCaps: 0x218 = DDSCAPS_PRIMARYSURFACE [0x200] | DDSCAPS_FLIP [0x10] | DDSCAPS_COMPLEX [0x08]
  lpDDSurfaceDesc.dwBackBufferCount = 1;

  // secondary surfaces
  dwFlags: 0x07 = DDSD_WIDTH [0x04] | DDSD_HEIGHT [0x02] | DDSD_CAPS [0x01]
  dwCaps: 0x40/0x840 = DDSCAPS_SYSTEMMEMORY [0x800] | DDSCAPS_OFFSCREENPLAIN [0x40]

  0 Primary Surface:
    dwFlags == [1] DDSD_CAPS
    dwCaps == [0x0200] DDSCAPS_PRIMARYSURFACE
  1 Secondary Surface:
    dwFlags == 0x0F
      [1] DDSD_CAPS
      [2] DDSD_HEIGHT
      [4] DDSD_WIDTH
      [8] DDSD_PITCH
    dwCaps == [0x4000] DDSCAPS_VIDEOMEMORY
*/
  DebugOut("=> %ux%u %u (%d)",
    lpDDSurfaceDesc->dwWidth,
    lpDDSurfaceDesc->dwHeight,
    lpDDSurfaceDesc->ddpfPixelFormat.u1.dwRGBBitCount,
    lpDDSurfaceDesc->u1.lPitch
  );
  // create surface
  ddsx = GetMem(sizeof(ddsx[0]));
  if (ddsx) {
    // fill with stubs so called but missing function can be identified by address
    FillWithStub((DWORD *) ddsx->list, 36, 0xD5); // (D)irect (5)urface
    // fill with the actual structs
    // IUnknown methods
    ddsx->list[ 0] = (void *) DS_QueryInterface; // !
//    ddsx->list[ 1] = (void *) DS_AddRef;
    ddsx->list[ 2] = (void *) DS_Release; // !
    // IDirectDrawSurface methods
//    ddsx->list[ 3] = (void *) DS_AddAttachedSurface;
//    ddsx->list[ 4] = (void *) DS_AddOverlayDirtyRect;
    ddsx->list[ 5] = (void *) DS_Blt; // !
//    ddsx->list[ 6] = (void *) DS_BltBatch;
    ddsx->list[ 7] = (void *) DS_BltFast; // !
//    ddsx->list[ 8] = (void *) DS_DeleteAttachedSurface;
//    ddsx->list[ 9] = (void *) DS_EnumAttachedSurfaces;
//    ddsx->list[10] = (void *) DS_EnumOverlayZOrders;
    ddsx->list[11] = (void *) DS_Flip; // !
    ddsx->list[12] = (void *) DS_GetAttachedSurface; // !
//    ddsx->list[13] = (void *) DS_GetBltStatus;
    ddsx->list[14] = (void *) DS_GetCaps; // !
//    ddsx->list[15] = (void *) DS_GetClipper;
//    ddsx->list[16] = (void *) DS_GetColorKey;
    ddsx->list[17] = (void *) DS_GetDC; // ! debug
//    ddsx->list[18] = (void *) DS_GetFlipStatus;
//    ddsx->list[19] = (void *) DS_GetOverlayPosition;
//    ddsx->list[20] = (void *) DS_GetPalette;
//    ddsx->list[21] = (void *) DS_GetPixelFormat;
//    ddsx->list[22] = (void *) DS_GetSurfaceDesc;
//    ddsx->list[23] = (void *) DS_Initialize;
    ddsx->list[24] = (void *) DS_IsLost; // ?
    ddsx->list[25] = (void *) DS_Lock; // !
    ddsx->list[26] = (void *) DS_ReleaseDC; // ! debug
    ddsx->list[27] = (void *) DS_Restore; // ?
//    ddsx->list[28] = (void *) DS_SetClipper;
    ddsx->list[29] = (void *) DS_SetColorKey; // !
//    ddsx->list[30] = (void *) DS_SetOverlayPosition;
    ddsx->list[31] = (void *) DS_SetPalette; // !
    ddsx->list[32] = (void *) DS_Unlock; // !
//    ddsx->list[33] = (void *) DS_UpdateOverlay;
//    ddsx->list[34] = (void *) DS_UpdateOverlayDisplay;
//    ddsx->list[35] = (void *) DS_UpdateOverlayZOrder;
    ddsx->ddmx = ddmx;
    ddsx->self_ptr = &ddsx->list;
    // copy surface properties
    CopyMemory(&ddsx->ddsd, lpDDSurfaceDesc, sizeof(ddsx->ddsd));
    // screen
    if ((ddsx->ddsd.dwFlags & DDSD_CAPS) && (ddsx->ddsd.ddsCaps.dwCaps & DDSCAPS_PRIMARYSURFACE)) {
      ddsx->ddsd.dwFlags |= DDSD_WIDTH | DDSD_HEIGHT;
      ddsx->ddsd.dwWidth = ddmx->dwWidth;
      ddsx->ddsd.dwHeight = ddmx->dwHeight;
    }
    ddsx->ddsd.dwFlags |= DDSD_PIXELFORMAT;
    ddsx->ddsd.ddpfPixelFormat.dwSize = sizeof(ddsx->ddsd.ddpfPixelFormat);
    ddsx->ddsd.ddpfPixelFormat.u1.dwRGBBitCount = ddmx->dwBPP;
    // fill in other data structures
    ddsx->ddsd.dwSize = sizeof(ddsx->ddsd);
    ddsx->ddsd.dwFlags |= DDSD_PITCH;
    // 32 bits aligned (4 bytes)
    ddsx->ddsd.u1.lPitch = ddsx->ddsd.dwWidth * ddsx->ddsd.ddpfPixelFormat.u1.dwRGBBitCount;
    for (; ddsx->ddsd.u1.lPitch & 0x1F; ddsx->ddsd.u1.lPitch++);
    ddsx->ddsd.u1.lPitch /= 8;
    ddsx->ddsd.dwFlags |= DDSD_CAPS;
    ddsx->ddsd.ddsCaps.dwCaps = DDSCAPS_LOCALVIDMEM | DDSCAPS_VISIBLE | DDSCAPS_VIDEOMEMORY | DDSCAPS_PRIMARYSURFACE;
    // debug info
    DebugOut("<= %ux%u %u (%d)",
      ddsx->ddsd.dwWidth,
      ddsx->ddsd.dwHeight,
      ddsx->ddsd.ddpfPixelFormat.u1.dwRGBBitCount,
      ddsx->ddsd.u1.lPitch
    );
    // allocate video buffer memory
    sz = ddsx->ddsd.dwHeight * ddsx->ddsd.u1.lPitch;
    if (sz) {
      // fill in bitmap header
      FillBitmapHeader((BYTE *)&ddsx->bh, ddsx->ddsd.dwWidth, ddsx->ddsd.dwHeight, ddsx->ddsd.ddpfPixelFormat.u1.dwRGBBitCount);
      ddsx->dwLength = 1 + ((ddsx->ddsd.dwFlags & DDSD_BACKBUFFERCOUNT) ? ddsx->ddsd.dwBackBufferCount: 0);
      ddsx->dwSize = sz;
      ddsx->lpScreen = GetMem(sz * ddsx->dwLength);
    }
    // not enough memory or some other error
    if (!ddsx->lpScreen) {
      FreeMem(ddsx);
      ddsx = NULL;
    }
    // return result
    *lplpDDSurface = (LPDIRECTDRAWSURFACE) ddsx;
  }
  DebugOut("DS:%08X", ddsx);
  return(ddsx ? DD_OK : DDERR_GENERIC);
}

// OK
HRESULT WINAPI DD_SetCooperativeLevel(
  ddm_xhdr *ddmx,
  HWND hWnd,
  DWORD dwFlags
) {
  DebugOut("DD_SetCooperativeLevel [%08X %08X]", hWnd, dwFlags);
  ddmx->wnd = hWnd;
  return(DD_OK);
}

// OK
HRESULT WINAPI DD_SetDisplayMode(
  ddm_xhdr *ddmx,
  DWORD dwWidth,
  DWORD dwHeight,
  DWORD dwBPP
) {
  DebugOut("DD_SetDisplayMode [%dx%d %d]", dwWidth, dwHeight, dwBPP);
  // save current mode
  ddmx->dwFullscreen = 1;
  ddmx->dwWidth = dwWidth;
  ddmx->dwHeight = dwHeight;
  ddmx->dwBPP = dwBPP;
  return(DD_OK);
}

// OK
HRESULT WINAPI DD_WaitForVerticalBlank(
  ddm_xhdr *ddmx,
  DWORD dwFlags,
  HANDLE hEvent
) {
  DebugOut("DD_WaitForVerticalBlank", NULL); // NULL to shut up compiler warnings
  if (LPDDO) {
    // IDirectDraw_WaitForVerticalBlank(LPDDO, DDWAITVB_BLOCKBEGIN, 0);
    IDirectDraw_WaitForVerticalBlank(LPDDO, dwFlags, hEvent);
  } else {
    Sleep(1000 / 60); // 60 FPS
  }
  return(DD_OK);
}

// OK
HRESULT WINAPI DD_GetCaps(
  ddm_xhdr *ddmx,
  LPDDCAPS lpDDDriverCaps,
  LPDDCAPS lpDDHELCaps
) {
DWORD dw;
  // always return zero
  if (lpDDDriverCaps) {
    dw = lpDDDriverCaps->dwSize;
    ZeroMemory(lpDDDriverCaps, dw);
    lpDDDriverCaps->dwSize = dw;
  }
  // always return zero
  if (lpDDHELCaps) {
    dw = lpDDHELCaps->dwSize;
    ZeroMemory(lpDDHELCaps, dw);
    lpDDHELCaps->dwSize = dw;
  }
  return(DD_OK);
}

typedef LRESULT (CALLBACK *LPWNDPRC)(HWND wnd, UINT umsg, WPARAM wparm, LPARAM lparm);
static LPWNDPRC hook_WndPrc;

void SetWndStyle(HWND wnd) {
DWORD dwStyle, x, y;
RECT rc;
POINT pt;
  fscr.b = TRUE;
  GetCursorPos(&pt);
  if (fscr.f) {
    ScreenToClient(wnd, &pt);
    dwStyle = WS_VISIBLE | WS_SYSMENU | WS_POPUP;
    x = 0;
    y = 0;
    rc.left = 0;
    rc.top = 0;
    rc.right = GetSystemMetrics(SM_CXSCREEN);
    rc.bottom = GetSystemMetrics(SM_CYSCREEN);
    // ---
    fscr._w = rc.right;
    fscr._h = rc.bottom;
    FillBitmapHeader((BYTE *) &fscr.bh, fscr._w, fscr._h, 8);
    fscr.w = fscr._w;
    fscr.h = fscr._h;
    if (!(dwAllFlags & FLAG_LONG)) {
      if ((fscr.w * 3) != (fscr.h * 4)) {
        if ((fscr.w / 4) > (fscr.h / 3)) {
          fscr.w = (fscr.h * 4) / 3;
        } else {
          fscr.h = (fscr.w * 3) / 4;
        }
      }
    }
    fscr.x = (fscr._w - fscr.w) / 2;
    fscr.y = (fscr._h - fscr.h) / 2;
    fscr.p = GetMem(fscr._w * fscr._h);
    if (fscr.p) { ZeroMemory(fscr.p, fscr._w * fscr._h); }
  } else {
    dwStyle = WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_VISIBLE;
    x = fscr.wx;
    y = fscr.wy;
    rc.left = 0;
    rc.top = 0;
    rc.right = 640;
    rc.bottom = 480;
    // ---
    if (fscr.p) {
      FreeMem(fscr.p);
      fscr.p = NULL;
    }
  }
  AdjustWindowRect(&rc, dwStyle, FALSE);
  SetWindowLong(wnd, GWL_STYLE, dwStyle);
  SetWindowPos(wnd, fscr.f ? HWND_TOPMOST : HWND_NOTOPMOST,
    x, y, rc.right - rc.left, rc.bottom - rc.top, SWP_FRAMECHANGED
  );
  if (fscr.f) {
    rc.top = 0;
    rc.left = 0;
    rc.right = 640;
    rc.bottom = 480;
    ClipCursor(&rc);
  } else {
    ClipCursor(NULL);
    ClientToScreen(wnd, &pt);
  }
  if (fscr.bh.bf.bfType) {
    SetCursorPos(pt.x, pt.y);
  }
  fscr.b = FALSE;
}

// 1, 2, 4 - left, right, middle pressed
static BYTE bMouseMask;
// joystick cursor movement step (1 or 10)
static DWORD dwJoySpeed;

LRESULT CALLBACK WndPrcCtrl(HWND wnd, UINT umsg, WPARAM wparm, LPARAM lparm) {
LRESULT lr;
JOYINFO ji;
POINT pt;
BYTE b;
  // v1.01
  if (umsg == WM_CREATE) {
    dwJoySpeed = 1;
    bMouseMask = 0;
  }
  // v1.02 fix game code
  if ((umsg == WM_SYSCOMMAND) &&
     (((wparm & 0xFFF0) == SC_SCREENSAVE) || ((wparm & 0xFFF0) == SC_MONITORPOWER))) {
    return(0);
  }
  // hide cursor only for client area and allow for the title bar and controls
  if (umsg == WM_SETCURSOR) {
    SetCursor((LOWORD(lparm) == HTCLIENT) ? NULL : LoadCursor(NULL, IDC_ARROW));
    return(TRUE);
  }
  // prevent system menu and hotkeys
  if (
    // right click menu on the window caption
    (umsg == WM_CONTEXTMENU) ||
    // Alt, F10, Alt+Space and left-click on window icon
    ((umsg == WM_SYSCOMMAND) && (
      // Alt, F10, Alt+Space
      (wparm == SC_KEYMENU) ||
      // click on the window icon, 0xF093 == SC_MOUSEMENU | HTSYSMENU
      (wparm == (SC_MOUSEMENU | HTSYSMENU)) ||
      // double click on the window icon, 0xF063 == SC_CLOSE | HTSYSMENU
      (wparm == (SC_CLOSE | HTSYSMENU))
    ))
  ) {
    return(0);
  }
  // additional features for right and middle mouse buttons
  if (dwAllFlags & FLAG_MBTN) {
    if (umsg == WM_RBUTTONDOWN) {
      // emulate VK_SPACE to skip Smacker videos
      hook_WndPrc(wnd, WM_KEYDOWN, VK_SPACE, MAKELPARAM(1, LOBYTE(MapVirtualKey(VK_SPACE, 0)))); // 0x00390001
      return(0);
    }
    if (umsg == WM_MBUTTONDOWN) {
      // emulate VK_ESCAPE to call main menu
      hook_WndPrc(wnd, WM_KEYDOWN, VK_ESCAPE, MAKELPARAM(1, LOBYTE(MapVirtualKey(VK_ESCAPE, 0)))); // 0x00010001
      return(0);
    }
  }
  // prevent mouse button holding - mostly for radio puzzle (stations switching too fast)
  if (dwAllFlags & FLAG_HOLD) {
    if ((umsg == WM_LBUTTONUP) || (umsg == WM_RBUTTONUP) || (umsg == WM_MBUTTONUP)) {
      // 513, 516, 519 => 0, 1, 2
      b = (umsg - WM_LBUTTONUP) / 3;
      // 0, 1, 2 => 1, 2, 4
      b = 1 << b;
      // drop flag
      bMouseMask = (bMouseMask | b) ^ b;
      return(0);
    }
    if ((umsg == WM_LBUTTONDOWN) || (umsg == WM_RBUTTONDOWN) || (umsg == WM_MBUTTONDOWN)) {
      // 514, 517, 520 => 0, 1, 2
      b = (umsg - WM_LBUTTONDOWN) / 3;
      // button was not pressed before
      if (!(bMouseMask & (1 << b))) {
        // only left button in override mode
        // or it will act like action in 1st person mode
        if ((umsg == WM_LBUTTONDOWN) || (!(dwAllFlags & FLAG_MBTN))) {
          // send both up and down events immediately
          hook_WndPrc(wnd, WM_LBUTTONDOWN + (b * 3), wparm, lparm);
          hook_WndPrc(wnd, WM_LBUTTONUP + (b * 3), wparm, lparm);
        }
        // set flag
        bMouseMask |= (1 << b);
      }
      return(0);
    }
  }
  // call original game window procedure
  lr = hook_WndPrc(wnd, umsg, wparm, lparm);
  // joystick code
  if (dwAllFlags & FLAG_JOYS) {
    if (umsg == WM_CREATE) {
      b = 0;
      if (joyGetNumDevs()) {
        b = (joySetCapture(
          wnd, (joyGetPos(JOYSTICKID1, &ji) == JOYERR_NOERROR) ? JOYSTICKID1 : JOYSTICKID2,
          16, FALSE) == JOYERR_NOERROR
        ) ? 1 : 0;
      }
      // no joysticks - drop flag
      dwAllFlags ^= b ? 0 : FLAG_JOYS;
    }
    // https://docs.microsoft.com/en-us/previous-versions/ms708509(v=vs.85)
    if ((umsg == MM_JOY1MOVE) || (umsg == MM_JOY2MOVE)) {
      GetCursorPos(&pt);
      if (LOWORD(lparm) < 0x5555) { pt.x += -dwJoySpeed; }
      if (LOWORD(lparm) > 0xAAAA) { pt.x +=  dwJoySpeed; }
      if (HIWORD(lparm) < 0x5555) { pt.y += -dwJoySpeed; }
      if (HIWORD(lparm) > 0xAAAA) { pt.y +=  dwJoySpeed; }
      SetCursorPos(pt.x, pt.y);
    }
    if ((umsg == MM_JOY1BUTTONDOWN) || (umsg == MM_JOY2BUTTONDOWN)) {
      // button 1 - left mouse
      if (wparm & JOY_BUTTON1) {
        GetCursorPos(&pt);
        ScreenToClient(wnd, &pt);
        SendMessage(wnd, WM_LBUTTONDOWN, 0, MAKELPARAM(pt.x, pt.y));
        SendMessage(wnd, WM_LBUTTONUP, 0, MAKELPARAM(pt.x, pt.y));
      }
      // button 2 - switch speed
      if (wparm & JOY_BUTTON2) {
        dwJoySpeed = (dwJoySpeed - 1) ? 1 : 10;
      }
      // button 3 - skip videos
      if (wparm & JOY_BUTTON3) {
        // emulate VK_SPACE to skip Smacker videos
        hook_WndPrc(wnd, WM_KEYDOWN, VK_SPACE, MAKELPARAM(1, LOBYTE(MapVirtualKey(VK_SPACE, 0)))); // 0x00390001
      }
      // button 4 - open menu
      if (wparm & JOY_BUTTON4) {
        // emulate VK_ESCAPE to call main menu
        hook_WndPrc(wnd, WM_KEYDOWN, VK_ESCAPE, MAKELPARAM(1, LOBYTE(MapVirtualKey(VK_ESCAPE, 0)))); // 0x00010001
      }
    }
  }
  return(lr);
}

#define WM_MODE_XCHG (WM_USER + 101)
LRESULT CALLBACK WndPrc(HWND wnd, UINT umsg, WPARAM wparm, LPARAM lparm) {
LRESULT lr;
RECT rc;
  // call control code
  lr = WndPrcCtrl(wnd, umsg, wparm, lparm);
  // Alt+Enter - switch between fullscreen / windowed mode
  if ((umsg == WM_SYSKEYDOWN) && (wparm == VK_RETURN)) { SendMessage(wnd, WM_MODE_XCHG, 0, 0); }
  // fullscreen / windowed mode change
  if (umsg == WM_MODE_XCHG) {
    fscr.f ^= TRUE;
    if (fscr.f) {
      GetWindowRect(wnd, &rc);
      fscr.wx = rc.left;
      fscr.wy = rc.top;
    }
    SetWndStyle(wnd);
    lr = 0;
  }
  // main window just created - center it
  if (umsg == WM_CREATE) {
    ZeroMemory(&fscr, sizeof(fscr));
    SetWndStyle(wnd);
    GetWindowRect(wnd, &rc);
    fscr.wx = (GetSystemMetrics(SM_CXSCREEN) - (rc.right - rc.left)) / 2;
    fscr.wy = (GetSystemMetrics(SM_CYSCREEN) - (rc.bottom - rc.top)) / 2;
    SetWindowPos(wnd, 0, fscr.wx, fscr.wy, 0, 0, SWP_NOZORDER | SWP_NOSIZE);
    if (!(dwAllFlags & FLAG_WIND)) { SendMessage(wnd, WM_MODE_XCHG, 0, 0); }
    lr = 0;
  }
  // clip cursor and some additional features
  if ((umsg == WM_LBUTTONDOWN) || (umsg == WM_MBUTTONDOWN) || (umsg == WM_RBUTTONDOWN)) {
    // clip cursor only if allowed or fullscreen
    if ((dwAllFlags & FLAG_LOCK) || (fscr.f)) {
      rc.left = 0;
      rc.top = 0;
      rc.right = 640;
      rc.bottom = 480;
      ClientToScreen(wnd, (POINT *) &rc.left);
      ClientToScreen(wnd, (POINT *) &rc.right);
      ClipCursor(&rc);
    }
  }
  // free mouse cursor when main window not focused
  if ((umsg == WM_KILLFOCUS) || (umsg == WM_CANCELMODE) || (umsg == WM_ENTERIDLE)) {
    ClipCursor(NULL);
    bMouseMask = 0;
  }
  return(lr);
}

// OK
HRESULT WINAPI DirectDrawCreate(GUID FAR *lpGUID, LPDIRECTDRAW FAR *lplpDD, IUnknown FAR *pUnkOuter) {
ddm_xhdr *ddmx;
  if (hook_DirectDrawCreate(0, &LPDDO, 0) != DD_OK) { LPDDO = NULL; }
  ddmx = (ddm_xhdr *) GetMem(sizeof(ddmx[0]));
  if (ddmx) {
    // fill with stubs so called but missing function can be identified by address
    FillWithStub((DWORD *) ddmx->list, 23, 0xD1); // (D)irect (1)nterface
    // fill with the actual structs
    // IUnknown methods
//    ddmx->list[ 0] = (void *) DD_QueryInterface;
//    ddmx->list[ 1] = (void *) DD_AddRef;
    ddmx->list[ 2] = (void *) DD_Release; // !
    // IDirectDraw methods
//    ddmx->list[ 3] = (void *) DD_Compact;
//    ddmx->list[ 4] = (void *) DD_CreateClipper;
    ddmx->list[ 5] = (void *) DD_CreatePalette; // !
    ddmx->list[ 6] = (void *) DD_CreateSurface; // !
//    ddmx->list[ 7] = (void *) DD_DuplicateSurface;
//    ddmx->list[ 8] = (void *) DD_EnumDisplayModes;
//    ddmx->list[ 9] = (void *) DD_EnumSurfaces;
//    ddmx->list[10] = (void *) DD_FlipToGDISurface;
    ddmx->list[11] = (void *) DD_GetCaps; // !
//    ddmx->list[12] = (void *) DD_GetDisplayMode;
//    ddmx->list[13] = (void *) DD_GetFourCCCodes;
//    ddmx->list[14] = (void *) DD_GetGDISurface;
//    ddmx->list[15] = (void *) DD_GetMonitorFrequency;
//    ddmx->list[16] = (void *) DD_GetScanLine;
//    ddmx->list[17] = (void *) DD_GetVerticalBlankStatus;
//    ddmx->list[18] = (void *) DD_Initialize;
    ddmx->list[19] = (void *) DD_RestoreDisplayMode; // !
    ddmx->list[20] = (void *) DD_SetCooperativeLevel; // !
    ddmx->list[21] = (void *) DD_SetDisplayMode; // !
    ddmx->list[22] = (void *) DD_WaitForVerticalBlank; // !
    ddmx->self_ptr = &ddmx->list;
    // return result
    *lplpDD = (LPDIRECTDRAW) ddmx;
  }
  return(ddmx ? DD_OK : DDERR_GENERIC);
}

HRESULT WINAPI DDrawEnum(LPDDSURFACEDESC lpDDSurfaceDesc, LPVOID lpContext) {
DWORD *data;
  data = (DWORD *) lpContext;
  data[0] |= 2; // this one for ddraw.dll proxy/wrapper without EnumDisplayModes() emulation
  if (
    (lpDDSurfaceDesc->dwWidth == data[1]) && (lpDDSurfaceDesc->dwHeight == data[2]) &&
    (lpDDSurfaceDesc->ddpfPixelFormat.u1.dwRGBBitCount == data[3])
  ) {
    data[0] |= 1; // mode found
  }
  // stop or continue enumeration
  return((data[0] & 1) ? DDENUMRET_CANCEL : DDENUMRET_OK);
}

DWORD IsDDrawMode(DWORD dwWidth, DWORD dwHeight, DWORD dwBPP, DWORD dwDDC) {
LPDIRECTDRAW DDObj;
DWORD data[4];
  // since this hook not initialized at this point
  hook_DirectDrawCreate = (LPDIRECTDRAWCREATE) dwDDC;//BinRead(0x4BD310, 4);
  data[0] = 0; // error initialize
  DDObj = NULL;
  if (hook_DirectDrawCreate(0, &DDObj, 0) == DD_OK) {
    data[1] = dwWidth;
    data[2] = dwHeight;
    data[3] = dwBPP;
    IDirectDraw_EnumDisplayModes(DDObj, 0, NULL, &data, DDrawEnum);
    IDirectDraw_Release(DDObj);
    // since DDrawEnum() never called - probably proxy/wrapper library with limited implementation
    // assuming that the library can go to 640x480 256 colors or at least emulate something instead
    data[0] = ((data[0] ^ 2) >> 1) | (data[0] & 1); //(data[0] & 2) ? (data[0] & 1) : 1;
  }
  return(data[0]);
}
