// v1.01
// copy-pasted stub-hook code for minimal Japanese release support
// differences from English are as follows:
// - removed all movies about game development and file M.BLB with it (even menu button removed)
// - no Hall of Records, but English text, font and art still in resources (unused)
// - Japanese hints, but English text and fonts still in resources (check resources: is hints images or sprites?)
// - ingame error messages for load/save/delete games output via WinAPI TextOutA() function
// - all English text redrawn, except:
// -- credits (also added Japanese localization team)
// -- Willie room - words "Dad" and "W" on bed
// -- "The End" when jump into lake sink
// -- "BOBBY" machine puzzle

void InitHooks_jp(void) {
char s[MAX_PATH];
DWORD i;
  // read config
  bLogHash = GetIniInt(CFG_LOGHASH, 0) & 0xFF;
  ZeroMemory(sBLBPath, sizeof(sBLBPath));
  GetIniStr(CFG_BLBPATH, sBLBPath, MAX_PATH);
  // remove tail backslash if any
  i = lstrlen(sBLBPath);
  while (i--) {
    if (sBLBPath[i] != '\\') { break; }
    sBLBPath[i] = 0;
  }
  // if empty - set as DATA folder
  if (!sBLBPath[0]) {
    sBLBPath[0] = 'D';
    sBLBPath[1] = 'A';
    sBLBPath[2] = 'T';
    sBLBPath[3] = 'A';
  }
  // set debug options
  i = GetIniInt(CFG_ISDEBUG, 0) & 0x1F;
  if (i) {
    // replace intro laugh since it's annoying as hell
    // also make it clear that debug mode enabled
    // 36691914.wav - boing
    // 470007EE.wav - key drop
    BinWrite(/*0x482850*/ 0x481500, 0x470007EE, 4);
    // initially enable "fastforward"
    if (i & 0x01) { BinWrite(/*0x44FB44*/ 0x477DD4, 0x00, 1); }
    // always enable "skipper" (not a fixed addr - code patch)
    if (i & 0x02) { BinWrite(/*0x404C8B*/ 0x43AAEB, 0x00, 1); }
    // always enable scene menu (not a fixed addr - code patch)
    // since both cheats "adoctormenu" and "chatterpops" required for it
    if (i & 0x04) {
      BinWrite(/*0x425759*/ 0x406579, 0x00, 1);
      BinWrite(/*0x48A3CC*/ 0x427A9A, 0x00, 1);
    }
    // initially enable "ahourprofs" debug mode
    if (i & 0x08) {
      BinWrite(/*0x4BB24B*/ 0x4BB483, 0x01, 1); // set flag
      BinWrite(/*0x469B3E*/ 0x40104E, 0x84, 1); // mov => test
    }
  }
  // mandatory fixes: replace priveleged instruction calls
  BinWrite(/*0x450E4F*/ 0x4790DF, 0x90, 1); // cli => nop
  BinWrite(/*0x450E72*/ 0x479102, 0x90, 1); // sti => nop
  // allow cheat "ahourprofs" to be toggleable
  BinWrite(/*0x48B8F1*/ 0x42C171, 0x30, 1); // mov => xor
  // allow cheat "adoctormenu" to be toggleable
  BinWrite(/*0x48B8BE*/ 0x42C13E, 0x3080, 1); // mov => xor
  // allow cheat "chatterpops" to be toggleable
  BinWrite(/*0x48B8D0*/ 0x42C150, 0x3080, 1); // mov => xor
  // allow cheat "skipper" to be toggleable
  BinWrite(/*0x48B8AC*/ 0x42C12C, 0x3080, 1); // mov => xor
  // fix "screensnapshot" cheat: "c:\NevShot.bmp" => "NevShot.bmp"
  BinWrite(/*0x48B8D6*/ 0x42C156, BinRead(/*0x48B8D6*/ 0x42C156, 4) + 3 , 4);
  // path to CD data files
  BinWrite(/*0x48DB04*/ 0x42E314, (DWORD) sBLBPath, 4);
  // improve Smacker playback on low end systems
  BinWrite(/*0x490ADF*/ 0x49208F, BinRead(/*0x490ADF*/ 0x49208F, 4) | FILE_FLAG_SEQUENTIAL_SCAN, 4);
  // load language
  s[0] = 0;
  GetIniStr(CFG_LNGNAME, s, MAX_PATH);
  PackOpen(s, &datafile);
  // do not hook anything if no language selected
  if (datafile.dwCount) {
    // subtitles not disabled
    if (!(dwAllFlags & FLAG_SUBS)) {
      // init subtitles
      SubsData();
      // load subtitles font
      NHCLoad(0x544E4F46, NHC_FONT, subsfont, sizeof(subsfont));
      // Smacker hooks
      hook_SmackToBuffer = (LPSMACKTOBUFFER) BinRead(/*0x4BD484*/ 0x4BD4A4, 4);
      BinWrite(/*0x4BD484*/ 0x4BD4A4, (DWORD) SmackToBuffer, 4);
      hook_SmackDoFrame = (LPSMACKDOFRAME) BinRead(/*0x4BD470*/ 0x4BD4A8, 4);
      BinWrite(/*0x4BD470*/ 0x4BD4A8, (DWORD) SmackDoFrame, 4);
      // OpenAndSeekToFile()
      hook_OpenAndSeekToFile = (LPOPENANDSEEKTOFILE) /*0x490AA0*/ 0x492050;
      HookAddr((BYTE *) /*0x46432D*/ 0x42FC1D, (void *) OpenAndSeekToFile, HOOK_CALL);
      // hook DrawAnim() in SurfaceDraw2()
      hook_DrawAnim = (LPDRAWANIM) /*0x493220*/ 0x493CD0;
      HookAddr((BYTE *) /*0x492757*/ 0x490A97, (void *) DrawAnim, HOOK_CALL);
      // v1.01 Japanese only - preserve ecx register (this object)
      BinWrite(0x490A93, 0x11, 1); // mov ecx, [ecx] => mov edx, [ecx]
      BinWrite(0x490A95, 0x52, 1); // push ecx => push edx
      // hook SndGetItem() in PlaySoundFile()
      HookAddr((BYTE *) /*0x40FD14*/ 0x41CA64, (void *) SndGetItem, HOOK_CALL);
    }
    #if 0
        // probably dead code, since no text notes or walls used in Japanese release
        // all text resources in language packs except subtitles are useless
        //BinWrite(0x4309A0, (480UL << 8) | (0xB8), 3); // imul (meCharHeight * meNumRows) => mov ax, 480
        BinWrite(0x40B443, 0xB8, 1); // imul cx, [ebp+arg_4] => mov eax, 480
        BinWrite(0x40B444,  480, 4);
        // allow range 128-256 for notes/walls
        BinWrite(/*0x430AAE*/ 0x40B54E, 0xEA, 1); // sar => shr
        BinWrite(/*0x430AC3*/ 0x40B563, 0xB6, 1); // movsx => movzx
        BinWrite(/*0x430B2C*/ 0x40B5CC, 0xB6, 1); // movsx => movzx
    #endif
  }
  // mioRead()
  HookAddr((BYTE *) /*0x493E57*/ 0x494747, (void *) mioRead, HOOK_CALL);
  // mmioRead()
  hook_mmioRead = (LPMMIOREAD) BinRead(/*0x4BD500*/ 0x4BD534, 4);
  // BLBReadItem()
  hook_BLBReadItem = (LPBLBREADITEM) /*0x493EB0*/ 0x4947A0;
  HookAddr((BYTE *) /*0x491B93*/ 0x493143, (void *) BLBReadItem, HOOK_CALL);
  HookAddr((BYTE *) /*0x491B93*/ 0x493833, (void *) BLBReadItem, HOOK_CALL);
  // puzzle correct order hooks
  hook_RegLoadSavedGame = (LPREGLOADSAVEDGAME) /*0x48F3B0*/ 0x48E930;
  HookAddr((BYTE *) /*0x469BB2*/ 0x48EC27, (void *) RegLoadSavedGame, HOOK_CALL);
  GetPtrByHash = (LPGETPTRBYHASH) /*0x48F870*/ 0x48EEC0;
  GetPtrByHashIdx = (LPGETPTRBYHASHIDX) /*0x48F8A0*/ 0x48EEF0;
  GetValByHash = (LPGETVALBYHASH) /*0x48F8D0*/ 0x48EF20;
  GetValByHashIdx = (LPGETVALBYHASHIDX) /*0x48F900*/ 0x48EF50;
  InitPuzzleProc = (LPINITPUZZLEPROC) /*0x429190*/ 0x4071E0;
  // replace signed conversion with unsigned to access upper part
  // of the codepage for error messages and save/load font
  BinWrite(/*0x46A052*/ 0x444B22, 0xB6, 1); // movsx => movzx
  // registry hooks
  HookAddr((BYTE *) /*0x469C50*/ 0x401160, (void *) Reg_GetSetMusicOn, HOOK_JUMP);
  HookAddr((BYTE *) /*0x469BF0*/ 0x401100, (void *) Reg_GameDrop, HOOK_JUMP);
  HookAddr((BYTE *) /*0x469C10*/ 0x401120, (void *) Reg_GameTest, HOOK_JUMP);
  HookAddr((BYTE *) /*0x469C30*/ 0x401140, (void *) Reg_GameEnum, HOOK_JUMP);
  GameList = (LPGAMELIST) /*0x492BA0*/ 0x491740;
  BinWrite(/*0x48F3E7*/ 0x48EA37, 0xEB, 1); // Reg_OpenKey() always OK in LoadGame
  BinWrite(/*0x48F516*/ 0x48EB66, 0xEB, 1); // Reg_CreateKey() always OK in SaveGame
  // fix empty save game error message (looks like copy-pasted code mistake with old variable address)
  BinWrite(/*0x489DBD*/ 0x42752A, 0xC4, 1); // lea ecx, [ebp - 1Ch] => lea ecx, [ebp - 3Ch]
  // allow 32-255 characters range in load/save game, except 9 not allowed in filenames
  MemWrite((BYTE *) /*0x41A15F*/ 0x4690FF, (void *) lpBadCharCode, sizeof(lpBadCharCode)); // filter for load game
  MemWrite((BYTE *) /*0x486AAF*/ 0x48892F, (void *) lpBadCharCode, sizeof(lpBadCharCode)); // filter for save game
  BinWrite(/*0x460EF7*/ 0x437357, 0x00, 1); // cmp ?, 0x7E; ja ? => ja +$
  // increase max saved games from 25 (0x19) to 127 (0x7F)
  BinWrite(/*0x489B91*/ 0x4272E1, 0x7F, 1); // 0x19 => 0x7F
  // do not change threads priorities
  BinWrite(/*0x43ED66*/ 0x419EFA, 0x00, 1); // [1] THREAD_PRIORITY_ABOVE_NORMAL => [0] THREAD_PRIORITY_NORMAL
  BinWrite(/*0x43E87E*/ 0x419FCE, 0x00, 1); // [-1] THREAD_PRIORITY_BELOW_NORMAL => [0] THREAD_PRIORITY_NORMAL
  BinWrite(/*0x43E7AA*/ 0x41A4B6, 0x00, 1); // [1] THREAD_PRIORITY_ABOVE_NORMAL => [0] THREAD_PRIORITY_NORMAL
  BinWrite(/*0x4921D8*/ 0x493788, 0x00, 1); // [-1] THREAD_PRIORITY_BELOW_NORMAL => [0] THREAD_PRIORITY_NORMAL
  // hook GetNextWillieHint()
  hook_GetHintNumWilly = (LPGETHINTNUMWILLY) /*0x402C70*/ 0x4730E0; // v1.01
  HookAddr((BYTE *) /*0x4026F5*/ 0x4723A5, (void *) GetNextWillieHint, HOOK_CALL);
  // fix cursor palette in debug scene switch menu
  BinWrite(/*0x470230*/ 0x416E60, 0x00208084, 4);
  // video renderer settings
  i = dwAllFlags & FLAG_VDRD;
  // use DirectDraw Emulated
  if (i == 1) {
    // disable hardware acceleration DDCREATE_EMULATIONONLY for DirectDrawCreate()
    BinWrite(/*0x44FB7C*/ 0x477E0C, 0x02, 1);
    // skip information message since emulation forced
    BinWrite(/*0x48AD64*/ 0x42B5D9, 0xEB, 1);
  }
  // original window procedure
  hook_WndPrc = (LPWNDPRC) /*0x43EA50*/ 0x41A1A0;
  // original DirectDrawCreate
  hook_DirectDrawCreate = (LPDIRECTDRAWCREATE) /*0x48DCD8*/ 0x48E5B8;
  // use compatibility renderer
  if (i == 2) {
    // hook call to DirectDrawCreate
    HookAddr((BYTE *) /*0x44FB83*/ 0x477E13, (void *) DirectDrawCreate, HOOK_CALL);
    // hook window procedure
    BinWrite(/*0x43EE45*/ 0x41A5B5, (DWORD) WndPrc, 4);
    // disable minimizing by ShowWindow() when focus lost: SW_SHOWMINNOACTIVE => SW_SHOWNA
    BinWrite(/*0x44FE70*/ 0x478100, SW_SHOWNA, 1);
    // never hide Windows cursor
    BinWrite(/*0x43E7ED*/ 0x419F3D, 0x01, 1);
    // don't drop WS_SYSMENU style
    BinWrite(/*0x43E7E0*/ 0x419F30, 0xFF, 1);
    // don't add WS_SYSMENU style
    BinWrite(/*0x43E837*/ 0x419F87, 0x00, 1);
  } else {
    // hook anyway for few features
    BinWrite(/*0x43EE45*/ 0x41A5B5, (DWORD) WndPrcCtrl, 4);
  }
}
