// build with GCC 3.2 (mingw special 20020817-1) from Dev-CPP 4.9.8.0

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <mmsystem.h>
#include <commctrl.h>
#include "language.h"

//#define DEBUGLOG 1

#define EXPORT __declspec(dllexport)

#define PCSD __attribute__ ((aligned(1))) const static

// subtitle
#include "subtitle.c"
// packfile
#include "packfile.c"

// external file flag
#define EXT_FLAG 0x80000000

#pragma pack(push, 1)
typedef struct {
  DWORD dwMagic;
  WORD  wVersion;
  WORD  wDataSize;
  DWORD dwFileSize;
  DWORD dwCount;
} blb_head;

typedef struct {
  BYTE  bFileType;
  BYTE  bPackType;
  WORD  wDataIndex;
  DWORD dwTimeStamp;
  DWORD dwFileOffs;
  DWORD dwPackSize;
  DWORD dwFileSize;
} blb_item;
#pragma pack(pop)

#define CFG_BLBPATH 3
#define CFG_MUSICON 4
#define CFG_CONFIGS 5
#define CFG_LOGHASH 6
#define CFG_ISDEBUG 7
#define CFG_LNGNAME 8
PCSD char stConfig[][8] = {
/*0*/".\\langua",
/*1*/"ge.ini",
/*2*/"nhc",
/*3*/"BLBPath",
/*4*/"MusicOn",
/*5*/"Configs",
/*6*/"LogHash",
/*7*/"IsDebug",
/*8*/"LngName"
};

PCSD TCHAR TTC[] = TOOLTIPS_CLASS;

// hash types to log for debug
static BYTE bLogHash;
// path to the game resource archives
static char sBLBPath[MAX_PATH];
// v1.01
static BYTE bEnglish;

// configuration flags
#define FLAG_VDRD 0x03
#define FLAG_LONG 0x04
#define FLAG_WIND 0x08
#define FLAG_LOCK 0x10
#define FLAG_HOLD 0x20
#define FLAG_MBTN 0x40
#define FLAG_JOYS 0x80
#define FLAG_SUBS 0x100
static DWORD dwAllFlags;
// selected data file from language packs
static nhc_file datafile;

// error text messages addresses
// "push <addr>" offsets (+1 byte to skip actual push command)
#define TEXTSIZE 33
PCSD DWORD textaddr[TEXTSIZE] = {
  0x489DA2 + 1, // [A1] Error loading game
  0x489DAF + 1, // [A2] or game not found
  0x489DB6 + 1, // [B1] Error saving game
  0x489DC3 + 1, // [B2] or maximum games saved
  0x489DCA + 1, // [C1] Maximum number of saved
  0x489DD7 + 1, // [C2] games reached
  0x48A122 + 1, // [D1] Game exists.
  0x48A11A + 1, // [D2] Overwrite it?
  0x489DDE + 1, // [E1] <empty line, but can be used>
  0x489DEB + 1, // [E2] Error deleting game
  0x489DF2 + 1, // [F1] <empty line, but can be used>
  0x489DFF + 1, // [F2] No games are saved
  0x489E06 + 1, // [G0] Game not loaded.
  0x489E0D + 1, // [H0] Game not saved.
  0x489E14 + 1, // [I0] Game not deleted.
  0x489E21 + 1, // [0] Need name of game.
  0x489D98 + 1, // Unknown error
  0x48ABD0 + 1, // [J1] Error initializing sound for movies // SmackSoundUseDirectSound() failed
  0x48ABE0 + 1, // [J2] <empty line, but can be used>
  0x48ABF0 + 1, // [J3] <empty line, but can be used>
  0x48AC27 + 1, // [K1] Your system may not have
  0x48AC37 + 1, // [K2] enough free disk space to
  0x48AC47 + 1, // [K3] run this game properly
  0x48AD66 + 1, // [L1] DirectDraw reports that your    // DirectDraw.GetCaps(drv, hal)
  0x48AD76 + 1, // [L2] video hardware may not be able  // #define DDCAPS_NOHARDWARE 0x02000000l
  0x48AD86 + 1, // [L3] to run this game properly       // Indicates that there is no hardware support.
  0x48ACBE + 1, // [M] Unable to initialize DirectDraw.
  0x48AD01 + 1, // [N] Unable to initialize DirectDraw.
  0x48ABA2 + 1, // [O] Error initializing DirectSound
  0x43EEC1 + 1, // [P] Error creating window.
  0x48AC7B + 1, // [Q] Error reading CD-ROM
  0x43EB23 + 1, // [R] Error reading CD-ROM.\nPlease Insert the Neverhood CD.
  0x43ED04 + 1  // [S] %s is running already.
};

// error text messages buffer
static sub_item textdata[TEXTSIZE];

typedef void (WINAPI *LPSMACKTOBUFFER)(void *smk, DWORD left, DWORD top, DWORD pitch, DWORD height, void *buf, DWORD flags);
typedef int (WINAPI *LPSMACKDOFRAME)(DWORD *smk);
typedef HANDLE (WINAPIV *LPOPENANDSEEKTOFILE)(DWORD hash);
typedef BOOL (WINAPI *LPBLBREADITEM)(HPSTR buf, DWORD idx, DWORD len);
typedef LONG (WINAPI *LPMMIOREAD)(HMMIO hmmio, HPSTR pch, LONG cch);

static LPSMACKTOBUFFER hook_SmackToBuffer;
static LPSMACKDOFRAME hook_SmackDoFrame;
static LPOPENANDSEEKTOFILE hook_OpenAndSeekToFile;
static LPBLBREADITEM hook_BLBReadItem;
static LPMMIOREAD hook_mmioRead; // this one used only to drop WINMM.DLL from import of this library

#ifdef DEBUGLOG
void WINAPIV DebugOut(const TCHAR *fmt, ...) {
TCHAR s[1025];
va_list args;
  va_start(args, fmt);
  wvsprintf(s, fmt, args);
  va_end(args);
  OutputDebugString(s);
}
#else
#define DebugOut(x,...)
#endif

void MemWrite(void *p, void *b, DWORD l) {
DWORD dx;
  if (p && b && l && VirtualProtect(p, l, PAGE_READWRITE, &dx)) {
    CopyMemory(p, b, l);
    VirtualProtect(p, l, dx, &dx);
    FlushInstructionCache(GetCurrentProcess(), p, l);
  }
}

DWORD BinRead(DWORD a, DWORD l) {
DWORD r;
  r = 0;
  CopyMemory(&r, (BYTE *) a, (l % 5));
  return(r);
}

void BinWrite(DWORD a, DWORD v, DWORD l) {
  MemWrite((BYTE *) a, &v, (l % 5));
}

#define HOOK_NONE 0x00
#define HOOK_CALL 0xE8
#define HOOK_JUMP 0xE9
void HookAddr(void *hd, void *hs, DWORD ht) {
BYTE *d, *s;
  d = hd;
  s = hs;
  // need to add jump / call instruction
  if (ht != HOOK_NONE) {
    MemWrite(d, &ht, 1);
    // recalc addr
    s -= (((SIZE_T) d) + 5);
    d++; // skip call / jump instruction
  }
  MemWrite(d, &s, 4);
}

// new item types, not present in game archives
#define NHC_FONT 11
#define NHC_TEXT 12
#define NHC_SUBS 13

DWORD NHCLoad(DWORD hash, BYTE type, void *buff, DWORD size) {
DWORD dw;
  dw = PackFind(&datafile, hash, type);
  if (dw) { dw = PackRead(&datafile, dw - 1, buff, size); }
  return(dw);
}

// helps a lot to find which resources actually used on a certain scene
// run game in windowed mode and don't forget to delete hashlist.log before going to required scene
// (that's why this file always reopened, so it can be deleted when game is idle)
void DumpHash(DWORD hash) {
char s[16];
HANDLE fl;
  fl = CreateFileA("hashlist.log", GENERIC_WRITE, 0, NULL, OPEN_ALWAYS, 0, 0);
  if (fl != INVALID_HANDLE_VALUE) {
    wsprintf(s, "%08X\r\n", hash);
    SetFilePointer(fl, 0, NULL, FILE_END);
    WriteFile(fl, s, 10, &hash, NULL);
    CloseHandle(fl);
  }
}

// OK
DWORD GetIniInt(const DWORD name, DWORD value) {
  return(GetPrivateProfileInt(stConfig[2], stConfig[name], value, stConfig[0]));
}

// OK
void PutIniInt(const DWORD name, DWORD value) {
char s[16];
  wsprintf(s, "%u", value);
  WritePrivateProfileString(stConfig[2], stConfig[name], s, stConfig[0]);
}

// OK
void GetIniStr(const DWORD name, char *data, DWORD size) {
char s;
  if (data && size) {
    s = 0;
    GetPrivateProfileString(stConfig[2], stConfig[name], &s, data, size, stConfig[0]);
  }
}

// OK
void PutIniStr(const DWORD name, char *data) {
  if (data) {
    WritePrivateProfileString(stConfig[2], stConfig[name], data, stConfig[0]);
  }
}

// puzzle order created
#define HASH_CREATED (0xDE2EC914)
// correct puzzle order
#define HASH_CORRECT (0xD4B2089C)
// current puzzle order
#define HASH_CURRENT (0xE11A1929)

// some helpers function
typedef BYTE  (WINAPIV *LPREGLOADSAVEDGAME)(HKEY hRootKey, LPCSTR lpSubKey, LPCSTR lpValueName);
typedef void* (WINAPIV *LPGETPTRBYHASH)(DWORD hash);
typedef void* (WINAPIV *LPGETPTRBYHASHIDX)(DWORD hash, DWORD idx);
typedef DWORD (WINAPIV *LPGETVALBYHASH)(DWORD hash);
typedef DWORD (WINAPIV *LPGETVALBYHASHIDX)(DWORD hash, DWORD idx);
typedef void  (WINAPIV *LPINITPUZZLEPROC)(void);
static LPREGLOADSAVEDGAME hook_RegLoadSavedGame;
static LPGETPTRBYHASH GetPtrByHash;
static LPGETPTRBYHASHIDX GetPtrByHashIdx;
static LPGETVALBYHASH GetValByHash;
static LPGETVALBYHASHIDX GetValByHashIdx;
static LPINITPUZZLEPROC InitPuzzleProc;

// this function localize crystal color machine puzzle for different languages
BYTE WINAPIV RegLoadSavedGame(HKEY hRootKey, LPCSTR lpSubKey, LPCSTR lpValueName) {
DWORD i, r, o[5][2];
  // call original handler
  r = hook_RegLoadSavedGame(hRootKey, lpSubKey, lpValueName);
  // game sucessfully loaded - apply crystal machine puzzle fix
  if (r) {
    // check that puzzle already created
    if (LOBYTE(GetValByHash(HASH_CREATED)) == 1) {
      // save old order
      for (i = 0; i < 5; i++) {
        o[i][0] = GetValByHashIdx(HASH_CORRECT, i);
        o[i][1] = GetValByHashIdx(HASH_CURRENT, i);
      }
      // drop puzzle state
      *((BYTE *) GetPtrByHash(HASH_CREATED)) = 0;
      // reinit puzzle - reset all states
      InitPuzzleProc();
      // update current order
      for (i = 0; i < 5; i++) {
        *((DWORD *) GetPtrByHashIdx(HASH_CURRENT, i)) =
          (GetValByHashIdx(HASH_CORRECT, i) + 6 -
            // how much steps before correct color
            ((o[i][0] + 6 - o[i][1]) % 6)
          ) % 6;
      }
    }
  }
  return(r);
}

void LoadSubtitles(DWORD hash) {
BYTE b;
  // last opened file
  subh = hash;
  // set correct frame buffer
  SubsType(hash);
  // drop current subtitle index
  subi = 0;
  // load subtitles
  subl = NHCLoad(hash, NHC_SUBS, subslist, sizeof(subslist)) / sizeof(subslist[0]);
  // can't show normal and extended subtitles at the same time
  if (subl) { subx = 0; }
  // allow extended subs only for specific videos
  if (subx) {
    // check for specific scene and position (2 - spot out of tunnel; 7 - cutscene with pot)
    b = BinRead(bEnglish ? 0x4BB248 : 0x4BB480, 1); // v1.01
    if ((GetValByHash(0x91080831) != 0x0002C818) || ((b != 2) && (b != 7))) { subx = 0; }
  }
}

HANDLE WINAPIV OpenAndSeekToFile(DWORD hash) {
HANDLE result;
DWORD dw;
  // log Smacker videos here
  if ((bLogHash == 0xFF) || (bLogHash == 10)) { DumpHash(hash); }
  // load Smacker video
  dw = PackFind(&datafile, hash, 10);
  if (dw) {
    // video found in language pack
    result = CreateFile(datafile.lpName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, 0);
  } else {
    result = INVALID_HANDLE_VALUE;
  }
  // new video found
  if (result != INVALID_HANDLE_VALUE) {
    // seek to the video start
    SetFilePointer(result, datafile.list[dw - 1].dwFileOffs, NULL, FILE_BEGIN);
  } else {
    // not in language pack or some error - load original
    result = hook_OpenAndSeekToFile(hash);
  }
  if (result != INVALID_HANDLE_VALUE) {
    // try to load subtitles
    LoadSubtitles(hash);
  }
  return(result);
}

// for Russian versions fixes
#include "rusfixes.c"

BOOL WINAPI BLBReadItem(HPSTR buf, WORD idx, DWORD len) {
DWORD *recx, *hash;
blb_item *item;
BOOL result;
  __asm__ __volatile__ ("movl %%ecx, %0" : "=m"(recx) : : "%ecx");
  result = FALSE;
  if (recx[4]) {
    hash = (DWORD *) recx[21];
    item = (blb_item *) recx[22];
    // everything except Smacker videos logged here
    if ((bLogHash == 0xFF) || (bLogHash == item[idx].bFileType)) { DumpHash(hash[idx]); }
    // got external file flag
    if (item[idx].dwFileOffs & EXT_FLAG) {
      PackRead(&datafile, item[idx].dwFileOffs ^ EXT_FLAG, buf, len ? len : item[idx].dwFileSize);
      result = TRUE;
    } else {
      // load original file
      __asm__ __volatile__ ("movl %0, %%ecx" : "=m"(recx) : : "%ecx");
      result = hook_BLBReadItem(buf, idx, len);
      // apply fixes for Russian versions
      if (result) {
        ApplyBLBFixes(hash[idx], &item[idx], (BYTE *) buf, len ? len : item[idx].dwFileSize);
      }
    }
  }
  return(result);
}

typedef DWORD (WINAPI *LPGETHINTNUMWILLY)(void);
static LPGETHINTNUMWILLY hook_GetHintNumWilly;

// v1.01
DWORD WINAPI GetNextWillieHint(void) {
DWORD n;
  n = GetValByHash(0x8A140C21);
  // 0..10
  *((DWORD *)GetPtrByHash(0x8A140C21)) = ((n + 1) % 11);
  // 0..9 => 30..39 - jokes
  // 10 => repeat actual useful hint
  n = (n < 10) ? (n + 30) : hook_GetHintNumWilly();
  return(n);
}

// "Klaymen, up here!" sound file loader
DWORD WINAPI *SndGetItem(WORD idx) {
DWORD *recx;
  __asm__ __volatile__ ("movl %%ecx, %0" : "=m"(recx) : : "%ecx");
  recx = (DWORD *) (*recx + (idx << 3));
  recx = (DWORD *) recx[1];
  // 2.5 seconds x 15 FPS = 37.5 => 38 frames
  if (*recx == 0x74E01054) {
    LoadSubtitles(*recx);
    // subtitles loaded
    if (subl) {
      subl = 0;
      subx = subslist[0].till;
    }
  }
  return(recx);
}

LONG WINAPI mioRead(HPSTR pch, LONG cch) {
DWORD *recx, *hash, r, i, j;
BYTE *stab;
blb_head *head;
blb_item *item;
  __asm__ __volatile__ ("movl %%ecx, %0" : "=m"(recx) : : "%ecx");
  if (recx[4]) {
    r = hook_mmioRead((HMMIO) recx[4], pch, cch);
    head = (blb_head *) &recx[9];
    hash = (DWORD *)    recx[21];
    item = (blb_item *) recx[22];
    stab = (BYTE *)     recx[24];
    // fix item table if file to replace exists
    for (i = 0; i < head->dwCount; i++) {
      // v1.02 - keep some original resources for Japanese version
      if (!bEnglish) {
        if (
          // original stWillieHints text required for hints to work properly
          (hash[i] == 0x80283101) ||
          // pict first wall with prologue (without texts and pictures)
          (hash[i] == 0x41983216) ||
          // pict bgArven07 (without texts and pictures)
          (hash[i] == 0x11840E24) ||
          // pict bgArven07Dark (without texts and pictures)
          (hash[i] == 0x25848E24)
        ) { continue; }
      }
      // apply fixes for Russian versions
      ApplyTOCFixes(hash[i], &item[i]);
      // find file to replace
      j = PackFind(&datafile, hash[i], item[i].bFileType);
      if (j) {
        j--;
        // sound or music and shift table existed
        if (((item[i].bFileType == 7) || (item[i].bFileType == 8)) && (stab) && (head->wDataSize)) {
          // non-zero (if zero this sound file disabled) and inside index table
          if ((item[i].wDataIndex) && (item[i].wDataIndex <= head->wDataSize)) {
            stab[item[i].wDataIndex - 1] = 0xFF; // mark as uncompressed (16-bit mono 22050 Hz)
          }
        }
        item[i].bPackType = 1; // uncompressed file
        item[i].dwPackSize = datafile.list[j].dwFileSize; // packed file size (size in archive)
        item[i].dwFileSize = datafile.list[j].dwFileSize; // same as packed size for uncompressed file
        item[i].dwFileOffs = j | EXT_FLAG; // external file flag (invalid offset)
      }
    }
  } else {
    r = 0;
  }
  return(r);
}

/*
  smk[0] - SMK2
  smk[1] - width
  smk[2] - height
  smk[3] - total frames
  smk[25] - extra (should be zero) - store file hash here
  smk[26] - non-zero if palette changed at this frame
  smk[27] - 6 bit VGA palette (256 * 3)
  smk[220] - current frame (zero based)
  226 - left
  227 - top
*/
void WINAPI SmackToBuffer(DWORD *smk, DWORD left, DWORD top, DWORD pitch, DWORD height, void *buf, DWORD flags) {
  // new video
  if (!smk[25]) {
    // new video - save hash
    smk[25] = subh;
  } else {
    // test for old video - this need when game video was interrupted
    // with menu "About..." video which will screw subtitles code
    if (smk[25] != subh) {
      // reload subtitles and update subh
      LoadSubtitles(smk[25]);
      // reinit subtitles settings
      SubsInit(0, left, top, pitch, height, smk[1], buf, flags);
    }
  }
  // init subtitles
  SubsInit(smk[220], left, top, pitch, height, smk[1], buf, flags);
  // prepare frame
  hook_SmackToBuffer(smk, left, top, pitch, height, buf, flags);
}

int WINAPI SmackDoFrame(DWORD *smk) {
int r;
  // render new frame to the buffer
  r = hook_SmackDoFrame(smk);
  // render subtitles on top of the new frame
  SubsDraw(0x00);
  return(r);
}

typedef DWORD (WINAPIV *LPDRAWANIM)(BYTE *frame, DWORD fpos, BYTE *buf, DWORD pitch, BYTE brevx, BYTE brevy);
static LPDRAWANIM hook_DrawAnim;

// "Hey, Klaymen, say knock-knock!"
// posyx - LOWORD(x), HIWORD(y)
DWORD WINAPIV DrawAnim(BYTE *frame, DWORD posyx, BYTE *buf, DWORD pitch, BYTE flipx, BYTE flipy) {
DWORD *recx, redi, r;
  __asm__ __volatile__ ("movl %%ecx, %0" : "=m"(recx) : : "%ecx");
  __asm__ __volatile__ ("movl %%edi, %0" : "=m"(redi) : : "%edi");
  r = hook_DrawAnim(frame, posyx, buf, pitch, flipx, flipy);
  // redi - frame number
  if (recx && recx[4] && (*((DWORD *) (recx[4] - 8)) == 0x4919397A)) {
    // 14.25 (114 / 8) chars max for knock-knock
    // 0..34 - frames; 128 - pitch; 114 - min width; 88 - min height
//    DebugOut("%02u: %u (%ux%u) %u %u", redi, pitch, LOWORD(posyx), HIWORD(posyx), flipx, flipy);
    // first frame or return from "About..." - load subtitles
    if ((!redi) || (subh != 0x4919397A)) {
      LoadSubtitles(0x4919397A);
      SubsInit(0, LOWORD(posyx), HIWORD(posyx), pitch, 88 - 1, pitch, buf, MAKEWORD(flipy, flipx));
    }
    // subtitles loaded
    if (subl) {
      // init subtitles
      SubsInit(redi, LOWORD(posyx), HIWORD(posyx), pitch, 88 - 1, pitch, buf, MAKEWORD(flipy, flipx));
      // skip first frame since it is already on scene and waiting before sound to play
      // which will render subtitles too early and last frame must be skipped because
      // it will overwrite and hide subtitles from animation and scene
      if ((redi > 0) && ((redi + 1) < *((DWORD *) (recx[4] - 4)))) {
        // shift to x position to avoid text left/right moving
        // add 8 pixels padding at left to avoid text corruption
        subv.addr += (LOWORD(posyx) + 8);
        // render subtitles (on that scene black color has 0x01 index in palette)
        SubsDraw(0x01);
        // return everything back
        subv.addr -= (LOWORD(posyx) + 8);
      }
    }
  }
  return(r);
}

// OK
void MakeName(char *d, char *s) {
  wsprintf(d, "SAVE\\%s.sav", s);
  while (*d) {
    if (*d == ' ') { *d = '_'; }
    d++;
  }
}

// change music state
void WINAPI Reg_GetSetMusicOn(BYTE *ptrval, BYTE bsetval) {
  if (bsetval) {
    PutIniInt(CFG_MUSICON, *ptrval ? 1 : 0);
  } else {
    *ptrval = GetIniInt(CFG_MUSICON, 1) ? 1 : 0;
  }
}

// check if saved game exists
BOOL WINAPI Reg_GameTest(char *name) {
char s[40];
DWORD fa;
  MakeName(s, name);
  fa = GetFileAttributes(s);
  return((fa != INVALID_FILE_ATTRIBUTES) && (!(fa & FILE_ATTRIBUTE_DIRECTORY)));
}

// delete saved game
BOOL WINAPI Reg_GameDrop(char *name) {
char s[40];
  MakeName(s, name);
  return(DeleteFile(s));
}

// internal function required by Reg_GameEnum()
typedef void (WINAPI *LPGAMELIST)(char *name);
static LPGAMELIST GameList;

// enumerates saved game files
BOOL WINAPI Reg_GameEnum(DWORD *recx) {
WIN32_FIND_DATA fd;
char s[40];
HANDLE fh;
DWORD i, l;
  i = 0;
  MakeName(s, "*");
  fh = FindFirstFile(s, &fd);
  if (fh != INVALID_HANDLE_VALUE) {
    do {
      l = lstrlen(fd.cFileName);
      if ((!(fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) && (l > 4) && (l < 34)) {
        l -= 4;
        fd.cFileName[l] = 0; // cut ".sav" extension
        while (l--) {
          fd.cFileName[l] = (fd.cFileName[l] == '_') ? ' ' : fd.cFileName[l];
        }
        __asm__ __volatile__ ("movl %0, %%ecx" : "=m"(recx) : : "%ecx");
        GameList(fd.cFileName);
        i++;
      }
    } while (FindNextFile(fh, &fd));
    FindClose(fh);
  }
  return(i > 0);
}

// load saved game
BOOL Reg_GameLoad(char *name, BYTE *buff, DWORD *size) {
char s[40];
HANDLE fl;
DWORD dw;
  dw = 0;
  if (size || (buff && size)) {
    MakeName(s, name);
    fl = CreateFileA(s, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, 0);
    if (fl != INVALID_HANDLE_VALUE) {
      if (!buff) {
        *size = GetFileSize(fl, NULL);
        dw = *size;
      } else {
        dw = (ReadFile(fl, buff, *size, &dw, NULL) && (*size == dw));
      }
      CloseHandle(fl);
    }
  }
  return(dw ? TRUE : FALSE);
}

// stores saved game
BOOL Reg_GameSave(char *name, BYTE *buff, DWORD size) {
char s[40];
HANDLE fl;
DWORD dw;
  dw = 0;
  if (buff && size) {
    MakeName(s, name);
    // make path
    for (dw = 0; s[dw]; dw++) {
      if ((s[dw] == '\\') || (s[dw] == '/')) {
        s[dw] = 0;
        if (GetFileAttributes(s) == INVALID_FILE_ATTRIBUTES) {
          CreateDirectory(s, NULL);
        }
        s[dw] = '\\';
      }
    }
    fl = CreateFileA(s, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
    if (fl != INVALID_HANDLE_VALUE) {
      dw = (WriteFile(fl, buff, size, &dw, NULL) && (size == dw));
      CloseHandle(fl);
    }
  }
  return(dw ? TRUE : FALSE);
}

// ***************************************************************************

// replace exactly 43 bytes long old comparison code
// this new code allows any character bigger or equal to space (32)
// excluding nine that not allowed in the filename: " * / : < > ? \ |
PCSD BYTE lpBadCharCode[43] = {
  0x51, // push ecx
  0x50, // push eax
  0x89, 0xF8, // mov eax, edi
  0xE8, 0x09, 0x00, 0x00, 0x00, // call @f
  0x22, 0x2A, 0x2F, 0x3A, 0x3C, 0x3E, 0x3F, 0x5C, 0x7C, // db '"*/:<>?\|'
  0x5F, // @@: pop edi
  0x31, 0xC9, // xor ecx, ecx
  0xB1, 0x09, // mov cl, 9
  0xFC, // cld
  0xF2, 0xAE, // repne scasb
  0x89, 0xC7, // mov edi, eax
  0x58, // pop eax
  0x59, // pop ecx
  0x75, 0x02, // jnz @f
  0x31, 0xFF, // xor edi, edi
  0x83, 0xFF, 0x20, // @@: cmp edi, 20h
  0x0F, 0x82, 0xA8, 0x01, 0x00, 0x00 // jb $ + 01A8h + 6
};

#include "ddrawgdi.c"

// v1.01
#include "japanese.c"

void InitHooks(void) {
char s[MAX_PATH];
WORD data[68 / 2];
DWORD i, j;
  // read config
  bLogHash = GetIniInt(CFG_LOGHASH, 0) & 0xFF;
  ZeroMemory(sBLBPath, sizeof(sBLBPath));
  GetIniStr(CFG_BLBPATH, sBLBPath, MAX_PATH);
  // remove tail backslash if any
  i = lstrlen(sBLBPath);
  while (i--) {
    if (sBLBPath[i] != '\\') { break; }
    sBLBPath[i] = 0;
  }
  // if empty - set as DATA folder
  if (!sBLBPath[0]) {
    sBLBPath[0] = 'D';
    sBLBPath[1] = 'A';
    sBLBPath[2] = 'T';
    sBLBPath[3] = 'A';
  }
  // set debug options
  i = GetIniInt(CFG_ISDEBUG, 0) & 0x1F;
  if (i) {
    // replace intro laugh since it's annoying as hell
    // also make it clear that debug mode enabled
    // 36691914.wav - boing
    // 470007EE.wav - key drop
    BinWrite(0x482850, 0x470007EE, 4);
    // initially enable "fastforward"
    if (i & 0x01) { BinWrite(0x44FB44, 0x00, 1); }
    // always enable "skipper" (not a fixed addr - code patch)
    if (i & 0x02) { BinWrite(0x404C8B, 0x00, 1); }
    // always enable scene menu (not a fixed addr - code patch)
    // since both cheats "adoctormenu" and "chatterpops" required for it
    if (i & 0x04) {
      BinWrite(0x425759, 0x00, 1);
      BinWrite(0x48A3CC, 0x00, 1);
    }
    // initially enable "ahourprofs" debug mode
    if (i & 0x08) {
      BinWrite(0x4BB24B, 0x01, 1); // set flag
      BinWrite(0x469B3E, 0x84, 1); // mov => test
    }
  }
  // mandatory fixes: replace priveleged instruction calls
  BinWrite(0x450E4F, 0x90, 1); // cli => nop
  BinWrite(0x450E72, 0x90, 1); // sti => nop
  // allow cheat "ahourprofs" to be toggleable
  BinWrite(0x48B8F1, 0x30, 1); // mov => xor
  // allow cheat "adoctormenu" to be toggleable
  BinWrite(0x48B8BE, 0x3080, 1); // mov => xor
  // allow cheat "chatterpops" to be toggleable
  BinWrite(0x48B8D0, 0x3080, 1); // mov => xor
  // allow cheat "skipper" to be toggleable
  BinWrite(0x48B8AC, 0x3080, 1); // mov => xor
  // fix "screensnapshot" cheat: "c:\NevShot.bmp" => "NevShot.bmp"
  BinWrite(0x48B8D6, BinRead(0x48B8D6, 4) + 3 , 4);
  // path to CD data files
  BinWrite(0x48DB04, (DWORD) sBLBPath, 4);
  // improve Smacker playback on low end systems
  BinWrite(0x490ADF, BinRead(0x490ADF, 4) | FILE_FLAG_SEQUENTIAL_SCAN, 4);
  // load language
  s[0] = 0;
  GetIniStr(CFG_LNGNAME, s, MAX_PATH);
  PackOpen(s, &datafile);
  // do not hook anything if no language selected
  if (datafile.dwCount) {
    // subtitles not disabled
    if (!(dwAllFlags & FLAG_SUBS)) {
      // init subtitles
      SubsData();
      // load subtitles font
      NHCLoad(0x544E4F46, NHC_FONT, subsfont, sizeof(subsfont));
      // Smacker hooks
      hook_SmackToBuffer = (LPSMACKTOBUFFER) BinRead(0x4BD484, 4);
      BinWrite(0x4BD484, (DWORD) SmackToBuffer, 4);
      hook_SmackDoFrame = (LPSMACKDOFRAME) BinRead(0x4BD470, 4);
      BinWrite(0x4BD470, (DWORD) SmackDoFrame, 4);
      // OpenAndSeekToFile()
      hook_OpenAndSeekToFile = (LPOPENANDSEEKTOFILE) 0x490AA0;
      HookAddr((BYTE *) 0x46432D, (void *) OpenAndSeekToFile, HOOK_CALL);
      // hook DrawAnim() in SurfaceDraw2()
      hook_DrawAnim = (LPDRAWANIM) 0x493220;
      HookAddr((BYTE *) 0x492757, (void *) DrawAnim, HOOK_CALL);
      // hook SndGetItem() in PlaySoundFile()
      HookAddr((BYTE *) 0x40FD14, (void *) SndGetItem, HOOK_CALL);
    }
    // non-original asRecFont records for font garniture exists
    i = PackFind(&datafile, 0x0002486A, 0x05);
    if (i) {
      // detect modified garniture
      if (
        (PackRead(&datafile, i - 1, data, sizeof(data)) == sizeof(data)) &&
        (data[0x32 / 2] ==  14) && // 0434000D meNumRows
        (data[0x36 / 2] ==  32) && // 240C2022 meFirstChar
        (data[0x3E / 2] ==  34) && // 41050240 meCharHeight
        (data[0x42 / 2] == 224)    // 530520E0 meTracking
      ) {
        // increase text padding for left-aligned font
        BinWrite(0x402BE5, BinRead(0x402BE5, 1) + 15, 1); // notes (188)
        BinWrite(0x40935A, BinRead(0x40935A, 1) + 15, 1); // walls (95)
        // increase text padding from top since font for notes/walls
        // was reduced to hold all ANSI table from range 32..255 inclusive
        // text for walls not required to shift since its vertical positon
        // relative to the bottom of header at top where sometimes big header text placed
        BinWrite(0x402BB4, BinRead(0x402BB4, 1) + 18, 1); // notes (36)
        // since full ANSI 40x34 font will gave height 476 (14 * 34)
        // instead of 480 - patch to replace with texture real size
        BinWrite(0x4309A0, (480UL << 8) | (0xB8), 3); // imul (meCharHeight * meNumRows) => mov ax, 480
        // allow range 128-256 for notes/walls
        BinWrite(0x430AAE, 0xEA, 1); // sar => shr
        BinWrite(0x430AC3, 0xB6, 1); // movsx => movzx
        BinWrite(0x430B2C, 0xB6, 1); // movsx => movzx
      }
    }
    // text messages for load/save/delete games if messages resource found
    if (NHCLoad(0x54584554, NHC_TEXT, textdata, sizeof(textdata)) == sizeof(textdata)) {
      for (i = 0; i < TEXTSIZE; i++) {
        for (j = 0; j < TEXTSIZE; j++) {
          // only allowed address and item exists
          if ((textaddr[i] == textdata[j].from) && ((textdata[i].text[0] == '+') || (textdata[i].text[0] == '-'))) {
            // only 38 (26h) characters text length - can't fit more in the error screen space
            BinWrite(textaddr[i], (DWORD) &textdata[i].text[1], 4);
            break;
          }
        }
      }
    }
  }
  // mioRead()
  HookAddr((BYTE *) 0x493E57, (void *) mioRead, HOOK_CALL);
  // mmioRead()
  hook_mmioRead = (LPMMIOREAD) BinRead(0x4BD500, 4);
  // BLBReadItem()
  hook_BLBReadItem = (LPBLBREADITEM) 0x493EB0;
  HookAddr((BYTE *) 0x491B93, (void *) BLBReadItem, HOOK_CALL);
  HookAddr((BYTE *) 0x492283, (void *) BLBReadItem, HOOK_CALL);
  // puzzle correct order hooks
  hook_RegLoadSavedGame = (LPREGLOADSAVEDGAME) 0x48F3B0;
  HookAddr((BYTE *) 0x469BB2, (void *) RegLoadSavedGame, HOOK_CALL);
  GetPtrByHash = (LPGETPTRBYHASH) 0x48F870;
  GetPtrByHashIdx = (LPGETPTRBYHASHIDX) 0x48F8A0;
  GetValByHash = (LPGETVALBYHASH) 0x48F8D0;
  GetValByHashIdx = (LPGETVALBYHASHIDX) 0x48F900;
  InitPuzzleProc = (LPINITPUZZLEPROC) 0x429190;
  // replace signed conversion with unsigned to access upper part
  // of the codepage for error messages and save/load font
  BinWrite(0x46A052, 0xB6, 1); // movsx => movzx
  // registry hooks
  HookAddr((BYTE *) 0x469C50, (void *) Reg_GetSetMusicOn, HOOK_JUMP);
  HookAddr((BYTE *) 0x469BF0, (void *) Reg_GameDrop, HOOK_JUMP);
  HookAddr((BYTE *) 0x469C10, (void *) Reg_GameTest, HOOK_JUMP);
  HookAddr((BYTE *) 0x469C30, (void *) Reg_GameEnum, HOOK_JUMP);
  GameList = (LPGAMELIST) 0x492BA0;
  BinWrite(0x48F3E7, 0xEB, 1); // Reg_OpenKey() always OK in LoadGame
  BinWrite(0x48F516, 0xEB, 1); // Reg_CreateKey() always OK in SaveGame
  // fix empty save game error message (looks like copy-pasted code mistake with old variable address)
  BinWrite(0x489DBD, 0xC4, 1); // lea ecx, [ebp - 1Ch] => lea ecx, [ebp - 3Ch]
  // allow 32-255 characters range in load/save game, except 9 not allowed in filenames
  MemWrite((BYTE *) 0x41A15F, (void *) lpBadCharCode, sizeof(lpBadCharCode)); // filter for load game
  MemWrite((BYTE *) 0x486AAF, (void *) lpBadCharCode, sizeof(lpBadCharCode)); // filter for save game
  BinWrite(0x460EF7, 0x00, 1); // cmp ?, 0x7E; ja ? => ja +$
  // increase max saved games from 25 (0x19) to 127 (0x7F)
  BinWrite(0x489B91, 0x7F, 1); // 0x19 => 0x7F
  // do not change threads priorities
  BinWrite(0x43ED66, 0x00, 1); // [1] THREAD_PRIORITY_ABOVE_NORMAL => [0] THREAD_PRIORITY_NORMAL
  BinWrite(0x43E87E, 0x00, 1); // [-1] THREAD_PRIORITY_BELOW_NORMAL => [0] THREAD_PRIORITY_NORMAL
  BinWrite(0x43E7AA, 0x00, 1); // [1] THREAD_PRIORITY_ABOVE_NORMAL => [0] THREAD_PRIORITY_NORMAL
  BinWrite(0x4921D8, 0x00, 1); // [-1] THREAD_PRIORITY_BELOW_NORMAL => [0] THREAD_PRIORITY_NORMAL
  // hook GetNextWillieHint()
  hook_GetHintNumWilly = (LPGETHINTNUMWILLY) 0x402C70; // v1.01
  HookAddr((BYTE *) 0x4026F5, (void *) GetNextWillieHint, HOOK_CALL);
  // fix cursor palette in debug scene switch menu
  BinWrite(0x470230, 0x00208084, 4);
//  // fix credits - stops too late (202100 => 3:22.100)
//  BinWrite(0x403D2A, BinRead(0x403D2A, 2) - 592, 2); // 1224
  // video renderer settings
  i = dwAllFlags & FLAG_VDRD;
  // use DirectDraw Emulated
  if (i == 1) {
    // disable hardware acceleration DDCREATE_EMULATIONONLY for DirectDrawCreate()
    BinWrite(0x44FB7C, 0x02, 1);
    // skip information message since emulation forced
    BinWrite(0x48AD64, 0xEB, 1);
  }
  // original window procedure
  hook_WndPrc = (LPWNDPRC) 0x43EA50;
  // original DirectDrawCreate
  hook_DirectDrawCreate = (LPDIRECTDRAWCREATE) 0x48DCD8;//BinRead(0x4BD310, 4);
  // use compatibility renderer
  if (i == 2) {
    // hook call to DirectDrawCreate
    HookAddr((BYTE *) 0x44FB83, (void *) DirectDrawCreate, HOOK_CALL);
    // hook window procedure
    BinWrite(0x43EE45, (DWORD) WndPrc, 4);
    // disable minimizing by ShowWindow() when focus lost: SW_SHOWMINNOACTIVE => SW_SHOWNA
    BinWrite(0x44FE70, SW_SHOWNA, 1);
    // never hide Windows cursor
    BinWrite(0x43E7ED, 0x01, 1);
    // don't drop WS_SYSMENU style
    BinWrite(0x43E7E0, 0xFF, 1);
    // don't add WS_SYSMENU style
    BinWrite(0x43E837, 0x00, 1);
  } else {
    // hook anyway for few features
    BinWrite(0x43EE45, (DWORD) WndPrcCtrl, 4);
  }
}

static HINSTANCE hMyInstDLL;

void InitToolTip(HWND wnd) {
TOOLINFO ti;
HWND httw;
DWORD i;
  if (IsWindow(wnd)) {
    // create tooltip window
    ZeroMemory(&ti, sizeof(ti));
    ti.hinst = hMyInstDLL;
    httw = CreateWindowEx(
      0, TTC, NULL,
      WS_POPUP | TTS_ALWAYSTIP,
      CW_USEDEFAULT, CW_USEDEFAULT,
      CW_USEDEFAULT, CW_USEDEFAULT,
      wnd, NULL, 
      ti.hinst, NULL
    );
    if (httw) {
      ti.cbSize = sizeof(ti);
      ti.hwnd = wnd;
      ti.uFlags = TTF_IDISHWND | TTF_SUBCLASS;
      // set text
      for (i = IDC_LANG; i <= IDC_SUBS; i++) {
        ti.uId = (UINT_PTR) GetDlgItem(wnd, i);
        ti.lpszText = MAKEINTRESOURCE(i - IDC_LANG + IDS_LANG);
        SendMessage(httw, TTM_ADDTOOL, 0, (LPARAM) &ti);
      }
      // activate
      SendMessage(wnd, TTM_ACTIVATE, (WPARAM) TRUE, 0);
      // save handle
      SetWindowLong(wnd, GWL_USERDATA, (LONG) httw);
    }
  }
}

void FreeToolTip(HWND wnd) {
HWND httw;
  if (IsWindow(wnd)) {
    httw = (HWND) GetWindowLong(wnd, GWL_USERDATA);
    if (IsWindow(httw)) {
      // remove from userdata
      SetWindowLong(wnd, GWL_USERDATA, 0);
      // deactivate
      SendMessage(wnd, TTM_ACTIVATE, (WPARAM) FALSE, 0);
      // destroy
      SendMessage(wnd, WM_CLOSE, 0, 0);
    }
  }
}

BOOL CALLBACK DlgPrc(HWND wnd, UINT umsg, WPARAM wparm, LPARAM lparm) {
char s[MAX_PATH + 9], z[MAX_PATH];
BOOL result;
HWND wh;
DWORD i;
int n;
  result = FALSE;
  switch (umsg) {
    case WM_INITDIALOG:
      // set icon
      lparm = (LPARAM) LoadIcon(GetModuleHandle(NULL), MAKEINTRESOURCE(102));
      SendMessage(wnd, WM_SETICON, ICON_BIG  , lparm);
      SendMessage(wnd, WM_SETICON, ICON_SMALL, lparm);
      // init tooltop
      InitToolTip(wnd);
      // get language window handle
      wh = GetDlgItem(wnd, IDC_LANG);
      // build language list
      PackList(wh);
      // must be first item - LB_INSERTSTRING does not cause a list with the LBS_SORT to be sorted
      SendMessage(wh, LB_INSERTSTRING , 0, (LPARAM) "<original>");
      // select first by default
      SendMessage(wh, LB_SETCURSEL, 0, 0);
      // any language to select except "<original>"
      n = SendMessage(wh, LB_GETCOUNT, 0, 0);
      if (n > 1) {
        // read language
        z[0] = 0;
        GetIniStr(CFG_LNGNAME, z, MAX_PATH);
        // language specified
        if (z[0]) {
          for (i = 1; i < n; i++) {
            // get name
            PackName(wh, i, s);
            // check name
            if (!lstrcmpiA(z, s)) {
              // select language
              SendMessage(wh, LB_SETCURSEL, i, 0);
              break;
            }
          }
        }
      }
      // read settings
      dwAllFlags = GetIniInt(CFG_CONFIGS, IDC_VRDE - IDC_VRDH);
      for (i = IDC_LONG; i <= IDC_SUBS; i++) {
        CheckDlgButton(wnd, i, (dwAllFlags & (4 << (i - IDC_LONG))) ? BST_CHECKED : BST_UNCHECKED);
      }
      // renderer settings
      i = (dwAllFlags & FLAG_VDRD) % 3;
      // test if required by video mode 640x480 8 BPP available
      if (!IsDDrawMode(640, 480, 8, (bEnglish ? 0x48DCD8 : 0x48E5B8))) {
        // error or mode not available
        for (i = IDC_VRDH; i < IDC_VRCR; i++) {
          EnableWindow(GetDlgItem(wnd, i), FALSE);
        }
        i = IDC_VRCR - IDC_VRDH;
      }
      CheckRadioButton(wnd, IDC_VRDH, IDC_VRCR, i + IDC_VRDH);
      // update dialog controls
      PostMessage(wnd, WM_COMMAND, MAKEWPARAM(IDC_VRCR, BN_CLICKED), (LPARAM) GetDlgItem(wnd, IDC_VRCR));
      PostMessage(wnd, WM_COMMAND, MAKEWPARAM(IDC_LANG, LBN_SELCHANGE), (LPARAM) GetDlgItem(wnd, IDC_LANG));
      result = TRUE;
      break;
    case WM_COMMAND:
      if (HIWORD(wparm) == BN_CLICKED) {
        switch (LOWORD(wparm)) {
          case IDOK:
            dwAllFlags = 0;
            // video renderer
            for (i = IDC_VRDH; i <= IDC_VRCR; i++) {
              if (IsDlgButtonChecked(wnd, i) == BST_CHECKED) {
                dwAllFlags = (i - IDC_VRDH) & FLAG_VDRD;
                break;
              }
            }
            // other flags
            for (i = IDC_LONG; i <= IDC_SUBS; i++) {
              dwAllFlags |= (IsDlgButtonChecked(wnd, i) == BST_CHECKED) ? (4 << (i - IDC_LONG)) : 0;
            }
            // save settings
            PutIniInt(CFG_CONFIGS, dwAllFlags);
            // get language selection
            wh = GetDlgItem(wnd, IDC_LANG);
            n = SendMessage(wh, LB_GETCURSEL, 0, 0);
            s[0] = 0;
            // filter out "<original>"
            if (n > 0) { PackName(wh, n, s); }
            // save language
            PutIniStr(CFG_LNGNAME, s);
            // free tooltop
            FreeToolTip(wnd); // v1.02
            EndDialog(wnd, 0);
            break;
          case IDCANCEL:
            // free tooltop
            FreeToolTip(wnd);
            EndDialog(wnd, -1);
            break;
          case IDC_VRDH:
          case IDC_VRDE:
          case IDC_VRCR:
            n = (IsDlgButtonChecked(wnd, IDC_VRCR) == BST_CHECKED) ? TRUE : FALSE;
            for (i = IDC_LONG; i <= IDC_LOCK; i++) {
              EnableWindow(GetDlgItem(wnd, i), n);
            }
            break;
        }
      }
      if (wparm == MAKEWPARAM(IDC_LANG, LBN_SELCHANGE)) {
        EnableWindow(GetDlgItem(wnd, IDC_SUBS), SendMessage(GetDlgItem(wnd, IDC_LANG), LB_GETCURSEL, 0, 0) ? TRUE : FALSE);
      }
      break;
  }
  return(result);
}

typedef void (WINAPI *LPINITHEAP)(void);
static LPINITHEAP hook_InitHeap;

void WINAPI InitHeap(void) {
  // for tooltips
  InitCommonControls();
  // load and ask for settings
  dwAllFlags = 0;
  if (DialogBox(hMyInstDLL, MAKEINTRESOURCE(IDD_FORM), 0, &DlgPrc) == -1) {
    ExitProcess(0);
  }
  // init hooks and other code
  if (bEnglish) {
    InitHooks();
  } else {
    // v1.01
    InitHooks_jp();
  }
  // call original code
  hook_InitHeap = (LPINITHEAP) (bEnglish ? 0x4986B0 : 0x498FD0);
  hook_InitHeap();
}

BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved) {
BOOL result;
DWORD dw;
  result = TRUE;
  if (fdwReason == DLL_PROCESS_ATTACH) {
    DisableThreadLibraryCalls(hinstDLL);
    // no language file
    PackInit(&datafile);
    // NHC.EXE build time
    dw = BinRead(0x400088, 4);
    // v1.01
    result = ((dw == 0x323D0B33) || (dw == 0x3447586B));
    if (result) {
      // English or Japanese
      bEnglish = (dw == 0x323D0B33) ? 1 : 0; // v1.01
      hMyInstDLL = hinstDLL;
      // hook InitHeap() call since all structures
      // need to be initialized as soon as possible
      HookAddr((BYTE *) (bEnglish ? 0x494F91 : 0x495841), (void *) InitHeap, HOOK_CALL); // v1.01
    }
  }
  if (fdwReason == DLL_PROCESS_DETACH) {
    // cleanup
    PackFree(&datafile);
  }
  return(result);
}

EXPORT LONG WINAPI RegDeleteKeyA(HKEY hKey, LPCSTR lpSubKey) {
  return(ERROR_NOT_SUPPORTED);
}

EXPORT LONG WINAPI RegCloseKey(HKEY hKey) {
  return(ERROR_NOT_SUPPORTED);
}

EXPORT LONG WINAPI RegQueryValueExA(
  HKEY hKey, LPCSTR lpValueName, LPDWORD lpReserved,
  LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData
) {
  return(Reg_GameLoad((char *) lpValueName, lpData, lpcbData) ? ERROR_SUCCESS : ERROR_NOT_SUPPORTED);
}

EXPORT LONG WINAPI RegOpenKeyExA(
  HKEY hKey, LPCSTR lpSubKey, DWORD ulOptions,
  REGSAM samDesired, PHKEY phkResult
) {
  return(ERROR_NOT_SUPPORTED);
}

EXPORT LONG WINAPI RegSetValueExA(
  HKEY hKey, LPCSTR lpValueName, DWORD Reserved,
  DWORD dwType, const BYTE *lpData, DWORD cbData
) {
  return(Reg_GameSave((char *) lpValueName, (BYTE *) lpData, cbData) ? ERROR_SUCCESS : ERROR_NOT_SUPPORTED);
}

EXPORT LONG WINAPI RegCreateKeyExA(
  HKEY hKey, LPCSTR lpSubKey, DWORD Reserved, LPSTR lpClass,
  DWORD dwOptions, REGSAM samDesired, LPSECURITY_ATTRIBUTES lpSecurityAttributes,
  PHKEY phkResult, PDWORD lpdwDisposition
) {
  return(ERROR_NOT_SUPPORTED);
}

EXPORT LONG WINAPI RegEnumKeyA(HKEY hKey, DWORD dwIndex, LPSTR lpName, DWORD cbName) {
  return(ERROR_NOT_SUPPORTED);
}
