// max items - see nhcpacks.c source code for explanation
#define NHC_MAX_ITEM 3520

#pragma pack(push, 1)
typedef struct {
  DWORD dwFileHash;
  DWORD dwFileType;
  DWORD dwFileOffs;
  DWORD dwFileSize;
} nhc_item;

typedef struct {
  HANDLE   hFile;
  DWORD    dwBuild;
  DWORD    dwCount;
  nhc_item list[NHC_MAX_ITEM];
  char     lpName[1025];
} nhc_file;
#pragma pack(pop)

void PackInit(nhc_file *data) {
  if (data) {
    ZeroMemory(data, sizeof(data[0]));
    data->hFile = INVALID_HANDLE_VALUE;
  }
}

void PackFree(nhc_file *data) {
  if (data) {
    if (data->hFile != INVALID_HANDLE_VALUE) { CloseHandle(data->hFile); }
    PackInit(data);
  }
}

DWORD PackOpen(char *filename, nhc_file *data) {
char s[1025]; // max wsprintf() buffer size
nhc_item head;
DWORD dw, sz;
HANDLE fl;
  dw = 0;
  if (data) { PackInit(data); }
  if (filename && filename[0]) {
    wsprintf(s, "language\\%s.nhc", filename);
    fl = CreateFile(s, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, 0);
    if (fl != INVALID_HANDLE_VALUE) {
      sz = GetFileSize(fl, NULL);
      ZeroMemory(&head, sizeof(head));
      ReadFile(fl, &head, sizeof(head), &dw, NULL);
      if (
        (dw == sizeof(head)) && (head.dwFileHash == 0x0043484E) &&
        (head.dwFileType) && (sz >= head.dwFileOffs) && (head.dwFileSize) &&
        (sz >= ((head.dwFileSize + 1) * sizeof(head))) && (head.dwFileSize <= NHC_MAX_ITEM)
      ) {
        if (data) {
          data->hFile = fl;
          data->dwBuild = head.dwFileType;
          data->dwCount = head.dwFileSize;
          CopyMemory(data->lpName, s, sizeof(s));
          ReadFile(fl, data->list, head.dwFileSize * sizeof(head), &dw, NULL);
        }
        dw = head.dwFileType;
      } else {
        dw = 0; // v1.02 error
      }
      // error or datetime only
      if ((!dw) || (!data)) { // v1.02
        if (data) {
          PackFree(data);
        } else {
          CloseHandle(fl);
        }
      }
    }
  }
  return(dw);
}

DWORD PackRead(nhc_file *data, DWORD idx, void *buff, DWORD size) {
  if (data && data->dwCount && (idx < data->dwCount) && buff && size) {
    SetFilePointer(data->hFile, data->list[idx].dwFileOffs, NULL, FILE_BEGIN);
    size = (size < data->list[idx].dwFileSize) ? size : data->list[idx].dwFileSize;
    ReadFile(data->hFile, buff, size, &size, NULL);
  } else {
    size = 0;
  }
  return(size);
}

void PackName(HWND wnd, int n, char *s) {
  if (s) {
    n = SendMessage(wnd, LB_GETTEXT, n, (LPARAM) s);
    n = (n >= 9) ? n : 9;
    // cut out date to keep combobox selection for updated archives
    s[n - 9] = 0;
  }
}

void PackList(HWND wnd) {
char s[1025]; // max wsprintf() buffer size
WIN32_FIND_DATA fd;
HANDLE fh;
DWORD dw;
  fh = FindFirstFile("language\\*.nhc", &fd);
  if (fh != INVALID_HANDLE_VALUE) {
    do {
      if (fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) { continue; }
      // cut extension
      fd.cFileName[lstrlenA(fd.cFileName) - 4] = 0;
      // check file
      dw = PackOpen(fd.cFileName, NULL);
      if (dw) {
        // file ok - add to list
        wsprintf(s, "%s %04u%02u%02u", fd.cFileName, HIWORD(dw), HIBYTE(dw), LOBYTE(dw));
        SendMessage(wnd, LB_ADDSTRING, 0, (LPARAM) s);
      }
    } while (FindNextFile(fh, &fd));
    FindClose(fh);
  }
}

DWORD PackFind(nhc_file *data, DWORD hash, DWORD type) {
int l, r, m, c;
  if (data && data->dwCount) {
    // bsearch() manual implementation to drop MSVCRT.DLL dependencies of GCC for W95 / W98
    l = 0;
    r = data->dwCount - 1;
    while (l <= r) {
      m = (l + r) / 2;
      if (data->list[m].dwFileType == type) {
        if (data->list[m].dwFileHash == hash) { return(m + 1); }
        c = (data->list[m].dwFileHash < hash) ? -1 : 1;
      } else {
        c = (data->list[m].dwFileType < type) ? -1 : 1;
      }
      if (c < 0) {
        l = m + 1;
      } else {
        r = m - 1;
      }
    }
  }
  return(0);
}
