#pragma pack(push, 1)
typedef struct {
  DWORD from;
  DWORD till;
  char  text[40];
} sub_item;

typedef struct {
  BYTE *addr;
  DWORD left;
  DWORD top;
  DWORD pitch;
  DWORD height;
  DWORD width;
  DWORD flags;
  DWORD frame;
} smk_info;
#pragma pack(pop)

// subl - subtitle length / subi - index / subx - extended / subh - last video hash / subp - page index
static DWORD subi, subl, subx, subh, subp;
// subv - subtitle video info
static smk_info subv;
// subtitle font 8x16, 256 characters, 1 BPP font
static BYTE subsfont[(8 / 8) * 16 * 256];
// 448 x 240 - max game video screen resolution
// two buffers: one for ingame videos and one for "About..."
static BYTE subsback[2][512 * 240];
// subs - subtitle string list
// 128 lines should be more than enough for all videos
static sub_item subslist[128];
// hashes of "About..." videos
PCSD DWORD subsvids[] = {
  0x21082409, 0x21082809, 0x21083009, 0x21080009, 0x21086009, 0x2108A009, 0x21092009,
  0x210A2009, 0x210C2009, 0x21082411, 0x21082811, 0x21083011, 0x21080011
};

// choose back buffer for frame
void SubsType(DWORD hash) {
DWORD i;
  subp = 0;
  for (i = 0; i < (sizeof(subsvids) / sizeof(subsvids[0])); i++) {
    if (hash == subsvids[i]) {
      subp = 1;
      break;
    }
  }
}

void SubsData(void) {
  subi = 0;
  subl = 0;
  subx = 0;
  subh = 0;
  subp = 0;
  ZeroMemory(&subv, sizeof(subv));
  ZeroMemory(subsfont, sizeof(subsfont));
  ZeroMemory(subsback, sizeof(subsback));
  ZeroMemory(subslist, sizeof(subslist));
}

void textdraw(BYTE *p, DWORD t, DWORD h, DWORD w, BYTE *s, DWORD f) {
DWORD i, j, k, l, m;
BYTE *b;
  // length
  l = lstrlen((char *) s);
  // sanity checks
  if (l && ((16 + 2) <= h) && (((l * 8) + 2) <= w)) {
    // top subtitles
    if (*s == '^') {
      s++;
      l--;
      i = 1;
    } else {
      // bottom subtitles (default)
      i = h - (16 + 1);
    }
    // offset in output buffer
    h = (i * t) + ((w - (l * 8)) / 2);
    // fill color for CopyMemory() - easier then byte-to-byte move
    f &= 0xFF;
    f |= (f << 8);
    f |= (f << 16);
    // two steps: border (black) and text color (white)
    for (m = 0; m < 2; m++) {
      // for each character
      for (k = 0; k < l; k++) {
        // get character image
        b = (BYTE *) &subsfont[s[k] * 16];
        // offset in output buffer where to draw
        h += (k * 8);
        // for each y of character
        for (j = 0; j < 16; j++) {
          // for each x of character
          for (i = 0; i < 8; i++) {
            // not background
            if (*b & (128 >> i)) {
              // second step - white color
              if (m) {
                p[h + i] = 0xFF;
              } else {
                // first step - black color (border)
                CopyMemory(&p[h + i - 1 - t], &f, 3);
                CopyMemory(&p[h + i - 1    ], &f, 3);
                CopyMemory(&p[h + i - 1 + t], &f, 3);
              }
            }
          }
          // next y of character image
          b++;
          // next y in output buffer
          h += t;
        }
        // go back in output buffer
        h -= ((k * 8) + (t * 16));
      }
    }
  }
}

void SubsView(BYTE *buf, BOOL save) {
DWORD l;
  // prevent overflow
  l = subv.pitch * subv.height;
  l = (l < sizeof(subsback[0])) ? l : sizeof(subsback[0]);
  if (save) {
    // save last frame
    CopyMemory(&subsback[subp], subv.addr, l);
  } else {
    // restore old frame for further rendering
    CopyMemory(buf, &subsback[subp], l);
  }
}

void SubsInit(DWORD frame, DWORD left, DWORD top, DWORD pitch, DWORD height, DWORD width, void *buf, DWORD flags) {
  // save frame property
  subv.frame = frame;
  subv.addr = buf;
  subv.left = left;
  subv.top = top;
  subv.pitch = pitch;
  subv.height = height;
  subv.width = width;
  subv.flags = flags;
  // for Smacker video only
  if ((!flags) && (frame)) {
    // restore old frame for further rendering
    SubsView(buf, FALSE);
  }
}

void SubsDraw(BYTE f) {
sub_item *subsitem[2];
DWORD i;
  // save last frame
  SubsView(subv.addr, TRUE);
  // bottom[0] and top[1] lines
  subsitem[0] = NULL;
  subsitem[1] = NULL;
  // need next titre?
  while ((subi < subl) && (subv.frame > subslist[subi].till)) { subi++; }
  i = subi;
  // since upper and lower titres may overlap
  while ((i < subl) && (subv.frame >= subslist[i].from)) {
    subsitem[(subslist[i].text[0] == '^') ? 1 : 0] = &subslist[i];
    i++;
  }
  // extended
  if (subx) {
    subsitem[(subslist[0].text[0] == '^') ? 1 : 0] = &subslist[0];
    // decrement frames count to display on screen
    subx--;
  }
  // draw subtitle text
  for (i = 0; i < 2; i++) {
    if (subsitem[i]) {
      textdraw(subv.addr, subv.pitch, subv.height, subv.width, (BYTE *) subsitem[i]->text, f);
    }
  }
}
