#include <windows.h>
#include <commctrl.h>
#include "resource.h"

#define LIST_LEN(x) (sizeof((x)) / sizeof((x)[0]))

typedef struct {
  DWORD size;
  BYTE  type; /* 0 - root folder (minimum installation); 1 - DATA folder (full installation) */
  TCHAR name[27];
} fileinfo;

typedef struct {
  HWND wnd;
  DWORD size;
  DWORD offs;
} copyinfo;

static TCHAR lngdllfn[] = TEXT("LANGUAGE.dll");
static TCHAR orgdllfn[] = TEXT("ADVAPI32.dll");
static TCHAR inisetup[] = TEXT("nhc\0.\\language.ini");
static TCHAR datasave[] = TEXT("DATA\0SAVE");
static TCHAR nhcexefn[] = TEXT(".\\NHC.EXE");
static TCHAR readmefn[] = TEXT(".\\readme.txt");
static TCHAR readnhfn[] = TEXT(".\\nhc-read.txt");

/* original CD and RU_DR */
static fileinfo masterfl[] = {
  {0, 0, TEXT("\0:\\setup\\NHC.exe")},
  {0, 0, TEXT("\0:\\setup\\Smackw32.dll")},
  {0, 0, TEXT("\0:\\readme.txt")},
  {0, 0, TEXT("\0:\\DATA\\hd.blb")}
};

/* RU_FG only */
static fileinfo fargusfl[] = {
  {0, 0, TEXT("\0:\\NHC.exe")},
  {0, 0, TEXT("\0:\\Smackw32.dll")},
  {0, 0, TEXT("\0:\\readme.txt")},
  {0, 0, TEXT("\0:\\hd.blb")}
};

/* warning: DO NOT touch order of the files in list below without checking the other code */
static fileinfo filelist[] = {
  {0, 0, TEXT("")},
  {0, 0, TEXT("")},
  {0, 0, TEXT("")},
  {0, 0, TEXT("")},
  {0, 1, TEXT("\0:\\DATA\\a.blb")}, /* [4] this must be there */
  {0, 1, TEXT("\0:\\DATA\\c.blb")},
  {0, 1, TEXT("\0:\\DATA\\i.blb")},
  {0, 1, TEXT("\0:\\DATA\\s.blb")},
  {0, 1, TEXT("\0:\\DATA\\t.blb")},
  {0, 1, TEXT("\0:\\DATA\\m.blb")}  /* [count-1] v1.01 and this must be here (non-existent in Japanese release) */
};

TCHAR *BaseName(TCHAR *s) {
TCHAR *r;
  if (s) {
    for (r = s; *r; r++) {
      if ((*r == TEXT('/')) || (*r == TEXT('\\'))) {
        s = &r[1];
      }
    }
  }
  return(s);
}

void ExecFile(HWND wnd, TCHAR *filename) {
  if (filename && *filename) {
    CoInitialize(NULL);
    /* note: relative (".\file.txt") or absolute path ("C:\dir\file.txt")
       must be specified or ShellExecute() will open first matched
       file from %PATH% if it's not found in current folder */
    ShellExecute(wnd, NULL, filename, NULL, NULL, SW_SHOWNORMAL);
    CoUninitialize();
  }
}

BOOL FileExists(TCHAR *filename) {
DWORD mode, attr;
  attr = INVALID_FILE_ATTRIBUTES;
  if (filename && *filename) {
    mode = SetErrorMode(SEM_FAILCRITICALERRORS);
    attr = GetFileAttributes(filename);
    SetErrorMode(mode);
  }
  return((attr != INVALID_FILE_ATTRIBUTES) && (!(attr & FILE_ATTRIBUTE_DIRECTORY)));
}

BOOL FillDiskData(fileinfo *list, DWORD count) {
TCHAR path[4];
DWORD drv, i;
  if (list && count) {
    path[0] = TEXT('A');
    path[1] = TEXT(':');
    path[2] = TEXT('\\');
    path[3] = 0;
    drv = GetLogicalDrives();
    while (drv) {
      if ((drv & 1) && (GetDriveType(path) == DRIVE_CDROM)) {
        for (i = 0; i < count; i++) {
          list[i].name[0] = path[0];
          if (!FileExists(list[i].name)) {
            /* v1.01 Japanese release */
            if ((i + 1) != count) {
              list[0].name[0] = 0;
              break;
            }
          } else {
            /* note: CD-ROM files never compressed, so this is a short way to obtain actual size */
            list[i].size = GetCompressedFileSize(list[i].name, NULL);
          }
        }
        if (list[0].name[0]) { break; }
      }
      path[0]++;
      drv >>= 1;
    }
  }
  return((list && list[0].name[0]) ? TRUE : FALSE);
}

BOOL FindDisk(void) {
DWORD l;
BOOL r;
  l = LIST_LEN(filelist);
  /* original CD and RU_DR */
  CopyMemory(filelist, masterfl, sizeof(masterfl));
  r = FillDiskData(filelist, l);
  /* not found - try RU_FG */
  if (!r) {
    CopyMemory(filelist, fargusfl, sizeof(fargusfl));
    r = FillDiskData(filelist, l);
  }
  return(r);
}

void BuildIni(TCHAR *path) {
  WritePrivateProfileString(inisetup, TEXT("MusicOn"), TEXT("1"), &inisetup[4]);
  WritePrivateProfileString(inisetup, TEXT("BLBPath"), path,      &inisetup[4]);
  WritePrivateProfileString(inisetup, TEXT("LogHash"), TEXT("0"), &inisetup[4]);
  WritePrivateProfileString(inisetup, TEXT("IsDebug"), TEXT("0"), &inisetup[4]);
  WritePrivateProfileString(inisetup, TEXT("Configs"), TEXT("1"), &inisetup[4]); /* 1 = VRDE */
  WritePrivateProfileString(inisetup, TEXT("LngName"), TEXT(""),  &inisetup[4]);
}

/* v1.01 */
DWORD GetImpLibOfs(TCHAR *filename, CCHAR *ilibname) {
HANDLE fl;
CCHAR c, d;
IMAGE_DOS_HEADER dh;
IMAGE_NT_HEADERS nt;
IMAGE_SECTION_HEADER sh;
IMAGE_IMPORT_DESCRIPTOR id;
DWORD ofs, dw, i, j, a, b;
  ofs = 0;
  if (filename && ilibname) {
    fl = CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    if (fl != INVALID_HANDLE_VALUE) {
      do {
        /* read DOS header */
        ZeroMemory(&dh, sizeof(dh));
        ReadFile(fl, &dh, sizeof(dh), &dw, NULL);
        if (dh.e_magic != IMAGE_DOS_SIGNATURE) { break; }
        /* read PE header */
        SetFilePointer(fl, dh.e_lfanew, NULL, FILE_BEGIN);
        ZeroMemory(&nt, sizeof(nt));
        ReadFile(fl, &nt, sizeof(nt), &dw, NULL);
        if ((nt.Signature != IMAGE_NT_SIGNATURE) ||
           (nt.OptionalHeader.Magic != IMAGE_NT_OPTIONAL_HDR_MAGIC)) { break; }
        /* find import section */
        SetFilePointer(fl, dh.e_lfanew + ((DWORD) &nt.OptionalHeader - (DWORD) &nt) +
          nt.FileHeader.SizeOfOptionalHeader, NULL, FILE_BEGIN);
        a = 0;
        b = nt.OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT].VirtualAddress;
        for (i = 0; i < nt.FileHeader.NumberOfSections; i++) {
          ZeroMemory(&sh, sizeof(sh));
          ReadFile(fl, &sh, sizeof(sh), &dw, NULL);
          if ((sh.VirtualAddress <= b) && (b <= (sh.VirtualAddress + sh.Misc.VirtualSize))) {
            a = sh.PointerToRawData + b - sh.VirtualAddress;
            break;
          }
        }
        if (!a) { break; }
        /* find import library name */
        i = 0;
        do {
          SetFilePointer(fl, a + i, NULL, FILE_BEGIN);
          i += sizeof(id);
          ZeroMemory(&id, sizeof(id));
          ReadFile(fl, &id, sizeof(id), &dw, NULL);
          if (id.Name) {
            SetFilePointer(fl, a - b + id.Name, NULL, FILE_BEGIN);
            j = 0;
            do {
              c = ilibname[j]; j++;
              d = 0;
              ReadFile(fl, &d, 1, &dw, NULL);
              c -= ((c >= 'a') && (c <= 'z')) ? ('a' - 'A') : 0;
              d -= ((d >= 'a') && (d <= 'z')) ? ('a' - 'A') : 0;
            } while ((c == d) && c);
            /* found */
            if (c == d) {
              ofs = a - b + id.Name;
              break;
            }
          }
        } while (id.Name);
      } while (0);
      CloseHandle(fl);
    }
  }
  return(ofs);
}

#define PATCH_BACK 0
#define PATCH_MAKE 1
#define PATCH_TEST 2
BOOL PatchExe(DWORD t) {
HANDLE fl;
CCHAR *s;
DWORD r;
  /* v1.01 */
  r = GetImpLibOfs(nhcexefn, (t == PATCH_MAKE) ? orgdllfn : lngdllfn);
  if (r && (t != PATCH_TEST)) {
    SetFileAttributes(nhcexefn, FILE_ATTRIBUTE_ARCHIVE);
    fl = CreateFile(nhcexefn, GENERIC_WRITE | GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    if (fl != INVALID_HANDLE_VALUE) {
      SetFilePointer(fl, r, NULL, FILE_BEGIN);
      s = (t == PATCH_BACK) ? orgdllfn : lngdllfn;
      WriteFile(fl, s, lstrlenA(s), &r, NULL);
      CloseHandle(fl);
      r = 1;
    } else {
      r = 0;
    }
  }
  return(r ? TRUE : FALSE);
}

void SwapCtrl(HWND wnd) {
  if (!IsWindowVisible(GetDlgItem(wnd, IDC_PERCENT))) {
    ShowWindow(GetDlgItem(wnd, IDOK), SW_HIDE);
    ShowWindow(GetDlgItem(wnd, IDC_TXTREAD), SW_HIDE);
    ShowWindow(GetDlgItem(wnd, IDC_INSTALL), SW_HIDE);
    ShowWindow(GetDlgItem(wnd, IDC_CLEANUP), SW_HIDE);
    ShowWindow(GetDlgItem(wnd, IDCANCEL), SW_HIDE);
    /* progress bar */
    SendMessage(GetDlgItem(wnd, IDC_PERCENT), PBM_SETRANGE, 0, MAKELPARAM(0, 100));
    SendMessage(GetDlgItem(wnd, IDC_PERCENT), PBM_SETPOS, 0, 0);
    ShowWindow(GetDlgItem(wnd, IDC_PERCENT), SW_SHOW);
  } else {
    ShowWindow(GetDlgItem(wnd, IDC_PERCENT), SW_HIDE);
    ShowWindow(GetDlgItem(wnd, IDOK), SW_SHOW);
    ShowWindow(GetDlgItem(wnd, IDC_TXTREAD), SW_SHOW);
    ShowWindow(GetDlgItem(wnd, IDC_INSTALL), SW_SHOW);
    ShowWindow(GetDlgItem(wnd, IDC_CLEANUP), SW_SHOW);
    ShowWindow(GetDlgItem(wnd, IDCANCEL), SW_SHOW);
  }
}

static HANDLE hThread;
static BOOL bStopCopy;
BYTE bTypeCopy;

DWORD WINAPI CallbackCopyFunc(
  LARGE_INTEGER TotalFileSize,
  LARGE_INTEGER TotalBytesTransferred,
  LARGE_INTEGER StreamSize,
  LARGE_INTEGER StreamBytesTransferred,
  DWORD dwStreamNumber,
  DWORD dwCallbackReason,
  HANDLE hSourceFile,
  HANDLE hDestinationFile,
  LPVOID lpData
) {
copyinfo *info;
  info = (copyinfo *) lpData;
  SendMessage(info->wnd, PBM_SETPOS, (info->offs + TotalBytesTransferred.LowPart) / ((info->size / 100) + 1), 0);
  return(PROGRESS_CONTINUE);
}

DWORD WINAPI ThreadCopyFunc(LPVOID parm) {
DWORD count, i;
copyinfo info;
TCHAR *s;
HWND wnd;
  bStopCopy = FALSE;
  wnd = (HWND) parm;
  SwapCtrl(wnd);
  info.wnd = GetDlgItem(wnd, IDC_PERCENT);
  info.size = 1;
  info.offs = 0;
  if (FindDisk()) {
    info.size = 0;
    count = LIST_LEN(filelist);
    for (i = 0; i < count; i++) {
      if (filelist[i].type > bTypeCopy) {
        count = i;
        break;
      }
      info.size += filelist[i].size;
    }
    if (bTypeCopy) { CreateDirectory(datasave, NULL); }
    CreateDirectory(&datasave[5], NULL);
    for (i = 0; i < count; i++) {
      /* v1.01: Japanese release */
      if (filelist[i].size) {
        s = filelist[i].type ? &filelist[i].name[3] : BaseName(filelist[i].name);
        SetFileAttributes(s, FILE_ATTRIBUTE_ARCHIVE);
        if ((!CopyFileEx(filelist[i].name, s, CallbackCopyFunc, &info, &bStopCopy, FALSE)) || bStopCopy) {
          info.offs = 0;
          info.size = 1;
          break;
        }
        SetFileAttributes(s, FILE_ATTRIBUTE_ARCHIVE);
        info.offs += filelist[i].size;
      }
    }
    /* error - cleanup already installed files */
    if (info.offs != info.size) {
      count = i + 1;
      for (i = 0; i < count; i++) {
        s = filelist[i].type ? &filelist[i].name[3] : BaseName(filelist[i].name);
        /* v1.01: Japanese release */
        if (filelist[i].size) {
          DeleteFile(s);
        }
      }
      RemoveDirectory(&datasave[5]);
      if (bTypeCopy) { RemoveDirectory(datasave); }
    }
  }
  SwapCtrl(wnd);
  i = (info.offs == info.size) ? 1 : 0;
  ShowWindow(GetDlgItem(wnd, i ? IDC_INSTALL : IDC_CLEANUP), SW_HIDE);
  EnableWindow(GetDlgItem(wnd, IDOK), i ? TRUE : FALSE);
  SendMessage(wnd, WM_USER + 1, 0, 0); /* SetFocus() will not work from another thread */
  if (i) {
    /* create config file */
    filelist[4].name[7] = 0; /* [4] "?:\DATA" */
    BuildIni(&filelist[4].name[bTypeCopy ? 3 : 0]);
    filelist[4].name[7] = TEXT('\\'); /* [4] */
    /* patch "NHC.EXE" file */
    PatchExe(PATCH_MAKE);
    MessageBox(wnd, TEXT("Installation complete."), TEXT(""), MB_OK | MB_ICONINFORMATION);
  } else {
    MessageBox(wnd, TEXT("Installation failed."), NULL, MB_OK | MB_ICONERROR);
  }
  hThread = 0;
  return(0);
}

BOOL CALLBACK DlgPrc2(HWND wnd, UINT umsg, WPARAM wparm, LPARAM lparm) {
  if ((umsg == WM_COMMAND) && (HIWORD(wparm) == BN_CLICKED)) {
    EndDialog(wnd, LOWORD(wparm));
  }
  return(FALSE);
}

BOOL MakeGame(HWND wnd) {
DWORD dw;
int i;
  dw = FindDisk() ? 1 : 0;
  if (dw) {
    i = DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG2), wnd, &DlgPrc2);
    if ((i == IDYES) || (i == IDNO)) {
      bTypeCopy = (i == IDYES) ? 1 : 0;
      hThread = CreateThread(NULL, 0, ThreadCopyFunc, (LPVOID) wnd, 0, &dw);
      dw = hThread ? 1 : 0;
      if (hThread) { CloseHandle(hThread); }
    }
  }
  return(dw ? TRUE : FALSE);
}

BOOL CALLBACK DlgPrc(HWND wnd, UINT umsg, WPARAM wparm, LPARAM lparm) {
BOOL result;
  result = FALSE;
  switch (umsg) {
    case WM_USER + 1:
      SetFocus(GetDlgItem(wnd, IsWindowVisible(GetDlgItem(wnd, IDOK)) ? IDOK : IDC_INSTALL));
      break;
    case WM_INITDIALOG:
      lparm = (LPARAM) LoadIcon(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_ICON));
      SendMessage(wnd, WM_SETICON, ICON_BIG  , lparm);
      SendMessage(wnd, WM_SETICON, ICON_SMALL, lparm);
      if (!FileExists(nhcexefn)) {
        EnableWindow(GetDlgItem(wnd, IDOK), FALSE);
      }
      ShowWindow(GetDlgItem(wnd, PatchExe(PATCH_TEST) ? IDC_INSTALL : IDC_CLEANUP), SW_HIDE);
      ShowWindow(GetDlgItem(wnd, IDC_PERCENT), SW_HIDE);
      hThread = 0;
      result = TRUE;
      break;
    case WM_COMMAND:
      if (HIWORD(wparm) == BN_CLICKED) {
        switch (LOWORD(wparm)) {
          case IDOK:
            /* patch file only if wrapped library exists */
            if (FileExists(lngdllfn)) {
              /* for manual installation - patch before run */
              PatchExe(PATCH_MAKE);
              /* create config file only if not exists (manual installation) */
              if ((!FileExists(&inisetup[4])) && (PatchExe(PATCH_TEST))) { BuildIni(datasave); }
            }
            ExecFile(wnd, nhcexefn);
            /* fall through */
          case IDCANCEL:
            if (hThread) {
              if ((!bStopCopy) && (MessageBox(wnd, TEXT("Stop installation?"), TEXT(""), MB_ICONQUESTION | MB_YESNO) == IDYES)) {
                bStopCopy = TRUE;
              }
            } else {
              EndDialog(wnd, 0);
            }
            break;
          case IDC_INSTALL:
            if (MessageBox(wnd, TEXT(
                "Please insert the original game CD. Game files will be copied to the same folder you ran this installer from.\n"
                "You can move the game folder anywhere after installation. Do not install over already existing installation of the game."
                ), TEXT("Proceed with installation"), MB_OKCANCEL | MB_ICONQUESTION) == IDOK
            ) {
              if (FileExists(lngdllfn)) {
                if (!MakeGame(wnd)) {
                  MessageBox(wnd, TEXT("The Neverhood game CD not found."), NULL, MB_OK | MB_ICONWARNING);
                }
              } else {
                MessageBox(wnd, TEXT("LANGUAGE.DLL not found."), NULL, MB_OK | MB_ICONWARNING);
              }
            }
            break;
          case IDC_CLEANUP:
            ShowWindow(GetDlgItem(wnd, IDC_CLEANUP), SW_HIDE);
            ShowWindow(GetDlgItem(wnd, IDC_INSTALL), SW_SHOW);
            if (PatchExe(PATCH_BACK)) {
              MessageBox(wnd, TEXT("NHC.EXE restored - translation and game files can be deleted."), TEXT(""), MB_OK | MB_ICONINFORMATION);
            }
            break;
          case IDC_TXTREAD:
            ExecFile(wnd, FileExists(readmefn) ? readmefn : readnhfn);
            break;
        }
      }
      break;
  }
  return(result);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {
  InitCommonControls();
  DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG1), 0, &DlgPrc);
  ExitProcess(0);
  return(0);
}
