unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    ComboBox1: TComboBox;
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    OpenDialog1: TOpenDialog;
    Label2: TLabel;
    Label3: TLabel;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
    procedure OpenPACFile(FName: String);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
Const TSign = '# NotRegistered';

Var
    FLS: Array Of String;

Procedure FreeStrings;
Var I: Integer;
Begin
  For I:=0 To Length(FLS)-1 Do
    SetLength(FLS[I], 0);
  SetLength(FLS, 0);  
End;

Procedure TForm1.OpenPACFile(FName: String);
Var
    Fl: File;
 I, TF: LongInt;
  FOfs: Array Of LongInt;
Begin
  AssignFile(Fl, FName);
  Reset(Fl, 1);
  BlockRead(Fl, I, 4);
  If I <> $434150 Then { 'PAC'#0 }
    Begin
      CloseFile(Fl);
      MessageDlg('This is not a .PAC file!', mtError, [mbOK], 0);
      Exit;
    End;

  FreeStrings;
  ComboBox1.Clear;
  Memo1.Clear;
  Memo1.ReadOnly:=True;

  BlockRead(Fl, TF, 4);
  SetLength(FOfs, TF+1);
  BlockRead(Fl, FOfs[0], TF*SizeOf(FOfs[0]));
  FOfs[TF]:=FileSize(Fl);
  SetLength(FLS, TF);
  For I:=1 To TF Do
    Begin
      Seek(Fl, FOfs[I-1]);
      SetLength(FLS[I-1], FOfs[I]-FOfs[I-1]);
      BlockRead(Fl, FLS[I-1][1], FOfs[I]-FOfs[I-1]);
      If ((Copy(FLS[I-1], 1, Length(TSign)) = TSign) And (I<>TF)) Then
        While ((Length(FLS[I-1])>0) And (FLS[I-1][Length(FLS[I-1])] = #0)) Do
          Delete(FLS[I-1], Length(FLS[I-1]), 1);
      ComboBox1.Items.Add('ITEM#'+IntToStr(I));
    End;
  SetLength(FOfs, 0);    
  CloseFile(Fl);
  Label3.Caption:=ExtractFileName(FName);
End;

Procedure SavePACFile(FName: String);
Var
    I, TF: Cardinal;
     FOfs: Array Of LongInt;    
       Fl: File;
        B: Byte;
Begin
  B:=0;
  AssignFile(Fl, FName);
  Reset(Fl, 1);
  I:=$434150;
  BlockWrite(Fl, I, 4);
  TF:=Length(FLS);
  SetLength(FOfs, TF);
  BlockWrite(Fl, TF, 4);
  For I:=1 To TF Do BlockWrite(Fl, TF, 4);
  While FilePos(Fl) Mod 16<>0 Do BlockWrite(Fl, B, 1);
  For I:=1 To TF Do
    Begin
      FOfs[I-1]:=FilePos(Fl);
      BlockWrite(Fl, FLS[I-1][1], Length(FLS[I-1]));
      If I<TF Then
        While FilePos(Fl) Mod 16<>0 Do BlockWrite(Fl, B, 1);
    End;
  Truncate(Fl);
  Seek(Fl, 8);
  BlockWrite(Fl, FOfs[0], TF*SizeOf(FOfs[0]));
  SetLength(FOfs, 0);
  CloseFile(Fl);
End;

procedure TForm1.Button1Click(Sender: TObject);
begin
  If OpenDialog1.Execute Then
    Begin
      OpenPACFile(OpenDialog1.FileName);
      Button2.Enabled:=True;
      Button3.Enabled:=True;      
    End;  
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  If OpenDialog1.FileName <> '' Then
    SavePACFile(OpenDialog1.FileName);
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  If Copy(FLS[ComboBox1.ItemIndex], 1, Length(TSign)) = TSign Then
    Begin
      Memo1.ReadOnly:=False;
      Button3.Enabled:=True;
      Memo1.Text:=FLS[ComboBox1.ItemIndex]
    End
  Else
    Begin
      Memo1.Text:='[This item contains not editable data!]';
      Memo1.ReadOnly:=True;
      Button3.Enabled:=False;
    End;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FreeStrings;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  If ComboBox1.ItemIndex >= 0 Then
    Begin
      SetLength(FLS[ComboBox1.ItemIndex], 0);
      FLS[ComboBox1.ItemIndex]:=Memo1.Text;  
    End;
end;

end.
