unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls;

type
  TForm1 = class(TForm)
    Image1: TImage;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
Var
    ImgWidth, ImgHeight, I, J: LongInt;
                   A, B, C, D: Byte;
                           Fl: File;
begin
  If ParamCount <> 1 Then
    Begin
      Application.Terminate;
      Exit;
    End;
  Image1.Picture.Bitmap.PixelFormat:=pf24bit;
  AssignFile(Fl, ParamStr(1));
  {$I-}
  Reset(Fl, 1);
  {$I+}
  If IOResult<>0 Then
    Begin
      Application.Terminate;
      Exit;
    End;
  BlockRead(Fl, ImgWidth, 4);
  BlockRead(Fl, ImgHeight, 4);
  If FileSize(Fl)<>(ImgWidth*ImgHeight*4)+8 Then
    Begin
      CloseFile(Fl);
      Application.Terminate;
      Exit;
    End;

  Image1.Width:=ImgWidth;
  Image1.Height:=ImgHeight;
  Image1.Picture.Bitmap.Width:=Image1.Width;
  Image1.Picture.Bitmap.Height:=Image1.Height;

  For J:=1 To ImgHeight Do
    For I:=1 To ImgWidth Do
      Begin
        BlockRead(Fl, A, 1);
        BlockRead(Fl, B, 1);
        BlockRead(Fl, C, 1);
        BlockRead(Fl, D, 1);
        If ((A = 0) And (B = 0) And (C = 0)) Then
          Image1.Picture.Bitmap.Canvas.Pixels[I-1, J-1]:=RGB(255, 00, 00) // Not used area - Paint it Red
        Else
          Image1.Picture.Bitmap.Canvas.Pixels[I-1, J-1]:=RGB(D, D, D); // Color - GrayScaled
      End;
  Image1.Picture.Bitmap.SaveToFile(ParamStr(1) + '.bmp'); // save output to .BMP
  CloseFile(Fl);
end;

end.
