#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <stdint.h>

/*
  2008.01.10 - v1.0 - ANSI C, Windows
  - first public release

  2008.03.18 - v1.1 - ANSI C, Windows
  - added multiply files unpacking
  - added align for file tail

  2023.07.28 - v1.2 - ANSI C, multi-platform
  - packer and unpacker tools merged in single file
  - code rewrite, added a lot of checks
  - fixed packing of tiny files (invalid work memory buffer size - too small)
  - fixed output buffer size on packing (invalid output buffer size - too small)
  - compiled with latest miniLZO version 2.10 (Mar 01 2017)
*/

/* http://www.oberhumer.com/opensource/lzo/ */
#include "minilzo.h"
#include "minilzo.c"

/* v1.2: based on OUT_LEN macros from testmini.c example code file */
#define LZO1X_COMPRESS_BOUND(x) ((x) + ((x) / 16) + 64 + 3)

#pragma pack(push, 1)
typedef struct {
  uint32_t size;
  uint32_t pack;
} bin_item;
#pragma pack(pop)

char *basename(char *s) {
char *r;
  if (s) {
    for (r = s; *r; r++) {
      if ((*r == '/') || (*r == '\\')) {
        s = &r[1];
      }
    }
  }
  return(s);
}

void newext(char *name, char *ext) {
char *p;
  if (name && ext) {
    for (; (*name == '.'); name++);
    for (p = NULL; *name; name++) {
      if (*name == '.') {
        p = name;
      }
    }
    strcpy(p ? p : name, ext);
  }
}

int main(int argc, char *argv[]) {
uint32_t flsize, sz, nm;
char s[260 + 16], e[16], m;
uint8_t *p, *w;
lzo_uint szx;
bin_item bi;
FILE *fl, *f;
  printf(
    "Beyond Good & Evil .BIN tool v1.2\n"
    "(c) CTPAX-X Team 2008,2023\n"
    "http://www.CTPAX-X.org/\n\n"
  );
  if (argc != 3) {
    printf(
      "Usage: bgaetool <u|p> <filename.bin>\n\n"
      "Where:\n"
      "u - for unpack filename.bin to filename.000, filename.001, ...\n"
      "p - for pack filename.000, filename.001, ... to filename.bin\n"
      "\n"
    );
    return(1);
  }
  m = argv[1][0];
  m += ((m >= 'A') && (m <= 'Z')) ? ('a' - 'A') : 0;
  if (((m != 'u') && (m != 'p')) || (argv[1][1])) {
    printf("Error: unknown mode '%s'.\n\n", argv[1]);
    return(2);
  }
  /* v1.2 */
  if (lzo_init() != LZO_E_OK) {
    printf("Error: miniLZO library initialization failed.\n\n");
    return(3);
  }
  if (m == 'u') {
    /* u - unpack */
    fl = fopen(argv[2], "rb");
    if (!fl) {
      printf("Error: can't open input file.\n\n");
      return(4);
    }
    fread(&sz, 4, 1, fl);
    sz += 4;
    fseek(fl, 0, SEEK_END);
    if (ftell(fl) < sz) {
      fclose(fl);
      printf("Error: invalid input file format.\n\n");
      return(5);
    }
    fseek(fl, 4, SEEK_SET);
    strcpy(s, basename(argv[2]));
    f = NULL;
    p = NULL;
    nm = 0;
    while ((ftell(fl) + sizeof(bi)) < sz) {
      memset(&bi, 0, sizeof(bi));
      fread(&bi, sizeof(bi), 1, fl);
      if ((!bi.pack) || (!bi.size)) { break; }
      p = (uint8_t *) malloc(bi.pack + bi.size);
      if (!p) {
        printf("Error: not enough memory for output file.\n\n");
        break;
      }
      memset(p, 0, bi.pack + bi.size);
      fread(p, bi.pack, 1, fl);
      szx = bi.size;
      lzo1x_decompress_safe(p, bi.pack, &p[bi.pack], &szx, NULL);
      sprintf(e, ".%03u", nm);
      newext(s, e);
      f = fopen(s, "wb");
      if (f) {
        fwrite(&p[bi.pack], bi.size, 1, f);
        fclose(f);
      }
      free(p);
      if (!f) {
        printf("Error: can't create output file.\n\n");
        break;
      }
      printf("%s (%u -> %u)\n", s, bi.pack, bi.size);
      nm++;
    }
    fclose(fl);
    /* some error*/
    if ((!p) || (!f)) { return(6); }
  } else {
    /* p - pack */
    w = (uint8_t *) malloc(LZO1X_1_MEM_COMPRESS); /* v1.2 fix */
    if (!w) {
      printf("Error: not enough memory for LZO work buffer.\n\n");
      return(4);
    }
    strcpy(s, argv[2]);
    newext(s, ".bin");
    f = fopen(s, "wb+");
    if (!f) {
      free(w);
      printf("Error: can't create output file.\n\n");
      return(5);
    }
    flsize = 4;
    fwrite(&flsize, 4, 1, f);
    nm = 0;
    do {
      sprintf(e, ".%03u", nm);
      newext(s, e);
      fl = fopen(s, "rb");
      if (!fl) { break; }
      fseek(fl, 0, SEEK_END);
      bi.size = ftell(fl);
      fseek(fl, 0, SEEK_SET);
      bi.pack = LZO1X_COMPRESS_BOUND(bi.size); /* v1.2 fix */
      p = (uint8_t *) malloc(bi.size + bi.pack);
      if (p) {
        memset(p, 0, bi.size + bi.pack);
        fread(p, bi.size, 1, fl);
      }
      fclose(fl);
      if (!p) { break; }
      szx = bi.pack;
      lzo1x_1_compress(p, bi.size, &p[bi.size], &szx, w);
      bi.pack = szx;
      printf("%s (%u <- %u)\n", s, bi.pack, bi.size);
      fwrite(&bi, sizeof(bi), 1, f);
      fwrite(&p[bi.size], 1, bi.pack, f);
      free(p);
      flsize = flsize + (bi.pack + 8);
      nm++;
    } while (nm);
    /* add padding */
    sz = flsize % 2048;
    if (sz) {
      sz = 2048 - sz;
      nm = LZO1X_1_MEM_COMPRESS;
      memset(w, 0, nm);
      szx = sz;
      while (szx) {
        nm = (nm < szx) ? nm : szx;
        fwrite(w, nm, 1, f);
        szx -= nm;
      }
    }
    free(w);
    /* update header */
    flsize = flsize - 4 + sz;
    fseek(f, 0, SEEK_SET);
    fwrite(&flsize, 4, 1, f);
    fclose(f);
  }
  printf("\ndone\n\n");
  return(0);
}
