#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <malloc.h>
#include <string.h>

#ifdef GCC32HACK
#include "win32gcc.h"
#endif

/*
http://www.geocities.jp/aoyoume/aotuv/index.html
http://rarewares.org/ogg-oggenc.php#oggenc-aotuv
http://www.eveonline.com/ingameboard.asp?a=topic&threadID=1018956
http://forum.xentax.com/viewtopic.php?f=17&t=3477

.BNK Format specifications

char {4} - header (BKHD) // BanK HeaDer
uint32 {4} - size of BKHD
uint32 {4} - unknow (version?)
uint32 {4} - unknow
uint32 {4} - unknow
uint32 {4} - unknow
byte {x} - zero padding (if any)

char {4} - header (DIDX) // Data InDeX
uint32 {4} - size of DIDX
following by records 12 bytes each:
  uint32 {4} - unknow
  uint32 {4} - relative file offset from start of DATA, 16 bytes aligned
  uint32 {4} - file size

char {4} - header (DATA)
uint32 {4} - size of DATA

char {4} - header (HIRC) // ???
uint32 {4} - size of HIRC

char {4} - header (STID) // Sound Type ID
uint32 {4} - size of STID
uint32 {4} - Always 1?
uint32 {4} - Always 1?
uint32 {4} - unknow
byte {1} - TID Length (TL)
char {TL} - TID string (usually same as filename, but without extension)

Init.bnk
STMG
HIRC
FXPR
ENVS
*/

#define BNK_SIGN_BKHD (0x44484B42)
#define BNK_SIGN_DIDX (0x58444944)
#define BNK_SIGN_STID (0x44495453)
#define BNK_SIGN_DATA (0x41544144)

#pragma pack(push, 1)
typedef struct {
  uint32_t sign;
  uint32_t size;
} tsect;

typedef struct {
  uint32_t unkn;
  uint32_t offs;
  uint32_t size;
} tidx;
#pragma pack(pop)

#define SWAP32(x) ((((x)>>24)&0xFF) | (((x)<<8)&0xFF0000) | (((x)>>8)&0xFF00) | (((x)<<24)&0xFF000000))

int main(int argc, char *argv[]) {
uint32_t i, dt, sz, cnt;
char *s, *si;
FILE *fl, *f;
tidx *fr;
tsect cs;
void *p;
  printf(
    "Divinity 2: Ego Draconis / Army of Two .BNK extractor\n"\
    "(c) CTPAX-X Team 2009-2010,2015\n"\
    "http://www.CTPAX-X.org/\n\n"
  );
  if ((argc < 2) || (argc > 3)) {
    printf(
      "Usage: bnkextr filename.bnk [/swap]\n"\
      "/swap - swap byte order (use it for unpacking AoT)\n"
    );
    return(1);
  }
  fl = fopen(argv[1], "rb");
  if (!fl) {
    printf("ERROR: can\'t open \"%s\".\n", argv[1]);
    return(2);
  }
  fread(&cs, sizeof(cs), 1, fl);
  if (cs.sign != BNK_SIGN_BKHD) {
    printf("ERROR: not a .BNK file!\n");
    fclose(fl);
    return(3);
  }
  /* parse file structure */
  fr = NULL;
  dt = 0;
  cnt = 0;
  si = NULL;
  fseek(fl, 0, SEEK_END);
  sz = ftell(fl);
  fseek(fl, 0, SEEK_SET);
  while (ftell(fl) < sz) {
    memset(&cs, 0, sizeof(cs));
    fread(&cs, sizeof(cs), 1, fl);
    if (!cs.sign) { break; }
    if (argc == 3) {
      cs.size = SWAP32(cs.size);
    }
    switch (cs.sign) {
      case BNK_SIGN_DIDX:
        if (!fr) {
          fr = (tidx *) malloc(cs.size);
          fread(fr, cs.size, 1, fl);
          cnt = cs.size / sizeof(fr[0]);
          cs.size = 0;
        }
        break;
      case BNK_SIGN_STID:
        if (!si) {
          fseek(fl, 12, SEEK_CUR);
          i = 0;
          fread(&i, 1, 1, fl);
          si = (char *) malloc(i + 1);
          fread(si, 1, i, fl);
          si[i] = 0;
          cs.size = 0;
        }
        break;
      case BNK_SIGN_DATA:
        if (!dt) {
          dt = ftell(fl);
        }
        break;
    }
    fseek(fl, cs.size, SEEK_CUR);
  }
  /* extract files */
  if (dt && fr) {
    if (!si) {
      si = (char *) malloc(9);
      strcpy(si, "BANKDATA");
    }
    s = (char *) malloc(strlen(si) + 1 + 4 + 4 /*!*/ + 16);
    for (i = 0; i < cnt; i++) {
      sprintf(s, "%s.%03u.wav", si, i + 1);
      printf("%s", s);
      if (argc == 3) {
        fr[i].size = SWAP32(fr[i].size);
        fr[i].offs = SWAP32(fr[i].offs);
      }
      fseek(fl, dt + fr[i].offs, SEEK_SET);
      p = malloc(fr[i].size);
      if (p) {
        fread(p, 1, fr[i].size, fl);
        f = fopen(s, "wb");
        if (f) {
          fwrite(p, 1, fr[i].size, f);
          fclose(f);
        }
        free(p);
      }
      printf("\n");
    }
    free(s);
  }
  /* cleanup */
  fclose(fl);
  if (si) { free(si); }
  if (fr) { free(fr); }
  return(0);
}
