#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <malloc.h>
#include <strings.h>

#ifdef GCC32HACK
#include "win32gcc.h"
#endif

#define SIGN_OggS 0x5367674FUL
#define SIGN_fmt_ 0x20746D66UL
#define SIGN_data 0x61746164UL

#pragma pack(push, 1)
typedef struct {
  uint32_t sign;
  uint8_t  vers;
  uint8_t  flag;
  uint64_t pend; /* 0 - single page */
  uint32_t snum; /* any?.. */
  uint32_t pnum; /* 0, 1, 2, ... */
  uint32_t csum; /* CRC32 */
  uint8_t  tnum;
} ogg_head;
#pragma pack(pop)

static uint32_t crc32table[256];

/* making the 32-bit CRC table */
void crc32maketable(void) {
uint32_t i, j, r;
  for (i = 0; i < 256; i++) {
    r = (i << 24);
    for (j = 0; j < 8; j++) {
      r = (r << 1) ^ ((r & 0x80000000) ? 0x04C11DB7 : 0);
    }
    crc32table[i] = r;
  }
}

/* Updating existed 32-bit CRC with new calaculated */
uint32_t crc32update(uint8_t *p, uint32_t sz, uint32_t crcval) {
uint32_t i;
  for (i = 0; i < sz; i++) {
/*    crcval = (crcval >> 8) ^ crc32table[*p ^ (crcval & 0xFF)];*/
    crcval = (crcval << 8) ^ crc32table[(crcval >> 24) ^ *p];
    p++;
  }
  return(crcval);
}

/* CRC32 buffer */
uint32_t crc32buffer(void *p, uint32_t sz) {
  return(/* ~ */crc32update((uint8_t *) p, sz, /*0xFFFFFFFF*/ 0));
}

char *basename(char *s) {
char *r;
  if (s) {
    for (r = s; *r; r++) {
      if ((*r == '/') || (*r == '\\')) {
        s = &r[1];
      }
    }
  }
  return(s);
}

void newext(char *name, char *ext) {
char *p;
  if (name && ext) {
    for (; (*name == '.'); name++);
    for (p = NULL; *name; name++) {
      if (*name == '.') {
        p = name;
      }
    }
    strcpy(p ? p : name, ext);
  }
}

int main(int argc, char *argv[]) {
uint32_t i, sc, sz, sg;
uint8_t *p, *z;
FILE *fl, *f;
ogg_head og;
char s[260];
  printf(
    "WAV2OGG v1.0\n"
    "(c) CTPAX-X Team 2010,2015\n"
    "http://www.CTPAX-X.org/\n\n"
  );
  if (argc != 2) {
    printf("Usage: wav2ogg <filename.wav>\n\n");
    return(1);
  }
  fl = fopen(argv[1], "rb");
  if (!fl) {
    printf("Error: can't open input file for read.\n\n");
    return(2);
  }
  fseek(fl, 0, SEEK_END);
  sz = ftell(fl);
  fseek(fl, 0, SEEK_SET);
  sg = 0;
  sc = 12;
  while ((ftell(fl) < sz) && (sg != SIGN_data)) {
    fseek(fl, sc, SEEK_CUR);
    sg = 0;
    sc = 0;
    fread(&sg, 4, 1, fl);
    fread(&sc, 4, 1, fl);
    printf("%08X|%08X\n", sc, sg);
    if (sg == SIGN_fmt_) {
      sc -= 2;
      sg = 0;
      fread(&sg, 2, 1, fl);
      if (sg != 0xFFFFUL) { break; }
    }
  }
  if (sg != SIGN_data) {
    fclose(fl);
    printf("Error: input file not an .OGG file or bad container.\n\n");
    return(3);
  }

  strcpy(s, basename(argv[1]));
  newext(s, ".ogg");
  printf("%s\n", s);
  f = fopen(s, "wb");
  if (!f) {
    fclose(fl);
    printf("Error: can't create output file.\n\n");
    return(4);
  }

  crc32maketable();
  memset(&og, 0, sizeof(og));
  og.sign = SIGN_OggS; /* OggS */
  og.snum = 1; /* any, don't care */
  og.flag = 2;
  while (ftell(fl) < sz) {
    sc = 0;
    sg = 0;
    fread(&sc, 4, 1, fl);
    fread(&sg, 4, 1, fl);
    if (!sc) { break; }

    i = (sc + 254) / 255;
    z = (uint8_t *) malloc(i);
    if (!z) {
      printf("Error: not enough memory.\n\n");
      break;
    }
    memset(z, 255, i);
    z[i - 1] = (sc % 255) ? (sc % 255) : 255;

    og.pend = sg;
    og.csum = 0;
    og.tnum = i;

    sg = sc + sizeof(og) + og.tnum;
    p = (uint8_t *) malloc(sg);
    if (!p) {
      printf("Error: not enough memory.\n\n");
      break;
    }
    p += sizeof(og);
    memcpy(p, z, og.tnum);
    p += og.tnum;

    fread(p, 1, sc, fl);
    p -= (sizeof(og) + og.tnum);
    if (og.flag != 2) {
      if (ftell(fl) >= sz) {
        og.flag = 4;
      } else {
        og.flag = 0;
      }
    }
    memcpy(p, &og, sizeof(og));

    og.csum = crc32buffer(p, sg);
    memcpy(p, &og, sizeof(og));
    fwrite(p, 1, sg, f);

    free(p);
    free(z);
    og.pnum++; /* next page */
    if (og.flag == 2) {
      og.flag = 0;
    }
  }
  fclose(f);
  fclose(fl);
  return(0);
}
