#define WIN32_LEAN_AND_MEAN 1
#pragma comment(linker,"/opt:nowin98")
#pragma comment(lib,"nvDXTlib")
#pragma comment(lib,"kernel32")
#pragma comment(lib,"advapi32")
#pragma comment(lib,"user32")

#include <stdio.h>
#include <windows.h>
#include <malloc.h>

#include "dxtlib.h"

// ---------------------------------------------------------------------
// a lot of stubs needed to compile VC7 library under VC6...
// ---------------------------------------------------------------------

// Source libvisual2003_visual2008.cpp
// #include <string>

namespace std {
  class _String_base {
    public:
     __declspec(dllexport) void _Xlen(void) const;
     __declspec(dllexport) void _Xran(void) const;
  };
};

void std::_String_base::_Xlen() const {
//  std::_String_base::_Xlen();
}

void std::_String_base::_Xran() const {
//  std::_String_base::_Xran();
}

// end of libvisual2003_visual2008.cpp

extern inline void __cdecl operator delete[](void *ptr) {
  free(ptr);
}

extern inline void * __cdecl operator new[](unsigned int size) {
  return(malloc(size));
}

extern "C" long _ftol (double); // defined by VC6 C libs
extern "C" long _ftol2 (double dblSource) { return _ftol( dblSource ); }

extern "C" const DWORD_PTR __security_cookie = 0xE64EBB40;
extern "C" void __fastcall __security_check_cookie(DWORD_PTR cookie) {
  if (cookie != __security_cookie) {
     __asm int 3;
  }
}

// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------

#define SWAP32(x) ((((x)>>24)&0xFF) | (((x)<<8)&0xFF0000) | (((x)>>8)&0xFF00) | (((x)<<24)&0xFF000000))

#define ALL_MIP_LEVELS 0

#pragma pack(push, 1)
typedef struct {
  BYTE IDLength;
  BYTE ColorMapType;
  BYTE ImageType;
  WORD CMapStart;
  WORD CMapLength;
  BYTE CMapDepth;
  WORD XOffset;
  WORD YOffset;
  WORD Width;
  WORD Height;
  BYTE PixelDepth;
  BYTE ImageDescriptor;
} tga_head;
#pragma pack(pop)

char *basename(char *s) {
char *r;
  for (r = s; *s; s++) {
    if ((*s == '/') || (*s == '\\')) {
      r = &s[1];
    }
  }
  return(r);
}

void newext(char *name, char *ext) {
char *p;
  if (name && ext) {
    for (; (*name == '.'); name++);
    for (p = NULL; *name; name++) {
      if (*name == '.') {
        p = name;
      }
    }
    strcpy(p ? p : name, ext);
  }
}

NV_ERROR_CODE nvDXTReadCallback(void *buffer, size_t count, void *userData) {
DWORD dw;
  return(ReadFile(*((HANDLE *)userData), buffer, count, &dw, NULL) ? NV_OK : NV_READ_FAILED);
}

DWORD DumpToTGA(char *filename, DWORD width, DWORD height, DWORD alpha, DWORD **data) {
tga_head th;
HANDLE fl;
DWORD i, j, dw, *d;
BYTE *p;
  ZeroMemory(&th, sizeof(th));
  th.ImageType = 2;
  th.PixelDepth = alpha ? 32 : 24;
  th.ImageDescriptor = 0x20;
  // single or cube image
  th.Width = data[1] ? (width * 6) : width;
  th.Height = height;
  fl = CreateFile(filename, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
  if (fl != INVALID_HANDLE_VALUE) {
    // write header
    WriteFile(fl, &th, sizeof(th), &dw, NULL);
    // for each line
    for (j = 0; j < height; j++) {
      // for each image
      for (i = 0; i < 6; i++) {
        // not a cube image
        if (!data[i]) { break; }
        // reverse data byte order
        d = data[i];
        // offset to current line
        d += (j * width);
        // for no alpha code
        p = (BYTE *) d;
        for (dw = 0; dw < width; dw++) {
          d[dw] = SWAP32(d[dw]);
          d[dw] = (d[dw] >> 8) | (d[dw] << 24);
          // no alpha channel
          if (!alpha) {
            *((DWORD *)p) = d[dw];
            p += 3;
          }
        }
        // write image row
        WriteFile(fl, d, width * (alpha ? 4 : 3), &dw, NULL);
      }
    }
    CloseHandle(fl);
  }
  return(fl != INVALID_HANDLE_VALUE);
}

int main(int argc, char * argv[]) {
char outfile[MAX_PATH + 4];
nvImageContainer *img;
DWORD i, e, j, *d[6];
WIN32_FIND_DATA fd;
HANDLE fh, fl;

  printf(
    ".DDS (DirectDraw Surface) to .TGA texture converter v1.4\n"
    "(c) nVIDIA 2004-2007 (ReadDXT & nvDXTlib.vc7.lib %s)\n"
    "(c) -=CHE@TER=- 2005, 2017 (dds2tga & patches)\n"
    "http://ctpax-cheater.losthost.org/personal.htm\n"
    "This tool based on the original nVIDIA ReadDXT source codes.\n\n",
    GetDXTCVersion()
  );

  if (argc != 2) {
    printf("Usage: %s <filemask.ext>\n\n", basename(argv[0]));
    return(1);
  }

  fh = FindFirstFile(argv[1], &fd);
  if (fh != INVALID_HANDLE_VALUE) {
    i = 0;
    e = 0;
    do {
      // skip directories
      if (fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) { continue; }
      strcpy(outfile, fd.cFileName);
      newext(outfile, ".tga");
      printf("%s -> %s\n", fd.cFileName, outfile);
      fl = CreateFile(fd.cFileName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, 0);
      if (fl != INVALID_HANDLE_VALUE) {
        img = new nvImageContainer();
        if (img) {
          if (nvDDS::nvDXTdecompress(*img, PF_RGBA, ALL_MIP_LEVELS, nvDXTReadCallback, &fl) == NV_OK) {
            ZeroMemory(d, 6 * sizeof(d[0]));
            if (img->rgbaMIPVolumeMap.numMIPMaps()) {
              d[0] = (DWORD *) img->rgbaMIPVolumeMap[0][0].pixels(0);
            }
            if (img->rgbaMIPCubeMap.numMIPMaps()) {
              for (j = 0; j < 6; j++) {
                d[j] = (DWORD *) img->rgbaMIPCubeMap[j][0].pixels(0);
              }
            }
            if (img->rgbaMIPImage.numMIPMaps()) {
              d[0] = (DWORD *) img->rgbaMIPImage[0].pixels(0);
            }
            if (!DumpToTGA(outfile, img->width, img->height, img->bFoundAlphaInRead, d)) {
              printf("Error: can't create output file (probably disk full or no permission).\n");
              e++;
            }
          } else {
            printf("Error: invalid input file format.\n");
            e++;
          }
          delete img;
        } else {
          printf("Error: nvImageContainer memory allocation failed.\n");
          e++;
        }
        CloseHandle(fl);
      } else {
        printf("Error: can't open input file.\n");
        e++;
      }
      i++;
    } while(FindNextFile(fh, &fd));
    FindClose(fh);
    printf("\nFiles: %d (errors: %d)\n", i, e);
  } else {
    printf("Error: no files found matching specified mask.\n");
  }

  return(0);
}
