Program textotga;
{$APPTYPE CONSOLE}
{$IFNDEF DCC32HACK}
Uses SysUtils, Windows;
{$ELSE}
{$I HELPERS2.INC}
{$ENDIF}

Type

  TTGAHeader = packed record
    IDLength    : byte;    // Length of the image ID string
    ColorMapType: byte;    // Type of the palette (Color map)
    ImageType   : byte;    // Type of the image
    CMapStart   : word;    // Offset of the palette data
    CMapLength  : word;    // Size of the palette
    CMapDepth   : byte;    // Depth of the palette items
    XOffset     : word;    // X-coord of the image
    YOffset     : word;    // Y-coord of the image
    Width       : word;    // Width of the image
    Height      : word;    // Height of the image
    PixelDepth  : byte;    // Depth of the pixels
    ImageDescriptor: byte; // Descriptor of the image
  end;

  TRGBA = packed record
           R, G, B, A: Byte;
          end;

Var
  Sz: LongInt;
  Fl: _File;
  TG: TTGAHeader;
   P: Array Of TRGBA;
  FH: THandle;
  TF: WIN32_FIND_DATA;
Begin
  WriteLn('Morrowind .TEX to .TGA font converter');
  WriteLn('(c) CTPAX-X Team 2008,2014');
  WriteLn('http://www.CTPAX-X.org/');
  WriteLn;

  FillChar(TG, SizeOf(TTGAHeader), 0);
  TG.ImageType:=2;
  TG.PixelDepth:=32;
  TG.ImageDescriptor:=$20;

  FillChar(TF, SizeOf(WIN32_FIND_DATA), 0);
  FH:=FindFirstFile('*.tex', TF);
  If FH <> INVALID_HANDLE_VALUE Then
  Begin
    Repeat
      // compare with '.' and '..', delphi bug workaround
      If ((TF.dwFileAttributes And FILE_ATTRIBUTE_DIRECTORY = 0) And
        ((Cardinal(@TF.cFileName[0]) And $0000FFFF)<>$002E) And
         (Cardinal(@TF.cFileName[0]) And $00FFFFFF<>$002E2E)) Then
      Begin
        Write(TF.cFileName);
        AssignFile(Fl, TF.cFileName);
        Reset(Fl, 1);
        BlockRead(Fl, Sz, 4);
        TG.Width:=Sz;
        BlockRead(Fl, Sz, 4);
        TG.Height:=Sz;
        Sz:=TG.Width*TG.Height;
        SetLength(P, Sz);
        BlockRead(Fl, P[0], Sz*4);
        CloseFile(Fl);

        AssignFile(Fl, ChangeFileExt(TF.cFileName, '.tga'));
        ReWrite(Fl, 1);
        BlockWrite(Fl, TG, SizeOf(TTGAHeader));
        BlockWrite(Fl, P[0], Sz*4);
        CloseFile(Fl);
        SetLength(P, 0);
        WriteLn;
      End;
    Until FindNextFile(FH, TF) = False;
    FindClose(FH);
  End;
End.
