#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <stdint.h>

/*#define DEBUG 1*/

#ifdef __HAVE_BUILTIN_SETJMP__
#include <setjmp.h>
#undef setjmp
#define setjmp __builtin_setjmp
#undef longjmp
#define longjmp __builtin_longjmp
#endif

/*
To compile this source code you'll need "puff.c" and "puff.h" files from zlib package.
Get this package from official site: http://zlib.net/
Required files can be found in /contrib/puff/ folder inside archive.
*/

#include "puff.h"
#include "puff.c"

/*

http://wiki.xentax.com/index.php/Obscure_HVP

Obscure: Learn about Fear (*.HVP)

Notes and Comments
* This file format uses ZLIB compression and CRC32 validation.
* Game validates CRC32 only for header and for directory.
* HVP extension is shortcut for "Hydravision PackFile".

// HVP file format
// Obscure 1 (PC)
// Big Endian

// header
12 bytes (char) - signature + null // "HV PackFile"
4 bytes (uint32) - archive type // 196608 - without CRC32 check
                                // 196609 - with CRC32 check
4 bytes (uint32) - number of main level directories
4 bytes (uint32) - number of files and directories
4 bytes (uint32) - number of files
4 bytes (uint32) - directory size

if archive_type == 196609:
  4 bytes (uint32) - header CRC32
  4 bytes (uint32) - directory CRC32
endif


// directory
number_of_entries *
{
  4 bytes (uint32) - entry size (including this field)
  1 byte (uint8) - entry type indicator (0=directory, 1=file)

  if entry_type == directory:
    4 bytes (uint32) - compression flag (always 0 for directories)
    4 bytes (uint32) - number of files/subdirectories in this directory
    4 bytes (uint32) - directory name length
    x bytes (char) - directory name
  endif

  else if entry_type == file:
    4 bytes (uint32) - compression flag (0=uncompressed, 1=compressed)
    4 bytes (uint32) - compressed file size
    4 bytes (uint32) - uncompressed file size
    4 bytes (uint32) - unknown hash
    4 bytes (uint32) - file offset
    4 bytes (uint32) - filename length
    x bytes (char) - filename
  endif
}


// data
number_of_files *
{
  x bytes - file data // can be compressed with ZLIB
}
*/

#define HVP_FLAG_NONE 0x030000
#define HVP_FLAG_HCRC 0x030001

#define SWAP32(x) ((((x)>>24)&0xFF) | (((x)<<8)&0xFF0000) | (((x)>>8)&0xFF00) | (((x)<<24)&0xFF000000))

#pragma pack(push, 1)
typedef struct {
  char magic[12];
  uint32_t flags;
  uint32_t nMainDirs; /* number of main level directories */
  uint32_t nFileDirs; /* number of files and directories */
  uint32_t nFileItem; /* number of files */
  uint32_t szDirSize; /* directory size */
} hvp_head;

/* HVP_FLAG_HCRC */
typedef struct {
  uint32_t hcrc; /* header CRC32 */
  uint32_t dcrc; /* directory CRC32 */
} crc_head;

typedef struct {
  uint32_t size; /* entry size (including this field) */
  uint8_t type;  /* entry type indicator (0=directory, 1=file) */
} hvp_item;

typedef struct {
  uint32_t pack; /* compression flag (always 0 for directories) */
  uint32_t nums; /* number of files/subdirectories in this directory */
  uint32_t nlen; /* directory name length */
} hvp_dirs;

typedef struct {
  uint32_t pack; /* compression flag (0=uncompressed, 1=compressed) */
  uint32_t pksz; /* compressed file size */
  uint32_t unsz; /* uncompressed file size */
  uint32_t data; /* unknown hash */
  uint32_t offs; /* file offset */
  uint32_t nlen; /* filename length */
} hvp_file;
#pragma pack(pop)

void makedirs(char *path) {
char *s;
  if (path) {
    for (s = path; *s; s++) {
      if ((*s == '\\') || (*s == '/')) {
        *s = 0;
        mkdir(path);
        *s = '/';
      }
    }
  }
}

void dumpdata(char *name, void *data, uint32_t size) {
FILE *f;
  if (name) {
    f = fopen(name, "wb");
    if (f) {
      if (data && size) {
        fwrite(data, size, 1, f);
      }
      fclose(f);
    }
  }
}

void readdata(FILE *fl, void *data, uint32_t size) {
  if (data && size) {
    memset(data, 0, size);
    if (fl) {
      fread(data, size, 1, fl);
    }
  }
}

void swapdata(void *p, uint32_t l) {
uint32_t *d;
  if (p && l) {
    d = (uint32_t *) p;
    while (l--) {
      *d = SWAP32(*d);
      d++;
    }
  }
}

uint32_t addstrchr(char *name, uint32_t scur, uint32_t smax, char *sadd, uint32_t slen, char cadd) {
  if (name && smax) {
    if (scur < smax) {
      if (sadd && slen) {
        slen = ((scur + slen) < smax) ? slen : (smax - scur - 1);
        memcpy(&name[scur], sadd, sizeof(name[0]) * slen);
        scur += slen;
      }
      name[scur] = cadd;
      scur++;
    }
    name[(scur < smax) ? scur : (smax - 1)] = 0;
  }
  return(scur);
}

void deeptree(FILE *fl, uint8_t *list, uint32_t *from, uint32_t much, char *name, uint32_t scur, uint32_t smax) {
unsigned long ps, us;
hvp_item *hi;
hvp_dirs *hd;
hvp_file *hf;
uint8_t *p;
  if (*from < much) {
    hi = (hvp_item *) &list[*from];
    swapdata(&hi->size, 1);
    *from += hi->size;
    if (!hi->type) {
      /* folder */
      hd = (hvp_dirs *) &hi[1];
      swapdata(hd, 3);
      scur = addstrchr(name, scur, smax, (char *) &hd[1], hd->nlen, '/');
      while (hd->nums--) {
        deeptree(fl, list, from, much, name, scur, smax);
      }
    } else {
      /* file */
      hf = (hvp_file *) &hi[1];
      swapdata(hf, 6);
      addstrchr(name, scur, smax, (char *) &hf[1], hf->nlen, 0);
      printf("%s\n", name);
      p = (uint8_t *) malloc(hf->pksz + (hf->pack ? hf->unsz : 0));
      if (p) {
        fseek(fl, hf->offs, SEEK_SET);
        readdata(fl, p, hf->pksz);
        if (hf->pack) {
          /* skip 2 bytes of zlib header */
          ps = hf->pksz - 2;
          us = hf->unsz;
          memset(&p[hf->pksz], 0, hf->unsz);
          puff(&p[hf->pksz], &us, &p[2], &ps);
        }
        #ifndef DEBUG
        makedirs(name);
        dumpdata(name, &p[hf->pack ? hf->pksz : 0], hf->pack ? hf->unsz : hf->pksz);
        #endif
        free(p);
      } else {
        printf("Warning: not enough memory for output file - skipping.\n");
      }
    }
  }
}

int main(int argc, char *argv[]) {
uint8_t *list;
uint32_t sz;
hvp_head hh;
crc_head ch;
char s[260];
FILE *fl;
  printf(
    "ObsCure / Mortifilia .HVP unpacker v1.0\n"
    "(c) CTPAX-X Team 2023\n"
    "http://www.CTPAX-X.org/\n\n"
  );
  if (argc != 2) {
    printf("Usage: unhvp <filename.hvp>\n\n");
    return(1);
  }
  fl = fopen(argv[1], "rb");
  if (!fl) {
    printf("Error: can't open input file.\n\n");
    return(2);
  }
  fseek(fl, 0, SEEK_END);
  sz = ftell(fl);
  fseek(fl, 0, SEEK_SET);
  readdata(fl, &hh, sizeof(hh));
  swapdata(&hh.flags, 5);
  if (
    strcmp(hh.magic, "HV PackFile") || ((hh.flags != HVP_FLAG_NONE) && (hh.flags != HVP_FLAG_HCRC)) ||
    (!hh.nMainDirs) || (!hh.nFileDirs) || (!hh.nFileItem) || (!hh.szDirSize) ||
    (hh.szDirSize > (sz - ftell(fl))) || (hh.szDirSize < (hh.nMainDirs * (sizeof(hvp_item) + sizeof(hvp_dirs))))
  ) {
    fclose(fl);
    printf("Error: invalid input file format.\n\n");
    return(3);
  }
  /* read CRC32 (unused in this code) */
  if (hh.flags == HVP_FLAG_HCRC) {
    readdata(fl, &ch, sizeof(ch));
    swapdata(&ch, 2);
  }
  list = (uint8_t *) malloc(hh.szDirSize);
  if (!list) {
    fclose(fl);
    printf("Error: not enough memory for contents table.\n\n");
    return(4);
  }
  readdata(fl, list, hh.szDirSize);
  sz = 0;
  while (hh.nMainDirs--) {
    deeptree(fl, list, &sz, hh.szDirSize, s, 0, sizeof(s) / sizeof(s[0]));
  }
  free(list);
  fclose(fl);
  printf("\ndone\n\n");
  return(0);
}
